// name   : DMSt2004.cs
// author : Harald Maier
// date   : 02.04.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
	/// <summary>
	/// 
	/// </summary>
	public class DMSt2004 : SoaringDotNET.Optimization.LegOptimizationBase
	{
        public DMSt2004(Flight flight) : 
            base(flight)
		{
			// 
			// TODO: Add constructor logic here
			//
            LEGS = 4;
            weight = new float [] {1.0f, 1.0f, 1.0f, 1.0f};
            optimizedTask.OptimizedFor = OptimizeTypes.DMSTFreeFlight;
        }
	
        public override void Optimize() {
            // TODO:  Add DMST2004.Optimize implementation
            int N;
            int i, j;
            int start, stop;
            ArrayList ranges = new ArrayList();
            FlightPoint p;
            WayPoint wp;
            WgsPoint tmpWp;
            SectorDefinition sector;
            double elevation;
            
            N = flight.Count;
            start = flight.Start != -1 ? flight.Start : 0;
            stop = flight.Stop != -1 ? flight.Stop : N - 1;

            status = OptimizataionStatus.Running;

            if (flight[start].Elevation - flight[stop].Elevation <= 1000.0) {
                ranges.Add(new int [] {start, stop});
            }
            else {
                // increase start until diff to finish <= 1000m
                int maxDiff = 0;
                for (i = start; i <= stop; i++) {
                    p = flight[i];
                    elevation = p.Elevation;
                    for (j = stop; j > i; j--) {
                        if (elevation - flight[j].Elevation <= 1000.0 && j - i > maxDiff) {
                            ranges.Add(new int [] {i, j});
                            maxDiff = j - i;
                            break;
                        }
                    }
                }
            }

            OptimizeLegs(ranges);

            // "optimize" start and finish according to DMSt rules
            // point is reached when fix inside 1 km radius
            // so we "extend" out flight by that distance

            // start
            wp = optimizedTask[1];
            tmpWp = wp.PosOfDistAndBearing(optimizedTask[2].bearing(wp), 0.99);
            wp.Latitude = tmpWp.Latitude;
            wp.Longitude = tmpWp.Longitude;

            // finish
            wp = optimizedTask[optimizedTask.Count - 2];
            tmpWp = wp.PosOfDistAndBearing(optimizedTask[optimizedTask.Count - 3].bearing(wp), 0.99);
            wp.Latitude = tmpWp.Latitude;
            wp.Longitude = tmpWp.Longitude;

            // set sectors of start and finish to show DMST rules
            sector = optimizedTask.GetSector(1);
            sector.radius2 = 1000;
            sector.sectorType = SectorTypes.Sector;
            optimizedTask.SetSector(1, sector);

            sector = optimizedTask.GetSector(optimizedTask.Count - 2);
            sector.radius2 = 1000;
            sector.sectorType = SectorTypes.Sector;
            optimizedTask.SetSector(optimizedTask.Count - 2, sector);

            status = OptimizataionStatus.Idle;
        }
    
        public override string ToString() {
            // TODO:  Add DMST2004.ToString implementation
            return "DMSt 2004/2005";
        }
    }
}
