// name   : Explorer.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// 
	/// </summary>
    public class Explorer : System.Windows.Forms.UserControl {
        private System.Windows.Forms.TreeView objectsView;
        private System.Windows.Forms.TreeNode flightNode;
        private System.Windows.Forms.TreeNode taskNode;
        private System.Windows.Forms.ImageList imageListRootItems;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.TreeNode waypointNode;
        private ContextMenuStrip contextMenuStripFlights;
        private ToolStripMenuItem openFlightToolStripMenuItem;
        private ToolStripMenuItem optimizeFlightToolStripMenuItem;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripMenuItem closeFlightToolStripMenuItem;
        private ContextMenuStrip contextMenuStripTasks;
        private ToolStripMenuItem newTaskToolStripMenuItem;
        private ToolStripMenuItem editTaskToolStripMenuItem;
        private ToolStripMenuItem deleteTaskToolStripMenuItem;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripMenuItem openTasksToolStripMenuItem;
        private ContextMenuStrip contextMenuStripWaypoints;
        private ToolStripMenuItem newCatalogueToolStripMenuItem;
        private ToolStripMenuItem openCatalogueToolStripMenuItem;
        private ToolStripMenuItem deleteCatalogueToolStripMenuItem;
        private ToolStripMenuItem mergeCatalogueToolStripMenuItem;
        private ToolStripSeparator toolStripSeparator3;
        private ToolStripMenuItem saveCatalogueToolStripMenuItem;
        private ToolStripMenuItem saveCatalogueAsToolStripMenuItem;
        private ToolStripMenuItem closeCatalogueToolStripMenuItem;
        private ToolStripMenuItem saveTasksToolStripMenuItem;

        public Explorer() {
            InitializeComponent();
            // 
            // TODO: Add constructor logic here
            //
            flightNode = new TreeNode("Flights", 0, 0);
            taskNode = new TreeNode("Tasks", 1, 1);
            waypointNode = new TreeNode("Waypoint catalogues", 2, 2);
            //userNode = new TreeNode("Pilots", 3, 3);

            objectsView.Nodes.Add(flightNode);
            objectsView.Nodes.Add(taskNode);
            objectsView.Nodes.Add(waypointNode);
            //objectsView.Nodes.Add(userNode);
        }


        #region Private Functions
        private TreeNode Look4ObjectNode(TreeNode n) {
            // look for object node
            while (n.Parent != null && n.Tag == null) {
                n = n.Parent;
            }
            return n;
        }

        private TreeNode Look4ItemNode(Flight f) {
            foreach (TreeNode n in flightNode.Nodes) {
                if (n.Tag == f) {
                    return n;
                }
            }
            return null;
        }

        private TreeNode Look4ItemNode(Task t) {
            foreach (TreeNode n in taskNode.Nodes) {
                if (n.Tag == t) {
                    return n;
                }
            }
            return null;
        }

        private TreeNode Look4ItemNode(WaypointCatalog c) {
            foreach (TreeNode n in waypointNode.Nodes) {
                if (n.Tag == c) {
                    return n;
                }
            }
            return null;
        }

        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Explorer));
            this.objectsView = new System.Windows.Forms.TreeView();
            this.imageListRootItems = new System.Windows.Forms.ImageList(this.components);
            this.contextMenuStripFlights = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.closeFlightToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.contextMenuStripTasks = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.contextMenuStripWaypoints = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.mergeCatalogueToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this.saveCatalogueAsToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.closeCatalogueToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.openFlightToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.optimizeFlightToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.newTaskToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.editTaskToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.deleteTaskToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.openTasksToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.saveTasksToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.newCatalogueToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.openCatalogueToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.deleteCatalogueToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.saveCatalogueToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.contextMenuStripFlights.SuspendLayout();
            this.contextMenuStripTasks.SuspendLayout();
            this.contextMenuStripWaypoints.SuspendLayout();
            this.SuspendLayout();
            // 
            // objectsView
            // 
            this.objectsView.Dock = System.Windows.Forms.DockStyle.Fill;
            this.objectsView.HideSelection = false;
            this.objectsView.ImageIndex = 0;
            this.objectsView.ImageList = this.imageListRootItems;
            this.objectsView.Location = new System.Drawing.Point(0, 0);
            this.objectsView.Name = "objectsView";
            this.objectsView.SelectedImageIndex = 0;
            this.objectsView.Size = new System.Drawing.Size(200, 288);
            this.objectsView.TabIndex = 0;
            this.objectsView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.objectsView_AfterSelect);
            this.objectsView.MouseDown += new System.Windows.Forms.MouseEventHandler(this.objectsView_MouseDown);
            // 
            // imageListRootItems
            // 
            this.imageListRootItems.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListRootItems.ImageStream")));
            this.imageListRootItems.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListRootItems.Images.SetKeyName(0, "Flight.png");
            this.imageListRootItems.Images.SetKeyName(1, "Task.png");
            this.imageListRootItems.Images.SetKeyName(2, "Waypoint.png");
            // 
            // contextMenuStripFlights
            // 
            this.contextMenuStripFlights.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.openFlightToolStripMenuItem,
            this.optimizeFlightToolStripMenuItem,
            this.toolStripSeparator1,
            this.closeFlightToolStripMenuItem});
            this.contextMenuStripFlights.Name = "contextMenuStripFlights";
            this.contextMenuStripFlights.Size = new System.Drawing.Size(154, 76);
            this.contextMenuStripFlights.Opening += new System.ComponentModel.CancelEventHandler(this.OnOpeningContextMenuFlight);
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(150, 6);
            // 
            // closeFlightToolStripMenuItem
            // 
            this.closeFlightToolStripMenuItem.Name = "closeFlightToolStripMenuItem";
            this.closeFlightToolStripMenuItem.Size = new System.Drawing.Size(153, 22);
            this.closeFlightToolStripMenuItem.Text = "&Close flight";
            this.closeFlightToolStripMenuItem.Click += new System.EventHandler(this.OnCloseFlight);
            // 
            // contextMenuStripTasks
            // 
            this.contextMenuStripTasks.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.newTaskToolStripMenuItem,
            this.editTaskToolStripMenuItem,
            this.deleteTaskToolStripMenuItem,
            this.toolStripSeparator2,
            this.openTasksToolStripMenuItem,
            this.saveTasksToolStripMenuItem});
            this.contextMenuStripTasks.Name = "contextMenuStripTasks";
            this.contextMenuStripTasks.Size = new System.Drawing.Size(140, 120);
            this.contextMenuStripTasks.Opening += new System.ComponentModel.CancelEventHandler(this.OnOpeningContextMenuTasks);
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size(136, 6);
            // 
            // contextMenuStripWaypoints
            // 
            this.contextMenuStripWaypoints.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.newCatalogueToolStripMenuItem,
            this.openCatalogueToolStripMenuItem,
            this.deleteCatalogueToolStripMenuItem,
            this.mergeCatalogueToolStripMenuItem,
            this.toolStripSeparator3,
            this.saveCatalogueToolStripMenuItem,
            this.saveCatalogueAsToolStripMenuItem,
            this.closeCatalogueToolStripMenuItem});
            this.contextMenuStripWaypoints.Name = "contextMenuStripWaypoints";
            this.contextMenuStripWaypoints.Size = new System.Drawing.Size(174, 186);
            this.contextMenuStripWaypoints.Opening += new System.ComponentModel.CancelEventHandler(this.OnOpeningContextMenuWaypoints);
            // 
            // mergeCatalogueToolStripMenuItem
            // 
            this.mergeCatalogueToolStripMenuItem.Name = "mergeCatalogueToolStripMenuItem";
            this.mergeCatalogueToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.mergeCatalogueToolStripMenuItem.Text = "&Merge catalogue";
            this.mergeCatalogueToolStripMenuItem.Click += new System.EventHandler(this.OnMergeCatalogue);
            // 
            // toolStripSeparator3
            // 
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            this.toolStripSeparator3.Size = new System.Drawing.Size(170, 6);
            // 
            // saveCatalogueAsToolStripMenuItem
            // 
            this.saveCatalogueAsToolStripMenuItem.Name = "saveCatalogueAsToolStripMenuItem";
            this.saveCatalogueAsToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.saveCatalogueAsToolStripMenuItem.Text = "Save catalogue &as";
            this.saveCatalogueAsToolStripMenuItem.Click += new System.EventHandler(this.OnSaveCatalogAs);
            // 
            // closeCatalogueToolStripMenuItem
            // 
            this.closeCatalogueToolStripMenuItem.Name = "closeCatalogueToolStripMenuItem";
            this.closeCatalogueToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.closeCatalogueToolStripMenuItem.Text = "&Close catalogue";
            this.closeCatalogueToolStripMenuItem.Click += new System.EventHandler(this.OnCloseCatalog);
            // 
            // openFlightToolStripMenuItem
            // 
            this.openFlightToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Open;
            this.openFlightToolStripMenuItem.Name = "openFlightToolStripMenuItem";
            this.openFlightToolStripMenuItem.Size = new System.Drawing.Size(153, 22);
            this.openFlightToolStripMenuItem.Text = "&Open flight";
            this.openFlightToolStripMenuItem.Click += new System.EventHandler(this.OnOpenFlight);
            // 
            // optimizeFlightToolStripMenuItem
            // 
            this.optimizeFlightToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Optimize;
            this.optimizeFlightToolStripMenuItem.Name = "optimizeFlightToolStripMenuItem";
            this.optimizeFlightToolStripMenuItem.Size = new System.Drawing.Size(153, 22);
            this.optimizeFlightToolStripMenuItem.Text = "O&ptimize flight";
            this.optimizeFlightToolStripMenuItem.Click += new System.EventHandler(this.OnOptimizeFlight);
            // 
            // newTaskToolStripMenuItem
            // 
            this.newTaskToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.NewTask;
            this.newTaskToolStripMenuItem.Name = "newTaskToolStripMenuItem";
            this.newTaskToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.newTaskToolStripMenuItem.Text = "&New task";
            this.newTaskToolStripMenuItem.Click += new System.EventHandler(this.OnNewTask);
            // 
            // editTaskToolStripMenuItem
            // 
            this.editTaskToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Edit;
            this.editTaskToolStripMenuItem.Name = "editTaskToolStripMenuItem";
            this.editTaskToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.editTaskToolStripMenuItem.Text = "&Edit task";
            this.editTaskToolStripMenuItem.Click += new System.EventHandler(this.OnEditTask);
            // 
            // deleteTaskToolStripMenuItem
            // 
            this.deleteTaskToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Delete;
            this.deleteTaskToolStripMenuItem.Name = "deleteTaskToolStripMenuItem";
            this.deleteTaskToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.deleteTaskToolStripMenuItem.Text = "&Delete task";
            this.deleteTaskToolStripMenuItem.Click += new System.EventHandler(this.OnDeleteTask);
            // 
            // openTasksToolStripMenuItem
            // 
            this.openTasksToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Open;
            this.openTasksToolStripMenuItem.Name = "openTasksToolStripMenuItem";
            this.openTasksToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.openTasksToolStripMenuItem.Text = "&Open tasks";
            this.openTasksToolStripMenuItem.Click += new System.EventHandler(this.OnOpenTasks);
            // 
            // saveTasksToolStripMenuItem
            // 
            this.saveTasksToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Save;
            this.saveTasksToolStripMenuItem.Name = "saveTasksToolStripMenuItem";
            this.saveTasksToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.saveTasksToolStripMenuItem.Text = "&Save tasks";
            this.saveTasksToolStripMenuItem.Click += new System.EventHandler(this.OnSaveTasks);
            // 
            // newCatalogueToolStripMenuItem
            // 
            this.newCatalogueToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.New;
            this.newCatalogueToolStripMenuItem.Name = "newCatalogueToolStripMenuItem";
            this.newCatalogueToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.newCatalogueToolStripMenuItem.Text = "&New catalogue";
            this.newCatalogueToolStripMenuItem.Click += new System.EventHandler(this.OnNewCatalog);
            // 
            // openCatalogueToolStripMenuItem
            // 
            this.openCatalogueToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Open;
            this.openCatalogueToolStripMenuItem.Name = "openCatalogueToolStripMenuItem";
            this.openCatalogueToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.openCatalogueToolStripMenuItem.Text = "&Open catalogue";
            this.openCatalogueToolStripMenuItem.Click += new System.EventHandler(this.OnOpenCatalog);
            // 
            // deleteCatalogueToolStripMenuItem
            // 
            this.deleteCatalogueToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Delete;
            this.deleteCatalogueToolStripMenuItem.Name = "deleteCatalogueToolStripMenuItem";
            this.deleteCatalogueToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.deleteCatalogueToolStripMenuItem.Text = "&Delete catalogue";
            this.deleteCatalogueToolStripMenuItem.Click += new System.EventHandler(this.OnDeleteCatalog);
            // 
            // saveCatalogueToolStripMenuItem
            // 
            this.saveCatalogueToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Save;
            this.saveCatalogueToolStripMenuItem.Name = "saveCatalogueToolStripMenuItem";
            this.saveCatalogueToolStripMenuItem.Size = new System.Drawing.Size(173, 22);
            this.saveCatalogueToolStripMenuItem.Text = "&Save catalogue";
            this.saveCatalogueToolStripMenuItem.Click += new System.EventHandler(this.OnSaveCatalog);
            // 
            // Explorer
            // 
            this.Controls.Add(this.objectsView);
            this.Name = "Explorer";
            this.Size = new System.Drawing.Size(200, 288);
            this.contextMenuStripFlights.ResumeLayout(false);
            this.contextMenuStripTasks.ResumeLayout(false);
            this.contextMenuStripWaypoints.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        #region Public Functions
        public void Add(Flight node) {
            TreeNode n = new TreeNode(node.Name, 0, 0);
            n.Tag = node;
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));

            TreeNode t = new TreeNode("Task", 1, 1);
            n.Nodes.Add(t);
            t.Nodes.Add(new TreeNode("", 1, 1));
            t.Nodes.Add(new TreeNode("", 1, 1));
            t.Nodes.Add(new TreeNode("", 1, 1));
            t.Nodes.Add(new TreeNode("Waypoints", 2, 2));

            flightNode.Nodes.Add(n);
            Update(node);
            objectsView.SelectedNode = n;
        }

        public void Add(Task node) {
            TreeNode n = new TreeNode(node.Name, 1, 1);
            n.Tag = node;
            n.Nodes.Add(new TreeNode("", 1, 1));
            n.Nodes.Add(new TreeNode("", 1, 1));
            n.Nodes.Add(new TreeNode("", 1, 1));
            n.Nodes.Add(new TreeNode("Waypoints", 2, 2));

            taskNode.Nodes.Add(n);
            Update(node);
            objectsView.SelectedNode = n;
        }

        public void Add(WaypointCatalog node) {
            TreeNode n = new TreeNode(node.Name, 2, 2);
            n.Tag = node;
            n.Nodes.Add(new TreeNode("", 2, 2));
            n.Nodes.Add(new TreeNode("", 2, 2));
            n.Nodes.Add(new TreeNode("", 2, 2));

            waypointNode.Nodes.Add(n);
            Update(node);
            objectsView.SelectedNode = n;
        }

        public void Update(Flight f) {
            int i;
            WayPoint wp;
            string txt;
            TreeNode n = Look4ItemNode(f);
            if (n != null) {
                n.Nodes[0].Text = "Pilot: " + f.Pilot;
                n.Nodes[1].Text = "Date: " + f.Date;
                n.Nodes[2].Text = "Glider: " + f.Glider + " " + f.GliderId + (f.CompetitionId != null ? " (" + f.CompetitionId + ")" : "");
                n.Nodes[3].Text = "Takeoff: " + f[f.Takeoff].ToStringTime();
                n.Nodes[4].Text = "Landing: " + f[f.Landing].ToStringTime();
                n.Nodes[5].Text = "Duration: " + Time.ToTimeString(f.Duration);
                n.Nodes[6].Text = "Task duration: " + Time.ToTimeString(f.TaskDuration);

                TreeNode t = n.Nodes[7];
                t.Nodes[0].Text = "Type: " + f.currentTask.TaskTypeString;
                if (!f.currentTask.IsArea) {
                    t.Nodes[1].Text = string.Format(AppContents.ni, "Task length: {0:F1} km", f.currentTask.TaskDistanceKM);
                    t.Nodes[2].Text = string.Format(AppContents.ni, "Total length: {0:F1} km", f.currentTask.TotalDistanceKM);
                }
                else {
                    t.Nodes[1].Text = string.Format(AppContents.ni, "Task length: FIXME");
                    t.Nodes[2].Text = string.Format(AppContents.ni, "Total length: FIXME");
                }

                t = t.Nodes[3];

                if (t.Nodes.Count > f.currentTask.Count) {
                    for (i = t.Nodes.Count - 1; i >= f.currentTask.Count; i--) {
                        t.Nodes.RemoveAt(i);
                    }
                }
                else if (t.Nodes.Count < f.currentTask.Count) {
                    for (i = t.Nodes.Count; i < f.currentTask.Count; i++) {
                        t.Nodes.Add(new TreeNode("", 2, 2));
                    }
                }

                for(i = 0; i < f.currentTask.Count; i++) {
                    wp = (WayPoint)f.currentTask[i];
                    if (i > 0) {
                        txt = string.Format(AppContents.ni, "{0} {1:F1} km", wp.longName, wp.distanceKM(f.currentTask[i - 1]));
                    }
                    else {
                        txt = wp.longName;
                    }
                    t.Nodes[i].Text = txt;
                }
                n.EnsureVisible();
                n.Expand();
            }
        }

        public void Update(Task t) {
            int i;
            string txt;
            WayPoint wp;

            TreeNode n = Look4ItemNode(t);
            if (n != null) {
                n.Text = t.Name;
                n.Nodes[0].Text = "Type: " + t.TaskTypeString;
                if (!t.IsArea) {
                    n.Nodes[1].Text = string.Format(AppContents.ni, "Task length: {0:F1} km", t.TaskDistanceKM);
                    n.Nodes[2].Text = string.Format(AppContents.ni, "Total length: {0:F1} km", t.TotalDistanceKM);
                }
                else {
                    n.Nodes[1].Text = string.Format(AppContents.ni, "Task length: FIXME");
                    n.Nodes[2].Text = string.Format(AppContents.ni, "Total length: FIXME");
                }

                TreeNode tt = n.Nodes[3];
                if (tt.Nodes.Count > t.Count) {
                    for (i = tt.Nodes.Count - 1; i >= t.Count; i--) {
                        tt.Nodes.RemoveAt(i);
                    }
                }
                else if (tt.Nodes.Count < t.Count) {
                    for (i = tt.Nodes.Count; i < t.Count; i++) {
                        tt.Nodes.Add(new TreeNode("", 2, 2));
                    }
                }

                for(i = 0; i < t.Count; i++) {
                    wp = (WayPoint)t[i];
                    if (i > 0) {
                        txt = string.Format(AppContents.ni, "{0} {1:F1} km", wp.longName, wp.distanceKM(t[i -1]));
                    }
                    else {
                        txt = wp.longName;
                    }
                    tt.Nodes[i].Text = txt;
                }

                n.EnsureVisible();
                n.Expand();
                tt.Expand();
            }
        }

        public void Update(WaypointCatalog c) {
            TreeNode n = Look4ItemNode(c);
            if (n != null) {
                n.Nodes[0].Text = c.Count.ToString() + " Items";
                n.Nodes[1].Text = "Last update: " + c.LastModification;
                n.Nodes[2].Text = "Status: " + ((c.Dirty == true) ? "need save" : "clean");

                n.EnsureVisible();
                n.Expand();
            }
        }

        public void Save() {
            TreeNode n = objectsView.SelectedNode;
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                if (n.Parent == waypointNode) {
                    OnSaveCatalog(null, null);
                }
                else if (n.Parent == taskNode) {
                    OnSaveTasks(null, null);
                }
            }
        }

        #endregion

        #region Control Events
        private void objectsView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e) {
            TreeNode n = e.Node;
            while (n.Parent != null) {
                n = n.Parent;
            }
            if (n == flightNode) {
                objectsView.ContextMenuStrip = contextMenuStripFlights;
            }
            else if (n == taskNode) {
                objectsView.ContextMenuStrip = contextMenuStripTasks;
            }
            else if (n == waypointNode) {
                objectsView.ContextMenuStrip = contextMenuStripWaypoints;
            }
            else {
                objectsView.ContextMenu = null;
            }

            n = Look4ObjectNode(e.Node);
            if (n.Tag != null) {
                if (n.Parent == waypointNode) {
                    AppContents.application.Switch((WaypointCatalog) n.Tag);
                }
                else if (n.Parent == taskNode) {
                    AppContents.application.Switch((Task)n.Tag);
                }
                else if (n.Parent == flightNode) {
                    AppContents.application.Switch((Flight)n.Tag);
                }
            }

        }

        private void objectsView_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e) {
            if (e.Button == MouseButtons.Right) {
                objectsView.SelectedNode = objectsView.GetNodeAt(e.X, e.Y);
            }
        }
        #endregion

        #region Flight Handlers
        private void OnOpenFlight(object sender, System.EventArgs e) {
            AppContents.application.OpenFlight();
        }

        private void OnOptimizeFlight(object sender, System.EventArgs e) {
            AppContents.application.OptimizeFlight();
        }

        private void OnCloseFlight(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;

            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                AppContents.application.Close((Flight)n.Tag);

                if (n.NextNode != null) {
                    objectsView.SelectedNode = n.NextNode;
                }
                else if (n.PrevNode != null) {
                    objectsView.SelectedNode = n.PrevNode;
                }
                else {
                    AppContents.application.Switch((Flight) null);
                }

                n.Remove();
            }
        }
        #endregion

        #region Waypoint Handlers
        private void OnNewCatalog(object sender, System.EventArgs e) {
            AppContents.application.NewCatalog();
        }

        private void OnOpenCatalog(object sender, System.EventArgs e) {
            AppContents.application.OpenCatalog();        
        }

        private void OnCloseCatalog(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;

            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                AppContents.application.Close((WaypointCatalog)n.Tag);

                if (n.NextNode != null) {
                    objectsView.SelectedNode = n.NextNode;
                }
                else if (n.PrevNode != null) {
                    objectsView.SelectedNode = n.PrevNode;
                }
                else {
                    AppContents.application.Switch((WaypointCatalog) null);
                }

                n.Remove();
            }
        }

        private void OnDeleteCatalog(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                WaypointCatalog c = (WaypointCatalog)n.Tag;
                if (MessageBox.Show(AppContents.application, "Remove catalogue " + c.Name + " from disk?", AppContents.application.Name, MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation,
                    MessageBoxDefaultButton.Button2) == DialogResult.OK) {
                    OnCloseCatalog(sender, e);
                    c.Destroy();
                }
            }
        }

        private void OnMergeCatalogue(object sender, System.EventArgs e) {
            AppContents.application.MergeCatalog();
        }

        private void OnSaveCatalog(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
                string defaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");

                WaypointCatalog c = (WaypointCatalog)n.Tag;
                c.Save(AppContents.tasks, defaultWaypointPath);
                AppContents.application.Update(c);
            }
        }

        private void OnSaveCatalogAs(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
                string defaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");

                WaypointCatalog c = (WaypointCatalog)n.Tag;
                c.SaveAs(AppContents.tasks, defaultWaypointPath);
                n.Text = c.Name;
                AppContents.application.Update(c);
            }
        }

        #endregion

        #region Task Handlers
        private void OnDeleteTask(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                AppContents.application.Close((Task)n.Tag);
                if (n.NextNode != null) {
                    objectsView.SelectedNode = n.NextNode;
                }
                else if (n.PrevNode != null) {
                    objectsView.SelectedNode = n.PrevNode;
                }
                else {
                    AppContents.application.Switch((Task) null);
                }

                n.Remove();
            }
        }

        private void OnNewTask(object sender, System.EventArgs e) {
            AppContents.application.NewTask();
        }

        private void OnEditTask(object sender, System.EventArgs e) {
            MessageBox.Show("Edit dialog not yet implemented!", "SoaringDotNet", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
        }

        private void OnOpenTasks(object sender, System.EventArgs e) {
            AppContents.application.OpenTasks();
        }

        private void OnSaveTasks(object sender, System.EventArgs e) {
            AppContents.application.SaveTasks();
        }
        #endregion

        #region PopupMenu Handlers

        private void OnOpeningContextMenuFlight(object sender, System.ComponentModel.CancelEventArgs e) {
            this.closeFlightToolStripMenuItem.Enabled = AppContents.application.currentFlight != null;
            this.optimizeFlightToolStripMenuItem.Enabled = AppContents.application.currentFlight != null;
        }

        private void OnOpeningContextMenuTasks(object sender, System.ComponentModel.CancelEventArgs e) {
            this.editTaskToolStripMenuItem.Enabled = AppContents.application.currentTask != null;
            this.deleteTaskToolStripMenuItem.Enabled = AppContents.application.currentTask != null;
            this.saveTasksToolStripMenuItem.Enabled = AppContents.application.currentTask != null;
        }

        private void OnOpeningContextMenuWaypoints(object sender, System.ComponentModel.CancelEventArgs e) {
            this.deleteCatalogueToolStripMenuItem.Enabled = AppContents.application.currentCatalog != null;
            this.mergeCatalogueToolStripMenuItem.Enabled = AppContents.application.currentCatalog != null;
            this.saveCatalogueToolStripMenuItem.Enabled = (AppContents.application.currentCatalog != null && AppContents.application.currentCatalog.Dirty);
            this.saveCatalogueAsToolStripMenuItem.Enabled = AppContents.application.currentCatalog != null;
            this.closeCatalogueToolStripMenuItem.Enabled = AppContents.application.currentCatalog != null;
        }
        #endregion

        #region Attributes
        #endregion

	}
}
