using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.FileFormats;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for ExportSUAOptionsDialog.
	/// </summary>
	public class ExportSUAOptionsDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Label labelItemsCount;
        private System.Windows.Forms.GroupBox groupBox1;
        private SoaringDotNET.Controls.SUASelectionControl suaSelection;
        private System.Windows.Forms.RadioButton radioButtonFormatOpenAir;
        private System.Windows.Forms.RadioButton radioButtonFormatTNP;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.Button buttonOK;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ExportSUAOptionsDialog()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.suaSelection = new SoaringDotNET.Controls.SUASelectionControl();
            this.labelItemsCount = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.radioButtonFormatOpenAir = new System.Windows.Forms.RadioButton();
            this.radioButtonFormatTNP = new System.Windows.Forms.RadioButton();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.buttonOK = new System.Windows.Forms.Button();
            this.groupBox1.SuspendLayout();
            this.SuspendLayout();
            // 
            // suaSelection
            // 
            this.suaSelection.Cursor = System.Windows.Forms.Cursors.Default;
            this.suaSelection.Dock = System.Windows.Forms.DockStyle.Top;
            this.suaSelection.Location = new System.Drawing.Point(5, 5);
            this.suaSelection.Name = "suaSelection";
            this.suaSelection.Size = new System.Drawing.Size(728, 224);
            this.suaSelection.TabIndex = 0;
            this.suaSelection.UseMapArea = false;
            this.suaSelection.SelectionChanged += new SoaringDotNET.Controls.SelectionChangedHandler(this.OnSelectedAirspaceChanged);
            // 
            // labelItemsCount
            // 
            this.labelItemsCount.Dock = System.Windows.Forms.DockStyle.Top;
            this.labelItemsCount.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.labelItemsCount.ForeColor = System.Drawing.Color.Red;
            this.labelItemsCount.Location = new System.Drawing.Point(5, 229);
            this.labelItemsCount.Name = "labelItemsCount";
            this.labelItemsCount.Size = new System.Drawing.Size(728, 23);
            this.labelItemsCount.TabIndex = 1;
            this.labelItemsCount.Text = "0 items";
            this.labelItemsCount.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.radioButtonFormatOpenAir);
            this.groupBox1.Controls.Add(this.radioButtonFormatTNP);
            this.groupBox1.Location = new System.Drawing.Point(5, 256);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(171, 72);
            this.groupBox1.TabIndex = 2;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "File format";
            // 
            // radioButtonFormatOpenAir
            // 
            this.radioButtonFormatOpenAir.Location = new System.Drawing.Point(8, 40);
            this.radioButtonFormatOpenAir.Name = "radioButtonFormatOpenAir";
            this.radioButtonFormatOpenAir.Size = new System.Drawing.Size(160, 24);
            this.radioButtonFormatOpenAir.TabIndex = 3;
            this.radioButtonFormatOpenAir.Text = "Open Air";
            // 
            // radioButtonFormatTNP
            // 
            this.radioButtonFormatTNP.Location = new System.Drawing.Point(8, 16);
            this.radioButtonFormatTNP.Name = "radioButtonFormatTNP";
            this.radioButtonFormatTNP.Size = new System.Drawing.Size(160, 24);
            this.radioButtonFormatTNP.TabIndex = 2;
            this.radioButtonFormatTNP.Text = "Tim Newport-Peace";
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(380, 344);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.TabIndex = 4;
            this.buttonCancel.Text = "Cancel";
            // 
            // buttonOK
            // 
            this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOK.Location = new System.Drawing.Point(284, 344);
            this.buttonOK.Name = "buttonOK";
            this.buttonOK.TabIndex = 3;
            this.buttonOK.Text = "OK";
            this.buttonOK.Click += new System.EventHandler(this.OnOK);
            // 
            // ExportSUAOptionsDialog
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(738, 376);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOK);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.labelItemsCount);
            this.Controls.Add(this.suaSelection);
            this.DockPadding.All = 5;
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.Name = "ExportSUAOptionsDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Export SUA options";
            this.groupBox1.ResumeLayout(false);
            this.ResumeLayout(false);

        }
		#endregion

        private void OnSelectedAirspaceChanged() {
            labelItemsCount.Text = string.Format("{0} items", suaSelection.SelectedAirspace.Count);
        }

        private void OnOK(object sender, System.EventArgs e) {
            if (FileFormat == SUAFileFormat.Unknown) {
                MessageBox.Show(this, "Please select your desired file format first", "Hint", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                DialogResult = DialogResult.None;
            }
            else {
                DialogResult = DialogResult.OK;
            }
        }

        public SUAFileFormat FileFormat {
            get {
                SUAFileFormat format = SUAFileFormat.Unknown;
                if (radioButtonFormatOpenAir.Checked) {
                    format = SUAFileFormat.OpenAir;
                }
                else if (radioButtonFormatTNP.Checked) {
                    format = SUAFileFormat.TNP;
                }
                return format;
            }
        }

        public ArrayList SelectedSUAs {
            get {
                return suaSelection.SelectedAirspace;
            }
        }
	}
}
