// name   : FlightPoint.cs
// author : Harald Maier
// date   : 13.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;

namespace SoaringDotNET.Data
{
	/// <summary>
	/// class FligthPoint
	/// represent one 3D GPS fix
	/// </summary>
	public class FlightPoint : SoaringDotNET.Data.WgsPoint
	{
        public int pAlt;
        public int gnssAlt;
        public int fixTime;
        public int engineNoiseLevel;

        public FlightPoint() : this (0, 0, -1, 0, 0, 0) {}
        public FlightPoint(int latitude, int longitude, int fixTime, int pAlt, int gnssAlt, int engineNoiseLevel) :
            base (latitude, longitude) {
            this.pAlt = pAlt;
            this.gnssAlt = gnssAlt;
            this.fixTime = fixTime;
            this.engineNoiseLevel = engineNoiseLevel;
        }

        #region Public Functions
        public double speedKMH(FlightPoint to) {
            return to.fixTime - this.fixTime != 0 ? distanceKM(to) / (((double)(to.fixTime - this.fixTime)) / 3600.0) : 0;
        }

        public double speedKNOTS(FlightPoint to) {
            return to.fixTime - this.fixTime != 0 ? distanceNM(to) / (((double)(to.fixTime - this.fixTime)) / 3600.0) : 0;
        }

        public double varioMPS(FlightPoint to) {
            return to.fixTime - this.fixTime != 0 ? (double)(to.pAlt - this.pAlt) / (double)(to.fixTime - this.fixTime) : 0;
        }

        public double varioFPM(FlightPoint to) {
            return varioMPS(to) * 196.85;
        }

        public string ToStringTime() {
            return SoaringDotNET.Data.Time.ToTimeString(fixTime);
        }

        #endregion

        #region Attributes
        public override int Elevation {
            get {
                return pAlt;
            }
            set {
                pAlt = value;
            }
        }

        #endregion
    }
}
