// name   : GenAirspaceDBDialog.cs
// author : Harald Maier
// date   : 11.02.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using Microsoft.Win32;

using SoaringDotNET.Data;
using SoaringDotNET.Database;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class GenAirspaceDBDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Button buttonRootDirectory;
        private System.Windows.Forms.TextBox textBoxRootDirectory;
        private System.Windows.Forms.CheckedListBox checkedListBoxCountries;
        private System.Windows.Forms.Button buttonGenAirspace;

        private ArrayList countries;
        private DateTime validFrom;
        private DateTime validTo;
        private System.Windows.Forms.Button buttonFinish;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.TextBox textBoxDestDirectory;
        private System.Windows.Forms.ProgressBar progressBar;
        private System.Windows.Forms.Label labelAirspaceName;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public GenAirspaceDBDialog()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            countries = new ArrayList();
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");

            textBoxRootDirectory.Text = (string)currUser.GetValue("DafifRoot", "");
            textBoxDestDirectory.Text = (string)currUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace");
            ReloadDafifDB();
        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.label1 = new System.Windows.Forms.Label();
            this.textBoxRootDirectory = new System.Windows.Forms.TextBox();
            this.buttonRootDirectory = new System.Windows.Forms.Button();
            this.checkedListBoxCountries = new System.Windows.Forms.CheckedListBox();
            this.buttonGenAirspace = new System.Windows.Forms.Button();
            this.buttonFinish = new System.Windows.Forms.Button();
            this.label2 = new System.Windows.Forms.Label();
            this.textBoxDestDirectory = new System.Windows.Forms.TextBox();
            this.progressBar = new System.Windows.Forms.ProgressBar();
            this.labelAirspaceName = new System.Windows.Forms.Label();
            this.SuspendLayout();
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(8, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(101, 13);
            this.label1.TabIndex = 0;
            this.label1.Text = "DAFIF root directory";
            // 
            // textBoxRootDirectory
            // 
            this.textBoxRootDirectory.Location = new System.Drawing.Point(8, 32);
            this.textBoxRootDirectory.Name = "textBoxRootDirectory";
            this.textBoxRootDirectory.ReadOnly = true;
            this.textBoxRootDirectory.Size = new System.Drawing.Size(408, 20);
            this.textBoxRootDirectory.TabIndex = 1;
            // 
            // buttonRootDirectory
            // 
            this.buttonRootDirectory.Location = new System.Drawing.Point(416, 32);
            this.buttonRootDirectory.Name = "buttonRootDirectory";
            this.buttonRootDirectory.Size = new System.Drawing.Size(24, 20);
            this.buttonRootDirectory.TabIndex = 2;
            this.buttonRootDirectory.Text = "...";
            this.buttonRootDirectory.Click += new System.EventHandler(this.OnSelectRootDirectory);
            // 
            // checkedListBoxCountries
            // 
            this.checkedListBoxCountries.CheckOnClick = true;
            this.checkedListBoxCountries.Location = new System.Drawing.Point(8, 112);
            this.checkedListBoxCountries.Name = "checkedListBoxCountries";
            this.checkedListBoxCountries.ScrollAlwaysVisible = true;
            this.checkedListBoxCountries.Size = new System.Drawing.Size(160, 259);
            this.checkedListBoxCountries.Sorted = true;
            this.checkedListBoxCountries.TabIndex = 3;
            // 
            // buttonGenAirspace
            // 
            this.buttonGenAirspace.Location = new System.Drawing.Point(192, 112);
            this.buttonGenAirspace.Name = "buttonGenAirspace";
            this.buttonGenAirspace.Size = new System.Drawing.Size(75, 34);
            this.buttonGenAirspace.TabIndex = 4;
            this.buttonGenAirspace.Text = "generate Airspace";
            this.buttonGenAirspace.Click += new System.EventHandler(this.OnGenerateAirspace);
            // 
            // buttonFinish
            // 
            this.buttonFinish.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonFinish.Location = new System.Drawing.Point(368, 352);
            this.buttonFinish.Name = "buttonFinish";
            this.buttonFinish.Size = new System.Drawing.Size(75, 23);
            this.buttonFinish.TabIndex = 5;
            this.buttonFinish.Text = "Finish";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(8, 64);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(60, 13);
            this.label2.TabIndex = 6;
            this.label2.Text = "Destination";
            // 
            // textBoxDestDirectory
            // 
            this.textBoxDestDirectory.Location = new System.Drawing.Point(8, 80);
            this.textBoxDestDirectory.Name = "textBoxDestDirectory";
            this.textBoxDestDirectory.ReadOnly = true;
            this.textBoxDestDirectory.Size = new System.Drawing.Size(408, 20);
            this.textBoxDestDirectory.TabIndex = 7;
            // 
            // progressBar
            // 
            this.progressBar.Location = new System.Drawing.Point(192, 152);
            this.progressBar.Name = "progressBar";
            this.progressBar.Size = new System.Drawing.Size(224, 23);
            this.progressBar.Step = 1;
            this.progressBar.TabIndex = 8;
            // 
            // labelAirspaceName
            // 
            this.labelAirspaceName.ForeColor = System.Drawing.SystemColors.ControlText;
            this.labelAirspaceName.Location = new System.Drawing.Point(192, 176);
            this.labelAirspaceName.Name = "labelAirspaceName";
            this.labelAirspaceName.Size = new System.Drawing.Size(224, 23);
            this.labelAirspaceName.TabIndex = 9;
            this.labelAirspaceName.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // GenAirspaceDBDialog
            // 
            this.AcceptButton = this.buttonFinish;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(456, 384);
            this.Controls.Add(this.labelAirspaceName);
            this.Controls.Add(this.progressBar);
            this.Controls.Add(this.textBoxDestDirectory);
            this.Controls.Add(this.textBoxRootDirectory);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.buttonFinish);
            this.Controls.Add(this.buttonGenAirspace);
            this.Controls.Add(this.checkedListBoxCountries);
            this.Controls.Add(this.buttonRootDirectory);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "GenAirspaceDBDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "SoaringDotNet database generator";
            this.ResumeLayout(false);
            this.PerformLayout();

        }
		#endregion

        private void OnSelectRootDirectory(object sender, System.EventArgs e) {
            FolderBrowserDialog fd = new FolderBrowserDialog();
            fd.ShowNewFolderButton = false;
            fd.Description = "Select path of DAFIF root directory";
            if (fd.ShowDialog(this) == DialogResult.OK) {
                textBoxRootDirectory.Text = fd.SelectedPath;

                RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
                currUser.SetValue("DafifRoot", textBoxRootDirectory.Text);

                ReloadDafifDB();
            }
        }

        private void ReloadDafifDB() {
            if (ReadVersionFile()) {
                ReadCountryList();
                checkedListBoxCountries.Items.Clear();
                checkedListBoxCountries.Items.AddRange(countries.ToArray());
                string[] usedAirspaces = Directory.GetFiles(textBoxDestDirectory.Text, "*.sdn");
                foreach (string s in usedAirspaces) {
                    string fileName = Path.GetFileNameWithoutExtension(s);
                    for (int i = 0; i < checkedListBoxCountries.Items.Count; i++) {
                        Country c = (Country) checkedListBoxCountries.Items[i];
                        if (c.name.Replace(" ", "") == fileName) {
                            checkedListBoxCountries.SetItemChecked(i, true);
                            break;
                        }
                    }
                }
            }
        }
        private void ReadCountryList() {
            string file;
            string line, code;
            string [] tokens;
            Country c = null;

            string path = textBoxRootDirectory.Text;

            try {
                file = path + "\\appc\\appc_cc_icao.txt";
                if (!File.Exists(file)) {
                    file = path + "\\appc_cc_icao.txt";
                    if (!File.Exists(file)) {
                        throw new Exception(string.Format("Invalid path for DAFIF files ({0})!\nCannot find file appc_cc_icao.txt", path));
                    }
                }

                using (StreamReader inStream = new StreamReader(file)) {
                    code = "";
                    while ((line = inStream.ReadLine()) != null) {
                        tokens = line.Split('\t');
                        if (tokens[0].Length == 2 && tokens[3] == "ALL RECORDS") {
                            if (tokens[0] != code) {
                                c = new Country();
                                c.code = tokens[0];
                                c.name = tokens[1];
                                c.keys.Add(tokens[0], null);
                                countries.Add(c);
                            }
                            code = tokens[0];
                        }
                    }
                }

                // append us state codes
                c = null;
                foreach (Country con in countries) {
                    if (con.code == "US") {
                        c = con;
                        break;
                    }
                }

                if (c != null) {
                    file = path + "\\appc\\appc_us_state_codes.txt";
                    if (!File.Exists(file)) {
                        file = path + "\\appc_us_state_codes.txt";
                        if (!File.Exists(file)) {
                            throw new Exception(string.Format("Invalid path for DAFIF files ({0})!\nCannot find file appc_us_state_codes.txt", path));
                        }
                    }
                    using (StreamReader inStream = new StreamReader(file)) {
                        while ((line = inStream.ReadLine()) != null) {
                            tokens = line.Split('\t');
                            if (tokens[0] != "CCPV") {
                                c.keys.Add(tokens[0], null);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                MessageBox.Show("Error occured while reading country information\n\n" +
                    e.Message + "\n\n" + e.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private bool ReadVersionFile() {
            string file = textBoxRootDirectory.Text + "\\version";
            string line;
            bool ok = true;
            if (File.Exists(file)) {
                using (StreamReader inStream = new StreamReader(file)) {
                    //0402190220041703200407052001
                    //
                    //Position 1-4	Production Cycle      i.e. 0402
                    //Position 5-12	Effective Date 	      DDMMYYYY
                    //Position 13-20  Expiration Date       DDMMYYYY 
                    //Position 21-22	Specification Edition i.e. 07
                    //Position 23-28	Specification Date    MMYYYY
                    line = inStream.ReadLine();
                    validFrom = new DateTime(int.Parse(line.Substring(8, 4)), int.Parse(line.Substring(6, 2)), int.Parse(line.Substring(4, 2)));
                    validTo = new DateTime(int.Parse(line.Substring(16, 4)), int.Parse(line.Substring(14, 2)), int.Parse(line.Substring(12, 2)));
                    if (line.Substring(20, 2) != "07") {
                        MessageBox.Show(this, "This is database specification version " + line.Substring(20, 2) + ".\nCurrently supported is version 07.", "Sorry", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        ok = false;
                    }
                    else {
                        ok = true;
                    }
                }
            }
            else {
                // no longer take care on version info
                //MessageBox.Show("Version information file 'version' not found in directory " + textBoxRootDirectory.Text + "\n\nThis is not a valid Dafif root directory.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                //ok = false;
            }
            return ok;
        }

        private void OnGenerateAirspace(object sender, System.EventArgs e) {
            AirspaceGenerator r = new AirspaceGenerator();
            Cursor = Cursors.WaitCursor;
            progressBar.Maximum = checkedListBoxCountries.CheckedItems.Count;
            progressBar.Value = 0;
            foreach (Country c in checkedListBoxCountries.CheckedItems) {
                labelAirspaceName.Text = c.name + ".sdn";
                labelAirspaceName.Refresh();
                r.GenDatabase(textBoxRootDirectory.Text, c, validTo, textBoxDestDirectory.Text);
                progressBar.PerformStep();
            }
            progressBar.Value = 0;
            labelAirspaceName.Text = "";
            Cursor = Cursors.Default;
        }	
    }
}
