// name   : RecorderBase.cs
// author : Harald Maier
// date   : 18.02.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.IO;
using System.Collections;

namespace SoaringDotNET.Data
{
	/// <summary>
	/// 
	/// </summary>
	public class IGCFile
	{
        public string A = "";
        public string DTE = "";
        public string FXA = "";
        public string PLT = "";
        public string GTY = "";
        public string GID = "";
        public string RFW = "";
        public string RHW = "";
        public string FTY = "";
        public string DTM = "";
        public string CID = "";
        public string CCL = "";
        public string TZN = "";
        public string GPS = "";
        public string PRS = "";
        public string SIT = "";
        public string OOI = "";
        public string CONV = "";
        public string I = "";

        public ArrayList CRecord;
        public ArrayList BRecord;
        public ArrayList GRecord;
        public ArrayList HRecord;

		public IGCFile()
		{
			// 
			// TODO: Add constructor logic here
			//
            BRecord = new ArrayList();
            CRecord = new ArrayList();
            GRecord = new ArrayList();
            // for unknown records only
            HRecord = new ArrayList();
            Reset();
        }

        public void Write(string path) {
            StreamWriter w = new StreamWriter(path);

            w.WriteLine(A);
            w.WriteLine(DTE);
            w.WriteLine(FXA);
            w.WriteLine(PLT);
            w.WriteLine(GTY);
            w.WriteLine(GID);
            w.WriteLine(DTM);
            w.WriteLine(RFW);
            w.WriteLine(RHW);
            w.WriteLine(FTY);
            if (GPS != "") {
                w.WriteLine(GPS);
            }
            if (PRS != "") {
                w.WriteLine(PRS);
            }
            w.WriteLine(CID);
            w.WriteLine(CCL);
            if (SIT != "") {
                w.WriteLine(SIT);
            }

            if (OOI != "") {
                w.WriteLine(OOI);
            }

            if (TZN != "") {
                w.WriteLine("HFTZNTIMEZONE:{0}", TZN);
            }

            // write all unknown H-records
            foreach (string s in HRecord) {
                w.WriteLine(s);
            }

            if (I != "") {
                w.WriteLine(I);
            }

            if (CONV != "") {
                w.WriteLine(CONV);
            }


            foreach (string s in CRecord) {
                w.WriteLine(s);
            }

            foreach (string s in BRecord) {
                w.WriteLine(s);
            }

            foreach (string s in GRecord) {
                w.WriteLine(s);
            }
            w.Close();
        }

        public void Reset() {
            A = "";
            DTE = "";
            FXA = "";
            PLT = "";
            GTY = "";
            GID = "";
            RFW = "";
            RHW = "";
            FTY = "";
            DTM = "";
            CID = "";
            CCL = "";
            TZN = "";
            GPS = "";
            PRS = "";
            SIT = "";
            OOI = "";
            CONV = "";
            I = "";
            BRecord.Clear();
            CRecord.Clear();
            GRecord.Clear();
            HRecord.Clear();
        }
	}
}
