using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;

using SoaringDotNET.Data;
using SoaringDotNET.FileFormats;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for ImportSUAOptionsDialog.
	/// </summary>
	public class ImportSUAOptionsDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.CheckBox checkBoxLorenzMeier;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.ComboBox comboBoxDefaultAirspace;
        private System.Windows.Forms.Button buttonSUAFile;
        private System.Windows.Forms.TextBox textBoxSUAFile;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.RadioButton radioButtonClassUseIfNotSet;
        private System.Windows.Forms.GroupBox groupBox2;
        private System.Windows.Forms.RadioButton radioButtonTypeAsDefined;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.ComboBox comboBoxDefaultType;
        private System.Windows.Forms.RadioButton radioButtonTypeOverwrite;
        private System.Windows.Forms.GroupBox groupBox3;
        private System.Windows.Forms.RadioButton radioButtonFormatTNP;
        private System.Windows.Forms.RadioButton radioButtonFormatOpenAir;
        private System.Windows.Forms.RadioButton radioButtonFormatDontKnow;
        private System.Windows.Forms.RadioButton radioButtonClassOverwrite;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.ComboBox comboBoxCountry;
        private System.Windows.Forms.GroupBox groupBox4;
        private System.Windows.Forms.RadioButton radioButtonAppendDatabase;
        private System.Windows.Forms.RadioButton radioButtonOverwriteDatabase;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ImportSUAOptionsDialog()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            foreach (IdType c in AppContents.airspaceClasses) {
                comboBoxDefaultAirspace.Items.Add(c);
            }
            comboBoxDefaultAirspace.SelectedIndex = comboBoxDefaultAirspace.FindString("Class C");

            foreach (IdType s in AppContents.suaTypes) {
                comboBoxDefaultType.Items.Add(s);
            }
            comboBoxDefaultType.SelectedIndex = comboBoxDefaultType.FindString("CTA/CTR");

            foreach (IdType t in AppContents.countryTypes) {
                comboBoxCountry.Items.Add(t);
            }
        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.buttonOK = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.checkBoxLorenzMeier = new System.Windows.Forms.CheckBox();
            this.label1 = new System.Windows.Forms.Label();
            this.comboBoxDefaultAirspace = new System.Windows.Forms.ComboBox();
            this.buttonSUAFile = new System.Windows.Forms.Button();
            this.textBoxSUAFile = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.radioButtonClassOverwrite = new System.Windows.Forms.RadioButton();
            this.radioButtonClassUseIfNotSet = new System.Windows.Forms.RadioButton();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.comboBoxDefaultType = new System.Windows.Forms.ComboBox();
            this.label3 = new System.Windows.Forms.Label();
            this.radioButtonTypeOverwrite = new System.Windows.Forms.RadioButton();
            this.radioButtonTypeAsDefined = new System.Windows.Forms.RadioButton();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.radioButtonFormatDontKnow = new System.Windows.Forms.RadioButton();
            this.radioButtonFormatOpenAir = new System.Windows.Forms.RadioButton();
            this.radioButtonFormatTNP = new System.Windows.Forms.RadioButton();
            this.label4 = new System.Windows.Forms.Label();
            this.comboBoxCountry = new System.Windows.Forms.ComboBox();
            this.groupBox4 = new System.Windows.Forms.GroupBox();
            this.radioButtonOverwriteDatabase = new System.Windows.Forms.RadioButton();
            this.radioButtonAppendDatabase = new System.Windows.Forms.RadioButton();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.groupBox3.SuspendLayout();
            this.groupBox4.SuspendLayout();
            this.SuspendLayout();
            // 
            // buttonOK
            // 
            this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOK.Location = new System.Drawing.Point(236, 304);
            this.buttonOK.Name = "buttonOK";
            this.buttonOK.TabIndex = 0;
            this.buttonOK.Text = "OK";
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(332, 304);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.TabIndex = 1;
            this.buttonCancel.Text = "Cancel";
            // 
            // checkBoxLorenzMeier
            // 
            this.checkBoxLorenzMeier.Location = new System.Drawing.Point(16, 96);
            this.checkBoxLorenzMeier.Name = "checkBoxLorenzMeier";
            this.checkBoxLorenzMeier.Size = new System.Drawing.Size(248, 32);
            this.checkBoxLorenzMeier.TabIndex = 2;
            this.checkBoxLorenzMeier.Text = "Determine airspace type from title generated by Michael-Lorenz Meiers collection";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(16, 24);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(150, 16);
            this.label1.TabIndex = 3;
            this.label1.Text = "Class for controlled airspace:";
            // 
            // comboBoxDefaultAirspace
            // 
            this.comboBoxDefaultAirspace.Location = new System.Drawing.Point(16, 40);
            this.comboBoxDefaultAirspace.Name = "comboBoxDefaultAirspace";
            this.comboBoxDefaultAirspace.Size = new System.Drawing.Size(144, 21);
            this.comboBoxDefaultAirspace.Sorted = true;
            this.comboBoxDefaultAirspace.TabIndex = 4;
            // 
            // buttonSUAFile
            // 
            this.buttonSUAFile.Location = new System.Drawing.Point(608, 24);
            this.buttonSUAFile.Name = "buttonSUAFile";
            this.buttonSUAFile.Size = new System.Drawing.Size(24, 20);
            this.buttonSUAFile.TabIndex = 7;
            this.buttonSUAFile.Text = "...";
            this.buttonSUAFile.Click += new System.EventHandler(this.OnSelectSUAFile);
            // 
            // textBoxSUAFile
            // 
            this.textBoxSUAFile.Location = new System.Drawing.Point(8, 24);
            this.textBoxSUAFile.Name = "textBoxSUAFile";
            this.textBoxSUAFile.Size = new System.Drawing.Size(600, 20);
            this.textBoxSUAFile.TabIndex = 6;
            this.textBoxSUAFile.Text = "";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(8, 8);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(51, 16);
            this.label2.TabIndex = 5;
            this.label2.Text = "SUA files";
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.radioButtonClassOverwrite);
            this.groupBox1.Controls.Add(this.radioButtonClassUseIfNotSet);
            this.groupBox1.Controls.Add(this.label1);
            this.groupBox1.Controls.Add(this.comboBoxDefaultAirspace);
            this.groupBox1.Location = new System.Drawing.Point(8, 160);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(312, 96);
            this.groupBox1.TabIndex = 8;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Class options";
            // 
            // radioButtonClassOverwrite
            // 
            this.radioButtonClassOverwrite.Location = new System.Drawing.Point(176, 64);
            this.radioButtonClassOverwrite.Name = "radioButtonClassOverwrite";
            this.radioButtonClassOverwrite.TabIndex = 6;
            this.radioButtonClassOverwrite.Text = "overwrite all";
            // 
            // radioButtonClassUseIfNotSet
            // 
            this.radioButtonClassUseIfNotSet.Checked = true;
            this.radioButtonClassUseIfNotSet.Location = new System.Drawing.Point(176, 40);
            this.radioButtonClassUseIfNotSet.Name = "radioButtonClassUseIfNotSet";
            this.radioButtonClassUseIfNotSet.Size = new System.Drawing.Size(112, 24);
            this.radioButtonClassUseIfNotSet.TabIndex = 5;
            this.radioButtonClassUseIfNotSet.TabStop = true;
            this.radioButtonClassUseIfNotSet.Text = "use only if not set";
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.comboBoxDefaultType);
            this.groupBox2.Controls.Add(this.label3);
            this.groupBox2.Controls.Add(this.radioButtonTypeOverwrite);
            this.groupBox2.Controls.Add(this.radioButtonTypeAsDefined);
            this.groupBox2.Controls.Add(this.checkBoxLorenzMeier);
            this.groupBox2.Location = new System.Drawing.Point(328, 160);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(304, 136);
            this.groupBox2.TabIndex = 9;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Type options";
            // 
            // comboBoxDefaultType
            // 
            this.comboBoxDefaultType.Location = new System.Drawing.Point(136, 64);
            this.comboBoxDefaultType.Name = "comboBoxDefaultType";
            this.comboBoxDefaultType.Size = new System.Drawing.Size(152, 21);
            this.comboBoxDefaultType.Sorted = true;
            this.comboBoxDefaultType.TabIndex = 10;
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(16, 24);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(29, 16);
            this.label3.TabIndex = 9;
            this.label3.Text = "Type";
            // 
            // radioButtonTypeOverwrite
            // 
            this.radioButtonTypeOverwrite.Location = new System.Drawing.Point(24, 64);
            this.radioButtonTypeOverwrite.Name = "radioButtonTypeOverwrite";
            this.radioButtonTypeOverwrite.Size = new System.Drawing.Size(128, 24);
            this.radioButtonTypeOverwrite.TabIndex = 8;
            this.radioButtonTypeOverwrite.Text = "overwrite all with";
            // 
            // radioButtonTypeAsDefined
            // 
            this.radioButtonTypeAsDefined.Checked = true;
            this.radioButtonTypeAsDefined.Location = new System.Drawing.Point(24, 40);
            this.radioButtonTypeAsDefined.Name = "radioButtonTypeAsDefined";
            this.radioButtonTypeAsDefined.TabIndex = 7;
            this.radioButtonTypeAsDefined.TabStop = true;
            this.radioButtonTypeAsDefined.Text = "as defined in file";
            // 
            // groupBox3
            // 
            this.groupBox3.Controls.Add(this.radioButtonFormatDontKnow);
            this.groupBox3.Controls.Add(this.radioButtonFormatOpenAir);
            this.groupBox3.Controls.Add(this.radioButtonFormatTNP);
            this.groupBox3.Location = new System.Drawing.Point(328, 56);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(304, 96);
            this.groupBox3.TabIndex = 10;
            this.groupBox3.TabStop = false;
            this.groupBox3.Text = "File format";
            // 
            // radioButtonFormatDontKnow
            // 
            this.radioButtonFormatDontKnow.Checked = true;
            this.radioButtonFormatDontKnow.Location = new System.Drawing.Point(16, 64);
            this.radioButtonFormatDontKnow.Name = "radioButtonFormatDontKnow";
            this.radioButtonFormatDontKnow.Size = new System.Drawing.Size(160, 24);
            this.radioButtonFormatDontKnow.TabIndex = 2;
            this.radioButtonFormatDontKnow.TabStop = true;
            this.radioButtonFormatDontKnow.Text = "unknown, try to detect";
            // 
            // radioButtonFormatOpenAir
            // 
            this.radioButtonFormatOpenAir.Location = new System.Drawing.Point(16, 40);
            this.radioButtonFormatOpenAir.Name = "radioButtonFormatOpenAir";
            this.radioButtonFormatOpenAir.Size = new System.Drawing.Size(160, 24);
            this.radioButtonFormatOpenAir.TabIndex = 1;
            this.radioButtonFormatOpenAir.Text = "Open Air";
            // 
            // radioButtonFormatTNP
            // 
            this.radioButtonFormatTNP.Location = new System.Drawing.Point(16, 16);
            this.radioButtonFormatTNP.Name = "radioButtonFormatTNP";
            this.radioButtonFormatTNP.Size = new System.Drawing.Size(160, 24);
            this.radioButtonFormatTNP.TabIndex = 0;
            this.radioButtonFormatTNP.Text = "Tim Newport-Peace";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(16, 24);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(44, 16);
            this.label4.TabIndex = 11;
            this.label4.Text = "Country";
            // 
            // comboBoxCountry
            // 
            this.comboBoxCountry.Location = new System.Drawing.Point(16, 40);
            this.comboBoxCountry.Name = "comboBoxCountry";
            this.comboBoxCountry.Size = new System.Drawing.Size(144, 21);
            this.comboBoxCountry.Sorted = true;
            this.comboBoxCountry.TabIndex = 12;
            // 
            // groupBox4
            // 
            this.groupBox4.Controls.Add(this.radioButtonOverwriteDatabase);
            this.groupBox4.Controls.Add(this.radioButtonAppendDatabase);
            this.groupBox4.Controls.Add(this.comboBoxCountry);
            this.groupBox4.Controls.Add(this.label4);
            this.groupBox4.Location = new System.Drawing.Point(8, 56);
            this.groupBox4.Name = "groupBox4";
            this.groupBox4.Size = new System.Drawing.Size(312, 96);
            this.groupBox4.TabIndex = 13;
            this.groupBox4.TabStop = false;
            this.groupBox4.Text = "Database options";
            // 
            // radioButtonOverwriteDatabase
            // 
            this.radioButtonOverwriteDatabase.Location = new System.Drawing.Point(176, 64);
            this.radioButtonOverwriteDatabase.Name = "radioButtonOverwriteDatabase";
            this.radioButtonOverwriteDatabase.Size = new System.Drawing.Size(120, 24);
            this.radioButtonOverwriteDatabase.TabIndex = 14;
            this.radioButtonOverwriteDatabase.Text = "overwrite database";
            // 
            // radioButtonAppendDatabase
            // 
            this.radioButtonAppendDatabase.Checked = true;
            this.radioButtonAppendDatabase.Location = new System.Drawing.Point(176, 40);
            this.radioButtonAppendDatabase.Name = "radioButtonAppendDatabase";
            this.radioButtonAppendDatabase.Size = new System.Drawing.Size(112, 24);
            this.radioButtonAppendDatabase.TabIndex = 13;
            this.radioButtonAppendDatabase.TabStop = true;
            this.radioButtonAppendDatabase.Text = "append database";
            // 
            // ImportSUAOptionsDialog
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(642, 336);
            this.Controls.Add(this.groupBox4);
            this.Controls.Add(this.groupBox3);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.buttonSUAFile);
            this.Controls.Add(this.textBoxSUAFile);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOK);
            this.Controls.Add(this.groupBox1);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.Name = "ImportSUAOptionsDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Import SUA options";
            this.groupBox1.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.groupBox3.ResumeLayout(false);
            this.groupBox4.ResumeLayout(false);
            this.ResumeLayout(false);

        }
		#endregion

        private void OnSelectSUAFile(object sender, System.EventArgs e) {
            OpenFileDialog fd = new OpenFileDialog();
            fd.Filter = "SUA files(*.sua;*.air;*.dat;*.txt)|*.sua;*.air;*.dat;*.txt|All files (*.*)|*.*";
            fd.Multiselect = true;
            RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");

            if (fd.ShowDialog(this) == DialogResult.OK) {
                textBoxSUAFile.Text = string.Join(";", fd.FileNames);
            }
        }

        public string [] FileNames {
            get {
                return textBoxSUAFile.Text.Split(';');
            }
        }

        public SUAFileFormat FileFormat {
            get {
                SUAFileFormat format = SUAFileFormat.Unknown;
                if (radioButtonFormatOpenAir.Checked) {
                    format = SUAFileFormat.OpenAir;
                }
                else if (radioButtonFormatTNP.Checked) {
                    format = SUAFileFormat.TNP;
                }
                return format;
            }
        }

        public bool UseMichaelMeier {
            get {
                return checkBoxLorenzMeier.Checked;
            }
        }

        public bool OverwriteClass {
            get {
                return radioButtonClassOverwrite.Checked;
            }
        }

        public bool OverwriteType {
            get {
                return radioButtonTypeOverwrite.Checked;
            }
        }

        public AirspaceClasses DefaultAirspace {
            get {
                AirspaceClasses space = AirspaceClasses.Unknown;
                IdType type = (IdType) comboBoxDefaultAirspace.SelectedItem;
                if (type != null) {
                    space = (AirspaceClasses) type.id;
                }
                return space;
            }
        }

        public SUATypes DefaultType {
            get {
                SUATypes type = SUATypes.Unknown;
                IdType selectedType = (IdType) comboBoxDefaultType.SelectedItem;
                if (selectedType != null) {
                    type = (SUATypes) selectedType.id;
                }
                return type;
            }
        }

        public Country Country {
            get {
                CountryTypeId country;
                Country c = new Country();
                if (comboBoxCountry.SelectedItem != null) {
                    country = (CountryTypeId)((IdType)comboBoxCountry.SelectedItem).id;
                }
                else {
                    country = CountryTypeId.Unknown;
                }

                c.code = (string)AppContents.countryTypesById[country];
                c.name = country.ToString();
                return c;
            }
        }

        public bool OverwriteDB {
            get {
                return radioButtonOverwriteDatabase.Checked;
            }
        }
	}
}
