// name   : LegOptimizationBase.cs
// author : Harald Maier
// date   : 11.01.2006
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
	/// <summary>
	/// 
	/// </summary>
	public abstract class LegOptimizationBase : SoaringDotNET.Optimization.OptimizationBase
	{
        protected int LEGS = 0;

        public LegOptimizationBase(Flight flight) : 
            base(flight) 
		{
			// 
			// TODO: Add constructor logic here
			//
		}

        public void OptimizeLegs(ArrayList ranges) {
            OptimizeLegs(ranges, LEGS);
        }

        public void OptimizeLegs(ArrayList ranges, int minLegs) {
            float [][]lengthValues;
            float [] prevLeg;
            float [] currentLeg;
            float [] lVector;
            int [][] wayPoints;
            int [] currentWaypoints;
            int [] pointList;
            int [] tmpPointList;
            int N;
            int leg, i, j;
            int start, stop, maxLeg, bestMaxLeg = LEGS;
            float length, length2, points, prevPoints;
            FlightPoint p;
            WayPoint wp;
            string t;
            float w;

            N = flight.Count;

            if (LEGS < 1) {
                throw new Exception("internal error: no LEG specification in optimization class");
            }

            lengthValues = new float[LEGS + 1][];
            wayPoints = new int[LEGS + 1][];
            pointList = new int[LEGS + 1];
            tmpPointList = new int[LEGS + 1];

            optimizedTask.Clear();

            for (i = 0; i < LEGS + 1; i++) {
                lengthValues[i] = new float[N];
                wayPoints[i] = new int[N];
            }

            prevPoints = 0;
            for (maxLeg = LEGS; maxLeg >= minLegs; maxLeg--) {
                foreach (int []indexes in ranges) {
                    start = indexes[0];
                    stop = indexes[1];
                    for (i = 0; i < LEGS + 1; i++) {
                        Array.Clear(lengthValues[i], 0, N);
                        Array.Clear(wayPoints[i], 0, N);
                    }

                    for (leg = 1; leg <= maxLeg; leg++) {
                        w = weight[leg - 1];
                        currentLeg = lengthValues[leg];
                        currentWaypoints = wayPoints[leg];
                        prevLeg = lengthValues[leg - 1];
                        for (i = start; i <= stop; i++) {
                            lVector = flight.lengthMatrix[i];
                            length2 = currentLeg[i];
                            for (j = start; j < i; j++) {
                                length = prevLeg[j] + (w * lVector[j]);
                                if (length > length2) {
                                    currentLeg[i] = length;
                                    currentWaypoints[i] = j;
                                    length2 = length;
                                }
                            }
                        }
                    }

                    currentLeg = lengthValues[maxLeg];
                    points = 0.0f;
                    for (i = start; i <= stop; i++){
                        if(currentLeg[i] > points){
                            points = currentLeg[i];
                            tmpPointList[maxLeg] = i;
                        }
                    }

                    if (points > prevPoints) {
                        prevPoints = points;
                        tmpPointList.CopyTo(pointList, 0);
                        bestMaxLeg = maxLeg;
                        for (leg = maxLeg; leg > 0; leg--){
                            pointList[leg - 1] = wayPoints[leg][pointList[leg]];
                        }
                    }
                }
            }

            p = flight[flight.Takeoff];
            wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Takeoff", WayPointTypeId.Unknown);
            wp.reachPoint = p;
            optimizedTask.Add(wp);

            for (leg = 0; leg <= bestMaxLeg; leg++) {
                if (leg == 0) {
                    t = "Start";
                }
                else if (leg == bestMaxLeg) {
                    t = "Finish";
                }
                else {
                    t = string.Format("TP {0}", leg);
                }
                p = flight[pointList[leg]];
                wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, t, WayPointTypeId.Unknown);
                wp.reachPoint = p;
                optimizedTask.Add(wp);
            }

            p = flight[flight.Landing];
            wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Landing", WayPointTypeId.Unknown);
            wp.reachPoint = p;
            optimizedTask.Add(wp);
        }

        public virtual bool CheckMaxElevation(int [] pointList, int start, int stop) {
            return true;
        }

	}
}
