// name   : OLCClassic2006.cs
// author : Harald Maier
// date   : 03.01.2006
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
	/// <summary>
	/// 
	/// </summary>
	public class OLC2006Classic : SoaringDotNET.Optimization.LegOptimizationBase
	{
        public OLC2006Classic(Flight flight) : 
            base(flight)
		{
			// 
			// TODO: Add constructor logic here
			//
            LEGS = 6;
            weight = new float [] {1.0f, 1.0f, 1.0f, 1.0f, 0.8f, 0.6f};
            optimizedTask.OptimizedFor = OptimizeTypes.OLC;
        }

        public override void Optimize() {
            int N;
            int i, j;
            int start, stop;
            ArrayList ranges = new ArrayList();
            FlightPoint p;
            double elevation;
            
            N = flight.Count;
            start = flight.Start != -1 ? flight.Start : 0;
            stop = flight.Stop != -1 ? flight.Stop : N - 1;

            status = OptimizataionStatus.Running;

            if (flight[start].Elevation - flight[stop].Elevation <= 1000.0) {
                ranges.Add(new int [] {start, stop});
            }
            else {
                // increase start until diff to finish <= 1000m
                int maxDiff = 0;
                for (i = start; i < stop; i++) {
                    p = flight[i];
                    elevation = p.Elevation;
                    for (j = stop; j > i; j--) {
                        if (elevation - flight[j].Elevation <= 1000.0 && j - i > maxDiff) {
                            ranges.Add(new int [] {i, j});
                            maxDiff = j - i;
                            break;
                        }
                    }
                }
            }

            OptimizeLegs(ranges, 4);

            status = OptimizataionStatus.Idle;
        }

        public override string ToString() {
            // TODO:  Add OLC2003.ToString implementation
            return "OLC 2006 Classic";
        }    
    }
}
