// name   : OLC2006FAI.cs
// author : Harald Maier
// date   : 09.01.2006
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
	/// <summary>
	/// 
	/// </summary>
	public class OLC2006FAI : SoaringDotNET.Optimization.TriangleOptimizationBase
	{
        public OLC2006FAI(Flight flight) : 
            base(flight)
        {
			// 
			// TODO: Add constructor logic here
			//
            weight = new float [] {1.0f, 1.0f, 1.0f};
            optimizedTask.OptimizedFor = OptimizeTypes.OLC;
        }

        public override void Optimize() {
            // TODO:  Add OLC2006FAI.Optimize implementation
            int i;
            int start, stop, step;
            int [] triangleStart = {0, 0, 0};
            int [] triangleStop = {0, 0, 0};
            ArrayList triangles = new ArrayList();
            FAITriangle []calculatedPoints = new FAITriangle[25];
            FAITriangle triangle;
            FAITriangle best = new FAITriangle();
            FlightPoint p;
            WayPoint wp;
            SectorDefinition sector;

            start = flight.Start != -1 ? flight.Start : 0;
            stop = flight.Stop != -1 ? flight.Stop : flight.Count - 1;

            status = OptimizataionStatus.Running;

            optimizedTask.Clear();

            for (i = 0; i < 25; i++) {
                triangles.Add(new FAITriangle());
            }

            // calculate largest FAI for each section
            triangleStart[0] = start;
            triangleStart[1] = start;
            triangleStart[2] = start;
            triangleStop[0] = stop;
            triangleStop[1] = stop;
            triangleStop[2] = stop;

            step = CalcStepSize(start, stop);
            // first iteration step
            OptimizeFAITriangle(triangleStart, triangleStop, step, start, stop, triangles, true);
            triangles.CopyTo(calculatedPoints);

            // now refine iteration for every triangle
            foreach (FAITriangle t in calculatedPoints) {
                triangleStart[0] = Math.Max(t.p1 - step, start);
                triangleStart[1] = Math.Max(t.p2 - step, start);
                triangleStart[2] = Math.Max(t.p3 - step, start);

                triangleStop[0] = Math.Min(triangleStart[0] + (2 * step), stop);
                triangleStop[1] = Math.Min(triangleStart[1] + (2 * step), stop);
                triangleStop[2] = Math.Min(triangleStart[2] + (2 * step), stop);

                if (triangleStart[0] > 0 && triangleStart[1] > 0 && triangleStart[2] > 0 &&
                    triangleStop[0] < flight.Count && triangleStop[1] < flight.Count && triangleStop[2] < flight.Count) {
                    OptimizeFAITriangle(triangleStart, triangleStop, 1, start, stop, triangles, false);
                }
            }

            triangle = (FAITriangle)triangles[0];
            if (triangle.length > 0.0) {
                if (triangle.p1 > triangle.p2 || triangle.p1 > triangle.p3 || best.p2 > triangle.p3) {
                    MessageBox.Show("No valid or finished FAI triangle found!", "Inforamtion", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else {
                    p = flight[flight.Takeoff];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Takeoff", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    p = flight[triangle.idx1];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Start", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    p = flight[triangle.p1];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "TP 1", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    p = flight[triangle.p2];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "TP 2", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    p = flight[triangle.p3];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "TP 3", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    p = flight[triangle.idx2];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Finish", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    p = flight[flight.Landing];
                    wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Landing", WayPointTypeId.Unknown);
                    wp.reachPoint = p;
                    optimizedTask.Add(wp);

                    // set sector of start to show OLC rules, finish <= 1km to start
                    sector = optimizedTask.GetSector(1);
                    sector.radius2 = 1000;
                    sector.sectorType = SectorTypes.Sector;
                    optimizedTask.SetSector(1, sector);
                }
            }

            status = OptimizataionStatus.Idle;            
        }

        public override string ToString() {
            // TODO:  Add DMSt2004FAI.ToString implementation
            return "OLC 2006 FAI Triangle";
        }
    
        protected override bool isValid(int loopA, int loopC, int soaringStart, int soaringStop, ref int startOfTask, ref int stopOfTask) {
            int i, j;
            int startElev = flight.minElevationSinceStartOfTask[loopA];
            bool acceptHeight = false;
            float []lengthVector;
            float [][] lengthMatrix = flight.lengthMatrix;

            for (i = loopC; i <= soaringStop; i++) {
                if (startElev - flight[i].Elevation <= 1000) {
                    acceptHeight = true;
                    break;
                }
            }
            
            if (acceptHeight) {
                if (loopA < startOfTask || loopC > stopOfTask) {
                    acceptHeight = false;
                    for (i = soaringStop; i >= loopC; i--) {
                        lengthVector = lengthMatrix[i];
                        for (j = soaringStart; j <= loopA; j++) {
                            if (lengthVector[j] <= 1.0) {
                                startOfTask = j;
                                stopOfTask = i;
                                return true;
                            }
                        }
                    }
                }
            }

            return acceptHeight;
        }
    }
}
