using System;
using System.Windows.Forms;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// 
	/// </summary>
	public class Objects : System.Windows.Forms.UserControl
	{
        private System.Windows.Forms.ContextMenu contextMenuFlights;
        private System.Windows.Forms.MenuItem menuItemOpenFlight;
        private System.Windows.Forms.MenuItem menuItemCloseFlight;
        private System.Windows.Forms.ContextMenu contextMenuTasks;
        private System.Windows.Forms.MenuItem menuItemNewTask;
        private System.Windows.Forms.MenuItem menuItemEditTask;
        private System.Windows.Forms.MenuItem menuItemDeleteTask;
        private System.Windows.Forms.MenuItem menuItem2;
        private System.Windows.Forms.MenuItem menuItemOpenTasks;
        private System.Windows.Forms.MenuItem menuItemSaveTasks;
        private System.Windows.Forms.MenuItem menuItemSaveTasksAs;
        private System.Windows.Forms.MenuItem menuItemCloseTasks;
        private System.Windows.Forms.ContextMenu contextMenuWaypoints;
        private System.Windows.Forms.MenuItem menuItemOpenCatalogue;
        private System.Windows.Forms.MenuItem menuItemDeleteCatalogue;
        private System.Windows.Forms.MenuItem menuItemSaveCatalogue;
        private System.Windows.Forms.MenuItem menuItemSaveCatalogueAs;
        private System.Windows.Forms.MenuItem menuItemCloseCatalogue;
        private System.Windows.Forms.TreeView objectsView;
        private System.Windows.Forms.TreeNode flightNode;
        private System.Windows.Forms.TreeNode taskNode;
        private System.Windows.Forms.TreeNode waypointNode;

        private void InitializeComponent() {
            this.objectsView = new System.Windows.Forms.TreeView();
            this.contextMenuFlights = new System.Windows.Forms.ContextMenu();
            this.menuItemOpenFlight = new System.Windows.Forms.MenuItem();
            this.menuItemCloseFlight = new System.Windows.Forms.MenuItem();
            this.contextMenuTasks = new System.Windows.Forms.ContextMenu();
            this.menuItemNewTask = new System.Windows.Forms.MenuItem();
            this.menuItemEditTask = new System.Windows.Forms.MenuItem();
            this.menuItemDeleteTask = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.menuItemOpenTasks = new System.Windows.Forms.MenuItem();
            this.menuItemSaveTasks = new System.Windows.Forms.MenuItem();
            this.menuItemSaveTasksAs = new System.Windows.Forms.MenuItem();
            this.menuItemCloseTasks = new System.Windows.Forms.MenuItem();
            this.contextMenuWaypoints = new System.Windows.Forms.ContextMenu();
            this.menuItemOpenCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemDeleteCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemSaveCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemSaveCatalogueAs = new System.Windows.Forms.MenuItem();
            this.menuItemCloseCatalogue = new System.Windows.Forms.MenuItem();
            this.SuspendLayout();
            // 
            // objectsView
            // 
            this.objectsView.Dock = System.Windows.Forms.DockStyle.Fill;
            this.objectsView.HideSelection = false;
            this.objectsView.ImageIndex = -1;
            this.objectsView.Location = new System.Drawing.Point(0, 0);
            this.objectsView.Name = "objectsView";
            this.objectsView.SelectedImageIndex = -1;
            this.objectsView.Size = new System.Drawing.Size(200, 288);
            this.objectsView.TabIndex = 0;
            this.objectsView.MouseDown += new System.Windows.Forms.MouseEventHandler(this.objectsView_MouseDown);
            this.objectsView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.objectsView_AfterSelect);
            // 
            // contextMenuFlights
            // 
            this.contextMenuFlights.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                               this.menuItemOpenFlight,
                                                                                               this.menuItemCloseFlight});
            // 
            // menuItemOpenFlight
            // 
            this.menuItemOpenFlight.Index = 0;
            this.menuItemOpenFlight.Text = "&Open flight";
            this.menuItemOpenFlight.Click += new System.EventHandler(this.OnOpenFlight);
            // 
            // menuItemCloseFlight
            // 
            this.menuItemCloseFlight.Index = 1;
            this.menuItemCloseFlight.Text = "&Close flight";
            this.menuItemCloseFlight.Click += new System.EventHandler(this.OnCloseFlight);
            // 
            // contextMenuTasks
            // 
            this.contextMenuTasks.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                             this.menuItemNewTask,
                                                                                             this.menuItemEditTask,
                                                                                             this.menuItemDeleteTask,
                                                                                             this.menuItem2,
                                                                                             this.menuItemOpenTasks,
                                                                                             this.menuItemSaveTasks,
                                                                                             this.menuItemSaveTasksAs,
                                                                                             this.menuItemCloseTasks});
            // 
            // menuItemNewTask
            // 
            this.menuItemNewTask.Index = 0;
            this.menuItemNewTask.Text = "&New task";
            // 
            // menuItemEditTask
            // 
            this.menuItemEditTask.Index = 1;
            this.menuItemEditTask.Text = "&Edit task";
            // 
            // menuItemDeleteTask
            // 
            this.menuItemDeleteTask.Index = 2;
            this.menuItemDeleteTask.Text = "&Delete task";
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 3;
            this.menuItem2.Text = "-";
            // 
            // menuItemOpenTasks
            // 
            this.menuItemOpenTasks.Index = 4;
            this.menuItemOpenTasks.Text = "&Open tasks";
            // 
            // menuItemSaveTasks
            // 
            this.menuItemSaveTasks.Index = 5;
            this.menuItemSaveTasks.Text = "&Save tasks";
            // 
            // menuItemSaveTasksAs
            // 
            this.menuItemSaveTasksAs.Index = 6;
            this.menuItemSaveTasksAs.Text = "Save tasks &as";
            // 
            // menuItemCloseTasks
            // 
            this.menuItemCloseTasks.Index = 7;
            this.menuItemCloseTasks.Text = "&Close tasks";
            // 
            // contextMenuWaypoints
            // 
            this.contextMenuWaypoints.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                                 this.menuItemOpenCatalogue,
                                                                                                 this.menuItemDeleteCatalogue,
                                                                                                 this.menuItemSaveCatalogue,
                                                                                                 this.menuItemSaveCatalogueAs,
                                                                                                 this.menuItemCloseCatalogue});
            // 
            // menuItemOpenCatalogue
            // 
            this.menuItemOpenCatalogue.Index = 0;
            this.menuItemOpenCatalogue.Text = "&Open catalogue";
            // 
            // menuItemDeleteCatalogue
            // 
            this.menuItemDeleteCatalogue.Index = 1;
            this.menuItemDeleteCatalogue.Text = "&Delete catalogue";
            // 
            // menuItemSaveCatalogue
            // 
            this.menuItemSaveCatalogue.Index = 2;
            this.menuItemSaveCatalogue.Text = "&Save catalogue";
            // 
            // menuItemSaveCatalogueAs
            // 
            this.menuItemSaveCatalogueAs.Index = 3;
            this.menuItemSaveCatalogueAs.Text = "Save catalogue &as";
            // 
            // menuItemCloseCatalogue
            // 
            this.menuItemCloseCatalogue.Index = 4;
            this.menuItemCloseCatalogue.Text = "&Close catalogue";
            // 
            // Objects
            // 
            this.Controls.Add(this.objectsView);
            this.Name = "Objects";
            this.Size = new System.Drawing.Size(200, 288);
            this.ResumeLayout(false);

        }
    
		public Objects()
		{
            InitializeComponent();
			// 
			// TODO: Add constructor logic here
			//
            flightNode = new TreeNode("Flights");
            taskNode = new TreeNode("Tasks");
            waypointNode = new TreeNode("Waypoints");

            objectsView.Nodes.Add(flightNode);
            objectsView.Nodes.Add(taskNode);
            objectsView.Nodes.Add(waypointNode);
        }

        private void objectsView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e) {
            TreeNode n = e.Node;
            while (n.Parent != null) {
                n = n.Parent;
            }
            if (n == flightNode) {
                objectsView.ContextMenu = contextMenuFlights;
            }
            else if (n == taskNode) {
                objectsView.ContextMenu = contextMenuTasks;
            }
            else if (n == waypointNode) {
                objectsView.ContextMenu = contextMenuWaypoints;
            }
            else {
                objectsView.ContextMenu = null;
            }
        }

        private void objectsView_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e) {
            if (e.Button == MouseButtons.Right) {
                objectsView.SelectedNode = objectsView.GetNodeAt(e.X, e.Y);
            }
        }

        private void OnOpenFlight(object sender, System.EventArgs e) {
            ((SoaringDotNet)ParentForm).OpenFlight();
        }

        private void OnCloseFlight(object sender, System.EventArgs e) {
            ((SoaringDotNet)ParentForm).CloseFlight();
        }
	}
}
