// name   : OptimizationBase.cs
// author : Harald Maier
// date   : 02.04.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
    public enum OptimizeTypes {Unknown, OLC, DMST, DMSTFreeFlight, OriginalTask};
    public enum OptimizataionStatus {Idle, Running};

    public class FAITriangle {
        public double length;
        public int p1, p2, p3;
        public int idx1, idx2;
    }

    public struct LegStartIdx {
        public double length;
        public int idx;

        public LegStartIdx(double lenght, int idx) {
            this.length = lenght;
            this.idx = idx;
        }
    }

	/// <summary>
	/// 
	/// </summary>
	public abstract class OptimizationBase
	{
        protected OptimizataionStatus status = OptimizataionStatus.Idle;
        protected Flight flight;
        protected Task optimizedTask;
        protected float [] weight;

		public OptimizationBase(Flight flight)
		{
			// 
			// TODO: Add constructor logic here
			//
            this.flight = flight;
            optimizedTask = new Task();
		}

        #region Attributes
        public OptimizataionStatus Status {
            get {
                return status;
            }
        }

        public Task OptimizedTask {
            get {
                return optimizedTask;
            }
        }

        public double TaskPoints {
            get {
                int i;
                WayPoint wp;
                double length;
                double sumPoints = 0, points;

                for (i = 0; i < optimizedTask.Count; i++) {
                    wp = optimizedTask[i];
                    length = (i > 0 ? wp.distanceKM(optimizedTask[i - 1]) : 0);

                    if (optimizedTask.TaskType != TaskTypes.TriangleStartOnLeg) {
                        // no points from takoff -> start
                        // no points from finish -> landing
                        if (i > 1 && i < optimizedTask.Count - 1) {
                            points = length * GetLegWeight(i - 2);
                        }
                        else {
                            points = 0.0;
                        }
                    }
                    else {
                        // no points from takoff -> start, start -> TP 1
                        // no points from TP 3 -> finish, finish -> landing
                        if (i > 1 && i < optimizedTask.Count - 2) {
                            if (i == 2) {
                                // first TP, get length to last TP
                                length = wp.distanceKM(optimizedTask[4]);
                            }
                            points = length * GetLegWeight(i - 2);
                        }
                        else {
                            points = 0.0;
                        }
                    }
                    sumPoints += points;
                }
                return sumPoints;
            }
        }

        #endregion	
    
        #region Public Functions
        public double GetLegWeight(int leg) {
            return leg < weight.Length ? weight[leg] : 1.0;
        }

        public abstract void Optimize();

        public override string ToString() {
            // TODO:  Add OptimizationBase.ToString implementation
            return base.ToString ();
        }

        #endregion

        #region Protected Functions
        /*protected int AdjustMaxElevationDifference(int start, int stop, int maxDiff) {
            FlightPoint p = flight[start];
            while (stop > start && Math.Abs(p.Elevation - flight[stop].Elevation) > maxDiff) {
                stop--;
            }
            return stop;
        }*/

        #endregion
    }

    public class LegLengthSorter : IComparer {
        int IComparer.Compare(object x, object y) {
            return ((LegStartIdx)x).length.CompareTo(((LegStartIdx)y).length);
        }
    }
}
