// name   : Recorder.cs
// author : Harald Maier
// date   : 19.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Windows.Forms;
using System.Threading;
using System.Collections;
using System.Text.RegularExpressions;
using Microsoft.Win32;

using SoaringDotNET.Recorders;
using SoaringDotNET.Dialogs;
using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// 
	/// </summary>
	public class Recorder : System.Windows.Forms.UserControl
	{
        private System.Windows.Forms.ImageList imageListOptions;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.Panel panelConnection;
        private System.Windows.Forms.Panel panelFlight;
        private System.Windows.Forms.Panel panelTasks;
        private System.Windows.Forms.Panel panelWaypoints;
        private System.Windows.Forms.Panel panelDeclaration;
        private RadioButton [] buttonItems;
        private System.Windows.Forms.ComboBox comboManufacturer;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.ComboBox comboBoxPort;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.ComboBox comboBoxBaud;
        private System.Windows.Forms.Panel panelInfo;
        private System.Windows.Forms.PictureBox connectionStatusPictureBox;
        private System.Windows.Forms.ImageList imageListConnectionStatus;
        private Panel [] panels;
        private System.Windows.Forms.Label label4;
        private RecorderBase currentRecorder = null;
        private Thread workerThread;
        private System.Windows.Forms.TextBox serialNo;
        private System.Windows.Forms.ListView listViewFlightDirectory;
        private System.Windows.Forms.Button buttonCancelTransfer;
        private System.Threading.Timer timer;
        private System.Windows.Forms.ProgressBar progress;
        private System.Windows.Forms.Panel panel1;
        private System.Windows.Forms.ImageList imageListTransfer;
        private System.Windows.Forms.ColumnHeader columnNo;
        private System.Windows.Forms.ColumnHeader columnDate;
        private System.Windows.Forms.ColumnHeader columnStart;
        private System.Windows.Forms.ColumnHeader columnEnd;
        private System.Windows.Forms.ColumnHeader columnDuration;
        private System.Windows.Forms.Panel panel2;
        private System.Windows.Forms.Button buttonUploadTasks;
        private System.Windows.Forms.GroupBox groupBoxTransferOptions;
        private System.Windows.Forms.RadioButton radioButtonSecure;
        private System.Windows.Forms.RadioButton radioButtonQuick;
        private System.Windows.Forms.Button buttonSaveFlight;
        private System.Windows.Forms.Button buttonReadFlightDir;
        private System.Windows.Forms.Button buttonDownloadTasks;
        private System.Windows.Forms.Panel panel3;
        private System.Windows.Forms.Button buttonUploadWaypoints;
        private System.Windows.Forms.Button buttonDownloadWaypoints;
        private System.Windows.Forms.Panel panel4;
        private System.Windows.Forms.Button buttonUploadDeclaration;
        private System.Windows.Forms.ComboBox comboBoxCatalogues;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.TextBox catalogueItems;
        private System.Windows.Forms.ListView listViewTasks;
        private System.Windows.Forms.ColumnHeader columnHeaderName;
        private System.Windows.Forms.ColumnHeader columnHeaderWaypoints;
        private System.Windows.Forms.ColumnHeader columnPilot;
        private System.Windows.Forms.ColumnHeader columnGlider;
        private System.Windows.Forms.Label label7;
        private System.Windows.Forms.ComboBox comboBoxTask;
        private System.Windows.Forms.ListView listViewTask;
        private System.Windows.Forms.ColumnHeader columnType;
        private System.Windows.Forms.ColumnHeader columnName;
        private System.Windows.Forms.ColumnHeader columnLat;
        private System.Windows.Forms.ColumnHeader columnLongitude;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.TextBox textPilot1;
        private System.Windows.Forms.TextBox textPilot2;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.Label label10;
        private System.Windows.Forms.ComboBox comboBoxGlider;
        private System.Windows.Forms.Label label11;
        private System.Windows.Forms.Label label12;
        private System.Windows.Forms.ComboBox comboBoxCompClass;
        private System.Windows.Forms.TextBox textBoxGliderId;
        private System.Windows.Forms.Label label13;
        private System.Windows.Forms.TextBox textBoxCompId;
        private System.Windows.Forms.Button buttonSelectPilot1;
        private System.Windows.Forms.Button buttonSelectPilot2;
        private System.Windows.Forms.Label labelTaskType;
        private System.Windows.Forms.ColumnHeader columnHeaderType;
        private System.Windows.Forms.ColumnHeader columnFileName;
        private System.Windows.Forms.Button buttonConnect;
        private bool abort;
        private System.Windows.Forms.Label label14;
        private System.Windows.Forms.Label label15;
        private System.Windows.Forms.TextBox visibleCatalogueItems;
        private System.Windows.Forms.Panel panelSUA;
        private System.Windows.Forms.Panel panel6;
        private System.Windows.Forms.Button buttonUploadSUA;
        private string flightPath;
        private WgsArea area;
        private System.Windows.Forms.ListView listViewSUAs;
        private System.Windows.Forms.ColumnHeader columnSUAName;
        private System.Windows.Forms.ColumnHeader columnSUAId;
        private System.Windows.Forms.ColumnHeader columnSUAClass;
        private System.Windows.Forms.ColumnHeader columnSUAType;
        private System.Windows.Forms.ColumnHeader columnSUABase;
        private System.Windows.Forms.ColumnHeader columnSUATop;
        private System.Windows.Forms.ColumnHeader columnSUARemark;
        private System.Windows.Forms.Label labelSUAItems;
        private System.Windows.Forms.Label label19;
        private System.Windows.Forms.Panel panelSUABottom;
        private System.Windows.Forms.ColumnHeader columnSUAComm;
        private System.Windows.Forms.ColumnHeader columnSUAFrequency;
        private System.Windows.Forms.Button buttonReloadTasks;
        private System.Windows.Forms.Panel panel5;
        private System.Windows.Forms.Panel panelDescription;
        private System.Windows.Forms.Panel panelTop;
        private System.Windows.Forms.Panel panelPilots;
        private System.Windows.Forms.ListBox listBoxPilots;
        private System.Windows.Forms.Panel panel7;
        private System.Windows.Forms.Button buttonUploadPilots;
        private System.Windows.Forms.Button buttonDownloadPilots;
        private System.Windows.Forms.Panel panel8;
        private System.Windows.Forms.Panel panel9;
        private SoaringDotNET.Controls.SUASelectionControl suaSelection;
        private TableLayoutPanel optionsPanel;
        private TextBox textBoxDescription;
        private RadioButton radioButtonConnection;
        private RadioButton radioButtonSUA;
        private RadioButton radioButtonPilots;
        private RadioButton radioButtonDeclaration;
        private RadioButton radioButtonWaypoints;
        private RadioButton radioButtonTasks;
        private RadioButton radioButtonFlights;
        private System.Windows.Forms.Button buttonReloadPilots;

        public Recorder()
		{
			// 
			// TODO: Add constructor logic here
			//
            InitializeComponent();

            columnHeaderWaypoints.Width = listViewTasks.Width - columnHeaderName.Width - columnHeaderType.Width;

            // Keep both lists in same order
            buttonItems = new RadioButton[] {radioButtonConnection, radioButtonFlights, radioButtonTasks, radioButtonWaypoints, 
                                        radioButtonDeclaration, radioButtonPilots, radioButtonSUA};

            panels = new Panel [] {panelConnection, panelFlight, panelTasks, panelWaypoints,
                                   panelDeclaration, panelPilots, panelSUA};

            comboBoxPort.Items.AddRange(System.IO.Ports.SerialPort.GetPortNames());//new object[] {"COM1:", "COM2:", "COM3:", "COM4:"});

            RecorderBase.SerialNoThreadNotify = new Notify(GetSerialNoHook);
            RecorderBase.FlightDirectoryThreadNotify= new Notify(GetFlightDirectoryHook);
            RecorderBase.DownloadWaypointsThreadNotify = new Notify(DownloadWaypointsHook);
            RecorderBase.UploadWaypointsThreadNotify = new Notify(UploadWaypointsHook);
            RecorderBase.DownloadTasksThreadNotify = new Notify(DownloadTasksHook);
            RecorderBase.UploadTasksThreadNotify = new Notify(UploadTasksHook);
            RecorderBase.DownloadFlightsThreadNotify = new Notify(DownloadFlightsHook);
            RecorderBase.UploadDeclarationThreadNotify = new Notify(UploadDeclarationHook);
            RecorderBase.UploadSUAsThreadNotify = new Notify(UploadSUAsHook);
            RecorderBase.DownloadPilotsThreadNotify = new Notify(DownloadPilotsHook);
            RecorderBase.UploadPilotsThreadNotify = new Notify(UploadPilotsHook);

            // VisualStudio will fail to create objects
            try {
                comboManufacturer.Items.Add(new SoaringPilotSerial());
                comboManufacturer.Items.Add(new SoaringPilotFile());
                comboManufacturer.Items.Add(new Volkslogger());
                comboManufacturer.Items.Add(new Flarm());
                comboManufacturer.Items.Add(new XCSoar());

                foreach (DictionaryEntry entry in AppContents.gliderIndexes) {
                    comboBoxGlider.Items.Add(entry.Value);
                }

                comboBoxCompClass.Items.AddRange(AppContents.compClasses);
            }
            catch {
            }
            
            currentRecorder = null;
            Disconnect();

            workerThread = null;
            timer = null;
            flightPath = "";
            area = new WgsArea();

            ReloadAirspaces();

            listViewSUAs.ListViewItemSorter = new ListViewItemSorter();
            listViewFlightDirectory.ListViewItemSorter = new ListViewItemSorter();
            listViewTasks.ListViewItemSorter = new ListViewItemSorter();

            radioButtonConnection.PerformClick();
        }

        #region Public Functions
        public void Add(WaypointCatalog c) {
            comboBoxCatalogues.Items.Add(c);
            comboBoxCatalogues.SelectedItem = c;
        }

        public void Add(Task t) {
            ListViewItem it = new ListViewItem(new string [] {"", "", ""});
            it.Tag = t;
            listViewTasks.Items.Add(it);
            Update(t);
            comboBoxTask.Items.Add(t);
        }

        public void Add(Pilot p) {
            listBoxPilots.Items.Add(p);
        }

        public void Remove(WaypointCatalog c) {
            int idx = comboBoxCatalogues.SelectedIndex;
            comboBoxCatalogues.Items.Remove(c);
            if (comboBoxCatalogues.Items.Count > 0) {
                comboBoxCatalogues.SelectedIndex = Math.Min(idx, comboBoxCatalogues.Items.Count - 1);
            }
            else {
                comboBoxCatalogues.SelectedIndex = -1;
                comboBoxCatalogues.Text = "";
            }
        }

        public void Remove(Pilot p) {
            listBoxPilots.Items.Remove(p);
        }

        public void Remove(Task t) {
            foreach (ListViewItem it in listViewTasks.Items) {
                if (it.Tag == t) {
                    it.Remove();
                    break;
                }
            }

            int idx = comboBoxTask.SelectedIndex;
            comboBoxTask.Items.Remove(t);
            if (comboBoxTask.Items.Count > 0) {
                comboBoxTask.SelectedIndex = Math.Min(idx, comboBoxTask.Items.Count - 1);
            }
            else {
                comboBoxTask.SelectedIndex = -1;
            }
        }

        public void ReloadAirspaces() {
            suaSelection.ReloadAirspace();
        }

        public void Update(WaypointCatalog c) {
            for (int i = 0; i < comboBoxCatalogues.Items.Count; i++) {
                if (comboBoxCatalogues.Items[i] == c) {
                    comboBoxCatalogues.Items[i] = c;
                    break;
                }
            }

            if (comboBoxCatalogues.SelectedItem == c) {
                OnCatalogueChanged(null, null);
            }
        }

        public void Update(Task t) {
            foreach (ListViewItem it in listViewTasks.Items) {
                if (it.Tag == t) {
                    string txt = "";
                    int i;
                    if (t.Count > 0) {
                        txt = t[0].longName;
                        for (i = 1; i < t.Count; i++) {
                            txt += ", " + t[i].longName;
                        }
                    }

                    it.Text = t.Name;
                    it.SubItems[1].Text = t.TaskTypeString;
                    it.SubItems[2].Text = txt;
                    break;
                }
            }

            for (int i = 0; i < comboBoxTask.Items.Count; i++) {
                if (comboBoxTask.Items[i] == t) {
                    comboBoxTask.Items[i] = t;
                    break;
                }
            }

            if (comboBoxTask.SelectedItem == t) {
                OnSelectedTaskChanged(null, null);
            }
        }

        public void Update(Pilot p) {
            int idx;
            if ((idx = listBoxPilots.Items.IndexOf(p)) >= 0) {
                listBoxPilots.Items[idx] = p;
            }
        }
        #endregion

        #region Protected Functions
        protected override void Dispose(bool disposing) {
            // TODO:  Add Recorder.Dispose implementation
            Disconnect();
            base.Dispose (disposing);
        }

        #endregion

        #region Private Functions
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Recorder));
            this.imageListOptions = new System.Windows.Forms.ImageList(this.components);
            this.panelConnection = new System.Windows.Forms.Panel();
            this.panelDescription = new System.Windows.Forms.Panel();
            this.textBoxDescription = new System.Windows.Forms.TextBox();
            this.label14 = new System.Windows.Forms.Label();
            this.panelTop = new System.Windows.Forms.Panel();
            this.buttonConnect = new System.Windows.Forms.Button();
            this.label4 = new System.Windows.Forms.Label();
            this.serialNo = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.comboBoxBaud = new System.Windows.Forms.ComboBox();
            this.label2 = new System.Windows.Forms.Label();
            this.comboBoxPort = new System.Windows.Forms.ComboBox();
            this.label1 = new System.Windows.Forms.Label();
            this.comboManufacturer = new System.Windows.Forms.ComboBox();
            this.panelFlight = new System.Windows.Forms.Panel();
            this.listViewFlightDirectory = new System.Windows.Forms.ListView();
            this.columnNo = new System.Windows.Forms.ColumnHeader();
            this.columnDate = new System.Windows.Forms.ColumnHeader();
            this.columnPilot = new System.Windows.Forms.ColumnHeader();
            this.columnGlider = new System.Windows.Forms.ColumnHeader();
            this.columnStart = new System.Windows.Forms.ColumnHeader();
            this.columnEnd = new System.Windows.Forms.ColumnHeader();
            this.columnDuration = new System.Windows.Forms.ColumnHeader();
            this.columnFileName = new System.Windows.Forms.ColumnHeader();
            this.panel1 = new System.Windows.Forms.Panel();
            this.groupBoxTransferOptions = new System.Windows.Forms.GroupBox();
            this.radioButtonSecure = new System.Windows.Forms.RadioButton();
            this.radioButtonQuick = new System.Windows.Forms.RadioButton();
            this.buttonReadFlightDir = new System.Windows.Forms.Button();
            this.imageListTransfer = new System.Windows.Forms.ImageList(this.components);
            this.buttonSaveFlight = new System.Windows.Forms.Button();
            this.panelTasks = new System.Windows.Forms.Panel();
            this.listViewTasks = new System.Windows.Forms.ListView();
            this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderType = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderWaypoints = new System.Windows.Forms.ColumnHeader();
            this.panel5 = new System.Windows.Forms.Panel();
            this.buttonReloadTasks = new System.Windows.Forms.Button();
            this.panel2 = new System.Windows.Forms.Panel();
            this.buttonUploadTasks = new System.Windows.Forms.Button();
            this.buttonDownloadTasks = new System.Windows.Forms.Button();
            this.panelWaypoints = new System.Windows.Forms.Panel();
            this.visibleCatalogueItems = new System.Windows.Forms.TextBox();
            this.label15 = new System.Windows.Forms.Label();
            this.catalogueItems = new System.Windows.Forms.TextBox();
            this.label6 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.comboBoxCatalogues = new System.Windows.Forms.ComboBox();
            this.panel3 = new System.Windows.Forms.Panel();
            this.buttonUploadWaypoints = new System.Windows.Forms.Button();
            this.buttonDownloadWaypoints = new System.Windows.Forms.Button();
            this.panelDeclaration = new System.Windows.Forms.Panel();
            this.panel4 = new System.Windows.Forms.Panel();
            this.buttonUploadDeclaration = new System.Windows.Forms.Button();
            this.labelTaskType = new System.Windows.Forms.Label();
            this.buttonSelectPilot2 = new System.Windows.Forms.Button();
            this.buttonSelectPilot1 = new System.Windows.Forms.Button();
            this.textBoxCompId = new System.Windows.Forms.TextBox();
            this.label13 = new System.Windows.Forms.Label();
            this.textBoxGliderId = new System.Windows.Forms.TextBox();
            this.comboBoxCompClass = new System.Windows.Forms.ComboBox();
            this.label12 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.comboBoxGlider = new System.Windows.Forms.ComboBox();
            this.label10 = new System.Windows.Forms.Label();
            this.label9 = new System.Windows.Forms.Label();
            this.textPilot2 = new System.Windows.Forms.TextBox();
            this.textPilot1 = new System.Windows.Forms.TextBox();
            this.label8 = new System.Windows.Forms.Label();
            this.listViewTask = new System.Windows.Forms.ListView();
            this.columnType = new System.Windows.Forms.ColumnHeader();
            this.columnName = new System.Windows.Forms.ColumnHeader();
            this.columnLat = new System.Windows.Forms.ColumnHeader();
            this.columnLongitude = new System.Windows.Forms.ColumnHeader();
            this.comboBoxTask = new System.Windows.Forms.ComboBox();
            this.label7 = new System.Windows.Forms.Label();
            this.panelInfo = new System.Windows.Forms.Panel();
            this.progress = new System.Windows.Forms.ProgressBar();
            this.buttonCancelTransfer = new System.Windows.Forms.Button();
            this.connectionStatusPictureBox = new System.Windows.Forms.PictureBox();
            this.imageListConnectionStatus = new System.Windows.Forms.ImageList(this.components);
            this.panelSUA = new System.Windows.Forms.Panel();
            this.panelSUABottom = new System.Windows.Forms.Panel();
            this.listViewSUAs = new System.Windows.Forms.ListView();
            this.columnSUAName = new System.Windows.Forms.ColumnHeader();
            this.columnSUAId = new System.Windows.Forms.ColumnHeader();
            this.columnSUAClass = new System.Windows.Forms.ColumnHeader();
            this.columnSUAType = new System.Windows.Forms.ColumnHeader();
            this.columnSUABase = new System.Windows.Forms.ColumnHeader();
            this.columnSUATop = new System.Windows.Forms.ColumnHeader();
            this.columnSUAComm = new System.Windows.Forms.ColumnHeader();
            this.columnSUAFrequency = new System.Windows.Forms.ColumnHeader();
            this.columnSUARemark = new System.Windows.Forms.ColumnHeader();
            this.labelSUAItems = new System.Windows.Forms.Label();
            this.panel6 = new System.Windows.Forms.Panel();
            this.buttonUploadSUA = new System.Windows.Forms.Button();
            this.label19 = new System.Windows.Forms.Label();
            this.suaSelection = new SoaringDotNET.Controls.SUASelectionControl();
            this.panelPilots = new System.Windows.Forms.Panel();
            this.panel8 = new System.Windows.Forms.Panel();
            this.listBoxPilots = new System.Windows.Forms.ListBox();
            this.panel9 = new System.Windows.Forms.Panel();
            this.buttonReloadPilots = new System.Windows.Forms.Button();
            this.panel7 = new System.Windows.Forms.Panel();
            this.buttonUploadPilots = new System.Windows.Forms.Button();
            this.buttonDownloadPilots = new System.Windows.Forms.Button();
            this.optionsPanel = new System.Windows.Forms.TableLayoutPanel();
            this.radioButtonSUA = new System.Windows.Forms.RadioButton();
            this.radioButtonPilots = new System.Windows.Forms.RadioButton();
            this.radioButtonDeclaration = new System.Windows.Forms.RadioButton();
            this.radioButtonWaypoints = new System.Windows.Forms.RadioButton();
            this.radioButtonTasks = new System.Windows.Forms.RadioButton();
            this.radioButtonFlights = new System.Windows.Forms.RadioButton();
            this.radioButtonConnection = new System.Windows.Forms.RadioButton();
            this.panelConnection.SuspendLayout();
            this.panelDescription.SuspendLayout();
            this.panelTop.SuspendLayout();
            this.panelFlight.SuspendLayout();
            this.panel1.SuspendLayout();
            this.groupBoxTransferOptions.SuspendLayout();
            this.panelTasks.SuspendLayout();
            this.panel5.SuspendLayout();
            this.panel2.SuspendLayout();
            this.panelWaypoints.SuspendLayout();
            this.panel3.SuspendLayout();
            this.panelDeclaration.SuspendLayout();
            this.panel4.SuspendLayout();
            this.panelInfo.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.connectionStatusPictureBox)).BeginInit();
            this.panelSUA.SuspendLayout();
            this.panelSUABottom.SuspendLayout();
            this.panel6.SuspendLayout();
            this.panelPilots.SuspendLayout();
            this.panel8.SuspendLayout();
            this.panel9.SuspendLayout();
            this.panel7.SuspendLayout();
            this.optionsPanel.SuspendLayout();
            this.SuspendLayout();
            // 
            // imageListOptions
            // 
            this.imageListOptions.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListOptions.ImageStream")));
            this.imageListOptions.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListOptions.Images.SetKeyName(0, "RecorderLarge.png");
            this.imageListOptions.Images.SetKeyName(1, "FlightLarge.png");
            this.imageListOptions.Images.SetKeyName(2, "TaskLarge.png");
            this.imageListOptions.Images.SetKeyName(3, "WaypointLarge.ico");
            this.imageListOptions.Images.SetKeyName(4, "Declaration.png");
            this.imageListOptions.Images.SetKeyName(5, "UserLarge.png");
            this.imageListOptions.Images.SetKeyName(6, "SUALarge.png");
            // 
            // panelConnection
            // 
            this.panelConnection.BackColor = System.Drawing.SystemColors.Control;
            this.panelConnection.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelConnection.Controls.Add(this.panelDescription);
            this.panelConnection.Controls.Add(this.panelTop);
            this.panelConnection.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelConnection.ForeColor = System.Drawing.SystemColors.ControlText;
            this.panelConnection.Location = new System.Drawing.Point(75, 0);
            this.panelConnection.Name = "panelConnection";
            this.panelConnection.Padding = new System.Windows.Forms.Padding(5);
            this.panelConnection.Size = new System.Drawing.Size(853, 628);
            this.panelConnection.TabIndex = 1;
            // 
            // panelDescription
            // 
            this.panelDescription.Controls.Add(this.textBoxDescription);
            this.panelDescription.Controls.Add(this.label14);
            this.panelDescription.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelDescription.Location = new System.Drawing.Point(5, 125);
            this.panelDescription.Name = "panelDescription";
            this.panelDescription.Padding = new System.Windows.Forms.Padding(10, 0, 10, 10);
            this.panelDescription.Size = new System.Drawing.Size(841, 496);
            this.panelDescription.TabIndex = 12;
            // 
            // textBoxDescription
            // 
            this.textBoxDescription.AcceptsReturn = true;
            this.textBoxDescription.AcceptsTab = true;
            this.textBoxDescription.Dock = System.Windows.Forms.DockStyle.Fill;
            this.textBoxDescription.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.textBoxDescription.Location = new System.Drawing.Point(10, 13);
            this.textBoxDescription.Multiline = true;
            this.textBoxDescription.Name = "textBoxDescription";
            this.textBoxDescription.ReadOnly = true;
            this.textBoxDescription.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.textBoxDescription.Size = new System.Drawing.Size(821, 473);
            this.textBoxDescription.TabIndex = 10;
            // 
            // label14
            // 
            this.label14.AutoSize = true;
            this.label14.Dock = System.Windows.Forms.DockStyle.Top;
            this.label14.Location = new System.Drawing.Point(10, 0);
            this.label14.Name = "label14";
            this.label14.Size = new System.Drawing.Size(60, 13);
            this.label14.TabIndex = 9;
            this.label14.Text = "Description";
            // 
            // panelTop
            // 
            this.panelTop.Controls.Add(this.buttonConnect);
            this.panelTop.Controls.Add(this.label4);
            this.panelTop.Controls.Add(this.serialNo);
            this.panelTop.Controls.Add(this.label3);
            this.panelTop.Controls.Add(this.comboBoxBaud);
            this.panelTop.Controls.Add(this.label2);
            this.panelTop.Controls.Add(this.comboBoxPort);
            this.panelTop.Controls.Add(this.label1);
            this.panelTop.Controls.Add(this.comboManufacturer);
            this.panelTop.Dock = System.Windows.Forms.DockStyle.Top;
            this.panelTop.Location = new System.Drawing.Point(5, 5);
            this.panelTop.Name = "panelTop";
            this.panelTop.Size = new System.Drawing.Size(841, 120);
            this.panelTop.TabIndex = 13;
            // 
            // buttonConnect
            // 
            this.buttonConnect.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonConnect.Location = new System.Drawing.Point(416, 30);
            this.buttonConnect.Name = "buttonConnect";
            this.buttonConnect.Size = new System.Drawing.Size(114, 24);
            this.buttonConnect.TabIndex = 8;
            this.buttonConnect.Text = "Connect Recorder";
            this.buttonConnect.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonConnect.Click += new System.EventHandler(this.OnConnectRecorder);
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(10, 72);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(53, 13);
            this.label4.TabIndex = 7;
            this.label4.Text = "Serial No.";
            // 
            // serialNo
            // 
            this.serialNo.Location = new System.Drawing.Point(10, 88);
            this.serialNo.Name = "serialNo";
            this.serialNo.ReadOnly = true;
            this.serialNo.Size = new System.Drawing.Size(56, 20);
            this.serialNo.TabIndex = 6;
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(304, 16);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(32, 13);
            this.label3.TabIndex = 5;
            this.label3.Text = "Baud";
            // 
            // comboBoxBaud
            // 
            this.comboBoxBaud.Location = new System.Drawing.Point(304, 32);
            this.comboBoxBaud.Name = "comboBoxBaud";
            this.comboBoxBaud.Size = new System.Drawing.Size(88, 21);
            this.comboBoxBaud.TabIndex = 4;
            this.comboBoxBaud.SelectedIndexChanged += new System.EventHandler(this.OnConnectionChanged);
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(208, 16);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(26, 13);
            this.label2.TabIndex = 3;
            this.label2.Text = "Port";
            // 
            // comboBoxPort
            // 
            this.comboBoxPort.Location = new System.Drawing.Point(208, 32);
            this.comboBoxPort.Name = "comboBoxPort";
            this.comboBoxPort.Size = new System.Drawing.Size(72, 21);
            this.comboBoxPort.Sorted = true;
            this.comboBoxPort.TabIndex = 2;
            this.comboBoxPort.SelectedIndexChanged += new System.EventHandler(this.OnConnectionChanged);
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(10, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(70, 13);
            this.label1.TabIndex = 1;
            this.label1.Text = "Manufacturer";
            // 
            // comboManufacturer
            // 
            this.comboManufacturer.Location = new System.Drawing.Point(10, 32);
            this.comboManufacturer.Name = "comboManufacturer";
            this.comboManufacturer.Size = new System.Drawing.Size(176, 21);
            this.comboManufacturer.Sorted = true;
            this.comboManufacturer.TabIndex = 0;
            this.comboManufacturer.SelectionChangeCommitted += new System.EventHandler(this.OnRecorderChanged);
            // 
            // panelFlight
            // 
            this.panelFlight.BackColor = System.Drawing.SystemColors.Control;
            this.panelFlight.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelFlight.Controls.Add(this.listViewFlightDirectory);
            this.panelFlight.Controls.Add(this.panel1);
            this.panelFlight.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelFlight.Location = new System.Drawing.Point(75, 0);
            this.panelFlight.Name = "panelFlight";
            this.panelFlight.Padding = new System.Windows.Forms.Padding(5);
            this.panelFlight.Size = new System.Drawing.Size(853, 628);
            this.panelFlight.TabIndex = 2;
            // 
            // listViewFlightDirectory
            // 
            this.listViewFlightDirectory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnNo,
            this.columnDate,
            this.columnPilot,
            this.columnGlider,
            this.columnStart,
            this.columnEnd,
            this.columnDuration,
            this.columnFileName});
            this.listViewFlightDirectory.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewFlightDirectory.FullRowSelect = true;
            this.listViewFlightDirectory.GridLines = true;
            this.listViewFlightDirectory.HideSelection = false;
            this.listViewFlightDirectory.Location = new System.Drawing.Point(5, 5);
            this.listViewFlightDirectory.Name = "listViewFlightDirectory";
            this.listViewFlightDirectory.Size = new System.Drawing.Size(841, 568);
            this.listViewFlightDirectory.TabIndex = 0;
            this.listViewFlightDirectory.UseCompatibleStateImageBehavior = false;
            this.listViewFlightDirectory.View = System.Windows.Forms.View.Details;
            this.listViewFlightDirectory.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnNo
            // 
            this.columnNo.Text = "Nr.";
            this.columnNo.Width = 30;
            // 
            // columnDate
            // 
            this.columnDate.Text = "Date";
            this.columnDate.Width = 90;
            // 
            // columnPilot
            // 
            this.columnPilot.Text = "Pilot";
            this.columnPilot.Width = 180;
            // 
            // columnGlider
            // 
            this.columnGlider.Text = "Glider";
            this.columnGlider.Width = 100;
            // 
            // columnStart
            // 
            this.columnStart.Text = "Start";
            // 
            // columnEnd
            // 
            this.columnEnd.Text = "End";
            // 
            // columnDuration
            // 
            this.columnDuration.Text = "Duration";
            // 
            // columnFileName
            // 
            this.columnFileName.Text = "Filename";
            this.columnFileName.Width = 120;
            // 
            // panel1
            // 
            this.panel1.Controls.Add(this.groupBoxTransferOptions);
            this.panel1.Controls.Add(this.buttonReadFlightDir);
            this.panel1.Controls.Add(this.buttonSaveFlight);
            this.panel1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel1.Location = new System.Drawing.Point(5, 573);
            this.panel1.Name = "panel1";
            this.panel1.Padding = new System.Windows.Forms.Padding(2);
            this.panel1.Size = new System.Drawing.Size(841, 48);
            this.panel1.TabIndex = 2;
            // 
            // groupBoxTransferOptions
            // 
            this.groupBoxTransferOptions.Controls.Add(this.radioButtonSecure);
            this.groupBoxTransferOptions.Controls.Add(this.radioButtonQuick);
            this.groupBoxTransferOptions.Location = new System.Drawing.Point(216, 2);
            this.groupBoxTransferOptions.Name = "groupBoxTransferOptions";
            this.groupBoxTransferOptions.Size = new System.Drawing.Size(136, 44);
            this.groupBoxTransferOptions.TabIndex = 2;
            this.groupBoxTransferOptions.TabStop = false;
            this.groupBoxTransferOptions.Text = "Transfer mode";
            // 
            // radioButtonSecure
            // 
            this.radioButtonSecure.Checked = true;
            this.radioButtonSecure.Location = new System.Drawing.Point(8, 16);
            this.radioButtonSecure.Name = "radioButtonSecure";
            this.radioButtonSecure.Size = new System.Drawing.Size(59, 17);
            this.radioButtonSecure.TabIndex = 1;
            this.radioButtonSecure.TabStop = true;
            this.radioButtonSecure.Text = "secure";
            // 
            // radioButtonQuick
            // 
            this.radioButtonQuick.Location = new System.Drawing.Point(72, 16);
            this.radioButtonQuick.Name = "radioButtonQuick";
            this.radioButtonQuick.Size = new System.Drawing.Size(56, 16);
            this.radioButtonQuick.TabIndex = 0;
            this.radioButtonQuick.Text = "quick";
            // 
            // buttonReadFlightDir
            // 
            this.buttonReadFlightDir.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonReadFlightDir.ImageIndex = 0;
            this.buttonReadFlightDir.ImageList = this.imageListTransfer;
            this.buttonReadFlightDir.Location = new System.Drawing.Point(0, 6);
            this.buttonReadFlightDir.Name = "buttonReadFlightDir";
            this.buttonReadFlightDir.Size = new System.Drawing.Size(100, 36);
            this.buttonReadFlightDir.TabIndex = 0;
            this.buttonReadFlightDir.Text = "Read flight directory";
            this.buttonReadFlightDir.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonReadFlightDir.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonReadFlightDir.Click += new System.EventHandler(this.OnReadFlightDirectory);
            // 
            // imageListTransfer
            // 
            this.imageListTransfer.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListTransfer.ImageStream")));
            this.imageListTransfer.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListTransfer.Images.SetKeyName(0, "OpenMedium.png");
            this.imageListTransfer.Images.SetKeyName(1, "SaveMedium.png");
            this.imageListTransfer.Images.SetKeyName(2, "Upload.png");
            this.imageListTransfer.Images.SetKeyName(3, "Download.png");
            this.imageListTransfer.Images.SetKeyName(4, "Reload.png");
            // 
            // buttonSaveFlight
            // 
            this.buttonSaveFlight.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonSaveFlight.ImageIndex = 1;
            this.buttonSaveFlight.ImageList = this.imageListTransfer;
            this.buttonSaveFlight.Location = new System.Drawing.Point(104, 6);
            this.buttonSaveFlight.Name = "buttonSaveFlight";
            this.buttonSaveFlight.Size = new System.Drawing.Size(100, 36);
            this.buttonSaveFlight.TabIndex = 1;
            this.buttonSaveFlight.Text = "Save flight";
            this.buttonSaveFlight.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonSaveFlight.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonSaveFlight.Click += new System.EventHandler(this.OnSaveFlights);
            // 
            // panelTasks
            // 
            this.panelTasks.BackColor = System.Drawing.SystemColors.Control;
            this.panelTasks.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelTasks.Controls.Add(this.listViewTasks);
            this.panelTasks.Controls.Add(this.panel5);
            this.panelTasks.Controls.Add(this.panel2);
            this.panelTasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelTasks.Location = new System.Drawing.Point(75, 0);
            this.panelTasks.Name = "panelTasks";
            this.panelTasks.Padding = new System.Windows.Forms.Padding(5);
            this.panelTasks.Size = new System.Drawing.Size(853, 628);
            this.panelTasks.TabIndex = 3;
            // 
            // listViewTasks
            // 
            this.listViewTasks.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeaderName,
            this.columnHeaderType,
            this.columnHeaderWaypoints});
            this.listViewTasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewTasks.FullRowSelect = true;
            this.listViewTasks.Location = new System.Drawing.Point(5, 5);
            this.listViewTasks.Name = "listViewTasks";
            this.listViewTasks.Size = new System.Drawing.Size(841, 520);
            this.listViewTasks.TabIndex = 1;
            this.listViewTasks.UseCompatibleStateImageBehavior = false;
            this.listViewTasks.View = System.Windows.Forms.View.Details;
            this.listViewTasks.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownTasks);
            this.listViewTasks.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnHeaderName
            // 
            this.columnHeaderName.Text = "Name";
            this.columnHeaderName.Width = 102;
            // 
            // columnHeaderType
            // 
            this.columnHeaderType.Text = "Type";
            this.columnHeaderType.Width = 180;
            // 
            // columnHeaderWaypoints
            // 
            this.columnHeaderWaypoints.Text = "Waypoints";
            this.columnHeaderWaypoints.Width = 470;
            // 
            // panel5
            // 
            this.panel5.Controls.Add(this.buttonReloadTasks);
            this.panel5.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel5.Location = new System.Drawing.Point(5, 525);
            this.panel5.Name = "panel5";
            this.panel5.Size = new System.Drawing.Size(841, 48);
            this.panel5.TabIndex = 3;
            // 
            // buttonReloadTasks
            // 
            this.buttonReloadTasks.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonReloadTasks.ImageIndex = 4;
            this.buttonReloadTasks.ImageList = this.imageListTransfer;
            this.buttonReloadTasks.Location = new System.Drawing.Point(0, 6);
            this.buttonReloadTasks.Name = "buttonReloadTasks";
            this.buttonReloadTasks.Size = new System.Drawing.Size(100, 36);
            this.buttonReloadTasks.TabIndex = 2;
            this.buttonReloadTasks.Text = "Reload Tasks";
            this.buttonReloadTasks.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonReloadTasks.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonReloadTasks.Click += new System.EventHandler(this.OnReloadTasks);
            // 
            // panel2
            // 
            this.panel2.Controls.Add(this.buttonUploadTasks);
            this.panel2.Controls.Add(this.buttonDownloadTasks);
            this.panel2.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel2.Location = new System.Drawing.Point(5, 573);
            this.panel2.Name = "panel2";
            this.panel2.Size = new System.Drawing.Size(841, 48);
            this.panel2.TabIndex = 0;
            // 
            // buttonUploadTasks
            // 
            this.buttonUploadTasks.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadTasks.ImageIndex = 2;
            this.buttonUploadTasks.ImageList = this.imageListTransfer;
            this.buttonUploadTasks.Location = new System.Drawing.Point(104, 6);
            this.buttonUploadTasks.Name = "buttonUploadTasks";
            this.buttonUploadTasks.Size = new System.Drawing.Size(100, 36);
            this.buttonUploadTasks.TabIndex = 1;
            this.buttonUploadTasks.Text = "Upload tasks";
            this.buttonUploadTasks.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadTasks.TextImageRelation = System.Windows.Forms.TextImageRelation.TextBeforeImage;
            this.buttonUploadTasks.Click += new System.EventHandler(this.OnUploadTasks);
            // 
            // buttonDownloadTasks
            // 
            this.buttonDownloadTasks.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadTasks.ImageIndex = 3;
            this.buttonDownloadTasks.ImageList = this.imageListTransfer;
            this.buttonDownloadTasks.Location = new System.Drawing.Point(0, 6);
            this.buttonDownloadTasks.Name = "buttonDownloadTasks";
            this.buttonDownloadTasks.Size = new System.Drawing.Size(100, 36);
            this.buttonDownloadTasks.TabIndex = 0;
            this.buttonDownloadTasks.Text = "Download tasks";
            this.buttonDownloadTasks.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonDownloadTasks.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonDownloadTasks.Click += new System.EventHandler(this.OnDownloadTasks);
            // 
            // panelWaypoints
            // 
            this.panelWaypoints.BackColor = System.Drawing.SystemColors.Control;
            this.panelWaypoints.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelWaypoints.Controls.Add(this.visibleCatalogueItems);
            this.panelWaypoints.Controls.Add(this.label15);
            this.panelWaypoints.Controls.Add(this.catalogueItems);
            this.panelWaypoints.Controls.Add(this.label6);
            this.panelWaypoints.Controls.Add(this.label5);
            this.panelWaypoints.Controls.Add(this.comboBoxCatalogues);
            this.panelWaypoints.Controls.Add(this.panel3);
            this.panelWaypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelWaypoints.Location = new System.Drawing.Point(75, 0);
            this.panelWaypoints.Name = "panelWaypoints";
            this.panelWaypoints.Padding = new System.Windows.Forms.Padding(5);
            this.panelWaypoints.Size = new System.Drawing.Size(853, 628);
            this.panelWaypoints.TabIndex = 4;
            // 
            // visibleCatalogueItems
            // 
            this.visibleCatalogueItems.BackColor = System.Drawing.SystemColors.Window;
            this.visibleCatalogueItems.ForeColor = System.Drawing.Color.Red;
            this.visibleCatalogueItems.Location = new System.Drawing.Point(232, 80);
            this.visibleCatalogueItems.Name = "visibleCatalogueItems";
            this.visibleCatalogueItems.Size = new System.Drawing.Size(64, 20);
            this.visibleCatalogueItems.TabIndex = 7;
            this.visibleCatalogueItems.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // label15
            // 
            this.label15.AutoSize = true;
            this.label15.Location = new System.Drawing.Point(232, 64);
            this.label15.Name = "label15";
            this.label15.Size = new System.Drawing.Size(85, 13);
            this.label15.TabIndex = 6;
            this.label15.Text = "Items for transfer";
            // 
            // catalogueItems
            // 
            this.catalogueItems.Location = new System.Drawing.Point(232, 32);
            this.catalogueItems.Name = "catalogueItems";
            this.catalogueItems.Size = new System.Drawing.Size(64, 20);
            this.catalogueItems.TabIndex = 5;
            this.catalogueItems.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(232, 16);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(93, 13);
            this.label6.TabIndex = 4;
            this.label6.Text = "Items in catalogue";
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(16, 16);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(55, 13);
            this.label5.TabIndex = 3;
            this.label5.Text = "Catalogue";
            // 
            // comboBoxCatalogues
            // 
            this.comboBoxCatalogues.Location = new System.Drawing.Point(16, 32);
            this.comboBoxCatalogues.Name = "comboBoxCatalogues";
            this.comboBoxCatalogues.Size = new System.Drawing.Size(184, 21);
            this.comboBoxCatalogues.TabIndex = 2;
            this.comboBoxCatalogues.SelectedIndexChanged += new System.EventHandler(this.OnCatalogueChanged);
            // 
            // panel3
            // 
            this.panel3.BackColor = System.Drawing.SystemColors.Control;
            this.panel3.Controls.Add(this.buttonUploadWaypoints);
            this.panel3.Controls.Add(this.buttonDownloadWaypoints);
            this.panel3.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel3.Location = new System.Drawing.Point(5, 573);
            this.panel3.Name = "panel3";
            this.panel3.Size = new System.Drawing.Size(841, 48);
            this.panel3.TabIndex = 1;
            // 
            // buttonUploadWaypoints
            // 
            this.buttonUploadWaypoints.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadWaypoints.ImageIndex = 2;
            this.buttonUploadWaypoints.ImageList = this.imageListTransfer;
            this.buttonUploadWaypoints.Location = new System.Drawing.Point(104, 6);
            this.buttonUploadWaypoints.Name = "buttonUploadWaypoints";
            this.buttonUploadWaypoints.Size = new System.Drawing.Size(100, 36);
            this.buttonUploadWaypoints.TabIndex = 1;
            this.buttonUploadWaypoints.Text = "Upload Waypoints";
            this.buttonUploadWaypoints.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadWaypoints.TextImageRelation = System.Windows.Forms.TextImageRelation.TextBeforeImage;
            this.buttonUploadWaypoints.Click += new System.EventHandler(this.OnUploadWaypoints);
            // 
            // buttonDownloadWaypoints
            // 
            this.buttonDownloadWaypoints.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadWaypoints.ImageIndex = 3;
            this.buttonDownloadWaypoints.ImageList = this.imageListTransfer;
            this.buttonDownloadWaypoints.Location = new System.Drawing.Point(0, 6);
            this.buttonDownloadWaypoints.Name = "buttonDownloadWaypoints";
            this.buttonDownloadWaypoints.Size = new System.Drawing.Size(100, 36);
            this.buttonDownloadWaypoints.TabIndex = 0;
            this.buttonDownloadWaypoints.Text = "Download waypoints";
            this.buttonDownloadWaypoints.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadWaypoints.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonDownloadWaypoints.Click += new System.EventHandler(this.OnDownloadWaypoints);
            // 
            // panelDeclaration
            // 
            this.panelDeclaration.BackColor = System.Drawing.SystemColors.Control;
            this.panelDeclaration.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelDeclaration.Controls.Add(this.panel4);
            this.panelDeclaration.Controls.Add(this.labelTaskType);
            this.panelDeclaration.Controls.Add(this.buttonSelectPilot2);
            this.panelDeclaration.Controls.Add(this.buttonSelectPilot1);
            this.panelDeclaration.Controls.Add(this.textBoxCompId);
            this.panelDeclaration.Controls.Add(this.label13);
            this.panelDeclaration.Controls.Add(this.textBoxGliderId);
            this.panelDeclaration.Controls.Add(this.comboBoxCompClass);
            this.panelDeclaration.Controls.Add(this.label12);
            this.panelDeclaration.Controls.Add(this.label11);
            this.panelDeclaration.Controls.Add(this.comboBoxGlider);
            this.panelDeclaration.Controls.Add(this.label10);
            this.panelDeclaration.Controls.Add(this.label9);
            this.panelDeclaration.Controls.Add(this.textPilot2);
            this.panelDeclaration.Controls.Add(this.textPilot1);
            this.panelDeclaration.Controls.Add(this.label8);
            this.panelDeclaration.Controls.Add(this.listViewTask);
            this.panelDeclaration.Controls.Add(this.comboBoxTask);
            this.panelDeclaration.Controls.Add(this.label7);
            this.panelDeclaration.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelDeclaration.Location = new System.Drawing.Point(75, 0);
            this.panelDeclaration.Name = "panelDeclaration";
            this.panelDeclaration.Padding = new System.Windows.Forms.Padding(5);
            this.panelDeclaration.Size = new System.Drawing.Size(853, 628);
            this.panelDeclaration.TabIndex = 5;
            // 
            // panel4
            // 
            this.panel4.BackColor = System.Drawing.SystemColors.Control;
            this.panel4.Controls.Add(this.buttonUploadDeclaration);
            this.panel4.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel4.Location = new System.Drawing.Point(5, 573);
            this.panel4.Name = "panel4";
            this.panel4.Size = new System.Drawing.Size(841, 48);
            this.panel4.TabIndex = 2;
            // 
            // buttonUploadDeclaration
            // 
            this.buttonUploadDeclaration.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadDeclaration.ImageIndex = 2;
            this.buttonUploadDeclaration.ImageList = this.imageListTransfer;
            this.buttonUploadDeclaration.Location = new System.Drawing.Point(0, 7);
            this.buttonUploadDeclaration.Name = "buttonUploadDeclaration";
            this.buttonUploadDeclaration.Size = new System.Drawing.Size(100, 36);
            this.buttonUploadDeclaration.TabIndex = 1;
            this.buttonUploadDeclaration.Text = "Upload Declaration";
            this.buttonUploadDeclaration.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadDeclaration.TextImageRelation = System.Windows.Forms.TextImageRelation.TextBeforeImage;
            this.buttonUploadDeclaration.Click += new System.EventHandler(this.OnUploadDeclaration);
            // 
            // labelTaskType
            // 
            this.labelTaskType.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.labelTaskType.ForeColor = System.Drawing.Color.OrangeRed;
            this.labelTaskType.Location = new System.Drawing.Point(224, 15);
            this.labelTaskType.Name = "labelTaskType";
            this.labelTaskType.Size = new System.Drawing.Size(256, 23);
            this.labelTaskType.TabIndex = 21;
            this.labelTaskType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // buttonSelectPilot2
            // 
            this.buttonSelectPilot2.Image = ((System.Drawing.Image)(resources.GetObject("buttonSelectPilot2.Image")));
            this.buttonSelectPilot2.Location = new System.Drawing.Point(480, 224);
            this.buttonSelectPilot2.Name = "buttonSelectPilot2";
            this.buttonSelectPilot2.Size = new System.Drawing.Size(22, 22);
            this.buttonSelectPilot2.TabIndex = 20;
            this.buttonSelectPilot2.Click += new System.EventHandler(this.OnSelectPilot2);
            // 
            // buttonSelectPilot1
            // 
            this.buttonSelectPilot1.Image = ((System.Drawing.Image)(resources.GetObject("buttonSelectPilot1.Image")));
            this.buttonSelectPilot1.Location = new System.Drawing.Point(232, 224);
            this.buttonSelectPilot1.Name = "buttonSelectPilot1";
            this.buttonSelectPilot1.Size = new System.Drawing.Size(22, 22);
            this.buttonSelectPilot1.TabIndex = 19;
            this.buttonSelectPilot1.Click += new System.EventHandler(this.OnSelectPilot1);
            // 
            // textBoxCompId
            // 
            this.textBoxCompId.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxCompId.Location = new System.Drawing.Point(328, 288);
            this.textBoxCompId.Name = "textBoxCompId";
            this.textBoxCompId.Size = new System.Drawing.Size(32, 20);
            this.textBoxCompId.TabIndex = 18;
            // 
            // label13
            // 
            this.label13.AutoSize = true;
            this.label13.Location = new System.Drawing.Point(269, 288);
            this.label13.Name = "label13";
            this.label13.Size = new System.Drawing.Size(51, 13);
            this.label13.TabIndex = 17;
            this.label13.Text = "Comp. ID";
            // 
            // textBoxGliderId
            // 
            this.textBoxGliderId.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxGliderId.Location = new System.Drawing.Point(328, 256);
            this.textBoxGliderId.Name = "textBoxGliderId";
            this.textBoxGliderId.Size = new System.Drawing.Size(152, 20);
            this.textBoxGliderId.TabIndex = 16;
            // 
            // comboBoxCompClass
            // 
            this.comboBoxCompClass.Location = new System.Drawing.Point(80, 288);
            this.comboBoxCompClass.Name = "comboBoxCompClass";
            this.comboBoxCompClass.Size = new System.Drawing.Size(152, 21);
            this.comboBoxCompClass.Sorted = true;
            this.comboBoxCompClass.TabIndex = 15;
            // 
            // label12
            // 
            this.label12.AutoSize = true;
            this.label12.Location = new System.Drawing.Point(8, 288);
            this.label12.Name = "label12";
            this.label12.Size = new System.Drawing.Size(65, 13);
            this.label12.TabIndex = 14;
            this.label12.Text = "Comp. Class";
            // 
            // label11
            // 
            this.label11.AutoSize = true;
            this.label11.Location = new System.Drawing.Point(272, 256);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(48, 13);
            this.label11.TabIndex = 12;
            this.label11.Text = "Glider ID";
            // 
            // comboBoxGlider
            // 
            this.comboBoxGlider.Location = new System.Drawing.Point(80, 256);
            this.comboBoxGlider.Name = "comboBoxGlider";
            this.comboBoxGlider.Size = new System.Drawing.Size(152, 21);
            this.comboBoxGlider.Sorted = true;
            this.comboBoxGlider.TabIndex = 11;
            // 
            // label10
            // 
            this.label10.AutoSize = true;
            this.label10.Location = new System.Drawing.Point(40, 256);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(34, 13);
            this.label10.TabIndex = 10;
            this.label10.Text = "Glider";
            // 
            // label9
            // 
            this.label9.AutoSize = true;
            this.label9.Location = new System.Drawing.Point(288, 224);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(36, 13);
            this.label9.TabIndex = 9;
            this.label9.Text = "Pilot 2";
            // 
            // textPilot2
            // 
            this.textPilot2.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textPilot2.Location = new System.Drawing.Point(328, 224);
            this.textPilot2.Name = "textPilot2";
            this.textPilot2.Size = new System.Drawing.Size(152, 20);
            this.textPilot2.TabIndex = 8;
            // 
            // textPilot1
            // 
            this.textPilot1.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textPilot1.Location = new System.Drawing.Point(80, 224);
            this.textPilot1.Name = "textPilot1";
            this.textPilot1.Size = new System.Drawing.Size(152, 20);
            this.textPilot1.TabIndex = 7;
            // 
            // label8
            // 
            this.label8.AutoSize = true;
            this.label8.Location = new System.Drawing.Point(40, 224);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(36, 13);
            this.label8.TabIndex = 6;
            this.label8.Text = "Pilot 1";
            // 
            // listViewTask
            // 
            this.listViewTask.BackColor = System.Drawing.SystemColors.Window;
            this.listViewTask.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnType,
            this.columnName,
            this.columnLat,
            this.columnLongitude});
            this.listViewTask.FullRowSelect = true;
            this.listViewTask.GridLines = true;
            this.listViewTask.Location = new System.Drawing.Point(80, 48);
            this.listViewTask.Name = "listViewTask";
            this.listViewTask.Size = new System.Drawing.Size(400, 168);
            this.listViewTask.TabIndex = 5;
            this.listViewTask.UseCompatibleStateImageBehavior = false;
            this.listViewTask.View = System.Windows.Forms.View.Details;
            // 
            // columnType
            // 
            this.columnType.Text = "Type";
            this.columnType.Width = 80;
            // 
            // columnName
            // 
            this.columnName.Text = "Name";
            this.columnName.Width = 140;
            // 
            // columnLat
            // 
            this.columnLat.Text = "Latitude";
            this.columnLat.Width = 80;
            // 
            // columnLongitude
            // 
            this.columnLongitude.Text = "Longitude";
            this.columnLongitude.Width = 80;
            // 
            // comboBoxTask
            // 
            this.comboBoxTask.Location = new System.Drawing.Point(80, 16);
            this.comboBoxTask.Name = "comboBoxTask";
            this.comboBoxTask.Size = new System.Drawing.Size(136, 21);
            this.comboBoxTask.TabIndex = 4;
            this.comboBoxTask.SelectedIndexChanged += new System.EventHandler(this.OnSelectedTaskChanged);
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(48, 18);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(31, 13);
            this.label7.TabIndex = 3;
            this.label7.Text = "Task";
            // 
            // panelInfo
            // 
            this.panelInfo.BackColor = System.Drawing.SystemColors.Control;
            this.panelInfo.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelInfo.Controls.Add(this.progress);
            this.panelInfo.Controls.Add(this.buttonCancelTransfer);
            this.panelInfo.Controls.Add(this.connectionStatusPictureBox);
            this.panelInfo.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panelInfo.Location = new System.Drawing.Point(75, 628);
            this.panelInfo.Name = "panelInfo";
            this.panelInfo.Padding = new System.Windows.Forms.Padding(2);
            this.panelInfo.Size = new System.Drawing.Size(853, 28);
            this.panelInfo.TabIndex = 6;
            // 
            // progress
            // 
            this.progress.BackColor = System.Drawing.Color.Silver;
            this.progress.Dock = System.Windows.Forms.DockStyle.Fill;
            this.progress.Location = new System.Drawing.Point(77, 2);
            this.progress.Maximum = 1000;
            this.progress.Name = "progress";
            this.progress.Size = new System.Drawing.Size(749, 22);
            this.progress.Step = 1;
            this.progress.TabIndex = 3;
            // 
            // buttonCancelTransfer
            // 
            this.buttonCancelTransfer.Dock = System.Windows.Forms.DockStyle.Left;
            this.buttonCancelTransfer.Location = new System.Drawing.Point(2, 2);
            this.buttonCancelTransfer.Name = "buttonCancelTransfer";
            this.buttonCancelTransfer.Size = new System.Drawing.Size(75, 22);
            this.buttonCancelTransfer.TabIndex = 2;
            this.buttonCancelTransfer.Text = "Cancel";
            this.buttonCancelTransfer.Click += new System.EventHandler(this.OnClickCancelTransfer);
            // 
            // connectionStatusPictureBox
            // 
            this.connectionStatusPictureBox.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.connectionStatusPictureBox.Dock = System.Windows.Forms.DockStyle.Right;
            this.connectionStatusPictureBox.InitialImage = null;
            this.connectionStatusPictureBox.Location = new System.Drawing.Point(826, 2);
            this.connectionStatusPictureBox.Name = "connectionStatusPictureBox";
            this.connectionStatusPictureBox.Size = new System.Drawing.Size(23, 22);
            this.connectionStatusPictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.CenterImage;
            this.connectionStatusPictureBox.TabIndex = 0;
            this.connectionStatusPictureBox.TabStop = false;
            // 
            // imageListConnectionStatus
            // 
            this.imageListConnectionStatus.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListConnectionStatus.ImageStream")));
            this.imageListConnectionStatus.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListConnectionStatus.Images.SetKeyName(0, "Disconected.png");
            this.imageListConnectionStatus.Images.SetKeyName(1, "Connected.png");
            this.imageListConnectionStatus.Images.SetKeyName(2, "Connecting.png");
            // 
            // panelSUA
            // 
            this.panelSUA.BackColor = System.Drawing.SystemColors.Control;
            this.panelSUA.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelSUA.Controls.Add(this.panelSUABottom);
            this.panelSUA.Controls.Add(this.panel6);
            this.panelSUA.Controls.Add(this.suaSelection);
            this.panelSUA.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelSUA.Location = new System.Drawing.Point(75, 0);
            this.panelSUA.Name = "panelSUA";
            this.panelSUA.Padding = new System.Windows.Forms.Padding(5);
            this.panelSUA.Size = new System.Drawing.Size(853, 628);
            this.panelSUA.TabIndex = 7;
            this.panelSUA.VisibleChanged += new System.EventHandler(this.OnSUAVisibleChanged);
            // 
            // panelSUABottom
            // 
            this.panelSUABottom.Controls.Add(this.listViewSUAs);
            this.panelSUABottom.Controls.Add(this.labelSUAItems);
            this.panelSUABottom.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelSUABottom.Location = new System.Drawing.Point(5, 229);
            this.panelSUABottom.Name = "panelSUABottom";
            this.panelSUABottom.Size = new System.Drawing.Size(841, 344);
            this.panelSUABottom.TabIndex = 11;
            // 
            // listViewSUAs
            // 
            this.listViewSUAs.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnSUAName,
            this.columnSUAId,
            this.columnSUAClass,
            this.columnSUAType,
            this.columnSUABase,
            this.columnSUATop,
            this.columnSUAComm,
            this.columnSUAFrequency,
            this.columnSUARemark});
            this.listViewSUAs.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewSUAs.FullRowSelect = true;
            this.listViewSUAs.GridLines = true;
            this.listViewSUAs.HideSelection = false;
            this.listViewSUAs.Location = new System.Drawing.Point(0, 0);
            this.listViewSUAs.Name = "listViewSUAs";
            this.listViewSUAs.Size = new System.Drawing.Size(841, 321);
            this.listViewSUAs.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listViewSUAs.TabIndex = 6;
            this.listViewSUAs.UseCompatibleStateImageBehavior = false;
            this.listViewSUAs.View = System.Windows.Forms.View.Details;
            this.listViewSUAs.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownSUAs);
            this.listViewSUAs.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnSUAName
            // 
            this.columnSUAName.Text = "Name";
            this.columnSUAName.Width = 150;
            // 
            // columnSUAId
            // 
            this.columnSUAId.Text = "ID";
            // 
            // columnSUAClass
            // 
            this.columnSUAClass.Text = "Class";
            // 
            // columnSUAType
            // 
            this.columnSUAType.Text = "Type";
            this.columnSUAType.Width = 80;
            // 
            // columnSUABase
            // 
            this.columnSUABase.Text = "Base";
            this.columnSUABase.Width = 80;
            // 
            // columnSUATop
            // 
            this.columnSUATop.Text = "Top";
            this.columnSUATop.Width = 80;
            // 
            // columnSUAComm
            // 
            this.columnSUAComm.Text = "Comm. Name";
            this.columnSUAComm.Width = 78;
            // 
            // columnSUAFrequency
            // 
            this.columnSUAFrequency.Text = "Frequency";
            this.columnSUAFrequency.Width = 64;
            // 
            // columnSUARemark
            // 
            this.columnSUARemark.Text = "Remark";
            this.columnSUARemark.Width = 220;
            // 
            // labelSUAItems
            // 
            this.labelSUAItems.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.labelSUAItems.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.labelSUAItems.ForeColor = System.Drawing.Color.Red;
            this.labelSUAItems.Location = new System.Drawing.Point(0, 321);
            this.labelSUAItems.Name = "labelSUAItems";
            this.labelSUAItems.Size = new System.Drawing.Size(841, 23);
            this.labelSUAItems.TabIndex = 10;
            this.labelSUAItems.Text = "0 items";
            this.labelSUAItems.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // panel6
            // 
            this.panel6.Controls.Add(this.buttonUploadSUA);
            this.panel6.Controls.Add(this.label19);
            this.panel6.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel6.Location = new System.Drawing.Point(5, 573);
            this.panel6.Name = "panel6";
            this.panel6.Size = new System.Drawing.Size(841, 48);
            this.panel6.TabIndex = 0;
            // 
            // buttonUploadSUA
            // 
            this.buttonUploadSUA.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadSUA.ImageIndex = 2;
            this.buttonUploadSUA.ImageList = this.imageListTransfer;
            this.buttonUploadSUA.Location = new System.Drawing.Point(0, 6);
            this.buttonUploadSUA.Name = "buttonUploadSUA";
            this.buttonUploadSUA.Size = new System.Drawing.Size(100, 36);
            this.buttonUploadSUA.TabIndex = 1;
            this.buttonUploadSUA.Text = "Upload SUA\'s";
            this.buttonUploadSUA.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadSUA.TextImageRelation = System.Windows.Forms.TextImageRelation.TextBeforeImage;
            this.buttonUploadSUA.Click += new System.EventHandler(this.OnUploadSUA);
            // 
            // label19
            // 
            this.label19.Location = new System.Drawing.Point(24, -24);
            this.label19.Name = "label19";
            this.label19.Size = new System.Drawing.Size(100, 23);
            this.label19.TabIndex = 10;
            this.label19.Text = "label18";
            // 
            // suaSelection
            // 
            this.suaSelection.Cursor = System.Windows.Forms.Cursors.Default;
            this.suaSelection.Dock = System.Windows.Forms.DockStyle.Top;
            this.suaSelection.Location = new System.Drawing.Point(5, 5);
            this.suaSelection.Name = "suaSelection";
            this.suaSelection.Size = new System.Drawing.Size(841, 224);
            this.suaSelection.TabIndex = 12;
            this.suaSelection.UseMapArea = false;
            this.suaSelection.SelectionChanged += new SoaringDotNET.Controls.SelectionChangedHandler(this.RefillSUAItems);
            // 
            // panelPilots
            // 
            this.panelPilots.BackColor = System.Drawing.SystemColors.Control;
            this.panelPilots.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelPilots.Controls.Add(this.panel8);
            this.panelPilots.Controls.Add(this.panel7);
            this.panelPilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelPilots.Location = new System.Drawing.Point(75, 0);
            this.panelPilots.Name = "panelPilots";
            this.panelPilots.Padding = new System.Windows.Forms.Padding(5);
            this.panelPilots.Size = new System.Drawing.Size(853, 628);
            this.panelPilots.TabIndex = 8;
            // 
            // panel8
            // 
            this.panel8.Controls.Add(this.listBoxPilots);
            this.panel8.Controls.Add(this.panel9);
            this.panel8.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panel8.Location = new System.Drawing.Point(5, 5);
            this.panel8.Name = "panel8";
            this.panel8.Size = new System.Drawing.Size(841, 568);
            this.panel8.TabIndex = 2;
            // 
            // listBoxPilots
            // 
            this.listBoxPilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listBoxPilots.Location = new System.Drawing.Point(0, 0);
            this.listBoxPilots.Name = "listBoxPilots";
            this.listBoxPilots.ScrollAlwaysVisible = true;
            this.listBoxPilots.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended;
            this.listBoxPilots.Size = new System.Drawing.Size(841, 511);
            this.listBoxPilots.Sorted = true;
            this.listBoxPilots.TabIndex = 0;
            this.listBoxPilots.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownPilots);
            // 
            // panel9
            // 
            this.panel9.Controls.Add(this.buttonReloadPilots);
            this.panel9.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel9.Location = new System.Drawing.Point(0, 520);
            this.panel9.Name = "panel9";
            this.panel9.Size = new System.Drawing.Size(841, 48);
            this.panel9.TabIndex = 4;
            // 
            // buttonReloadPilots
            // 
            this.buttonReloadPilots.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonReloadPilots.ImageIndex = 4;
            this.buttonReloadPilots.ImageList = this.imageListTransfer;
            this.buttonReloadPilots.Location = new System.Drawing.Point(0, 6);
            this.buttonReloadPilots.Name = "buttonReloadPilots";
            this.buttonReloadPilots.Size = new System.Drawing.Size(100, 36);
            this.buttonReloadPilots.TabIndex = 2;
            this.buttonReloadPilots.Text = "Reload Pilots";
            this.buttonReloadPilots.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonReloadPilots.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonReloadPilots.Click += new System.EventHandler(this.OnReloadPilots);
            // 
            // panel7
            // 
            this.panel7.Controls.Add(this.buttonUploadPilots);
            this.panel7.Controls.Add(this.buttonDownloadPilots);
            this.panel7.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel7.Location = new System.Drawing.Point(5, 573);
            this.panel7.Name = "panel7";
            this.panel7.Size = new System.Drawing.Size(841, 48);
            this.panel7.TabIndex = 1;
            // 
            // buttonUploadPilots
            // 
            this.buttonUploadPilots.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadPilots.ImageIndex = 2;
            this.buttonUploadPilots.ImageList = this.imageListTransfer;
            this.buttonUploadPilots.Location = new System.Drawing.Point(104, 6);
            this.buttonUploadPilots.Name = "buttonUploadPilots";
            this.buttonUploadPilots.Size = new System.Drawing.Size(100, 36);
            this.buttonUploadPilots.TabIndex = 1;
            this.buttonUploadPilots.Text = "Upload pilots";
            this.buttonUploadPilots.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadPilots.TextImageRelation = System.Windows.Forms.TextImageRelation.TextBeforeImage;
            this.buttonUploadPilots.Click += new System.EventHandler(this.OnUploadPilots);
            // 
            // buttonDownloadPilots
            // 
            this.buttonDownloadPilots.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadPilots.ImageIndex = 3;
            this.buttonDownloadPilots.ImageList = this.imageListTransfer;
            this.buttonDownloadPilots.Location = new System.Drawing.Point(0, 6);
            this.buttonDownloadPilots.Name = "buttonDownloadPilots";
            this.buttonDownloadPilots.Size = new System.Drawing.Size(100, 36);
            this.buttonDownloadPilots.TabIndex = 0;
            this.buttonDownloadPilots.Text = "Download pilots";
            this.buttonDownloadPilots.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadPilots.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageBeforeText;
            this.buttonDownloadPilots.Click += new System.EventHandler(this.OnDownloadPilots);
            // 
            // optionsPanel
            // 
            this.optionsPanel.BackColor = System.Drawing.SystemColors.Control;
            this.optionsPanel.ColumnCount = 1;
            this.optionsPanel.ColumnStyles.Add(new System.Windows.Forms.ColumnStyle(System.Windows.Forms.SizeType.Percent, 100F));
            this.optionsPanel.Controls.Add(this.radioButtonSUA, 0, 6);
            this.optionsPanel.Controls.Add(this.radioButtonPilots, 0, 5);
            this.optionsPanel.Controls.Add(this.radioButtonDeclaration, 0, 4);
            this.optionsPanel.Controls.Add(this.radioButtonWaypoints, 0, 3);
            this.optionsPanel.Controls.Add(this.radioButtonTasks, 0, 2);
            this.optionsPanel.Controls.Add(this.radioButtonFlights, 0, 1);
            this.optionsPanel.Controls.Add(this.radioButtonConnection, 0, 0);
            this.optionsPanel.Dock = System.Windows.Forms.DockStyle.Left;
            this.optionsPanel.Location = new System.Drawing.Point(0, 0);
            this.optionsPanel.Margin = new System.Windows.Forms.Padding(0);
            this.optionsPanel.Name = "optionsPanel";
            this.optionsPanel.RowCount = 8;
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 65F));
            this.optionsPanel.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 20F));
            this.optionsPanel.Size = new System.Drawing.Size(75, 656);
            this.optionsPanel.TabIndex = 9;
            // 
            // radioButtonSUA
            // 
            this.radioButtonSUA.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonSUA.AutoSize = true;
            this.radioButtonSUA.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonSUA.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonSUA.Image = global::SoaringDotNET.Properties.Resources.SUALarge;
            this.radioButtonSUA.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonSUA.Location = new System.Drawing.Point(3, 393);
            this.radioButtonSUA.Name = "radioButtonSUA";
            this.radioButtonSUA.Size = new System.Drawing.Size(69, 59);
            this.radioButtonSUA.TabIndex = 6;
            this.radioButtonSUA.Text = "SUA";
            this.radioButtonSUA.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonSUA.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonSUA.UseVisualStyleBackColor = false;
            this.radioButtonSUA.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // radioButtonPilots
            // 
            this.radioButtonPilots.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonPilots.AutoSize = true;
            this.radioButtonPilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonPilots.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonPilots.Image = global::SoaringDotNET.Properties.Resources.UsersLarge;
            this.radioButtonPilots.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonPilots.Location = new System.Drawing.Point(3, 328);
            this.radioButtonPilots.Name = "radioButtonPilots";
            this.radioButtonPilots.Size = new System.Drawing.Size(69, 59);
            this.radioButtonPilots.TabIndex = 5;
            this.radioButtonPilots.Text = "Pilots";
            this.radioButtonPilots.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonPilots.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonPilots.UseVisualStyleBackColor = false;
            this.radioButtonPilots.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // radioButtonDeclaration
            // 
            this.radioButtonDeclaration.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonDeclaration.AutoSize = true;
            this.radioButtonDeclaration.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonDeclaration.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonDeclaration.Image = global::SoaringDotNET.Properties.Resources.Declaration;
            this.radioButtonDeclaration.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonDeclaration.Location = new System.Drawing.Point(3, 263);
            this.radioButtonDeclaration.Name = "radioButtonDeclaration";
            this.radioButtonDeclaration.Size = new System.Drawing.Size(69, 59);
            this.radioButtonDeclaration.TabIndex = 4;
            this.radioButtonDeclaration.Text = "Declaration";
            this.radioButtonDeclaration.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonDeclaration.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonDeclaration.UseVisualStyleBackColor = false;
            this.radioButtonDeclaration.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // radioButtonWaypoints
            // 
            this.radioButtonWaypoints.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonWaypoints.AutoSize = true;
            this.radioButtonWaypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonWaypoints.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonWaypoints.Image = global::SoaringDotNET.Properties.Resources.WaypointLarge;
            this.radioButtonWaypoints.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonWaypoints.Location = new System.Drawing.Point(3, 198);
            this.radioButtonWaypoints.Name = "radioButtonWaypoints";
            this.radioButtonWaypoints.Size = new System.Drawing.Size(69, 59);
            this.radioButtonWaypoints.TabIndex = 3;
            this.radioButtonWaypoints.Text = "Waypoints";
            this.radioButtonWaypoints.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonWaypoints.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonWaypoints.UseVisualStyleBackColor = false;
            this.radioButtonWaypoints.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // radioButtonTasks
            // 
            this.radioButtonTasks.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonTasks.AutoSize = true;
            this.radioButtonTasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonTasks.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonTasks.Image = global::SoaringDotNET.Properties.Resources.TaskLarge;
            this.radioButtonTasks.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonTasks.Location = new System.Drawing.Point(3, 133);
            this.radioButtonTasks.Name = "radioButtonTasks";
            this.radioButtonTasks.Size = new System.Drawing.Size(69, 59);
            this.radioButtonTasks.TabIndex = 2;
            this.radioButtonTasks.Text = "Tasks";
            this.radioButtonTasks.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonTasks.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonTasks.UseVisualStyleBackColor = false;
            this.radioButtonTasks.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // radioButtonFlights
            // 
            this.radioButtonFlights.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonFlights.AutoSize = true;
            this.radioButtonFlights.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonFlights.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonFlights.Image = global::SoaringDotNET.Properties.Resources.FlightLarge;
            this.radioButtonFlights.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonFlights.Location = new System.Drawing.Point(3, 68);
            this.radioButtonFlights.Name = "radioButtonFlights";
            this.radioButtonFlights.Size = new System.Drawing.Size(69, 59);
            this.radioButtonFlights.TabIndex = 1;
            this.radioButtonFlights.Text = "Flights";
            this.radioButtonFlights.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonFlights.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonFlights.UseVisualStyleBackColor = false;
            this.radioButtonFlights.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // radioButtonConnection
            // 
            this.radioButtonConnection.Appearance = System.Windows.Forms.Appearance.Button;
            this.radioButtonConnection.AutoSize = true;
            this.radioButtonConnection.Checked = true;
            this.radioButtonConnection.Dock = System.Windows.Forms.DockStyle.Fill;
            this.radioButtonConnection.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.radioButtonConnection.Image = global::SoaringDotNET.Properties.Resources.RecorderLarge;
            this.radioButtonConnection.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
            this.radioButtonConnection.Location = new System.Drawing.Point(3, 3);
            this.radioButtonConnection.Name = "radioButtonConnection";
            this.radioButtonConnection.Size = new System.Drawing.Size(69, 59);
            this.radioButtonConnection.TabIndex = 0;
            this.radioButtonConnection.TabStop = true;
            this.radioButtonConnection.Text = "Connection";
            this.radioButtonConnection.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            this.radioButtonConnection.TextImageRelation = System.Windows.Forms.TextImageRelation.ImageAboveText;
            this.radioButtonConnection.UseVisualStyleBackColor = false;
            this.radioButtonConnection.Click += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // Recorder
            // 
            this.Controls.Add(this.panelSUA);
            this.Controls.Add(this.panelPilots);
            this.Controls.Add(this.panelDeclaration);
            this.Controls.Add(this.panelWaypoints);
            this.Controls.Add(this.panelTasks);
            this.Controls.Add(this.panelFlight);
            this.Controls.Add(this.panelConnection);
            this.Controls.Add(this.panelInfo);
            this.Controls.Add(this.optionsPanel);
            this.Name = "Recorder";
            this.Size = new System.Drawing.Size(928, 656);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownSUAs);
            this.panelConnection.ResumeLayout(false);
            this.panelDescription.ResumeLayout(false);
            this.panelDescription.PerformLayout();
            this.panelTop.ResumeLayout(false);
            this.panelTop.PerformLayout();
            this.panelFlight.ResumeLayout(false);
            this.panel1.ResumeLayout(false);
            this.groupBoxTransferOptions.ResumeLayout(false);
            this.panelTasks.ResumeLayout(false);
            this.panel5.ResumeLayout(false);
            this.panel2.ResumeLayout(false);
            this.panelWaypoints.ResumeLayout(false);
            this.panelWaypoints.PerformLayout();
            this.panel3.ResumeLayout(false);
            this.panelDeclaration.ResumeLayout(false);
            this.panelDeclaration.PerformLayout();
            this.panel4.ResumeLayout(false);
            this.panelInfo.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.connectionStatusPictureBox)).EndInit();
            this.panelSUA.ResumeLayout(false);
            this.panelSUABottom.ResumeLayout(false);
            this.panel6.ResumeLayout(false);
            this.panelPilots.ResumeLayout(false);
            this.panel8.ResumeLayout(false);
            this.panel9.ResumeLayout(false);
            this.panel7.ResumeLayout(false);
            this.optionsPanel.ResumeLayout(false);
            this.optionsPanel.PerformLayout();
            this.ResumeLayout(false);

        }


        private void OnSelectedItemChanged(object sender, System.EventArgs e) {
            RadioButton selectedButton = (RadioButton)sender;
            int i;
            for(i = 0; i < buttonItems.Length; i++) {
                panels[i].Visible = (buttonItems[i] == selectedButton);
            }

            if (selectedButton == radioButtonDeclaration && currentRecorder != null) {
                Regex split = new Regex("[ \t]+");
                string []tokens = split.Split(currentRecorder.flightDeclaration.pilot);

                if (tokens.Length > 0) {
                    textPilot1.Text = tokens[0];
                }
                if (tokens.Length > 1) {
                    textPilot1.Text += " " + tokens[1];
                }
                if (tokens.Length > 2) {
                    textPilot2.Text = tokens[2];
                }
                if (tokens.Length > 3) {
                    textPilot2.Text += " " + tokens[3];
                }

                textBoxCompId.Text = currentRecorder.flightDeclaration.competitionId;
                textBoxGliderId.Text = currentRecorder.flightDeclaration.gliderId;
                
                string s = currentRecorder.flightDeclaration.gliderType.Replace(" ", "");
                if (AppContents.gliderIndexes.ContainsKey(s)) {
                    comboBoxGlider.SelectedItem = AppContents.gliderIndexes[s];
                }

                if (currentRecorder.flightDeclaration.competitionClass != "" &&
                    (i = comboBoxCompClass.FindString(currentRecorder.flightDeclaration.competitionClass)) != -1) {
                    comboBoxCompClass.SelectedIndex = i;
                }
            }
        }

        private void OnRecorderChanged(object sender, System.EventArgs e) {
            Disconnect();
            comboBoxBaud.Items.Clear();
            comboBoxBaud.SelectedText = "";
            textBoxDescription.Text = "";
            if ((currentRecorder = (RecorderBase)comboManufacturer.SelectedItem) != null) {
                switch (currentRecorder.ConnectionType) {
                case RecorderConnectionType.Serial:
                    comboBoxBaud.Items.AddRange(((SerialConnectionRecorder)currentRecorder).SupportedLineSpeeds);
                    comboBoxBaud.SelectedItem = ((SerialConnectionRecorder)currentRecorder).PreferedSpeed;
                    textBoxDescription.Text = currentRecorder.Description;
                    comboBoxBaud.Enabled = true;
                    comboBoxPort.Enabled = true;
                    buttonConnect.Enabled = true;
                    break;
                case RecorderConnectionType.FileSystem:
                    textBoxDescription.Text = currentRecorder.Description;
                    comboBoxBaud.Enabled = false;
                    comboBoxPort.Enabled = false;
                    buttonConnect.Enabled = false;
                    OnConnectRecorder(null, null);
                    break;
                }
            }
        }

        private void OnReadFlightDirectory(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.DownloadFlights) == RecorderOptions.DownloadFlights) {
                currentRecorder.flightDirectory.Clear();
                workerThread = currentRecorder.FlightDirectoryThread();
                RunThread();
            }
        }

        private void OnDownloadWaypoints(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                workerThread = currentRecorder.DownloadWaypointsThread();
                RunThread();
            }
        }

        private void OnUploadWaypoints(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.UploadWaypoints) == RecorderOptions.UploadWaypoints) {
                currentRecorder.currentCatalogue = (WaypointCatalog)comboBoxCatalogues.SelectedItem;
                if (currentRecorder.capacity.maxNrWaypoints != (int)CapacityNumbers.Unlimited && currentRecorder.currentCatalogue.VisibleWaypointsCount > currentRecorder.capacity.maxNrWaypoints) {
                    if (MessageBox.Show(this, string.Format("Too many waypoints ({0}) in catalogue {1}. The max. capacity is {2}.\nIf you proceed, all further waypoints will be ignored!\n\nProceed anyway?", 
                        currentRecorder.currentCatalogue.Count, currentRecorder.currentCatalogue.Name, currentRecorder.capacity.maxNrWaypoints), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }
                workerThread = currentRecorder.UploadWaypointsThread();
                RunThread();
            }
        }

        private void OnUploadDeclaration(object sender, System.EventArgs e) {
            Task t = (Task)comboBoxTask.SelectedItem;

            if (currentRecorder != null && t != null && (currentRecorder.Options & RecorderOptions.UploadDeclaration) == RecorderOptions.UploadDeclaration) {
                currentRecorder.flightDeclaration.competitionClass = comboBoxCompClass.Text;
                currentRecorder.flightDeclaration.competitionId = textBoxCompId.Text;
                currentRecorder.flightDeclaration.gliderId = textBoxGliderId.Text;
                currentRecorder.flightDeclaration.gliderType = comboBoxGlider.Text;
                currentRecorder.flightDeclaration.pilot = textPilot1.Text + " " + textPilot2.Text;
                currentRecorder.declarationTask = t;

                // NOTE takeoff and landing are always ignored
                if (currentRecorder.capacity.maxNrWaypointsPerTask != (int)CapacityNumbers.Unlimited && t.Count - 2 > currentRecorder.capacity.maxNrWaypointsPerTask) {
                    if (MessageBox.Show(this, string.Format("Too many waypoints ({0}) in declaration form. The max. capacity is {1}.\nIf you proceed, all further waypoints in this task will be ignored!\n\nProceed anyway?", 
                        t.Count - 2, currentRecorder.capacity.maxNrWaypointsPerTask), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }

                workerThread = currentRecorder.UploadDeclarationThread();
                RunThread();
            }
        }

        private void OnCatalogueChanged(object sender, System.EventArgs e) {
            WaypointCatalog c = (WaypointCatalog)comboBoxCatalogues.SelectedItem;
            if (c != null) {
                catalogueItems.Text = c.Count.ToString();
                visibleCatalogueItems.Text = c.VisibleWaypointsCount.ToString();
            }
            else {
                catalogueItems.Text = "";
                visibleCatalogueItems.Text = "";
            }
        }

        private void OnDownloadTasks(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.DownloadTasks) == RecorderOptions.DownloadTasks) {
                currentRecorder.tasks.Clear();
                workerThread = currentRecorder.DownloadTasksThread();
                RunThread();
            }
        }

        private void OnUploadTasks(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.UploadTask) == RecorderOptions.UploadTask) {
                currentRecorder.tasks.Clear();
                foreach (ListViewItem it in listViewTasks.Items) {
                    currentRecorder.tasks.Add(it.Tag);
                }

                if (currentRecorder.capacity.maxNrTasks != (int)CapacityNumbers.Unlimited && currentRecorder.tasks.Count > currentRecorder.capacity.maxNrTasks) {
                    if (MessageBox.Show(this, string.Format("Too many tasks ({0}) in list. The max. capacity is {1}.\nIf you proceed, all further tasks will be ignored!\n\nProceed anyway?", 
                        currentRecorder.tasks.Count, currentRecorder.capacity.maxNrTasks), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }
                
                if (currentRecorder.capacity.maxNrWaypointsPerTask != (int)CapacityNumbers.Unlimited) {
                    foreach (Task t in currentRecorder.tasks) {
                        // NOTE takeoff and landing are always ignored
                        if (t.Count - 2 > currentRecorder.capacity.maxNrWaypointsPerTask) {
                            if (MessageBox.Show(this, string.Format("Too many waypoints ({0}) in task {1}. The max. capacity is {2}.\nIf you proceed, all further waypoints in this task will be ignored!\n\nProceed anyway?", 
                                t.Count - 2, t.Name, currentRecorder.capacity.maxNrWaypointsPerTask), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                                return;
                            }
                        }
                    }
                }
                workerThread = currentRecorder.UploadTasksThread();
                RunThread();
            }
        }

        private void OnDownloadPilots(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.DownloadPilots) == RecorderOptions.DownloadPilots) {
                workerThread = currentRecorder.DownloadPilotsThread();
                RunThread();
            }
        }

        private void OnUploadPilots(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.UploadPilots) == RecorderOptions.UploadPilots) {
                currentRecorder.pilots.Clear();
                foreach (Pilot p in listBoxPilots.Items) {
                    currentRecorder.pilots.Add(p);
                }

                if (currentRecorder.capacity.maxNrPilots != (int)CapacityNumbers.Unlimited && currentRecorder.pilots.Count > currentRecorder.capacity.maxNrPilots) {
                    if (MessageBox.Show(this, string.Format("Too many pilots ({0}) in list. The max. capacity is {1}.\nIf you proceed, all further pilots will be ignored!\n\nProceed anyway?", 
                        currentRecorder.pilots.Count, currentRecorder.capacity.maxNrPilots), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }
                workerThread = currentRecorder.UploadPilotsThread();
                RunThread();
            }
        }

        private void OnUploadSUA(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.UploadSUA) == RecorderOptions.UploadSUA) {
                currentRecorder.suas.Clear();
                foreach (ListViewItem it in listViewSUAs.Items) {
                    currentRecorder.suas.Add(it.Tag);
                }
                workerThread = currentRecorder.UploadSUASThread();
                RunThread();
            }
        }

        private void OnSaveFlights(object sender, System.EventArgs e) {
            if (currentRecorder != null && (currentRecorder.Options & RecorderOptions.DownloadFlights) == RecorderOptions.DownloadFlights) {
                FolderBrowserDialog fd = new FolderBrowserDialog();
                RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");

                fd.Description = "Select path for ICC files";                
                fd.SelectedPath = flightPath != "" ? flightPath : (string)currentUser.GetValue("DefaultFlightPath", "");;
                if (listViewFlightDirectory.SelectedIndices.Count > 0) {
                    if (fd.ShowDialog(this) == DialogResult.OK) {
                        flightPath = fd.SelectedPath;

                        currentRecorder.flightIndexes.Clear();
                        currentRecorder.flightIndexes.AddRange(listViewFlightDirectory.SelectedIndices);
                        currentRecorder.secureDownload = radioButtonSecure.Checked;
                        workerThread = currentRecorder.DownloadFlightsThread();
                        RunThread();
                    }
                }
                else {
                    MessageBox.Show(this, "Please select one or more flight's!", "SoaringDotNet", MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation);
                }
            }        
        }

        private void GetSerialNoHook(bool success) {
            if (success) {
                serialNo.Text = currentRecorder.SerialNo;
                connectionStatusPictureBox.Image = imageListConnectionStatus.Images[1];
            }
            else {
                Disconnect();
            }
        }

        private void GetFlightDirectoryHook(bool success) {
            int i = 1;
            int w;
            TimeSpan diffTime;
            listViewFlightDirectory.Items.Clear();
            if (success) {
                w = (int)(Math.Floor(Math.Log10(currentRecorder.flightDirectory.Count))) + 1;
                string format = "{" + string.Format("0:D{0}", w) + "}";
                foreach (DirectoryEntry de in currentRecorder.flightDirectory) {
                    diffTime = de.lastFix - de.firstFix;
                    listViewFlightDirectory.Items.Add(new ListViewItem(new string [] {string.Format(format, i),
                                                                                         de.firstFix.ToShortDateString(),
                                                                                         de.pilot, 
                                                                                         string.Format("{0} ({1})", de.gliderId, de.competitionId),
                                                                                         de.firstFix.ToString("HH:mm:ss"),
                                                                                         de.lastFix.ToString("HH:mm:ss"),
                                                                                         string.Format("{0}:{1:00}:{2:00}", diffTime.Hours, diffTime.Minutes, diffTime.Seconds),
                                                                                         de.fileName}));
                    i++;
                }
            }
        }

        private void DownloadWaypointsHook(bool success) {
            if (success) {
                AppContents.application.Invoke(AppContents.application.AddWaypointCatalogueDelegate, new object [] {currentRecorder.currentCatalogue});
            }
        }

        private void UploadWaypointsHook(bool success) {
        }

        private void DownloadTasksHook(bool success) {
            if (success) {
                AppContents.application.Invoke(AppContents.application.AddTasksDelegate, new object [] {currentRecorder.tasks});
            }
        }

        private void DownloadPilotsHook(bool success) {
            if (success) {
                AppContents.application.Invoke(AppContents.application.AddPilotsDelegate, new object [] {currentRecorder.pilots});
            }
        }

        private void UploadTasksHook(bool success) {
        }

        private void UploadDeclarationHook(bool success) {
        }

        private void UploadSUAsHook(bool success) {
        }

        private void DownloadFlightsHook(bool success) {
            if (success) {
                DirectoryEntry de;
                string fileName;
                ArrayList fileNames = new ArrayList();
                foreach (int idx in currentRecorder.flightIndexes) {
                    de = (DirectoryEntry) currentRecorder.flightDirectory[idx];
                    fileName = flightPath + @"\" + de.fileName;
                    de.igcFile.Write(fileName);
                    fileNames.Add(fileName);
                }
                AppContents.application.Invoke(AppContents.application.AddFlightDelegate, new object [] {fileNames});
            }
        }

        private void UploadPilotsHook(bool success) {
        }

        private void RunThread() {
            abort = false;
            try {
                workerThread.IsBackground = true;

                panelConnection.Enabled = false;

                workerThread.Start();
                timer = new System.Threading.Timer(new TimerCallback(CheckStatus), this, 0, 10);
            }
            finally {
                panelConnection.Enabled = true;
            }
        }

        private void Disconnect() {
            if (currentRecorder != null) {
                currentRecorder.Close();
            }

            buttonDownloadTasks.Enabled = false;
            buttonDownloadWaypoints.Enabled = false;
            buttonDownloadPilots.Enabled = false;
            buttonReadFlightDir.Enabled = false;
            buttonSaveFlight.Enabled = false;
            buttonUploadDeclaration.Enabled = false;
            buttonUploadTasks.Enabled = false;
            buttonUploadWaypoints.Enabled = false;
            buttonUploadPilots.Enabled = false;
            buttonUploadSUA.Enabled = false;

            connectionStatusPictureBox.Image = imageListConnectionStatus.Images[0];
            listViewFlightDirectory.Items.Clear();
        }
	
        private void OnClickCancelTransfer(object sender, System.EventArgs e) {
            abort = true;
        }

        private void CheckStatus(object obj) {
            if (workerThread != null && (workerThread.IsAlive || workerThread.ThreadState == ThreadState.Unstarted)) {
                if (abort) {
                    currentRecorder.BreakTransfer();
                }

                if (progress.Value < progress.Maximum) {
                    progress.PerformStep();
                }
                else {
                    progress.Value = progress.Minimum;
                }
            }
            else {
                panelConnection.Enabled = true;

                progress.Value = progress.Minimum;
                timer.Dispose();
            }
        }

        private void OnSelectPilot1(object sender, System.EventArgs e) {
            SelectPilotDialog d = new SelectPilotDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                textPilot1.Text = d.selectedPilot.FirstName.ToUpper() + " " + d.selectedPilot.LastName.ToUpper();
            }
        }

        private void OnSelectPilot2(object sender, System.EventArgs e) {
            SelectPilotDialog d = new SelectPilotDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                textPilot2.Text = d.selectedPilot.FirstName.ToUpper() + " " + d.selectedPilot.LastName.ToUpper();
            }
        }

        private void OnSelectedTaskChanged(object sender, System.EventArgs e) {
            Task t = (Task)comboBoxTask.SelectedItem;
            int i;
            string txt;
            WayPoint wp;
            ListViewItem item;

            if (t != null) {
                if (listViewTask.Items.Count > t.Count) {
                    for (i = listViewTask.Items.Count - 1; i >= t.Count; i--) {
                        listViewTask.Items.RemoveAt(i);
                    }
                }
                else if (listViewTask.Items.Count < t.Count) {
                    for (i = listViewTask.Items.Count; i < t.Count; i++) {
                        listViewTask.Items.Add(new ListViewItem(new string []{"", "", "", ""}));
                    }
                }

                for (i = 0; i < t.Count; i++) {
                    if (i == 0) {
                        txt = "Takeoff";
                    }
                    else if (i == 1) {
                        txt = "Start";
                    }
                    else if (i == t.Count - 2) {
                        txt = "Finish";
                    }
                    else if (i == t.Count - 1) {
                        txt = "Landing";
                    }
                    else {
                        txt = "Turnpoint";                        
                    }

                    wp = t[i];
                    item = listViewTask.Items[i];
                    item.SubItems[0].Text = txt;
                    item.SubItems[1].Text = wp.longName;
                    item.SubItems[2].Text = wp.ToStringLat();
                    item.SubItems[3].Text = wp.ToStringLong();

                    labelTaskType.Text = t.TaskTypeString;
                }
            }
        }

        private void OnConnectRecorder(object sender, System.EventArgs e) {
            int speed = 9600;
            string port = "";

            if (currentRecorder != null) {
                Disconnect();
            }

            currentRecorder = (RecorderBase) comboManufacturer.SelectedItem;
            if (currentRecorder != null) {
                try {
                    switch (currentRecorder.ConnectionType) {
                    case RecorderConnectionType.Serial:
                        if (comboBoxBaud.SelectedItem == null || comboBoxPort.SelectedItem == null) {
                            return;
                        }

                        speed = int.Parse(comboBoxBaud.SelectedItem != null ? comboBoxBaud.SelectedItem.ToString() : "0");
                        if (speed == 0) {
                            speed = 9600;
                        }

                        port = comboBoxPort.SelectedItem != null ? comboBoxPort.SelectedItem.ToString() : "";
                        if (port != "") {
                            Cursor = Cursors.WaitCursor;
                            if (currentRecorder.Open(port, speed)) {
                                connectionStatusPictureBox.Image = imageListConnectionStatus.Images[2];
                                workerThread = currentRecorder.SerialNoThread();
                                RunThread();
                            }
                            Cursor = Cursors.Default;
                        }
                        break;
                    case RecorderConnectionType.FileSystem:
                        if (currentRecorder.Open()) {
                            connectionStatusPictureBox.Image = imageListConnectionStatus.Images[2];
                            workerThread = currentRecorder.SerialNoThread();
                            RunThread();
                        }
                        break;
                    default:
                        return;
                    }

                    buttonDownloadTasks.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadTasks) != 0);
                    buttonDownloadPilots.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadPilots) != 0);
                    buttonDownloadWaypoints.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadWaypoints) != 0);
                    buttonReadFlightDir.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadFlights) != 0);
                    buttonSaveFlight.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadFlights) != 0);
                    buttonUploadDeclaration.Enabled = ((currentRecorder.Options & RecorderOptions.UploadDeclaration) != 0);
                    buttonUploadTasks.Enabled = ((currentRecorder.Options & RecorderOptions.UploadTask) != 0);
                    buttonUploadPilots.Enabled = ((currentRecorder.Options & RecorderOptions.UploadPilots) != 0);
                    buttonUploadWaypoints.Enabled = ((currentRecorder.Options & RecorderOptions.UploadWaypoints) != 0);
                    buttonUploadSUA.Enabled = ((currentRecorder.Options & RecorderOptions.UploadSUA) != 0);

                    Cursor = Cursors.WaitCursor;
                }
                catch (Exception ex) {
                    MessageBox.Show(ex.Message, "Connection Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    Disconnect();
                }
                finally {
                    Cursor = Cursors.Default;
                }
            }
        }

        private void RefillSUAItems() {
            ListViewItem it;
            ArrayList items = new ArrayList(suaSelection.SelectedAirspace.Count);

            listViewSUAs.BeginUpdate();
            listViewSUAs.Items.Clear();

            Cursor = Cursors.WaitCursor;

            foreach (AirspaceElement space in suaSelection.SelectedAirspace) {
                it = new ListViewItem(new string [] {space.airspace.name, space.airspace.id, 
                                                        space.AirspaceClass != AirspaceClasses.Unknown ? space.AirspaceClassString : "", 
                                                        space.AirspaceTypeString, space.airspace.lowerBound, space.airspace.upperBound, 
                                                        space.airspace.commName, space.airspace.radioFrequency, space.airspace.remark});
                it.Tag = space;
                items.Add(it);
            }
            
            if (items.Count > 0) {
                listViewSUAs.Items.AddRange((ListViewItem [])items.ToArray(items[0].GetType()));
            }

            labelSUAItems.Text = string.Format("{0} items", listViewSUAs.Items.Count);
            listViewSUAs.EndUpdate();

            Cursor = Cursors.Default;
        }

        private void OnKeyDownSUAs(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                foreach (ListViewItem it in listViewSUAs.SelectedItems) {
                    it.Remove();
                }
                labelSUAItems.Text = string.Format("{0} items", listViewSUAs.Items.Count);
            }
        }

        private void OnKeyDownTasks(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                foreach (ListViewItem it in listViewTasks.SelectedItems) {
                    it.Remove();
                }
            }
        }

        private void OnKeyDownPilots(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                int i;
                for (i = listBoxPilots.SelectedIndices.Count - 1; i >= 0; i--) {
                    listBoxPilots.Items.RemoveAt(listBoxPilots.SelectedIndices[i]);
                }
            }
        }


        private void OnReloadTasks(object sender, System.EventArgs e) {
            string txt = "";
            int i;

            listViewTasks.Items.Clear();
            comboBoxTask.Items.Clear();

            foreach (Task t in AppContents.tasks) {
                if (t.Count > 0) {
                    txt = t[0].longName;
                    for (i = 1; i < t.Count; i++) {
                        txt += ", " + t[i].longName;
                    }
                }
                else {
                    txt = "";
                }

                ListViewItem it = new ListViewItem(new string [] {t.Name, t.TaskTypeString, txt});
                it.Tag = t;
                listViewTasks.Items.Add(it);
                comboBoxTask.Items.Add(t);
            }
        }

        private void OnReloadPilots(object sender, System.EventArgs e) {
            listBoxPilots.Items.Clear();
            foreach(Pilot p in AppContents.pilots) {
                listBoxPilots.Items.Add(p);
            }
        }

        private void OnConnectionChanged(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                Disconnect();
            }
        }

        private void OnColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e) {
            ListView lv = (ListView) sender;
            ListViewItemSorter sorter = (ListViewItemSorter)lv.ListViewItemSorter;
            if (sorter != null) {
                sorter.Col = e.Column;
                lv.Sort();
            }
        }

        private void OnSUAVisibleChanged(object sender, System.EventArgs e) {
            if (panelSUA.Visible) {
                // force update
                if (suaSelection.UseMapArea) {
                    suaSelection.UseMapArea = true;
                }
            }
        }

        #endregion

        #region Attributes
        #endregion
    }
}
