using System;
using System.IO;
using System.Collections;
using System.Text.RegularExpressions;

using SoaringDotNET.Data;

namespace SoaringDotNET.FileFormats {
    /// <summary>
    /// 
    /// </summary>
    public enum SUAFileFormat {Unknown = -1, TNP, OpenAir};

	public class SUAFileHandlerBase
	{
		public SUAFileHandlerBase()
		{
			// 
			// TODO: Add constructor logic here
			//
		}

        public void WriteFile(ArrayList suas, StreamWriter file) {
            foreach (string line in WriteFile(suas)) {
                file.WriteLine(line);
            }
        }

        public ArrayList ReadFile(StreamReader file) {
            return ReadFile(file, false, AirspaceClasses.C, false, SUATypes.Unknown, false);
        }

        public ArrayList ReadFile(StreamReader file, bool useMichaelMeier) {
            return ReadFile(file, useMichaelMeier, AirspaceClasses.C, false, SUATypes.Unknown, false);
        }

        public ArrayList ReadFile(StreamReader file, AirspaceClasses defaultClass) {
            return ReadFile(file, false, defaultClass, false, SUATypes.Unknown, false);
        }

        public ArrayList ReadFile(StreamReader file, bool useMichaelMeier, AirspaceClasses defaultClass, bool overwriteClass, SUATypes defaultType, bool overwriteType) {
            ArrayList lines = new ArrayList();
            string line;
            while ((line = file.ReadLine()) != null) {
                lines.Add(line.Trim().ToUpper());
            }
            return ReadFile(lines, useMichaelMeier, defaultClass, overwriteClass, defaultType, overwriteType);
        }

        public virtual ArrayList ReadFile(ArrayList file, bool useMichaelMeier, AirspaceClasses defaultClass, bool overwriteClass, SUATypes defaultType, bool overwriteType) {
            throw new Exception("internal error: no overwritten ReadFile in SUAFileHandler");
        }

        public virtual ArrayList WriteFile(ArrayList suas) {
            throw new Exception("internal error: no overwritten WriteFile in SUAFileHandler");
        }

        public static SUAFileFormat DetectSUAFileFormat(string file) {
            SUAFileFormat format = SUAFileFormat.Unknown;
            StreamReader f = null;
            string t;
            char [] comment = new char []{'*', '"'};

            try {
                f = new StreamReader(file);
                while ((t = f.ReadLine()) != null) {
                    if (t.Trim().IndexOfAny(comment) >= 0) {
                        continue;
                    }
                    
                    if (t.IndexOf("TYPE=") != -1) {
                        format = SUAFileFormat.TNP;
                        break;
                    }
                    else if (t.IndexOf("AC ") != -1) {
                        format = SUAFileFormat.OpenAir;
                        break;
                    }                      
                }
            }
            finally {
                if (f != null) {
                    f.Close();
                }
            }
            return format;
        }

        protected void CheckImportOptions(Airspace space, bool useMichaelMeier, AirspaceClasses defaultClass, bool overwriteClass, SUATypes defaultType, bool overwriteType) {
            AirspaceSegment seg1, seg2;

            if (useMichaelMeier) {
                switch (space.name[0]) {
                case 'C':
                    space.airspaceClass = AirspaceClasses.C;
                    break;
                case 'D':
                    space.airspaceClass = AirspaceClasses.D;
                    break;
                case 'F':
                    if (space.name[1] == 'X') {
                        space.airspaceClass = AirspaceClasses.F;
                    }
                    break;
                case 'H':
                    if (space.name[1] == 'X') {
                        space.airspaceClass = AirspaceClasses.D;
                    }
                    break;
                case 'S':
                    if (space.name[1] == 'X') {
                        space.airspaceType = AirspaceTypes.Soaring;
                    }
                    break;
                default:
                    if (space.name.Substring(0, 3) == "TMZ") {
                        space.airspaceType = AirspaceTypes.TMZ;
                    }
                    break;
                }
            }
            else if (overwriteType) {
                switch (defaultType) {
                case SUATypes.CTACTR:
                    space.airspaceType = AirspaceTypes.ControlArea;
                    break;
                case SUATypes.Alert:
                    space.airspaceType = AirspaceTypes.Alert;
                    break;
                case SUATypes.Danger:
                    space.airspaceType = AirspaceTypes.Danger;
                    break;
                case SUATypes.MilitaryAerodromeTraffic:
                    space.airspaceType = AirspaceTypes.MilitaryAerodromeTraffic;
                    break;
                case SUATypes.Military:
                    space.airspaceType = AirspaceTypes.Military;
                    break;
                case SUATypes.Other:
                    space.airspaceType = AirspaceTypes.Other;
                    break;
                case SUATypes.Prohibited:
                    space.airspaceType = AirspaceTypes.Prohibited;
                    break;
                case SUATypes.Restricted:
                    space.airspaceType = AirspaceTypes.Restricted;
                    break;
                case SUATypes.Soaring:
                    space.airspaceType = AirspaceTypes.Soaring;
                    break;
                case SUATypes.Temporary:
                    space.airspaceType = AirspaceTypes.Temporary;
                    break;
                case SUATypes.TMZ:
                    space.airspaceType = AirspaceTypes.TMZ;
                    break;
                case SUATypes.Unknown:
                    space.airspaceType = AirspaceTypes.Unknown;
                    break;
                case SUATypes.Warning:
                    space.airspaceType = AirspaceTypes.Warning;
                    break;
                case SUATypes.Airway:
                    space.airspaceType = AirspaceTypes.Airway;
                    break;
                case SUATypes.GliderProhibited:
                    space.airspaceType = AirspaceTypes.GliderProhibited;
                    break;
                default:
                    space.airspaceType = AirspaceTypes.Unknown;
                    break;
                }
            }

            if (overwriteClass) {
                space.airspaceClass = defaultClass;
            }
            else if ((space.airspaceType == AirspaceTypes.ControlArea ||
                space.airspaceType == AirspaceTypes.ControlZone ||
                space.airspaceType == AirspaceTypes.TerminalControlArea) &&
                space.airspaceClass == AirspaceClasses.Unknown) {
                space.airspaceClass = defaultClass;
            }

            seg1 = (AirspaceSegment) space.points[space.points.Count - 1];

            if (seg1.type == AirspaceSegmentTypes.Line ||
                seg1.type == AirspaceSegmentTypes.ArcClock ||
                seg1.type == AirspaceSegmentTypes.ArcCounterClock) {
                seg2 = (AirspaceSegment)space.points[0];
                // check for closed section
                if (seg1.latTo != seg2.latFrom || seg1.lonTo != seg2.lonFrom) {
                    AirspaceSegment seg3 = new AirspaceSegment();
                    seg3.type = AirspaceSegmentTypes.Line;
                    seg3.latFrom = seg1.latTo;
                    seg3.lonFrom = seg1.lonTo;
                    seg3.latTo = seg2.latFrom;
                    seg3.lonTo = seg2.lonFrom;
                    space.points.Add(seg3);
                }
            }
        }
        protected string ParseAltitude(string txt) {
            Regex reg = new Regex("FL|MSL|AGL|SFC|GND");

            txt = txt.ToUpper();
            if (!reg.IsMatch(txt)) {
                txt += "MSL";
            }
            return txt;
        }
    }
}
