// name   : SUASelectionControl.cs
// author : Harald Maier
// date   : 28.04.2006
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for SUASelectionControl.
	/// </summary>
	
    public delegate void SelectionChangedHandler();

	public class SUASelectionControl : System.Windows.Forms.UserControl
	{
        private System.Windows.Forms.GroupBox groupBox2;
        private System.Windows.Forms.CheckedListBox checkedListBoxClasses;
        private System.Windows.Forms.Button buttonUseAllClasses;
        private System.Windows.Forms.Button buttonUseAllCountries;
        private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.CheckedListBox checkedListBoxAirspaces;
        private System.Windows.Forms.Button buttonUseAllAirspaces;
        private System.Windows.Forms.GroupBox groupBoxArea;
        private System.Windows.Forms.CheckBox checkBoxUseMapCoord;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonTo;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatTo;
        private System.Windows.Forms.Label label16;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonFrom;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatFrom;
        private System.Windows.Forms.Label label17;
        private System.Windows.Forms.RadioButton radioButtonArea;
        private System.Windows.Forms.CheckedListBox checkedListBoxCountry;
        private System.Windows.Forms.RadioButton radioButtonCountry;
        
        private Hashtable selectedCountries;
        private Hashtable selectedAirspaces;
        private Hashtable selectedClasses;

        private ArrayList visibleAirspace;

        private bool refresh;

        public event SelectionChangedHandler SelectionChanged;

        private WgsArea mapArea;
        /// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

        public SUASelectionControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call
            mapArea = new WgsArea();

            selectedCountries = new Hashtable();
            selectedAirspaces = new Hashtable();
            selectedClasses = new Hashtable();
            visibleAirspace = new ArrayList();

            refresh = true;

            // VisualStudio will fail to create objects
            try {
                ReloadAirspace();
                foreach (IdType t in AppContents.airspaceTypes) {
                    checkedListBoxAirspaces.Items.Add(t);
                }
                foreach (IdType c in AppContents.airspaceClasses) {
                    checkedListBoxClasses.Items.Add(c);
                }
            }
            catch {
            }

            radioButtonCountry.Checked = true;
		}

        public void ReloadAirspace() {
            checkedListBoxCountry.Items.Clear();
            selectedCountries.Clear();
            foreach (CountryTypeId c in AppContents.loadedAirspaceCountries) {
                checkedListBoxCountry.Items.Add(AppContents.CreateCountry(c));
            }
            RecalcItems();
        }

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.checkedListBoxClasses = new System.Windows.Forms.CheckedListBox();
            this.buttonUseAllClasses = new System.Windows.Forms.Button();
            this.buttonUseAllCountries = new System.Windows.Forms.Button();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.checkedListBoxAirspaces = new System.Windows.Forms.CheckedListBox();
            this.buttonUseAllAirspaces = new System.Windows.Forms.Button();
            this.groupBoxArea = new System.Windows.Forms.GroupBox();
            this.checkBoxUseMapCoord = new System.Windows.Forms.CheckBox();
            this.coordEditControlLonTo = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatTo = new SoaringDotNET.Controls.CoordEditControl();
            this.label16 = new System.Windows.Forms.Label();
            this.coordEditControlLonFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.label17 = new System.Windows.Forms.Label();
            this.radioButtonArea = new System.Windows.Forms.RadioButton();
            this.checkedListBoxCountry = new System.Windows.Forms.CheckedListBox();
            this.radioButtonCountry = new System.Windows.Forms.RadioButton();
            this.groupBox2.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.groupBoxArea.SuspendLayout();
            this.SuspendLayout();
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.checkedListBoxClasses);
            this.groupBox2.Controls.Add(this.buttonUseAllClasses);
            this.groupBox2.Location = new System.Drawing.Point(568, 8);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(152, 208);
            this.groupBox2.TabIndex = 16;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Classes (contr. airspace)";
            // 
            // checkedListBoxClasses
            // 
            this.checkedListBoxClasses.CheckOnClick = true;
            this.checkedListBoxClasses.Location = new System.Drawing.Point(8, 56);
            this.checkedListBoxClasses.Name = "checkedListBoxClasses";
            this.checkedListBoxClasses.ScrollAlwaysVisible = true;
            this.checkedListBoxClasses.Size = new System.Drawing.Size(136, 139);
            this.checkedListBoxClasses.Sorted = true;
            this.checkedListBoxClasses.TabIndex = 10;
            this.checkedListBoxClasses.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.OnClassItemCheckChanged);
            // 
            // buttonUseAllClasses
            // 
            this.buttonUseAllClasses.Location = new System.Drawing.Point(8, 24);
            this.buttonUseAllClasses.Name = "buttonUseAllClasses";
            this.buttonUseAllClasses.Size = new System.Drawing.Size(75, 24);
            this.buttonUseAllClasses.TabIndex = 9;
            this.buttonUseAllClasses.Text = "Select all";
            this.buttonUseAllClasses.Click += new System.EventHandler(this.OnUseAllClasses);
            // 
            // buttonUseAllCountries
            // 
            this.buttonUseAllCountries.Location = new System.Drawing.Point(8, 32);
            this.buttonUseAllCountries.Name = "buttonUseAllCountries";
            this.buttonUseAllCountries.Size = new System.Drawing.Size(75, 24);
            this.buttonUseAllCountries.TabIndex = 15;
            this.buttonUseAllCountries.Text = "Select all";
            this.buttonUseAllCountries.Click += new System.EventHandler(this.OnUseAllCountries);
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.checkedListBoxAirspaces);
            this.groupBox1.Controls.Add(this.buttonUseAllAirspaces);
            this.groupBox1.Location = new System.Drawing.Point(400, 8);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(152, 208);
            this.groupBox1.TabIndex = 14;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Airspaces";
            // 
            // checkedListBoxAirspaces
            // 
            this.checkedListBoxAirspaces.CheckOnClick = true;
            this.checkedListBoxAirspaces.Location = new System.Drawing.Point(8, 56);
            this.checkedListBoxAirspaces.Name = "checkedListBoxAirspaces";
            this.checkedListBoxAirspaces.ScrollAlwaysVisible = true;
            this.checkedListBoxAirspaces.Size = new System.Drawing.Size(136, 139);
            this.checkedListBoxAirspaces.Sorted = true;
            this.checkedListBoxAirspaces.TabIndex = 10;
            this.checkedListBoxAirspaces.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.OnAirspaceItemCheckChanged);
            // 
            // buttonUseAllAirspaces
            // 
            this.buttonUseAllAirspaces.Location = new System.Drawing.Point(8, 24);
            this.buttonUseAllAirspaces.Name = "buttonUseAllAirspaces";
            this.buttonUseAllAirspaces.Size = new System.Drawing.Size(75, 24);
            this.buttonUseAllAirspaces.TabIndex = 9;
            this.buttonUseAllAirspaces.Text = "Select all";
            this.buttonUseAllAirspaces.Click += new System.EventHandler(this.OnUseAllAirspaces);
            // 
            // groupBoxArea
            // 
            this.groupBoxArea.Controls.Add(this.checkBoxUseMapCoord);
            this.groupBoxArea.Controls.Add(this.coordEditControlLonTo);
            this.groupBoxArea.Controls.Add(this.coordEditControlLatTo);
            this.groupBoxArea.Controls.Add(this.label16);
            this.groupBoxArea.Controls.Add(this.coordEditControlLonFrom);
            this.groupBoxArea.Controls.Add(this.coordEditControlLatFrom);
            this.groupBoxArea.Controls.Add(this.label17);
            this.groupBoxArea.Location = new System.Drawing.Point(168, 32);
            this.groupBoxArea.Name = "groupBoxArea";
            this.groupBoxArea.Size = new System.Drawing.Size(216, 120);
            this.groupBoxArea.TabIndex = 13;
            this.groupBoxArea.TabStop = false;
            this.groupBoxArea.Text = "Area";
            // 
            // checkBoxUseMapCoord
            // 
            this.checkBoxUseMapCoord.Location = new System.Drawing.Point(40, 88);
            this.checkBoxUseMapCoord.Name = "checkBoxUseMapCoord";
            this.checkBoxUseMapCoord.TabIndex = 6;
            this.checkBoxUseMapCoord.Text = "use map area";
            this.checkBoxUseMapCoord.CheckedChanged += new System.EventHandler(this.OnUseMapArea);
            // 
            // coordEditControlLonTo
            // 
            this.coordEditControlLonTo.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLonTo.IsLatitude = false;
            this.coordEditControlLonTo.Location = new System.Drawing.Point(128, 56);
            this.coordEditControlLonTo.Name = "coordEditControlLonTo";
            this.coordEditControlLonTo.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLonTo.TabIndex = 5;
            this.coordEditControlLonTo.Value = 0;
            this.coordEditControlLonTo.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnAreaChanged);
            // 
            // coordEditControlLatTo
            // 
            this.coordEditControlLatTo.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLatTo.IsLatitude = true;
            this.coordEditControlLatTo.Location = new System.Drawing.Point(40, 56);
            this.coordEditControlLatTo.Name = "coordEditControlLatTo";
            this.coordEditControlLatTo.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLatTo.TabIndex = 4;
            this.coordEditControlLatTo.Value = 0;
            this.coordEditControlLatTo.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnAreaChanged);
            // 
            // label16
            // 
            this.label16.AutoSize = true;
            this.label16.Location = new System.Drawing.Point(24, 56);
            this.label16.Name = "label16";
            this.label16.Size = new System.Drawing.Size(14, 16);
            this.label16.TabIndex = 3;
            this.label16.Text = "to";
            // 
            // coordEditControlLonFrom
            // 
            this.coordEditControlLonFrom.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLonFrom.IsLatitude = false;
            this.coordEditControlLonFrom.Location = new System.Drawing.Point(128, 24);
            this.coordEditControlLonFrom.Name = "coordEditControlLonFrom";
            this.coordEditControlLonFrom.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLonFrom.TabIndex = 2;
            this.coordEditControlLonFrom.Value = 0;
            this.coordEditControlLonFrom.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSelectedAreaChanged);
            // 
            // coordEditControlLatFrom
            // 
            this.coordEditControlLatFrom.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLatFrom.IsLatitude = true;
            this.coordEditControlLatFrom.Location = new System.Drawing.Point(40, 24);
            this.coordEditControlLatFrom.Name = "coordEditControlLatFrom";
            this.coordEditControlLatFrom.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLatFrom.TabIndex = 1;
            this.coordEditControlLatFrom.Value = 0;
            this.coordEditControlLatFrom.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnAreaChanged);
            // 
            // label17
            // 
            this.label17.AutoSize = true;
            this.label17.Location = new System.Drawing.Point(8, 24);
            this.label17.Name = "label17";
            this.label17.Size = new System.Drawing.Size(27, 16);
            this.label17.TabIndex = 0;
            this.label17.Text = "from";
            // 
            // radioButtonArea
            // 
            this.radioButtonArea.Location = new System.Drawing.Point(168, 8);
            this.radioButtonArea.Name = "radioButtonArea";
            this.radioButtonArea.TabIndex = 12;
            this.radioButtonArea.Text = "Select by area";
            this.radioButtonArea.CheckedChanged += new System.EventHandler(this.OnSelectedAreaChanged);
            // 
            // checkedListBoxCountry
            // 
            this.checkedListBoxCountry.CheckOnClick = true;
            this.checkedListBoxCountry.Location = new System.Drawing.Point(8, 64);
            this.checkedListBoxCountry.Name = "checkedListBoxCountry";
            this.checkedListBoxCountry.ScrollAlwaysVisible = true;
            this.checkedListBoxCountry.Size = new System.Drawing.Size(144, 154);
            this.checkedListBoxCountry.Sorted = true;
            this.checkedListBoxCountry.TabIndex = 11;
            this.checkedListBoxCountry.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.OnCountyItemCheckChanged);
            // 
            // radioButtonCountry
            // 
            this.radioButtonCountry.Location = new System.Drawing.Point(8, 8);
            this.radioButtonCountry.Name = "radioButtonCountry";
            this.radioButtonCountry.Size = new System.Drawing.Size(144, 24);
            this.radioButtonCountry.TabIndex = 10;
            this.radioButtonCountry.Text = "Select by country";
            this.radioButtonCountry.CheckedChanged += new System.EventHandler(this.OnSelectedAreaChanged);
            // 
            // SUASelectionControl
            // 
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.buttonUseAllCountries);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.groupBoxArea);
            this.Controls.Add(this.radioButtonArea);
            this.Controls.Add(this.checkedListBoxCountry);
            this.Controls.Add(this.radioButtonCountry);
            this.Name = "SUASelectionControl";
            this.Size = new System.Drawing.Size(728, 224);
            this.groupBox2.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            this.groupBoxArea.ResumeLayout(false);
            this.ResumeLayout(false);

        }
		#endregion

        #region Private Functions
        private void RecalcItems() {
            Hashtable controlledAirspace = new Hashtable();
            WgsArea area = new WgsArea();

            Cursor = Cursors.WaitCursor;

            controlledAirspace.Add(AirspaceTypes.ControlArea, null);
            controlledAirspace.Add(AirspaceTypes.ControlZone, null);
            controlledAirspace.Add(AirspaceTypes.TerminalControlArea, null);
            controlledAirspace.Add(AirspaceTypes.MilitaryAerodromeTraffic, null);

            bool useCountries = radioButtonCountry.Checked;
            if (!useCountries) {
                if ((coordEditControlLatFrom.Value != 0 || coordEditControlLatTo.Value != 0) &&
                    (coordEditControlLonFrom.Value != 0 || coordEditControlLonTo.Value != 0)) {
                    area.TopLat = coordEditControlLatFrom.Value;
                    area.LeftLon = coordEditControlLonFrom.Value;
                    area.BottomLat = coordEditControlLatTo.Value;
                    area.RightLon = coordEditControlLonTo.Value;
                }
                else {
                    area.Clear();
                }
            }

            if (selectedAirspaces.Count > 0 || selectedClasses.Count > 0) {
                visibleAirspace = new ArrayList(AppContents.airspaces.Count);
                if (useCountries) {
                    foreach (string country in selectedCountries.Keys) {
                        CountryTypeId id = (CountryTypeId)AppContents.countryTypesByCode[country];
                        foreach (AirspaceElement space in (ArrayList)AppContents.airspacesByCountry[id]) {
                            if (selectedAirspaces.ContainsKey(space.AirspaceType)) {
                                // controlled airspace must meet class criteria
                                if (controlledAirspace.ContainsKey(space.AirspaceType) && !selectedClasses.ContainsKey(space.AirspaceClass)) {
                                    continue;
                                }
                                visibleAirspace.Add(space);
                            }
                        }
                    }
                }
                else if (!area.IsEmpty) {
                    foreach (AirspaceElement space in AppContents.airspaces) {
                        if (area.AreaIntersect(space.Area)&& selectedAirspaces.ContainsKey(space.AirspaceType)) {
                            // controlled airspace must meet class criteria
                            if (controlledAirspace.ContainsKey(space.AirspaceType) && !selectedClasses.ContainsKey(space.AirspaceClass)) {
                                continue;
                            }
                            visibleAirspace.Add(space);
                        }
                    }
                }
            }
            Cursor = Cursors.Default;

            if (SelectionChanged != null) {
                SelectionChanged();
            }
        }

        private void OnAreaChanged(object sender, System.EventArgs e) {
            RecalcItems();
        }

        private void OnSelectedAreaChanged(object sender, System.EventArgs e) {
            if (radioButtonCountry.Checked) {
                buttonUseAllCountries.Enabled = true;
                checkedListBoxCountry.Enabled = true;

                coordEditControlLatFrom.Enabled = false;
                coordEditControlLatTo.Enabled = false;
                coordEditControlLonFrom.Enabled  = false;
                coordEditControlLonTo.Enabled = false;
                checkBoxUseMapCoord.Enabled = false;
            }
            else {
                buttonUseAllCountries.Enabled = false;
                checkedListBoxCountry.Enabled = false;

                coordEditControlLatFrom.Enabled = true;
                coordEditControlLatTo.Enabled = true;
                coordEditControlLonFrom.Enabled  = true;
                coordEditControlLonTo.Enabled = true;
                checkBoxUseMapCoord.Enabled = true;
            }

            RecalcItems();
        }

        private void OnUseMapArea(object sender, System.EventArgs e) {
            if (checkBoxUseMapCoord.Checked) {
                coordEditControlLatFrom.Value = AppContents.application.MapUpperLeft.Y;
                coordEditControlLatTo.Value = AppContents.application.MapLowerRight.Y;
                coordEditControlLonFrom.Value = AppContents.application.MapUpperLeft.X;
                coordEditControlLonTo.Value = AppContents.application.MapLowerRight.X;
            }
            else {
                coordEditControlLatFrom.Value = 0;
                coordEditControlLatTo.Value = 0;
                coordEditControlLonFrom.Value = 0;
                coordEditControlLonTo.Value = 0;
            }

            RecalcItems();
        }

        private void OnUseAllCountries(object sender, System.EventArgs e) {
            Country c;
            selectedCountries.Clear();
            refresh = false;
            for (int i = 0; i < checkedListBoxCountry.Items.Count; i++) {
                checkedListBoxCountry.SetItemChecked(i, true);
                c = (Country)checkedListBoxCountry.Items[i];
                if (!selectedCountries.ContainsKey(c.code)) {
                    selectedCountries.Add(c.code, null);
                }
            }
            refresh = true;
            RecalcItems();
        }

        private void OnUseAllAirspaces(object sender, System.EventArgs e) {
            AirspaceTypes t;
            selectedAirspaces.Clear();
            refresh = false;
            for (int i = 0; i < checkedListBoxAirspaces.Items.Count; i++) {
                checkedListBoxAirspaces.SetItemChecked(i, true);
                t = (AirspaceTypes)((IdType)checkedListBoxAirspaces.Items[i]).id;
                if (!selectedAirspaces.ContainsKey(t)) {
                    selectedAirspaces.Add(t, null);
                }
            }

            refresh = true;
            RecalcItems();
        }

        private void OnUseAllClasses(object sender, System.EventArgs e) {
            AirspaceClasses c;
            selectedClasses.Clear();
            refresh = false;
            for (int i = 0; i < checkedListBoxClasses.Items.Count; i++) {
                checkedListBoxClasses.SetItemChecked(i, true);
                c = (AirspaceClasses)((IdType)checkedListBoxClasses.Items[i]).id;
                if (!selectedClasses.ContainsKey(c)) {
                    selectedClasses.Add(c, null);
                }
            }

            refresh = true;
            RecalcItems();
        }

        private void OnCountyItemCheckChanged(object sender, System.Windows.Forms.ItemCheckEventArgs e) {
            // prevent from cyclic update when select all countries
            if (refresh) {
                Country c = (Country)checkedListBoxCountry.Items[e.Index];
                if (e.NewValue == CheckState.Checked) {
                    if (!selectedCountries.ContainsKey(c.code)) {
                        selectedCountries.Add(c.code, null);
                    }
                }
                else {
                    if (selectedCountries.ContainsKey(c.code)) {
                        selectedCountries.Remove(c.code);
                    }
                }
                RecalcItems();
            }
        }

        private void OnAirspaceItemCheckChanged(object sender, System.Windows.Forms.ItemCheckEventArgs e) {
            // prevent from cyclic update when select all countries
            if (refresh) {
                AirspaceTypes t = (AirspaceTypes)((IdType)checkedListBoxAirspaces.Items[e.Index]).id;
                if (e.NewValue == CheckState.Checked) {
                    if (!selectedAirspaces.ContainsKey(t)) {
                        selectedAirspaces.Add(t, null);
                    }
                }
                else {
                    if (selectedAirspaces.ContainsKey(t)) {
                        selectedAirspaces.Remove(t);
                    }
                }
                RecalcItems();
            }
        }

        private void OnClassItemCheckChanged(object sender, System.Windows.Forms.ItemCheckEventArgs e) {
            // prevent from cyclic update when select all countries
            if (refresh) {
                AirspaceClasses c = (AirspaceClasses)((IdType)checkedListBoxClasses.Items[e.Index]).id;
                if (e.NewValue == CheckState.Checked) {
                    if (!selectedClasses.ContainsKey(c)) {
                        selectedClasses.Add(c, null);
                    }
                }
                else {
                    if (selectedClasses.ContainsKey(c)) {
                        selectedClasses.Remove(c);
                    }
                }
                RecalcItems();
            }
        }
        #endregion

        #region Attributes
/*        public bool UseCountries {
            get {
                return radioButtonCountry.Checked;
            }
            set {
                radioButtonCountry.Checked = value;
            }
        }

        public bool UseArea {
            get {
                return radioButtonArea.Checked;
            }
            set {
                radioButtonArea.Checked = value;
            }
        }
*/
        public bool UseMapArea {
            get {
                return checkBoxUseMapCoord.Checked;
            }
            set {
                checkBoxUseMapCoord.Checked = value;

                if (checkBoxUseMapCoord.Checked) {
                    OnUseMapArea(null, null);
                }
            }
        }
/*
        public WgsArea Area {
            get {
                return new WgsArea(coordEditControlLatFrom.Value, coordEditControlLonFrom.Value, 
                    coordEditControlLatTo.Value, coordEditControlLonTo.Value);
            }
            set {
                coordEditControlLatFrom.Value = value.TopLat;
                coordEditControlLonFrom.Value = value.LeftLon;
                coordEditControlLatTo.Value = value.BottomLat;
                coordEditControlLonTo.Value = value.RightLon;
            }
        }

        public WgsArea MapArea {
            get {
                return new WgsArea(mapArea);
            }
            set {
                mapArea.Area = value;
            }
        }
        */
        public ArrayList SelectedAirspace {
            get {
                return visibleAirspace;
            }
        }
        #endregion
	}
}
