// name   : SerialConnectionRecorder.cs
// author : Harald Maier
// date   : 25.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Windows.Forms;
using System.IO;

namespace SoaringDotNET.Recorders
{
    /// <summary>
	/// 
	/// </summary>
	public abstract class SerialConnectionRecorder : SoaringDotNET.Recorders.RecorderBase
	{
        protected System.IO.Ports.SerialPort comPort;
        protected int preferedLineSpeed;
        protected object [] supportedLineSpeeds;

        public SerialConnectionRecorder()
		{
			// 
			// TODO: Add constructor logic here
			//
            comPort = new System.IO.Ports.SerialPort();
            comPort.Encoding = System.Text.Encoding.ASCII;
            comPort.ReadTimeout = 100;
            comPort.WriteTimeout = 100;

            comPort.Handshake = System.IO.Ports.Handshake.None;
            connectionType = RecorderConnectionType.Serial;
            preferedLineSpeed = 9600;
            supportedLineSpeeds = new object[0];

        }

        public override void Close() {
            // TODO:  Add SoaringPilot.Close implementation
            if (comPort.IsOpen) {
                comPort.Close();
            }
            base.Close();
        }

        public override bool Open() {
            throw new System.NotImplementedException();
        }

        public override bool Open(string port, int speed) {
            bool ok = false;

            if (comPort.IsOpen) {
                comPort.Close();
            }

            comPort.BaudRate = speed;
            comPort.PortName = port;

            try {
                comPort.Open();
                ok = true;
            }
            catch (Exception e) {
                MessageBox.Show(e.Message, "IO Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            return ok;
        }

        protected override void DownloadFlights() {
            throw new System.NotImplementedException();
        }

        protected override void DownloadPilots() {
            throw new System.NotImplementedException();
        }

        protected override void DownloadTasks() {
            throw new System.NotImplementedException();
        }

        protected override void DownloadWaypoints() {
            throw new System.NotImplementedException();
        }

        protected override void GetFlightDir() {
            throw new System.NotImplementedException();
        }

        protected override void UploadDeclaration() {
            throw new System.NotImplementedException();
        }

        protected override void UploadPilots() {
            throw new System.NotImplementedException();
        }

        protected override void UploadSUAs() {
            throw new System.NotImplementedException();
        }

        protected override void UploadTasks() {
            throw new System.NotImplementedException();
        }

        protected override void UploadWaypoints() {
            throw new System.NotImplementedException();
        }
    
        public int PreferedSpeed {
            get {
                return preferedLineSpeed;
            }
        }

        public object[] SupportedLineSpeeds {
            get {
                return supportedLineSpeeds;
            }
        }
	}
}
