// name   : SetuDialog.cs
// author : Harald Maier
// date   : 03.01.2005
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Controls;
using SoaringDotNET.Data;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for Setup.
	/// </summary>
	public class SetupDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Panel panelButtons;
        private System.Windows.Forms.Button buttonOk;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.TabControl tabControl1;
        private System.Windows.Forms.TabPage tabPagePath;
        private System.Windows.Forms.TabPage tabPageSUA;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.TextBox textBoxFlightPath;
        private System.Windows.Forms.Button buttonFlightPath;
        private System.Windows.Forms.Button buttonWaypointPath;
        private System.Windows.Forms.TextBox textBoxWaypointPath;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Button buttonSUAPath;
        private System.Windows.Forms.TextBox textBoxSUAPath;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.ListView listViewAirspaces;
        private System.Windows.Forms.ColumnHeader columnHeader1;
        private System.Windows.Forms.TabPage tabPageTurnpoint;
        private System.Windows.Forms.ComboBox comboBoxSector;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.ComboBox comboBoxSectorType;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.TextBox textBoxCylinder;
        private System.Windows.Forms.TextBox textBoxSector;
        private System.Windows.Forms.Label label7;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.ColumnHeader columnHeader2;
        private System.Windows.Forms.Panel panelColorPreview;
        private System.Windows.Forms.Panel panelSector;
        private System.Windows.Forms.Button buttonResetAllColor;
        private System.Windows.Forms.Button buttonResetColor;
        private System.Windows.Forms.Button buttonResetAllSector;
        private System.Windows.Forms.Button buttonResetSector;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.NumericUpDown widthUpDown;
        private System.Windows.Forms.Panel panelWidthPreview;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public SetupDialog()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            comboBoxSectorType.Items.Add("Sector/Cyl.");
            comboBoxSectorType.Items.Add("Line");
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.panelButtons = new System.Windows.Forms.Panel();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.buttonOk = new System.Windows.Forms.Button();
            this.tabControl1 = new System.Windows.Forms.TabControl();
            this.tabPagePath = new System.Windows.Forms.TabPage();
            this.buttonSUAPath = new System.Windows.Forms.Button();
            this.textBoxSUAPath = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.buttonWaypointPath = new System.Windows.Forms.Button();
            this.textBoxWaypointPath = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.buttonFlightPath = new System.Windows.Forms.Button();
            this.textBoxFlightPath = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.tabPageSUA = new System.Windows.Forms.TabPage();
            this.panelWidthPreview = new System.Windows.Forms.Panel();
            this.widthUpDown = new System.Windows.Forms.NumericUpDown();
            this.label9 = new System.Windows.Forms.Label();
            this.buttonResetAllColor = new System.Windows.Forms.Button();
            this.buttonResetColor = new System.Windows.Forms.Button();
            this.panelColorPreview = new System.Windows.Forms.Panel();
            this.listViewAirspaces = new System.Windows.Forms.ListView();
            this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
            this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
            this.label4 = new System.Windows.Forms.Label();
            this.tabPageTurnpoint = new System.Windows.Forms.TabPage();
            this.buttonResetAllSector = new System.Windows.Forms.Button();
            this.buttonResetSector = new System.Windows.Forms.Button();
            this.panelSector = new System.Windows.Forms.Panel();
            this.textBoxCylinder = new System.Windows.Forms.TextBox();
            this.textBoxSector = new System.Windows.Forms.TextBox();
            this.label7 = new System.Windows.Forms.Label();
            this.label8 = new System.Windows.Forms.Label();
            this.comboBoxSectorType = new System.Windows.Forms.ComboBox();
            this.label6 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.comboBoxSector = new System.Windows.Forms.ComboBox();
            this.panelButtons.SuspendLayout();
            this.tabControl1.SuspendLayout();
            this.tabPagePath.SuspendLayout();
            this.tabPageSUA.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.widthUpDown)).BeginInit();
            this.tabPageTurnpoint.SuspendLayout();
            this.SuspendLayout();
            // 
            // panelButtons
            // 
            this.panelButtons.Controls.Add(this.buttonCancel);
            this.panelButtons.Controls.Add(this.buttonOk);
            this.panelButtons.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panelButtons.Location = new System.Drawing.Point(0, 341);
            this.panelButtons.Name = "panelButtons";
            this.panelButtons.Size = new System.Drawing.Size(416, 40);
            this.panelButtons.TabIndex = 0;
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(200, 8);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.Size = new System.Drawing.Size(75, 23);
            this.buttonCancel.TabIndex = 1;
            this.buttonCancel.Text = "Cancel";
            // 
            // buttonOk
            // 
            this.buttonOk.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOk.Location = new System.Drawing.Point(112, 8);
            this.buttonOk.Name = "buttonOk";
            this.buttonOk.Size = new System.Drawing.Size(75, 23);
            this.buttonOk.TabIndex = 0;
            this.buttonOk.Text = "Ok";
            // 
            // tabControl1
            // 
            this.tabControl1.Controls.Add(this.tabPagePath);
            this.tabControl1.Controls.Add(this.tabPageSUA);
            this.tabControl1.Controls.Add(this.tabPageTurnpoint);
            this.tabControl1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tabControl1.Location = new System.Drawing.Point(0, 0);
            this.tabControl1.Name = "tabControl1";
            this.tabControl1.SelectedIndex = 0;
            this.tabControl1.Size = new System.Drawing.Size(416, 341);
            this.tabControl1.TabIndex = 1;
            // 
            // tabPagePath
            // 
            this.tabPagePath.Controls.Add(this.buttonSUAPath);
            this.tabPagePath.Controls.Add(this.textBoxSUAPath);
            this.tabPagePath.Controls.Add(this.label3);
            this.tabPagePath.Controls.Add(this.buttonWaypointPath);
            this.tabPagePath.Controls.Add(this.textBoxWaypointPath);
            this.tabPagePath.Controls.Add(this.label2);
            this.tabPagePath.Controls.Add(this.buttonFlightPath);
            this.tabPagePath.Controls.Add(this.textBoxFlightPath);
            this.tabPagePath.Controls.Add(this.label1);
            this.tabPagePath.Location = new System.Drawing.Point(4, 22);
            this.tabPagePath.Name = "tabPagePath";
            this.tabPagePath.Size = new System.Drawing.Size(408, 315);
            this.tabPagePath.TabIndex = 0;
            this.tabPagePath.Text = "Path";
            // 
            // buttonSUAPath
            // 
            this.buttonSUAPath.Location = new System.Drawing.Point(360, 120);
            this.buttonSUAPath.Name = "buttonSUAPath";
            this.buttonSUAPath.Size = new System.Drawing.Size(24, 23);
            this.buttonSUAPath.TabIndex = 8;
            this.buttonSUAPath.Text = "...";
            this.buttonSUAPath.Click += new System.EventHandler(this.OnSUADirectoryClicked);
            // 
            // textBoxSUAPath
            // 
            this.textBoxSUAPath.Location = new System.Drawing.Point(8, 121);
            this.textBoxSUAPath.Name = "textBoxSUAPath";
            this.textBoxSUAPath.Size = new System.Drawing.Size(352, 20);
            this.textBoxSUAPath.TabIndex = 7;
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(6, 104);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(74, 13);
            this.label3.TabIndex = 6;
            this.label3.Text = "SUA Directory";
            // 
            // buttonWaypointPath
            // 
            this.buttonWaypointPath.Location = new System.Drawing.Point(360, 72);
            this.buttonWaypointPath.Name = "buttonWaypointPath";
            this.buttonWaypointPath.Size = new System.Drawing.Size(24, 23);
            this.buttonWaypointPath.TabIndex = 5;
            this.buttonWaypointPath.Text = "...";
            this.buttonWaypointPath.Click += new System.EventHandler(this.OnDefaultWaypointDirectoryClicked);
            // 
            // textBoxWaypointPath
            // 
            this.textBoxWaypointPath.Location = new System.Drawing.Point(8, 73);
            this.textBoxWaypointPath.Name = "textBoxWaypointPath";
            this.textBoxWaypointPath.Size = new System.Drawing.Size(352, 20);
            this.textBoxWaypointPath.TabIndex = 4;
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(6, 56);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(163, 13);
            this.label2.TabIndex = 3;
            this.label2.Text = "Default Waypoint/Task Directory";
            // 
            // buttonFlightPath
            // 
            this.buttonFlightPath.Location = new System.Drawing.Point(360, 24);
            this.buttonFlightPath.Name = "buttonFlightPath";
            this.buttonFlightPath.Size = new System.Drawing.Size(24, 23);
            this.buttonFlightPath.TabIndex = 2;
            this.buttonFlightPath.Text = "...";
            this.buttonFlightPath.Click += new System.EventHandler(this.OnDefaultFlightDirectoryClicked);
            // 
            // textBoxFlightPath
            // 
            this.textBoxFlightPath.Location = new System.Drawing.Point(8, 25);
            this.textBoxFlightPath.Name = "textBoxFlightPath";
            this.textBoxFlightPath.Size = new System.Drawing.Size(352, 20);
            this.textBoxFlightPath.TabIndex = 1;
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(6, 8);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(114, 13);
            this.label1.TabIndex = 0;
            this.label1.Text = "Default Flight Directory";
            // 
            // tabPageSUA
            // 
            this.tabPageSUA.Controls.Add(this.panelWidthPreview);
            this.tabPageSUA.Controls.Add(this.widthUpDown);
            this.tabPageSUA.Controls.Add(this.label9);
            this.tabPageSUA.Controls.Add(this.buttonResetAllColor);
            this.tabPageSUA.Controls.Add(this.buttonResetColor);
            this.tabPageSUA.Controls.Add(this.panelColorPreview);
            this.tabPageSUA.Controls.Add(this.listViewAirspaces);
            this.tabPageSUA.Controls.Add(this.label4);
            this.tabPageSUA.Location = new System.Drawing.Point(4, 22);
            this.tabPageSUA.Name = "tabPageSUA";
            this.tabPageSUA.Size = new System.Drawing.Size(408, 315);
            this.tabPageSUA.TabIndex = 1;
            this.tabPageSUA.Text = "Map";
            // 
            // panelWidthPreview
            // 
            this.panelWidthPreview.Location = new System.Drawing.Point(280, 96);
            this.panelWidthPreview.Name = "panelWidthPreview";
            this.panelWidthPreview.Size = new System.Drawing.Size(88, 24);
            this.panelWidthPreview.TabIndex = 9;
            this.panelWidthPreview.Paint += new System.Windows.Forms.PaintEventHandler(this.OnPaintPanelWidth);
            // 
            // widthUpDown
            // 
            this.widthUpDown.BackColor = System.Drawing.SystemColors.Window;
            this.widthUpDown.Location = new System.Drawing.Point(320, 70);
            this.widthUpDown.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.widthUpDown.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.widthUpDown.Name = "widthUpDown";
            this.widthUpDown.ReadOnly = true;
            this.widthUpDown.Size = new System.Drawing.Size(48, 20);
            this.widthUpDown.TabIndex = 8;
            this.widthUpDown.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.widthUpDown.ValueChanged += new System.EventHandler(this.OnDrawWithChanged);
            // 
            // label9
            // 
            this.label9.AutoSize = true;
            this.label9.Location = new System.Drawing.Point(280, 74);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(35, 13);
            this.label9.TabIndex = 7;
            this.label9.Text = "Width";
            // 
            // buttonResetAllColor
            // 
            this.buttonResetAllColor.Location = new System.Drawing.Point(280, 168);
            this.buttonResetAllColor.Name = "buttonResetAllColor";
            this.buttonResetAllColor.Size = new System.Drawing.Size(75, 23);
            this.buttonResetAllColor.TabIndex = 6;
            this.buttonResetAllColor.Text = "Reset All";
            this.buttonResetAllColor.Click += new System.EventHandler(this.OnResetColor);
            // 
            // buttonResetColor
            // 
            this.buttonResetColor.Location = new System.Drawing.Point(280, 136);
            this.buttonResetColor.Name = "buttonResetColor";
            this.buttonResetColor.Size = new System.Drawing.Size(75, 23);
            this.buttonResetColor.TabIndex = 5;
            this.buttonResetColor.Text = "Reset";
            this.buttonResetColor.Click += new System.EventHandler(this.OnResetColor);
            // 
            // panelColorPreview
            // 
            this.panelColorPreview.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelColorPreview.Location = new System.Drawing.Point(280, 24);
            this.panelColorPreview.Name = "panelColorPreview";
            this.panelColorPreview.Size = new System.Drawing.Size(88, 40);
            this.panelColorPreview.TabIndex = 4;
            // 
            // listViewAirspaces
            // 
            this.listViewAirspaces.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2});
            this.listViewAirspaces.FullRowSelect = true;
            this.listViewAirspaces.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            this.listViewAirspaces.HideSelection = false;
            this.listViewAirspaces.Location = new System.Drawing.Point(8, 24);
            this.listViewAirspaces.Name = "listViewAirspaces";
            this.listViewAirspaces.Size = new System.Drawing.Size(264, 256);
            this.listViewAirspaces.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listViewAirspaces.TabIndex = 3;
            this.listViewAirspaces.UseCompatibleStateImageBehavior = false;
            this.listViewAirspaces.View = System.Windows.Forms.View.Details;
            this.listViewAirspaces.DoubleClick += new System.EventHandler(this.OnDblClickColor);
            this.listViewAirspaces.SelectedIndexChanged += new System.EventHandler(this.OnSelectedColorIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Width = 120;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Width = 120;
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(8, 8);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(37, 13);
            this.label4.TabIndex = 1;
            this.label4.Text = "Colour";
            // 
            // tabPageTurnpoint
            // 
            this.tabPageTurnpoint.Controls.Add(this.buttonResetAllSector);
            this.tabPageTurnpoint.Controls.Add(this.buttonResetSector);
            this.tabPageTurnpoint.Controls.Add(this.panelSector);
            this.tabPageTurnpoint.Controls.Add(this.textBoxCylinder);
            this.tabPageTurnpoint.Controls.Add(this.textBoxSector);
            this.tabPageTurnpoint.Controls.Add(this.label7);
            this.tabPageTurnpoint.Controls.Add(this.label8);
            this.tabPageTurnpoint.Controls.Add(this.comboBoxSectorType);
            this.tabPageTurnpoint.Controls.Add(this.label6);
            this.tabPageTurnpoint.Controls.Add(this.label5);
            this.tabPageTurnpoint.Controls.Add(this.comboBoxSector);
            this.tabPageTurnpoint.Location = new System.Drawing.Point(4, 22);
            this.tabPageTurnpoint.Name = "tabPageTurnpoint";
            this.tabPageTurnpoint.Size = new System.Drawing.Size(408, 315);
            this.tabPageTurnpoint.TabIndex = 2;
            this.tabPageTurnpoint.Text = "Turnpoint";
            // 
            // buttonResetAllSector
            // 
            this.buttonResetAllSector.Location = new System.Drawing.Point(16, 256);
            this.buttonResetAllSector.Name = "buttonResetAllSector";
            this.buttonResetAllSector.Size = new System.Drawing.Size(75, 23);
            this.buttonResetAllSector.TabIndex = 15;
            this.buttonResetAllSector.Text = "Reset All";
            this.buttonResetAllSector.Click += new System.EventHandler(this.OnResetAllSector);
            // 
            // buttonResetSector
            // 
            this.buttonResetSector.Location = new System.Drawing.Point(16, 224);
            this.buttonResetSector.Name = "buttonResetSector";
            this.buttonResetSector.Size = new System.Drawing.Size(75, 23);
            this.buttonResetSector.TabIndex = 14;
            this.buttonResetSector.Text = "Reset";
            this.buttonResetSector.Click += new System.EventHandler(this.OnResetSector);
            // 
            // panelSector
            // 
            this.panelSector.BackColor = System.Drawing.Color.White;
            this.panelSector.Location = new System.Drawing.Point(144, 32);
            this.panelSector.Name = "panelSector";
            this.panelSector.Size = new System.Drawing.Size(250, 250);
            this.panelSector.TabIndex = 13;
            this.panelSector.Paint += new System.Windows.Forms.PaintEventHandler(this.OnPaintPanelSector);
            // 
            // textBoxCylinder
            // 
            this.textBoxCylinder.Location = new System.Drawing.Point(16, 176);
            this.textBoxCylinder.Name = "textBoxCylinder";
            this.textBoxCylinder.Size = new System.Drawing.Size(64, 20);
            this.textBoxCylinder.TabIndex = 12;
            this.textBoxCylinder.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.textBoxCylinder.TextChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // textBoxSector
            // 
            this.textBoxSector.Location = new System.Drawing.Point(16, 129);
            this.textBoxSector.Name = "textBoxSector";
            this.textBoxSector.Size = new System.Drawing.Size(64, 20);
            this.textBoxSector.TabIndex = 11;
            this.textBoxSector.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.textBoxSector.TextChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(14, 156);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(79, 13);
            this.label7.TabIndex = 10;
            this.label7.Text = "Radius cylinder";
            // 
            // label8
            // 
            this.label8.AutoSize = true;
            this.label8.Location = new System.Drawing.Point(14, 109);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(93, 13);
            this.label8.TabIndex = 9;
            this.label8.Text = "Radius sector/line";
            // 
            // comboBoxSectorType
            // 
            this.comboBoxSectorType.Location = new System.Drawing.Point(16, 81);
            this.comboBoxSectorType.Name = "comboBoxSectorType";
            this.comboBoxSectorType.Size = new System.Drawing.Size(104, 21);
            this.comboBoxSectorType.TabIndex = 4;
            this.comboBoxSectorType.SelectedIndexChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(14, 61);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(61, 13);
            this.label6.TabIndex = 3;
            this.label6.Text = "Sector type";
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(14, 13);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(38, 13);
            this.label5.TabIndex = 2;
            this.label5.Text = "Sector";
            // 
            // comboBoxSector
            // 
            this.comboBoxSector.Location = new System.Drawing.Point(16, 33);
            this.comboBoxSector.Name = "comboBoxSector";
            this.comboBoxSector.Size = new System.Drawing.Size(104, 21);
            this.comboBoxSector.TabIndex = 1;
            this.comboBoxSector.SelectedIndexChanged += new System.EventHandler(this.OnSelectedSectorChanged);
            // 
            // SetupDialog
            // 
            this.AcceptButton = this.buttonOk;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(416, 381);
            this.Controls.Add(this.tabControl1);
            this.Controls.Add(this.panelButtons);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "SetupDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Setup";
            this.DoubleClick += new System.EventHandler(this.OnDblClickColor);
            this.panelButtons.ResumeLayout(false);
            this.tabControl1.ResumeLayout(false);
            this.tabPagePath.ResumeLayout(false);
            this.tabPagePath.PerformLayout();
            this.tabPageSUA.ResumeLayout(false);
            this.tabPageSUA.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.widthUpDown)).EndInit();
            this.tabPageTurnpoint.ResumeLayout(false);
            this.tabPageTurnpoint.PerformLayout();
            this.ResumeLayout(false);

        }
		#endregion

        private void OnDefaultFlightDirectoryClicked(object sender, System.EventArgs e) {
            FolderBrowserDialog fd = new FolderBrowserDialog();
            fd.Description = "Select default flight directory";
            fd.SelectedPath = textBoxFlightPath.Text;
            if (fd.ShowDialog(this) == DialogResult.OK) {
                textBoxFlightPath.Text = fd.SelectedPath;
            }
        }

        private void OnDefaultWaypointDirectoryClicked(object sender, System.EventArgs e) {
            FolderBrowserDialog fd = new FolderBrowserDialog();
            fd.Description = "Select default waypoint/task directory";
            fd.SelectedPath = textBoxWaypointPath.Text;
            if (fd.ShowDialog(this) == DialogResult.OK) {
                textBoxWaypointPath.Text = fd.SelectedPath;
            }
        }

        private void OnSUADirectoryClicked(object sender, System.EventArgs e) {
            FolderBrowserDialog fd = new FolderBrowserDialog();
            fd.Description = "Select path of SUA directory";
            fd.SelectedPath = textBoxSUAPath.Text;
            if (fd.ShowDialog(this) == DialogResult.OK) {
                textBoxSUAPath.Text = fd.SelectedPath;
            }
        }

        public void AddColor(MapColor c) {
            ListViewItem it = new ListViewItem(new string [] {c.Name, string.Format("{0}{1}", c.DrawColor.IsKnownColor ? "" : "0x", c.DrawColor.Name)});
            it.Tag = c;
            listViewAirspaces.Items.Add(it);
            if (listViewAirspaces.SelectedIndices.Count == 0) {
                listViewAirspaces.Items[0].Selected = true;
            }
        }

        public void AddSector(SectorDefinition sector) {
            comboBoxSector.Items.Add(sector);
            if (comboBoxSector.SelectedIndex == -1) {
                comboBoxSector.SelectedIndex = 0;
            }
        }

        public SectorDefinition GetSector(TurnpointTypes type) {
            foreach (SectorDefinition s in comboBoxSector.Items) {
                if (s.turnpointType == type) {
                    return s;
                }
            }
            return null;
        }

        private void OnSelectedColorIndexChanged(object sender, System.EventArgs e) {
            if (listViewAirspaces.SelectedItems.Count > 0) {
                panelColorPreview.BackColor = ((MapColor)listViewAirspaces.SelectedItems[0].Tag).DrawColor;
                widthUpDown.Value = (decimal)((MapColor)listViewAirspaces.SelectedItems[0].Tag).Width;
                panelWidthPreview.Invalidate();
            }
        }

        private void OnDblClickColor(object sender, System.EventArgs e) {
            if (listViewAirspaces.SelectedItems.Count > 0) {
                ListViewItem it = listViewAirspaces.SelectedItems[0];
                ColorDialog c = new ColorDialog();
                c.AllowFullOpen = true;
                c.AnyColor = true;
                c.Color = ((MapColor)listViewAirspaces.SelectedItems[0].Tag).DrawColor;
                c.FullOpen = true;
                c.SolidColorOnly = false;
                if (c.ShowDialog(this) == DialogResult.OK) {
                    it.SubItems[1].Text = string.Format("{0}{1}", c.Color.IsKnownColor ? "" : "0x", c.Color.Name);
                    ((MapColor)listViewAirspaces.SelectedItems[0].Tag).DrawColor = c.Color;
                    OnSelectedColorIndexChanged(null, null);
                }
            }
        }

        private void OnResetColor(object sender, System.EventArgs e) {
            int start = 0, stop = 0;
            if (sender == buttonResetColor && listViewAirspaces.SelectedItems.Count > 0) {
                start = listViewAirspaces.SelectedIndices[0];
                stop = start + 1;
            }
            else if (sender == buttonResetAllColor) {
                start = 0;
                stop = listViewAirspaces.Items.Count;
            }
            ResetColor(start, stop);
        }

        private void ResetColor(int start, int stop) {
            int i;
            MapColor c;
            for (i = start; i < stop; i++) {
                ListViewItem it = listViewAirspaces.Items[i];
                c = (MapColor)it.Tag;
                c.Reset();
                it.SubItems[1].Text = string.Format("{0}{1}", c.DrawColor.IsKnownColor ? "" : "0x", c.DrawColor.Name);
            }
            OnSelectedColorIndexChanged(null, null);
        }

        private void OnSelectedSectorChanged(object sender, System.EventArgs e) {
            if (comboBoxSector.SelectedIndex != -1) {
                SectorDefinition sector = (SectorDefinition)comboBoxSector.SelectedItem;
                textBoxSector.Text = sector.radius1.ToString();
                textBoxCylinder.Text = sector.radius2.ToString();
                comboBoxSectorType.SelectedIndex = (int)sector.sectorType;
                panelSector.Invalidate();
            }
        }

        private void OnSectorDefinitionChanged(object sender, System.EventArgs e) {
            if (comboBoxSector.SelectedIndex != -1) {
                SectorDefinition sector = (SectorDefinition)comboBoxSector.SelectedItem;
                if (sender == comboBoxSectorType && comboBoxSectorType.SelectedIndex != -1) {
                    sector.sectorType = (SectorTypes)comboBoxSectorType.SelectedIndex;
                    if (sector.sectorType == SectorTypes.Line) {                        
                        textBoxCylinder.Text = "";
                        sector.radius2 = 0;
                    }

                    textBoxCylinder.Enabled = sector.sectorType == SectorTypes.Sector;
                }
                else if (sender == textBoxSector && textBoxSector.Text != "") {
                    try {
                        sector.radius1 = int.Parse(textBoxSector.Text);
                    }
                    catch {
                        sector.radius1 = 0;
                    }
                }
                else if (sender == textBoxCylinder && textBoxCylinder.Text != "") {
                    try { 
                        sector.radius2 = int.Parse(textBoxCylinder.Text);
                    }
                    catch {
                        sector.radius2 = 0;
                    }
                }
                panelSector.Invalidate();
            }
        }

        private void OnPaintPanelSector(object sender, System.Windows.Forms.PaintEventArgs e) {
            Graphics g = e.Graphics;
            int logWidth = 15000;
            int x, y, x2, y2, xx2, yy2;
            int size;
            double alpha;
            Pen drawPen;

            g.Clear(panelSector.BackColor);

            // start -> turnpoint
            drawPen = Pens.Gray;
            x = (int)(panelSector.Width * 0.2);
            y = (int)(panelSector.Height * 0.8);
            x2 = (int)(panelSector.Width * 0.5);
            y2 = (int)(panelSector.Height * 0.2);
            g.DrawLine(drawPen, x, y, x2, y2);

            // start sector
            SectorDefinition sector = (SectorDefinition)comboBoxSector.Items[0];
            if (comboBoxSector.SelectedIndex == 0) {
                drawPen = Pens.Red;
            }
            alpha = 90 - (Math.Atan((y - y2) / (x2 - x)) * 180 / Math.PI);
            switch (sector.sectorType) {
            case SectorTypes.Sector:
                if (sector.radius1 > 0) {
                    alpha = (alpha + (sector.angle / 2.0) % 360.0);
                    size = panelSector.Width * sector.radius1 / logWidth;
                    g.DrawPie(drawPen, x - (size / 2), y - (size / 2), size, size, (int)alpha + 90, -90);
                }
                if (sector.radius2 > 0) {
                    size = panelSector.Width * sector.radius2 / logWidth;
                    g.DrawEllipse(drawPen, x - (size / 2), y - (size / 2), size, size);
                }
                break;
            case SectorTypes.Line:
                size = panelSector.Width * sector.radius1 / logWidth / 2;
                xx2 = (int)(Math.Cos(Math.PI * alpha / 180.0) * size);
                yy2 = (int)(Math.Sin(Math.PI * alpha / 180.0) * size);
                g.DrawLine(drawPen, x + xx2, y + yy2, x - xx2, y - yy2);
                break;
            }

            // turnpoint -> start
            drawPen = Pens.Gray;
            x = (int)(panelSector.Width * 0.8);
            g.DrawLine(drawPen, x2, y2, x, y);

            // turnpoint sector
            sector = (SectorDefinition)comboBoxSector.Items[1];
            if (comboBoxSector.SelectedIndex == 1) {
                drawPen = Pens.Red;
            }
            alpha = (sector.angle / 2.0);
            switch (sector.sectorType) {
            case SectorTypes.Sector:
                if (sector.radius1 > 0) {
                    size = panelSector.Width * sector.radius1 / logWidth;
                    g.DrawPie(drawPen, x2 - (size / 2), y2 - (size / 2), size, size, (int)alpha - 90, -90);
                }
                if (sector.radius2 > 0) {
                    size = panelSector.Width * sector.radius2 / logWidth;
                    g.DrawEllipse(drawPen, x2 - (size / 2), y2 - (size / 2), size, size);
                }
                break;
            case SectorTypes.Line:
                alpha -= 45;
                size = panelSector.Width * sector.radius1 / logWidth / 2;
                xx2 = (int)(Math.Cos(Math.PI * alpha / 180.0) * size);
                yy2 = (int)(Math.Sin(Math.PI * alpha / 180.0) * size);
                g.DrawLine(drawPen, x2 + xx2, y2 + yy2, x2 - xx2, y2 - yy2);
                break;
            }

            // finish sector
            sector = (SectorDefinition)comboBoxSector.Items[2];
            drawPen = Pens.Gray;
            if (comboBoxSector.SelectedIndex == 2) {
                drawPen = Pens.Red;
            }
            alpha = 270 - (Math.Atan((y - y2) / (x2 - x)) * 180 / Math.PI);
            switch (sector.sectorType) {
            case SectorTypes.Sector:
                if (sector.radius1 > 0) {
                    alpha = (alpha + (sector.angle / 2.0) % 360.0);
                    size = panelSector.Width * sector.radius1 / logWidth;
                    g.DrawPie(drawPen, x - (size / 2), y - (size / 2), size, size, (int)alpha + 90, -90);
                }
                if (sector.radius2 > 0) {
                    size = panelSector.Width * sector.radius2 / logWidth;
                    g.DrawEllipse(drawPen, x - (size / 2), y - (size / 2), size, size);
                }
                break;
            case SectorTypes.Line:
                size = panelSector.Width * sector.radius1 / logWidth / 2;
                xx2 = (int)(Math.Cos(Math.PI * alpha / 180.0) * size);
                yy2 = (int)(Math.Sin(Math.PI * alpha / 180.0) * size);
                g.DrawLine(drawPen, x + xx2, y + yy2, x - xx2, y - yy2);
                break;
            }
        }

        private void OnResetAllSector(object sender, System.EventArgs e) {
            foreach (SectorDefinition sector in comboBoxSector.Items) {
                sector.Reset();
            }
            OnSelectedSectorChanged(null, null);
        }

        private void OnResetSector(object sender, System.EventArgs e) {
            if (comboBoxSector.SelectedItem != null) {
                ((SectorDefinition)comboBoxSector.SelectedItem).Reset();
                OnSelectedSectorChanged(null, null);
            }
        }

        private void OnPaintPanelWidth(object sender, System.Windows.Forms.PaintEventArgs e) {
            Graphics g = e.Graphics;
            g.Clear(BackColor);
            
            if (listViewAirspaces.SelectedItems.Count > 0) {
                g.DrawLine(new Pen(((MapColor)listViewAirspaces.SelectedItems[0].Tag).DrawColor,
                    ((MapColor)listViewAirspaces.SelectedItems[0].Tag).Width), 0, panelWidthPreview.Height / 2,
                    panelWidthPreview.Width, panelWidthPreview.Height / 2);
            }
        }

        private void OnDrawWithChanged(object sender, System.EventArgs e) {
            if (listViewAirspaces.SelectedItems.Count > 0) {
                ((MapColor)listViewAirspaces.SelectedItems[0].Tag).Width = decimal.ToSingle(widthUpDown.Value);
                panelWidthPreview.Invalidate();
            }
        }

        public string DefaultFlightPath {
            get {
                return textBoxFlightPath.Text;
            }
            set {
                textBoxFlightPath.Text = value;
            }
        }

        public string DefaultWaypointPath {
            get {
                return textBoxWaypointPath.Text;
            }
            set {
                textBoxWaypointPath.Text = value;
            }
        }

        public string SUAPath {
            get {
                return textBoxSUAPath.Text;
            }
            set {
                textBoxSUAPath.Text = value;
            }
        }

    }
}
