// name   : SoaringDotNet.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Xml;
using Microsoft.Win32;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;
using SoaringDotNET.Dialogs;
using SoaringDotNET.FileFormats;
using SoaringDotNET.Optimization;

namespace SoaringDotNET
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>

    public delegate void AddGUIObjectDelegate(object o);

    public class SoaringDotNet : System.Windows.Forms.Form {
        //public SoaringDotNET.Data.AppContents appContents;
        public WaypointCatalog currentCatalog;
        public Flight currentFlight;
        public Task currentTask;
        public AddGUIObjectDelegate AddWaypointCatalogueDelegate;
        public AddGUIObjectDelegate AddTasksDelegate;
        public AddGUIObjectDelegate AddFlightDelegate;
        public AddGUIObjectDelegate AddPilotsDelegate;

        private System.Windows.Forms.MainMenu mainMenu;

        private System.Windows.Forms.StatusBar statusBar;
        private System.Windows.Forms.StatusBarPanel statusBarPanelLat;
        private System.Windows.Forms.StatusBarPanel statusBarPanelLong;
        private System.Windows.Forms.TabControl tabControlDetails;
        private SoaringDotNET.Controls.Map map;
        private System.Windows.Forms.ImageList detailTabsImageList;
        private System.Windows.Forms.TabPage wayPointsPage;
        private System.Windows.Forms.TabPage tasksPage;
        private System.Windows.Forms.TabPage pilotsPage;
        private SoaringDotNET.Controls.Waypoints waypoints;
        private SoaringDotNET.Controls.Tasks tasks;
        private SoaringDotNET.Controls.Pilots pilots;
        private System.Windows.Forms.Splitter splitter1;
        private SoaringDotNET.Controls.Explorer explorer;
        private System.Windows.Forms.Splitter splitter2;
        private System.Windows.Forms.TabControl tabControlGraphics;
        private System.Windows.Forms.ImageList graphicsTabsImageList;
        private System.Windows.Forms.TabPage mapPage;
        private System.Windows.Forms.TabPage diagramPage;
        private System.Windows.Forms.StatusBarPanel statusBarPanelElevation;
        private System.Windows.Forms.StatusBarPanel statusBarPanelVario;
        private System.Windows.Forms.StatusBarPanel statusBarPanelSpeed;
        private System.Windows.Forms.StatusBarPanel statusBarPanelTime;
        private System.Windows.Forms.TabPage recorderPage;
        private SoaringDotNET.Controls.DiagramControl diagramControl;
        private SoaringDotNET.Controls.Recorder recorder;
        private System.Windows.Forms.TabPage statisticPage;
        private System.Windows.Forms.Label label1;
        private ToolStrip toolStrip;
        private ToolStripButton toolStripButtonOpenFile;
        private ToolStripButton toolStripButtonSaveFile;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripButton toolStripButtonZoomIn;
        private ToolStripButton toolStripButtonZoomOut;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripButton toolStripButtonCenterHome;
        private ToolStripButton toolStripButtonCenterTask;
        private ToolStripButton toolStripButtonCenterFlight;
        private ToolStripSeparator toolStripSeparator3;
        private ToolStripButton toolStripButtonPrint;
        private ToolStripButton toolStripButtonSetup;
        private ToolStripSeparator toolStripSeparator4;
        private ToolStripButton toolStripButtonOptimize;
        private ToolStripButton toolStripButtonOlc;
        private ToolStripContainer toolStripContainer1;
        private MenuStrip menuStrip;
        private ToolStripMenuItem toolStripMenuFile;
        private ToolStripMenuItem toolStripMenuView;
        private ToolStripMenuItem toolStripMenuTools;
        private ToolStripMenuItem toolStripMenuHelp;
        private ToolStripMenuItem newToolStripMenuItem;
        private ToolStripMenuItem openToolStripMenuItem;
        private ToolStripSeparator toolStripSeparator5;
        private ToolStripMenuItem importToolStripMenuItem;
        private ToolStripMenuItem exportToolStripMenuItem;
        private ToolStripMenuItem exitToolStripMenuItem;
        private ToolStripMenuItem waypointToolStripMenuItem;
        private ToolStripMenuItem taskToolStripMenuItem;
        private ToolStripMenuItem sUAToolStripMenuItem;
        private ToolStripMenuItem sUAToolStripMenuItem1;
        private ToolStripMenuItem mapToolStripMenuItem;
        private ToolStripMenuItem explorerToolStripMenuItem;
        private ToolStripMenuItem waypointsToolStripMenuItem;
        private ToolStripMenuItem tasksToolStripMenuItem;
        private ToolStripMenuItem pilotsToolStripMenuItem;
        private ToolStripMenuItem generateAirspaceDatabaseToolStripMenuItem;
        private ToolStripMenuItem generateTerrainDBToolStripMenuItem;
        private ToolStripMenuItem airspaceEditorToolStripMenuItem;
        private ToolStripMenuItem onlineManualToolStripMenuItem;
        private ToolStripMenuItem aboutSoaringDotNetToolStripMenuItem;
        private System.ComponentModel.IContainer components;
        public SoaringDotNet() {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
            currentCatalog = null;
            currentFlight = null;
            currentTask = null;

            this.mapToolStripMenuItem.Checked = true;
            this.waypointsToolStripMenuItem.Checked = true;
            this.explorerToolStripMenuItem.Checked = true;
            this.tasksToolStripMenuItem.Checked = true;
            this.pilotsToolStripMenuItem.Checked = true;
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(SoaringDotNet));
            this.mainMenu = new System.Windows.Forms.MainMenu(this.components);
            this.detailTabsImageList = new System.Windows.Forms.ImageList(this.components);
            this.graphicsTabsImageList = new System.Windows.Forms.ImageList(this.components);
            this.toolStripContainer1 = new System.Windows.Forms.ToolStripContainer();
            this.tabControlGraphics = new System.Windows.Forms.TabControl();
            this.mapPage = new System.Windows.Forms.TabPage();
            this.map = new SoaringDotNET.Controls.Map();
            this.diagramPage = new System.Windows.Forms.TabPage();
            this.diagramControl = new SoaringDotNET.Controls.DiagramControl();
            this.statisticPage = new System.Windows.Forms.TabPage();
            this.label1 = new System.Windows.Forms.Label();
            this.recorderPage = new System.Windows.Forms.TabPage();
            this.recorder = new SoaringDotNET.Controls.Recorder();
            this.splitter2 = new System.Windows.Forms.Splitter();
            this.explorer = new SoaringDotNET.Controls.Explorer();
            this.splitter1 = new System.Windows.Forms.Splitter();
            this.tabControlDetails = new System.Windows.Forms.TabControl();
            this.wayPointsPage = new System.Windows.Forms.TabPage();
            this.waypoints = new SoaringDotNET.Controls.Waypoints();
            this.tasksPage = new System.Windows.Forms.TabPage();
            this.tasks = new SoaringDotNET.Controls.Tasks();
            this.pilotsPage = new System.Windows.Forms.TabPage();
            this.pilots = new SoaringDotNET.Controls.Pilots();
            this.statusBar = new System.Windows.Forms.StatusBar();
            this.statusBarPanelLat = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelLong = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelTime = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelElevation = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelVario = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelSpeed = new System.Windows.Forms.StatusBarPanel();
            this.menuStrip = new System.Windows.Forms.MenuStrip();
            this.toolStripMenuFile = new System.Windows.Forms.ToolStripMenuItem();
            this.newToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.waypointToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.taskToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.openToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator5 = new System.Windows.Forms.ToolStripSeparator();
            this.importToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.sUAToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.exportToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.sUAToolStripMenuItem1 = new System.Windows.Forms.ToolStripMenuItem();
            this.exitToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuView = new System.Windows.Forms.ToolStripMenuItem();
            this.mapToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.explorerToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.waypointsToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.tasksToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.pilotsToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuTools = new System.Windows.Forms.ToolStripMenuItem();
            this.generateAirspaceDatabaseToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.generateTerrainDBToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.airspaceEditorToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuHelp = new System.Windows.Forms.ToolStripMenuItem();
            this.onlineManualToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.aboutSoaringDotNetToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStrip = new System.Windows.Forms.ToolStrip();
            this.toolStripButtonOpenFile = new System.Windows.Forms.ToolStripButton();
            this.toolStripButtonSaveFile = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripButtonZoomIn = new System.Windows.Forms.ToolStripButton();
            this.toolStripButtonZoomOut = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripButtonCenterHome = new System.Windows.Forms.ToolStripButton();
            this.toolStripButtonCenterTask = new System.Windows.Forms.ToolStripButton();
            this.toolStripButtonCenterFlight = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripButtonPrint = new System.Windows.Forms.ToolStripButton();
            this.toolStripButtonSetup = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator4 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripButtonOptimize = new System.Windows.Forms.ToolStripButton();
            this.toolStripButtonOlc = new System.Windows.Forms.ToolStripButton();
            this.toolStripContainer1.ContentPanel.SuspendLayout();
            this.toolStripContainer1.TopToolStripPanel.SuspendLayout();
            this.toolStripContainer1.SuspendLayout();
            this.tabControlGraphics.SuspendLayout();
            this.mapPage.SuspendLayout();
            this.diagramPage.SuspendLayout();
            this.statisticPage.SuspendLayout();
            this.recorderPage.SuspendLayout();
            this.tabControlDetails.SuspendLayout();
            this.wayPointsPage.SuspendLayout();
            this.tasksPage.SuspendLayout();
            this.pilotsPage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLat)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLong)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelElevation)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelVario)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelSpeed)).BeginInit();
            this.menuStrip.SuspendLayout();
            this.toolStrip.SuspendLayout();
            this.SuspendLayout();
            // 
            // detailTabsImageList
            // 
            this.detailTabsImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("detailTabsImageList.ImageStream")));
            this.detailTabsImageList.TransparentColor = System.Drawing.Color.Transparent;
            this.detailTabsImageList.Images.SetKeyName(0, "Waypoint.png");
            this.detailTabsImageList.Images.SetKeyName(1, "Task.png");
            this.detailTabsImageList.Images.SetKeyName(2, "User.png");
            // 
            // graphicsTabsImageList
            // 
            this.graphicsTabsImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("graphicsTabsImageList.ImageStream")));
            this.graphicsTabsImageList.TransparentColor = System.Drawing.Color.Transparent;
            this.graphicsTabsImageList.Images.SetKeyName(0, "");
            this.graphicsTabsImageList.Images.SetKeyName(1, "");
            this.graphicsTabsImageList.Images.SetKeyName(2, "");
            this.graphicsTabsImageList.Images.SetKeyName(3, "");
            // 
            // toolStripContainer1
            // 
            // 
            // toolStripContainer1.ContentPanel
            // 
            this.toolStripContainer1.ContentPanel.AutoScroll = true;
            this.toolStripContainer1.ContentPanel.Controls.Add(this.tabControlGraphics);
            this.toolStripContainer1.ContentPanel.Controls.Add(this.splitter2);
            this.toolStripContainer1.ContentPanel.Controls.Add(this.explorer);
            this.toolStripContainer1.ContentPanel.Controls.Add(this.splitter1);
            this.toolStripContainer1.ContentPanel.Controls.Add(this.tabControlDetails);
            this.toolStripContainer1.ContentPanel.Controls.Add(this.statusBar);
            this.toolStripContainer1.ContentPanel.Size = new System.Drawing.Size(992, 572);
            this.toolStripContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.toolStripContainer1.Location = new System.Drawing.Point(0, 0);
            this.toolStripContainer1.Name = "toolStripContainer1";
            this.toolStripContainer1.Size = new System.Drawing.Size(992, 621);
            this.toolStripContainer1.TabIndex = 13;
            this.toolStripContainer1.Text = "toolStripContainer1";
            // 
            // toolStripContainer1.TopToolStripPanel
            // 
            this.toolStripContainer1.TopToolStripPanel.Controls.Add(this.menuStrip);
            this.toolStripContainer1.TopToolStripPanel.Controls.Add(this.toolStrip);
            // 
            // tabControlGraphics
            // 
            this.tabControlGraphics.Controls.Add(this.mapPage);
            this.tabControlGraphics.Controls.Add(this.diagramPage);
            this.tabControlGraphics.Controls.Add(this.statisticPage);
            this.tabControlGraphics.Controls.Add(this.recorderPage);
            this.tabControlGraphics.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tabControlGraphics.ImageList = this.graphicsTabsImageList;
            this.tabControlGraphics.ItemSize = new System.Drawing.Size(55, 22);
            this.tabControlGraphics.Location = new System.Drawing.Point(205, 0);
            this.tabControlGraphics.Name = "tabControlGraphics";
            this.tabControlGraphics.SelectedIndex = 0;
            this.tabControlGraphics.Size = new System.Drawing.Size(787, 330);
            this.tabControlGraphics.TabIndex = 12;
            // 
            // mapPage
            // 
            this.mapPage.Controls.Add(this.map);
            this.mapPage.ImageIndex = 0;
            this.mapPage.Location = new System.Drawing.Point(4, 26);
            this.mapPage.Name = "mapPage";
            this.mapPage.Size = new System.Drawing.Size(779, 300);
            this.mapPage.TabIndex = 0;
            this.mapPage.Text = "Map";
            this.mapPage.UseVisualStyleBackColor = true;
            this.mapPage.Leave += new System.EventHandler(this.OnLeaveMapPage);
            // 
            // map
            // 
            this.map.BackColor = System.Drawing.Color.AliceBlue;
            this.map.Cursor = System.Windows.Forms.Cursors.Cross;
            this.map.Dock = System.Windows.Forms.DockStyle.Fill;
            this.map.Location = new System.Drawing.Point(0, 0);
            this.map.Name = "map";
            this.map.Size = new System.Drawing.Size(779, 300);
            this.map.TabIndex = 0;
            // 
            // diagramPage
            // 
            this.diagramPage.AutoScroll = true;
            this.diagramPage.Controls.Add(this.diagramControl);
            this.diagramPage.ImageIndex = 1;
            this.diagramPage.Location = new System.Drawing.Point(4, 26);
            this.diagramPage.Name = "diagramPage";
            this.diagramPage.Size = new System.Drawing.Size(779, 300);
            this.diagramPage.TabIndex = 1;
            this.diagramPage.Text = "Diagram";
            this.diagramPage.UseVisualStyleBackColor = true;
            // 
            // diagramControl
            // 
            this.diagramControl.AutoScroll = true;
            this.diagramControl.Dock = System.Windows.Forms.DockStyle.Fill;
            this.diagramControl.Location = new System.Drawing.Point(0, 0);
            this.diagramControl.Name = "diagramControl";
            this.diagramControl.Size = new System.Drawing.Size(779, 300);
            this.diagramControl.TabIndex = 0;
            // 
            // statisticPage
            // 
            this.statisticPage.Controls.Add(this.label1);
            this.statisticPage.ImageIndex = 3;
            this.statisticPage.Location = new System.Drawing.Point(4, 26);
            this.statisticPage.Name = "statisticPage";
            this.statisticPage.Size = new System.Drawing.Size(779, 300);
            this.statisticPage.TabIndex = 3;
            this.statisticPage.Text = "Statistic";
            this.statisticPage.UseVisualStyleBackColor = true;
            // 
            // label1
            // 
            this.label1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 48F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Italic))), System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label1.ForeColor = System.Drawing.Color.IndianRed;
            this.label1.Location = new System.Drawing.Point(0, 0);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(779, 300);
            this.label1.TabIndex = 0;
            this.label1.Text = "coming soon";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // recorderPage
            // 
            this.recorderPage.Controls.Add(this.recorder);
            this.recorderPage.ImageIndex = 2;
            this.recorderPage.Location = new System.Drawing.Point(4, 26);
            this.recorderPage.Margin = new System.Windows.Forms.Padding(0);
            this.recorderPage.Name = "recorderPage";
            this.recorderPage.Size = new System.Drawing.Size(779, 300);
            this.recorderPage.TabIndex = 2;
            this.recorderPage.Text = "Recorder";
            this.recorderPage.UseVisualStyleBackColor = true;
            // 
            // recorder
            // 
            this.recorder.Cursor = System.Windows.Forms.Cursors.Default;
            this.recorder.Dock = System.Windows.Forms.DockStyle.Fill;
            this.recorder.Location = new System.Drawing.Point(0, 0);
            this.recorder.Margin = new System.Windows.Forms.Padding(0);
            this.recorder.Name = "recorder";
            this.recorder.Size = new System.Drawing.Size(779, 300);
            this.recorder.TabIndex = 0;
            // 
            // splitter2
            // 
            this.splitter2.BackColor = System.Drawing.SystemColors.Control;
            this.splitter2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.splitter2.Location = new System.Drawing.Point(200, 0);
            this.splitter2.Name = "splitter2";
            this.splitter2.Size = new System.Drawing.Size(5, 330);
            this.splitter2.TabIndex = 11;
            this.splitter2.TabStop = false;
            // 
            // explorer
            // 
            this.explorer.Dock = System.Windows.Forms.DockStyle.Left;
            this.explorer.Location = new System.Drawing.Point(0, 0);
            this.explorer.Name = "explorer";
            this.explorer.Size = new System.Drawing.Size(200, 330);
            this.explorer.TabIndex = 10;
            // 
            // splitter1
            // 
            this.splitter1.BackColor = System.Drawing.SystemColors.Control;
            this.splitter1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.splitter1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.splitter1.Location = new System.Drawing.Point(0, 330);
            this.splitter1.Name = "splitter1";
            this.splitter1.Size = new System.Drawing.Size(992, 5);
            this.splitter1.TabIndex = 9;
            this.splitter1.TabStop = false;
            // 
            // tabControlDetails
            // 
            this.tabControlDetails.Controls.Add(this.wayPointsPage);
            this.tabControlDetails.Controls.Add(this.tasksPage);
            this.tabControlDetails.Controls.Add(this.pilotsPage);
            this.tabControlDetails.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.tabControlDetails.ImageList = this.detailTabsImageList;
            this.tabControlDetails.ItemSize = new System.Drawing.Size(84, 22);
            this.tabControlDetails.Location = new System.Drawing.Point(0, 335);
            this.tabControlDetails.Name = "tabControlDetails";
            this.tabControlDetails.SelectedIndex = 0;
            this.tabControlDetails.Size = new System.Drawing.Size(992, 215);
            this.tabControlDetails.TabIndex = 8;
            // 
            // wayPointsPage
            // 
            this.wayPointsPage.Controls.Add(this.waypoints);
            this.wayPointsPage.ImageIndex = 0;
            this.wayPointsPage.Location = new System.Drawing.Point(4, 26);
            this.wayPointsPage.Name = "wayPointsPage";
            this.wayPointsPage.Size = new System.Drawing.Size(984, 185);
            this.wayPointsPage.TabIndex = 0;
            this.wayPointsPage.Text = "Waypoints";
            // 
            // waypoints
            // 
            this.waypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.waypoints.Location = new System.Drawing.Point(0, 0);
            this.waypoints.Name = "waypoints";
            this.waypoints.Size = new System.Drawing.Size(984, 185);
            this.waypoints.TabIndex = 0;
            // 
            // tasksPage
            // 
            this.tasksPage.Controls.Add(this.tasks);
            this.tasksPage.ImageIndex = 1;
            this.tasksPage.Location = new System.Drawing.Point(4, 26);
            this.tasksPage.Name = "tasksPage";
            this.tasksPage.Size = new System.Drawing.Size(984, 185);
            this.tasksPage.TabIndex = 1;
            this.tasksPage.Text = "Task definition";
            // 
            // tasks
            // 
            this.tasks.AutoScroll = true;
            this.tasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tasks.Location = new System.Drawing.Point(0, 0);
            this.tasks.Name = "tasks";
            this.tasks.Size = new System.Drawing.Size(984, 185);
            this.tasks.TabIndex = 0;
            // 
            // pilotsPage
            // 
            this.pilotsPage.Controls.Add(this.pilots);
            this.pilotsPage.ImageIndex = 2;
            this.pilotsPage.Location = new System.Drawing.Point(4, 26);
            this.pilotsPage.Name = "pilotsPage";
            this.pilotsPage.Size = new System.Drawing.Size(984, 185);
            this.pilotsPage.TabIndex = 2;
            this.pilotsPage.Text = "Pilots";
            // 
            // pilots
            // 
            this.pilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pilots.Location = new System.Drawing.Point(0, 0);
            this.pilots.Name = "pilots";
            this.pilots.Size = new System.Drawing.Size(984, 185);
            this.pilots.TabIndex = 0;
            // 
            // statusBar
            // 
            this.statusBar.Location = new System.Drawing.Point(0, 550);
            this.statusBar.Name = "statusBar";
            this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
            this.statusBarPanelLat,
            this.statusBarPanelLong,
            this.statusBarPanelTime,
            this.statusBarPanelElevation,
            this.statusBarPanelVario,
            this.statusBarPanelSpeed});
            this.statusBar.ShowPanels = true;
            this.statusBar.Size = new System.Drawing.Size(992, 22);
            this.statusBar.TabIndex = 1;
            this.statusBar.Text = "statusBar1";
            // 
            // statusBarPanelLat
            // 
            this.statusBarPanelLat.Name = "statusBarPanelLat";
            this.statusBarPanelLat.Text = "0000\'00\"N";
            this.statusBarPanelLat.Width = 70;
            // 
            // statusBarPanelLong
            // 
            this.statusBarPanelLong.Name = "statusBarPanelLong";
            this.statusBarPanelLong.Text = "00000\'00\"E";
            this.statusBarPanelLong.Width = 75;
            // 
            // statusBarPanelTime
            // 
            this.statusBarPanelTime.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelTime.Name = "statusBarPanelTime";
            this.statusBarPanelTime.Text = "12:00 UTC";
            this.statusBarPanelTime.Width = 70;
            // 
            // statusBarPanelElevation
            // 
            this.statusBarPanelElevation.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelElevation.Name = "statusBarPanelElevation";
            this.statusBarPanelElevation.Text = "0 m";
            this.statusBarPanelElevation.Width = 70;
            // 
            // statusBarPanelVario
            // 
            this.statusBarPanelVario.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelVario.Name = "statusBarPanelVario";
            this.statusBarPanelVario.Text = "0 m/s";
            this.statusBarPanelVario.Width = 70;
            // 
            // statusBarPanelSpeed
            // 
            this.statusBarPanelSpeed.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelSpeed.Name = "statusBarPanelSpeed";
            this.statusBarPanelSpeed.Text = "0 km/h";
            this.statusBarPanelSpeed.Width = 70;
            // 
            // menuStrip
            // 
            this.menuStrip.Dock = System.Windows.Forms.DockStyle.None;
            this.menuStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuFile,
            this.toolStripMenuView,
            this.toolStripMenuTools,
            this.toolStripMenuHelp});
            this.menuStrip.Location = new System.Drawing.Point(0, 0);
            this.menuStrip.Name = "menuStrip";
            this.menuStrip.Size = new System.Drawing.Size(992, 24);
            this.menuStrip.TabIndex = 13;
            this.menuStrip.Text = "menuStrip1";
            // 
            // toolStripMenuFile
            // 
            this.toolStripMenuFile.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.newToolStripMenuItem,
            this.openToolStripMenuItem,
            this.toolStripSeparator5,
            this.importToolStripMenuItem,
            this.exportToolStripMenuItem,
            this.exitToolStripMenuItem});
            this.toolStripMenuFile.Name = "toolStripMenuFile";
            this.toolStripMenuFile.Size = new System.Drawing.Size(35, 20);
            this.toolStripMenuFile.Text = "&File";
            // 
            // newToolStripMenuItem
            // 
            this.newToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.waypointToolStripMenuItem,
            this.taskToolStripMenuItem});
            this.newToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.New;
            this.newToolStripMenuItem.Name = "newToolStripMenuItem";
            this.newToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.N)));
            this.newToolStripMenuItem.Size = new System.Drawing.Size(140, 22);
            this.newToolStripMenuItem.Text = "&New";
            // 
            // waypointToolStripMenuItem
            // 
            this.waypointToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.NewWaypoint;
            this.waypointToolStripMenuItem.Name = "waypointToolStripMenuItem";
            this.waypointToolStripMenuItem.Size = new System.Drawing.Size(120, 22);
            this.waypointToolStripMenuItem.Text = "&Waypoint";
            this.waypointToolStripMenuItem.Click += new System.EventHandler(this.OnNewWaypoint);
            // 
            // taskToolStripMenuItem
            // 
            this.taskToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.NewTask;
            this.taskToolStripMenuItem.Name = "taskToolStripMenuItem";
            this.taskToolStripMenuItem.Size = new System.Drawing.Size(120, 22);
            this.taskToolStripMenuItem.Text = "&Task";
            this.taskToolStripMenuItem.Click += new System.EventHandler(this.OnNewTask);
            // 
            // openToolStripMenuItem
            // 
            this.openToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Open;
            this.openToolStripMenuItem.Name = "openToolStripMenuItem";
            this.openToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.O)));
            this.openToolStripMenuItem.Size = new System.Drawing.Size(140, 22);
            this.openToolStripMenuItem.Text = "&Open";
            this.openToolStripMenuItem.Click += new System.EventHandler(this.OnFileOpen);
            // 
            // toolStripSeparator5
            // 
            this.toolStripSeparator5.Name = "toolStripSeparator5";
            this.toolStripSeparator5.Size = new System.Drawing.Size(137, 6);
            // 
            // importToolStripMenuItem
            // 
            this.importToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.sUAToolStripMenuItem});
            this.importToolStripMenuItem.Name = "importToolStripMenuItem";
            this.importToolStripMenuItem.Size = new System.Drawing.Size(140, 22);
            this.importToolStripMenuItem.Text = "&Import";
            // 
            // sUAToolStripMenuItem
            // 
            this.sUAToolStripMenuItem.Name = "sUAToolStripMenuItem";
            this.sUAToolStripMenuItem.Size = new System.Drawing.Size(94, 22);
            this.sUAToolStripMenuItem.Text = "&SUA";
            this.sUAToolStripMenuItem.Click += new System.EventHandler(this.OnImportSUA);
            // 
            // exportToolStripMenuItem
            // 
            this.exportToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.sUAToolStripMenuItem1});
            this.exportToolStripMenuItem.Name = "exportToolStripMenuItem";
            this.exportToolStripMenuItem.Size = new System.Drawing.Size(140, 22);
            this.exportToolStripMenuItem.Text = "&Export";
            // 
            // sUAToolStripMenuItem1
            // 
            this.sUAToolStripMenuItem1.Name = "sUAToolStripMenuItem1";
            this.sUAToolStripMenuItem1.Size = new System.Drawing.Size(94, 22);
            this.sUAToolStripMenuItem1.Text = "&SUA";
            this.sUAToolStripMenuItem1.Click += new System.EventHandler(this.OnExportSUA);
            // 
            // exitToolStripMenuItem
            // 
            this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
            this.exitToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.X)));
            this.exitToolStripMenuItem.Size = new System.Drawing.Size(140, 22);
            this.exitToolStripMenuItem.Text = "&Exit";
            this.exitToolStripMenuItem.Click += new System.EventHandler(this.OnFileExit);
            // 
            // toolStripMenuView
            // 
            this.toolStripMenuView.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.mapToolStripMenuItem,
            this.explorerToolStripMenuItem,
            this.waypointsToolStripMenuItem,
            this.tasksToolStripMenuItem,
            this.pilotsToolStripMenuItem});
            this.toolStripMenuView.Name = "toolStripMenuView";
            this.toolStripMenuView.Size = new System.Drawing.Size(41, 20);
            this.toolStripMenuView.Text = "&View";
            // 
            // mapToolStripMenuItem
            // 
            this.mapToolStripMenuItem.CheckOnClick = true;
            this.mapToolStripMenuItem.Name = "mapToolStripMenuItem";
            this.mapToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.M)));
            this.mapToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.mapToolStripMenuItem.Text = "&Map";
            this.mapToolStripMenuItem.Click += new System.EventHandler(this.OnViewMap);
            // 
            // explorerToolStripMenuItem
            // 
            this.explorerToolStripMenuItem.CheckOnClick = true;
            this.explorerToolStripMenuItem.Name = "explorerToolStripMenuItem";
            this.explorerToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.explorerToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.explorerToolStripMenuItem.Text = "&Explorer";
            this.explorerToolStripMenuItem.Click += new System.EventHandler(this.OnViewExplorer);
            // 
            // waypointsToolStripMenuItem
            // 
            this.waypointsToolStripMenuItem.CheckOnClick = true;
            this.waypointsToolStripMenuItem.Name = "waypointsToolStripMenuItem";
            this.waypointsToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
            this.waypointsToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.waypointsToolStripMenuItem.Text = "&Waypoints";
            this.waypointsToolStripMenuItem.Click += new System.EventHandler(this.OnViewWaypoint);
            // 
            // tasksToolStripMenuItem
            // 
            this.tasksToolStripMenuItem.CheckOnClick = true;
            this.tasksToolStripMenuItem.Name = "tasksToolStripMenuItem";
            this.tasksToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
            this.tasksToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.tasksToolStripMenuItem.Text = "&Tasks";
            this.tasksToolStripMenuItem.Click += new System.EventHandler(this.OnViewTask);
            // 
            // pilotsToolStripMenuItem
            // 
            this.pilotsToolStripMenuItem.CheckOnClick = true;
            this.pilotsToolStripMenuItem.Name = "pilotsToolStripMenuItem";
            this.pilotsToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.P)));
            this.pilotsToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.pilotsToolStripMenuItem.Text = "&Pilots";
            this.pilotsToolStripMenuItem.Click += new System.EventHandler(this.OnViewPilot);
            // 
            // toolStripMenuTools
            // 
            this.toolStripMenuTools.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.generateAirspaceDatabaseToolStripMenuItem,
            this.generateTerrainDBToolStripMenuItem,
            this.airspaceEditorToolStripMenuItem});
            this.toolStripMenuTools.Name = "toolStripMenuTools";
            this.toolStripMenuTools.Size = new System.Drawing.Size(44, 20);
            this.toolStripMenuTools.Text = "&Tools";
            // 
            // generateAirspaceDatabaseToolStripMenuItem
            // 
            this.generateAirspaceDatabaseToolStripMenuItem.Name = "generateAirspaceDatabaseToolStripMenuItem";
            this.generateAirspaceDatabaseToolStripMenuItem.Size = new System.Drawing.Size(248, 22);
            this.generateAirspaceDatabaseToolStripMenuItem.Text = "&Generate airspace database";
            this.generateAirspaceDatabaseToolStripMenuItem.Click += new System.EventHandler(this.OnGenerateAirspaceDB);
            // 
            // generateTerrainDBToolStripMenuItem
            // 
            this.generateTerrainDBToolStripMenuItem.Name = "generateTerrainDBToolStripMenuItem";
            this.generateTerrainDBToolStripMenuItem.Size = new System.Drawing.Size(248, 22);
            this.generateTerrainDBToolStripMenuItem.Text = "Generate &Terrain DB for SoaringPilot";
            this.generateTerrainDBToolStripMenuItem.Click += new System.EventHandler(this.OnGenerateTerrainDB);
            // 
            // airspaceEditorToolStripMenuItem
            // 
            this.airspaceEditorToolStripMenuItem.Name = "airspaceEditorToolStripMenuItem";
            this.airspaceEditorToolStripMenuItem.Size = new System.Drawing.Size(248, 22);
            this.airspaceEditorToolStripMenuItem.Text = "&Airspace Editor";
            this.airspaceEditorToolStripMenuItem.Click += new System.EventHandler(this.OnAirspaceEditor);
            // 
            // toolStripMenuHelp
            // 
            this.toolStripMenuHelp.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.onlineManualToolStripMenuItem,
            this.aboutSoaringDotNetToolStripMenuItem});
            this.toolStripMenuHelp.Name = "toolStripMenuHelp";
            this.toolStripMenuHelp.Size = new System.Drawing.Size(40, 20);
            this.toolStripMenuHelp.Text = "&Help";
            // 
            // onlineManualToolStripMenuItem
            // 
            this.onlineManualToolStripMenuItem.Name = "onlineManualToolStripMenuItem";
            this.onlineManualToolStripMenuItem.Size = new System.Drawing.Size(176, 22);
            this.onlineManualToolStripMenuItem.Text = "&Online manual";
            this.onlineManualToolStripMenuItem.Click += new System.EventHandler(this.OnOnlineManual);
            // 
            // aboutSoaringDotNetToolStripMenuItem
            // 
            this.aboutSoaringDotNetToolStripMenuItem.Name = "aboutSoaringDotNetToolStripMenuItem";
            this.aboutSoaringDotNetToolStripMenuItem.Size = new System.Drawing.Size(176, 22);
            this.aboutSoaringDotNetToolStripMenuItem.Text = "&About SoaringDotNet";
            this.aboutSoaringDotNetToolStripMenuItem.Click += new System.EventHandler(this.OnAbout);
            // 
            // toolStrip
            // 
            this.toolStrip.Dock = System.Windows.Forms.DockStyle.None;
            this.toolStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripButtonOpenFile,
            this.toolStripButtonSaveFile,
            this.toolStripSeparator1,
            this.toolStripButtonZoomIn,
            this.toolStripButtonZoomOut,
            this.toolStripSeparator2,
            this.toolStripButtonCenterHome,
            this.toolStripButtonCenterTask,
            this.toolStripButtonCenterFlight,
            this.toolStripSeparator3,
            this.toolStripButtonPrint,
            this.toolStripButtonSetup,
            this.toolStripSeparator4,
            this.toolStripButtonOptimize,
            this.toolStripButtonOlc});
            this.toolStrip.Location = new System.Drawing.Point(3, 24);
            this.toolStrip.Name = "toolStrip";
            this.toolStrip.Size = new System.Drawing.Size(289, 25);
            this.toolStrip.TabIndex = 1;
            this.toolStrip.Text = "toolStrip";
            this.toolStrip.ItemClicked += new System.Windows.Forms.ToolStripItemClickedEventHandler(this.OnToolbarItemClicked);
            // 
            // toolStripButtonOpenFile
            // 
            this.toolStripButtonOpenFile.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonOpenFile.Image = global::SoaringDotNET.Properties.Resources.Open;
            this.toolStripButtonOpenFile.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonOpenFile.Name = "toolStripButtonOpenFile";
            this.toolStripButtonOpenFile.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonOpenFile.Text = "Open file";
            this.toolStripButtonOpenFile.ToolTipText = "Open file";
            // 
            // toolStripButtonSaveFile
            // 
            this.toolStripButtonSaveFile.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonSaveFile.Image = global::SoaringDotNET.Properties.Resources.Save;
            this.toolStripButtonSaveFile.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonSaveFile.Name = "toolStripButtonSaveFile";
            this.toolStripButtonSaveFile.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonSaveFile.Text = "Save file";
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(6, 25);
            // 
            // toolStripButtonZoomIn
            // 
            this.toolStripButtonZoomIn.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonZoomIn.Image = global::SoaringDotNET.Properties.Resources.ZoomIn;
            this.toolStripButtonZoomIn.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonZoomIn.Name = "toolStripButtonZoomIn";
            this.toolStripButtonZoomIn.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonZoomIn.Text = "Zoom in";
            // 
            // toolStripButtonZoomOut
            // 
            this.toolStripButtonZoomOut.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonZoomOut.Image = global::SoaringDotNET.Properties.Resources.ZoomOut;
            this.toolStripButtonZoomOut.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonZoomOut.Name = "toolStripButtonZoomOut";
            this.toolStripButtonZoomOut.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonZoomOut.Text = "Zoom out";
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size(6, 25);
            // 
            // toolStripButtonCenterHome
            // 
            this.toolStripButtonCenterHome.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonCenterHome.Image = global::SoaringDotNET.Properties.Resources.Home;
            this.toolStripButtonCenterHome.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonCenterHome.Name = "toolStripButtonCenterHome";
            this.toolStripButtonCenterHome.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonCenterHome.Text = "Center home";
            // 
            // toolStripButtonCenterTask
            // 
            this.toolStripButtonCenterTask.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonCenterTask.Image = global::SoaringDotNET.Properties.Resources.Task;
            this.toolStripButtonCenterTask.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonCenterTask.Name = "toolStripButtonCenterTask";
            this.toolStripButtonCenterTask.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonCenterTask.Text = "Center task";
            // 
            // toolStripButtonCenterFlight
            // 
            this.toolStripButtonCenterFlight.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonCenterFlight.Image = global::SoaringDotNET.Properties.Resources.Flight;
            this.toolStripButtonCenterFlight.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonCenterFlight.Name = "toolStripButtonCenterFlight";
            this.toolStripButtonCenterFlight.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonCenterFlight.Text = "Center flight";
            // 
            // toolStripSeparator3
            // 
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            this.toolStripSeparator3.Size = new System.Drawing.Size(6, 25);
            // 
            // toolStripButtonPrint
            // 
            this.toolStripButtonPrint.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonPrint.Image = global::SoaringDotNET.Properties.Resources.Print;
            this.toolStripButtonPrint.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonPrint.Name = "toolStripButtonPrint";
            this.toolStripButtonPrint.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonPrint.Text = "Print";
            // 
            // toolStripButtonSetup
            // 
            this.toolStripButtonSetup.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonSetup.Image = global::SoaringDotNET.Properties.Resources.Setup;
            this.toolStripButtonSetup.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonSetup.Name = "toolStripButtonSetup";
            this.toolStripButtonSetup.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonSetup.Text = "Setup";
            // 
            // toolStripSeparator4
            // 
            this.toolStripSeparator4.Name = "toolStripSeparator4";
            this.toolStripSeparator4.Size = new System.Drawing.Size(6, 25);
            // 
            // toolStripButtonOptimize
            // 
            this.toolStripButtonOptimize.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonOptimize.Image = global::SoaringDotNET.Properties.Resources.Optimize;
            this.toolStripButtonOptimize.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonOptimize.Name = "toolStripButtonOptimize";
            this.toolStripButtonOptimize.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonOptimize.Text = "Optimize";
            // 
            // toolStripButtonOlc
            // 
            this.toolStripButtonOlc.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonOlc.Image = global::SoaringDotNET.Properties.Resources.Olc;
            this.toolStripButtonOlc.ImageTransparentColor = System.Drawing.Color.Transparent;
            this.toolStripButtonOlc.Name = "toolStripButtonOlc";
            this.toolStripButtonOlc.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonOlc.Text = "Send to OLC";
            // 
            // SoaringDotNet
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(992, 621);
            this.Controls.Add(this.toolStripContainer1);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MainMenuStrip = this.menuStrip;
            this.Menu = this.mainMenu;
            this.Name = "SoaringDotNet";
            this.Text = "SoaringDotNET";
            this.toolStripContainer1.ContentPanel.ResumeLayout(false);
            this.toolStripContainer1.TopToolStripPanel.ResumeLayout(false);
            this.toolStripContainer1.TopToolStripPanel.PerformLayout();
            this.toolStripContainer1.ResumeLayout(false);
            this.toolStripContainer1.PerformLayout();
            this.tabControlGraphics.ResumeLayout(false);
            this.mapPage.ResumeLayout(false);
            this.diagramPage.ResumeLayout(false);
            this.statisticPage.ResumeLayout(false);
            this.recorderPage.ResumeLayout(false);
            this.tabControlDetails.ResumeLayout(false);
            this.wayPointsPage.ResumeLayout(false);
            this.tasksPage.ResumeLayout(false);
            this.pilotsPage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLat)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLong)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelElevation)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelVario)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelSpeed)).EndInit();
            this.menuStrip.ResumeLayout(false);
            this.menuStrip.PerformLayout();
            this.toolStrip.ResumeLayout(false);
            this.toolStrip.PerformLayout();
            this.ResumeLayout(false);

        }
        #endregion

        #region Protected Functions
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        protected override void OnClosing(CancelEventArgs e) {
            // TODO:  Add SoaringDotNet.OnClosing implementation
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            string defaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");

            foreach (WaypointCatalog c in AppContents.waypointCatalogs) {
                if (c.Dirty) {
                    switch (MessageBox.Show(this, string.Format("{0} is modified!\n\nSave changes?", c.Name), "Warning", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation)) {
                    case DialogResult.Yes:
                        c.Save(AppContents.tasks, defaultWaypointPath);
                        break;
                    case DialogResult.Cancel:
                        e.Cancel = true;
                        break;
                    }
                }
                if (e.Cancel) {
                    break;
                }
            }
            SaveConfig();
            base.OnClosing (e);
        }

        #endregion

        #region Private Functions
        private void OnImportSUA(object sender, System.EventArgs e) {
            RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            string destPath = (string)currentUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace");
            ArrayList suas = new ArrayList();
            ImportSUAOptionsDialog importOptions = new ImportSUAOptionsDialog();

            SUAFileHandlerBase fileHandler = null;

            if (importOptions.ShowDialog(this) == DialogResult.OK) {
                try {
                    SUAFileFormat fFormat = importOptions.FileFormat;
                    foreach (string file in importOptions.FileNames) {
                        if (fFormat == SUAFileFormat.Unknown) {
                            fFormat = SUAFileHandlerBase.DetectSUAFileFormat(file);
                        }
                        switch (fFormat) {
                        default:
                            throw new Exception("Unable to detect file format!");
                        case SUAFileFormat.TNP:
                            fileHandler = new SUAFileHandlerTimNewport();
                            break;
                        case SUAFileFormat.OpenAir:
                            fileHandler = new SUAFileHandlerOpenAir();
                            break;
                        }

                        suas.Clear();
                        try {
                            using (StreamReader inStream = new StreamReader(file)) {
                                suas.AddRange(fileHandler.ReadFile(inStream, importOptions.UseMichaelMeier, importOptions.DefaultAirspace, importOptions.OverwriteClass, importOptions.DefaultType, importOptions.OverwriteType));
                            }
                            if (importOptions.OverwriteDB) {
                                SoaringDotNET.Database.AirspaceGenerator.WriteDatabase(importOptions.Country, suas, DateTime.Now, destPath);
                            }
                            else {
                                SoaringDotNET.Database.AirspaceGenerator.AppendDatabase(importOptions.Country, suas, DateTime.Now, destPath);
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.Show("Error occured while reading file\n\n" + file + "\n\n" +
                                ex.Message + "\n\n" + ex.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                }
                catch (Exception ex) {
                    MessageBox.Show(ex.Message, "File format exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally {
                    AppContents.ReloadAirspace();
                    recorder.ReloadAirspaces();
                    map.RedrawMap();
                }
            }
        }

        private void OnAirspaceEditor(object sender, System.EventArgs e) {
            AirspaceDialog d = new AirspaceDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                AppContents.SaveAirspace();
            }
            AppContents.ReloadAirspace();
            recorder.ReloadAirspaces();
            map.RedrawMap();
        }

        private void OnFileExit(object sender, System.EventArgs e) {
            this.Close();
        }

        private void OnNewWaypoint(object sender, System.EventArgs e) {
            AddWaypoint();
        }

        private void OnNewTask(object sender, System.EventArgs e) {
            NewTask();
        }

        private void OnViewWaypoint(object sender, System.EventArgs e) {
            bool isChecked = this.waypointsToolStripMenuItem.Checked;
            if (isChecked) {
                if (!tabControlDetails.Visible) {
                    tabControlDetails.Show();
                }
                waypoints.Show();
                tabControlDetails.TabPages.Add(wayPointsPage);
                tabControlDetails.SelectedTab = wayPointsPage;
            }
            else {
                waypoints.Hide();
                tabControlDetails.TabPages.Remove(wayPointsPage);
                if (tabControlDetails.TabCount < 1) {
                    tabControlDetails.Hide();
                }
            }
            //this.menuViewWaypoint.Checked = isChecked;
        }

        private void OnViewMap(object sender, System.EventArgs e) {
            bool isChecked = this.mapToolStripMenuItem.Checked;
            if (isChecked) {
                map.Show();
            }
            else {
                map.Hide();
            }
            //this.menuViewMap.Checked = isChecked;        
        }

        private void OnViewExplorer(object sender, System.EventArgs e) {
            bool isChecked = this.explorerToolStripMenuItem.Checked;
            if (isChecked) {
                explorer.Show();
            }
            else {
                explorer.Hide();
            }
            //this.menuViewExplorer.Checked = isChecked;        
        }

        private void OnViewTask(object sender, System.EventArgs e) {
            bool isChecked = this.tasksToolStripMenuItem.Checked;
            if (isChecked) {
                if (!tabControlDetails.Visible) {
                    tabControlDetails.Show();
                }
                tasks.Show();
                tabControlDetails.TabPages.Add(tasksPage);
                tabControlDetails.SelectedTab = tasksPage;
            }
            else {
                tasks.Hide();
                tabControlDetails.TabPages.Remove(tasksPage);
                if (tabControlDetails.TabCount < 1) {
                    tabControlDetails.Hide();
                }
            }
            //this.menuViewTasks.Checked = isChecked;                
        }

        private void OnViewPilot(object sender, System.EventArgs e) {
            bool isChecked = this.pilotsToolStripMenuItem.Checked;
            if (isChecked) {
                if (!tabControlDetails.Visible) {
                    tabControlDetails.Show();
                }
                pilots.Show();
                tabControlDetails.TabPages.Add(pilotsPage);
                tabControlDetails.SelectedTab = pilotsPage;
            }
            else {
                pilots.Hide();
                tabControlDetails.TabPages.Remove(pilotsPage);
                if (tabControlDetails.TabCount < 1) {
                    tabControlDetails.Hide();
                }
            }
            //this.menuViewPilots.Checked = isChecked;
        }

        private void OnGenerateAirspaceDB(object sender, System.EventArgs e) {
            GenAirspaceDBDialog d = new GenAirspaceDBDialog();
            d.ShowDialog(this);
            AppContents.ReloadAirspace();
            recorder.ReloadAirspaces();
            map.RedrawMap();
        }

        private void OnToolbarItemClicked(object sender, ToolStripItemClickedEventArgs e) {
            if (e.ClickedItem == toolStripButtonZoomOut) {
                if (map.Visible) {
                    map.OnZoomOut();
                }
                else if (diagramControl.Visible) {
                    diagramControl.Diagram.OnZoomOut();
                }
            }
            else if (e.ClickedItem == toolStripButtonZoomIn) {
                if (map.Visible) {
                    map.OnZoomIn();
                }
                else if (diagramControl.Visible) {
                    diagramControl.Diagram.OnZoomIn();
                }
            }
            else if (e.ClickedItem == toolStripButtonCenterHome) {
                if (map.Visible) {
                    map.OnCenterHome();
                }
            }
            else if (e.ClickedItem == toolStripButtonCenterTask) {
                if (map.Visible) {
                    map.OnCenterTask();
                }
            }
            else if (e.ClickedItem == toolStripButtonCenterFlight) {
                if (map.Visible) {
                    map.OnCenterFlight();
                }
            }
            else if (e.ClickedItem == toolStripButtonOpenFile) {
                OpenFile(FileTypeId.All);
            }
            else if (e.ClickedItem == toolStripButtonSaveFile) {
                explorer.Save();
            }
            else if (e.ClickedItem == toolStripButtonPrint) {
                if (currentCatalog != null) {
                    currentCatalog.Print();
                }
            }
            else if (e.ClickedItem == toolStripButtonSetup) {
                OnSetup();
            }
            else if (e.ClickedItem == toolStripButtonOlc) {
                OnSendOLC();
            }
            else if (e.ClickedItem == toolStripButtonOptimize) {
                OptimizeFlight();
            }
        }

        private void OpenFile(FileTypeId preselection) {
            OpenFileDialog fd = new OpenFileDialog();
            fd.Filter = "All known types|*.igc;*.cup;*.dbt;*.dat|IGC files (*.igc)|*.igc|All known Catalogs|*.dbt;*.cup;*.dat|All known tasks|*.cup|All files (*.*)|*.*";
            fd.Multiselect = true;
            RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            switch (preselection) {
            case FileTypeId.All:
                fd.FilterIndex = 1;
                break;
            case FileTypeId.Flight:
                fd.FilterIndex = 2;
                fd.InitialDirectory = (string)currentUser.GetValue("DefaultFlightPath", "");
                break;
            case FileTypeId.Waypoint:
                fd.FilterIndex = 3;
                fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");
                break;
            case FileTypeId.Task:
                fd.FilterIndex = 4;
                fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");
                break;
            default:
                fd.FilterIndex = 5;
                break;
            }
            if (fd.ShowDialog(this) == DialogResult.OK) {
                foreach (string file in fd.FileNames) {
                    try {
                        FileInfo fi = new FileInfo(file);
                        switch (fi.Extension.ToLower()) {
                        case ".igc":
                            OpenFlight(file);
                            break;
                        case ".dat":
                        case ".dbt":
                        case ".cup":
                            OpenCatalog(file);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.Show("Error occured while reading file\n\n" + file + "\n\n" +
                            ex.Message + "\n\n" + ex.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }
                map.RedrawMap();
                diagramControl.Diagram.RedrawDiagram(diagramControl.Diagram.CreateGraphics());
            }
        }

        private void OnFileOpen(object sender, System.EventArgs e) {
            OpenFile(FileTypeId.All);
        }

        private void SaveConfig() {
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Window");
            currUser.SetValue("State", WindowState == FormWindowState.Maximized ? (int)FormWindowState.Maximized : (int)FormWindowState.Normal);
            if (WindowState == FormWindowState.Normal) {
                currUser.SetValue("Width", this.Width);
                currUser.SetValue("Height", this.Height);
            }

            currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Home");
            currUser.SetValue("Name", AppContents.homePoint.longName);
            currUser.SetValue("Latitude", AppContents.homePoint.Latitude);
            currUser.SetValue("Longitude", AppContents.homePoint.Longitude);

            currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Map");
            currUser.SetValue("TopLat", map.UpperLeft.Y);
            currUser.SetValue("LeftLon", map.UpperLeft.X);
            currUser.SetValue("BottomLat", map.LowerRight.Y);
            currUser.SetValue("RightLon", map.LowerRight.X);

            if (currentCatalog != null && currentCatalog.FileName != null) {
                currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet");
                currUser.SetValue("Waypoint Catalogue", currentCatalog.FileName);
            }
        }

        private void ReadConfig() {
            int lat, lon;
            string name = "";
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Window");
            WindowState = (FormWindowState)currUser.GetValue("State", FormWindowState.Normal);
            if (WindowState == FormWindowState.Normal) {
                this.Width = (int)currUser.GetValue("Width", 500);
                this.Height = (int)currUser.GetValue("Height", 500);
            }

            currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Home");

            name = (string)currUser.GetValue("Name", "LAUPHEIM");
            lat = (int)currUser.GetValue("Latitude", -((48 * 360000) + (13 * 6000) + (13 * 100)));
            lon = (int)currUser.GetValue("Longitude", (9 * 360000) + (54 * 6000) + (37 * 100));
            AppContents.homePoint = new WayPoint(lat, lon, name);

            currUser = Registry.CurrentUser.OpenSubKey("Software\\SoaringDotNet");
            name = (string)currUser.GetValue("Waypoint Catalogue", "");

            AppContents.splash.SetMessage("Reading Waypoints");
            if (name != "") {
                OpenCatalog(name);
            }

            AppContents.splash.StepProgess();
        }

        private void OnAbout(object sender, System.EventArgs e) {
            About d = new About();
            d.ShowDialog(this);
        }

        private void OnSendOLC() {
            if (currentFlight != null) {
                OLCDialog d = new OLCDialog(currentFlight);
                d.ShowDialog(this);
            }
            else {
                MessageBox.Show("No flight selected.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private void OnSetup() {
            SetupDialog sd = new SetupDialog();
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            sd.DefaultFlightPath = (string)currUser.GetValue("DefaultFlightPath", "");;
            sd.DefaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");
            sd.SUAPath = (string)currUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace");

            foreach (MapColor c in AppContents.allColors) {
                sd.AddColor(c);
            }

            sd.AddSector(AppContents.GetDefaultSector(TurnpointTypes.Start));
            sd.AddSector(AppContents.GetDefaultSector(TurnpointTypes.Turnpoint));
            sd.AddSector(AppContents.GetDefaultSector(TurnpointTypes.Finish));

            if (sd.ShowDialog(this) == DialogResult.OK) {
                currUser.SetValue("DefaultFlightPath", sd.DefaultFlightPath);
                currUser.SetValue("DefaultWaypointPath", sd.DefaultWaypointPath);
                if ((string)currUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace") != sd.SUAPath) {
                    currUser.SetValue("AirspacePath", sd.SUAPath);
                }
                currUser.Close();

                AppContents.SetDefaultSector(sd.GetSector(TurnpointTypes.Start));
                AppContents.SetDefaultSector(sd.GetSector(TurnpointTypes.Turnpoint));
                AppContents.SetDefaultSector(sd.GetSector(TurnpointTypes.Finish));

                AppContents.SaveColors();
                AppContents.SaveSectors();
                AppContents.ReloadAirspace();
                /*                if (currentTask != null) {
                                }
                                else if (currentFlight != null) {
                                }*/
                map.RedrawMap();
            }
            else {
                AppContents.ReadColours();
            }
        }

        private void UpdatePanel(int lat, int lon, int time, int elevation, double speed, double vario) {
            this.statusBarPanelLat.Text = lat != -1 ? WgsPoint.ToString(lat, true) : "";
            this.statusBarPanelLong.Text = lon != -1 ? WgsPoint.ToString(lon, false) : "";
            this.statusBarPanelElevation.Text = elevation != -1 ? string.Format("{0} m", elevation) : "";
            this.statusBarPanelSpeed.Text = speed != -1 ? string.Format(AppContents.ni, "{0:F0} km/h", speed) : "";
            this.statusBarPanelTime.Text = time != -1 ? SoaringDotNET.Data.Time.ToTimeString(time) : "";
            this.statusBarPanelVario.Text = vario != -1 ? string.Format(AppContents.ni, "{0:F1} m/s", vario) : "";
        }

        private void OpenCatalog(string fName) {
            if (File.Exists(fName)) {
                WaypointCatalog k = new WaypointCatalog();
                ArrayList tasks = new ArrayList();
                k.Load(fName, tasks);
                AppContents.waypointCatalogs.Add(k);
                explorer.Add(k);
                recorder.Add(k);
                AppContents.tasks.AddRange(tasks);
                foreach(Task t in tasks) {
                    explorer.Add(t);
                    recorder.Add(t);
                }
            }
        }

        private void OpenFlight(string fName) {
            if (File.Exists(fName)) {
                Flight f = new Flight(fName);
                AppContents.flights.Add(f);
                explorer.Add(f);
            }
        }

        private void OnLeaveMapPage(object sender, System.EventArgs e) {
            map.HideToolTip();
        }

        private void OnGenerateTerrainDB(object sender, System.EventArgs e) {
            GenTerrainDb4SoaringPilotDialog d = new GenTerrainDb4SoaringPilotDialog();
            d.ShowDialog(this);
        }

        private void OnOnlineManual(object sender, System.EventArgs e) {
            System.Diagnostics.Process.Start("http://www.soaringdotnet.org/dokuwiki/doku.php");
        }

        private void OnExportSUA(object sender, System.EventArgs e) {
            ExportSUAOptionsDialog d = new ExportSUAOptionsDialog();
            SUAFileHandlerBase fileHandler = null;
            StreamWriter outStream = null;
            
            SaveFileDialog fd = new SaveFileDialog();

            fd.Filter = "SUA files(*.sua;*.air;*.dat;*.txt)|*.sua;*.air;*.dat;*.txt|All files (*.*)|*.*";
            RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");

            if (d.ShowDialog(this) == DialogResult.OK) {
                switch (d.FileFormat) {
                case SUAFileFormat.OpenAir:
                    fileHandler = new SUAFileHandlerOpenAir();
                    break;
                case SUAFileFormat.TNP:
                    fileHandler = new SUAFileHandlerTimNewport();
                    break;
                default:
                    return;
                }

                if (fd.ShowDialog() == DialogResult.OK) {
                    try {
                        outStream = new StreamWriter(fd.FileName, false);
                        fileHandler.WriteFile(d.SelectedSUAs, outStream);
                    }
                    catch (Exception ex) {
                        MessageBox.Show(ex.ToString(), "Write Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    finally {
                        if (outStream != null) {
                            outStream.Close();
                        }
                    }
                }
            }
        }

        #endregion

        #region Public Functions
        public void Init(ArrayList igcFiles) {
            AppContents.splash.SetMessage("Reading Config");
            ReadConfig();
            AppContents.splash.StepProgess();

            AppContents.splash.SetMessage("Show Pilots");
            pilots.ShowPilots();
            foreach(Pilot p in AppContents.pilots) {
                recorder.Add(p);
            }
            AppContents.splash.StepProgess();
            
            map.CenterTo(AppContents.homePoint);

            AddWaypointCatalogueDelegate = new AddGUIObjectDelegate(AddWaypointCatalogue);
            AddTasksDelegate = new AddGUIObjectDelegate(AddTasks);
            AddFlightDelegate = new AddGUIObjectDelegate(AddFlights);
            AddPilotsDelegate = new AddGUIObjectDelegate(AddPilots);

            AppContents.splash.SetMessage("Reading Flight(s)");
            foreach (string igcFile in igcFiles) {
                OpenFlight(igcFile);
            }
            AppContents.splash.StepProgess();
            AppContents.splash.Close();
        }

        public void UpdatePosInfo() {
            UpdatePanel(-1, -1, -1, -1, -1, -1);
        }

        public void UpdatePosInfo(int lat, int lon) {
            UpdatePanel(lat, lon, -1, -1, -1, -1);
        }

        public void UpdatePosInfo(int lat, int lon, int time, int elevation, double speed, double vario) {
            UpdatePanel(lat, lon, time, elevation, speed, vario);
        }

        public void OpenFlight() {
            OpenFile(FileTypeId.Flight);
        }

        public void OptimizeFlight() {
            if (currentFlight != null) {
                OptimizationDialog d = new OptimizationDialog(currentFlight);
                if (d.ShowDialog(this) == DialogResult.OK && d.OptimizedTask != null) {
                    currentFlight.currentTask = d.OptimizedTask;
                    currentFlight.CalcFlightArea();
                    map.RedrawMap();
                    diagramPage.Refresh();
                    explorer.Update(currentFlight);
                }
            }
        }

        public void Close(Flight f) {
            AppContents.flights.Remove(f);
            if (f.calcDistanceThread.IsAlive) {
                f.calcDistanceThread.Abort();
            }
            f.calcDistanceThread = null;
            f.lengthMatrix = null;
            f.minElevationSinceStartOfTask = null;
        }

        public void Close(Task t) {
            AppContents.tasks.Remove(t);
            recorder.Remove(t);
        }

        public void Close(WaypointCatalog c) {
            AppContents.waypointCatalogs.Remove(c);
            recorder.Remove(c);
        }

        public void NewCatalog() {
            WaypointCatalog c = AppContents.NewCatalog();
            explorer.Add(c);
            recorder.Add(c);
        }

        public void NewTask() {
            Task t = new Task(string.Format("Task{0}", AppContents.tasks.Count + 1));
            AppContents.tasks.Add(t);
            explorer.Add(t);
            recorder.Add(t);
            tasks.Switch(t);
            tabControlDetails.SelectedTab = tasksPage;
        }

        public void AddWaypoint(int lat, int lon) {
            WaypointDialog d = new WaypointDialog();

            d.latEdit.Value = lat;
            d.lonEdit.Value = lon;

            if (d.ShowDialog() == DialogResult.OK) {
                WayPoint wp = new WayPoint(d.latEdit.Value, d.lonEdit.Value, d.name.Text);
                wp.Elevation = d.elevationEdit.Text != "" ? int.Parse(d.elevationEdit.Text) : -1;
                if (d.typeCombo.SelectedItem != null) {
                    wp.type = (WayPointTypeId)((IdType)d.typeCombo.SelectedItem).id;
                }
                wp.description = d.descriptionEdit.Text;
                wp.icao = d.icaoEdit.Text;
                wp.landable = d.landabeCheck.Checked;
                wp.runway = d.runwayEdit.Text;
                wp.frequency = d.frequencyEdit.Text;
                if (d.lenghtEdit.Text != "") {
                    wp.length = int.Parse(d.lenghtEdit.Text);
                }
                if (d.surfaceCombo.SelectedItem != null) {
                    wp.surface = (SurfaceTypeId)((IdType)d.surfaceCombo.SelectedItem).id;
                }
                wp.comment = d.commentEdit.Text;

                if (d.countryCombo.SelectedItem != null) {
                    wp.country = (CountryTypeId)((IdType)d.countryCombo.SelectedItem).id;
                }

                waypoints.Add(wp);
                map.RedrawMap();
                explorer.Update(currentCatalog);
                tasks.Add(wp);
                recorder.Update(currentCatalog);
            }
        }

        public void AddWaypoint() {
            WaypointDialog d = new WaypointDialog();
            if (d.ShowDialog() == DialogResult.OK) {
                WayPoint wp = new WayPoint(d.latEdit.Value, d.lonEdit.Value, d.name.Text);
                wp.Elevation = d.elevationEdit.Text != "" ? int.Parse(d.elevationEdit.Text) : -1;
                if (d.typeCombo.SelectedItem != null) {
                    wp.type = (WayPointTypeId)((IdType)d.typeCombo.SelectedItem).id;
                }
                wp.description = d.descriptionEdit.Text;
                wp.icao = d.icaoEdit.Text;
                wp.landable = d.landabeCheck.Checked;
                wp.runway = d.runwayEdit.Text;
                wp.frequency = d.frequencyEdit.Text;
                if (d.lenghtEdit.Text != "") {
                    wp.length = int.Parse(d.lenghtEdit.Text);
                }
                if (d.surfaceCombo.SelectedItem != null) {
                    wp.surface = (SurfaceTypeId)((IdType)d.surfaceCombo.SelectedItem).id;
                }
                wp.comment = d.commentEdit.Text;

                if (d.countryCombo.SelectedItem != null) {
                    wp.country = (CountryTypeId)((IdType)d.countryCombo.SelectedItem).id;
                }

                waypoints.Add(wp);
                map.RedrawMap();
                explorer.Update(currentCatalog);
                recorder.Update(currentCatalog);
            }
        }

        public void EditWaypoint(WayPoint old) {
            WaypointDialog d = new WaypointDialog();
            d.name.Text = old.longName;
            d.shortName.Text = old.shortName;
            d.latEdit.Value = old.Latitude;
            d.lonEdit.Value = old.Longitude;
            if (old.Elevation != -1) {
                d.elevationEdit.Text = old.Elevation.ToString();
            }
            d.typeCombo.SelectedItem = AppContents.waypointTypes.getIdType((int)old.type);
            d.descriptionEdit.Text = old.description;
            d.icaoEdit.Text = old.icao;
            d.landabeCheck.Checked = old.landable;
            d.runwayEdit.Text = old.runway;
            d.frequencyEdit.Text = old.frequency;
            if (old.length != -1) {
                d.lenghtEdit.Text = old.length.ToString();
            }
            d.surfaceCombo.SelectedItem = AppContents.surfaceTypes.getIdType((int)old.surface);
            old.comment = d.commentEdit.Text;
            d.countryCombo.SelectedItem = AppContents.countryTypes.getIdType((int)old.country);

            d.checkBoxHomePoint.Checked = (AppContents.homePoint.Latitude == old.Latitude &&
                AppContents.homePoint.Longitude == old.Longitude &&
                AppContents.homePoint.longName == old.longName);

            if (d.ShowDialog() == DialogResult.OK) {
                WayPoint wp = new WayPoint(d.latEdit.Value, d.lonEdit.Value, d.name.Text);
                wp.Elevation = d.elevationEdit.Text != "" ? int.Parse(d.elevationEdit.Text) : -1;
                if (d.typeCombo.SelectedItem != null) {
                    wp.type = (WayPointTypeId)((IdType)d.typeCombo.SelectedItem).id;
                }
                wp.description = d.descriptionEdit.Text;
                wp.icao = d.icaoEdit.Text;
                wp.landable = d.landabeCheck.Checked;
                wp.runway = d.runwayEdit.Text;
                wp.frequency = d.frequencyEdit.Text;
                if (d.lenghtEdit.Text != "") {
                    wp.length = int.Parse(d.lenghtEdit.Text);
                }
                if (d.surfaceCombo.SelectedItem != null) {
                    wp.surface = (SurfaceTypeId)((IdType)d.surfaceCombo.SelectedItem).id;
                }
                wp.comment = d.commentEdit.Text;

                if (d.countryCombo.SelectedItem != null) {
                    wp.country = (CountryTypeId)((IdType)d.countryCombo.SelectedItem).id;
                }

                if (d.checkBoxHomePoint.Checked) {
                    SetHomePoint(wp);
                }

                waypoints.Update(old, wp);
                map.RedrawMap();
                explorer.Update(currentCatalog);
                // make sure all tasks show correct names
                UpdateAllTasks(old, wp);
                tasks.Switch(currentCatalog);
                recorder.Update(currentCatalog);
            }
        }

        public void Delete(WayPoint wp) {
            currentCatalog.Remove(wp);
            waypoints.Remove(wp);
            map.RedrawMap();
            explorer.Update(currentCatalog);
            tasks.Remove(wp);
            recorder.Update(currentCatalog);
        }

        public void Delete(ArrayList wpList) {
            foreach (WayPoint wp in wpList) {
                currentCatalog.Remove(wp);
            }
            waypoints.Refill();
            map.RedrawMap();
            explorer.Update(currentCatalog);
            tasks.Switch(currentCatalog);
            recorder.Update(currentCatalog);
        }

        public void CenterMapTo(WayPoint wp) {
            map.CenterTo(wp);
        }

        public void SetHomePoint(WayPoint wp) {
            AppContents.homePoint = wp;
        }

        public void OpenCatalog() {
            OpenFile(FileTypeId.Waypoint);
        }

        public void MergeCatalog() {
            if (currentCatalog != null) {
                OpenFileDialog fd = new OpenFileDialog();
                fd.Filter = "All known Catalogs|*.dbt;*.cup;*.dat|All files (*.*)|*.*";
                fd.Multiselect = true;
                fd.FilterIndex = 1;

                if (fd.ShowDialog(this) == DialogResult.OK) {
                    foreach (string file in fd.FileNames) {
                        try {
                            FileInfo fi = new FileInfo(file);
                            switch (fi.Extension.ToLower()) {
                            case ".dat":
                            case ".dbt":
                            case ".cup":
                                currentCatalog.Merge(file);
                                break;
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.Show("Error occured while reading file\n\n" + file + "\n\n" +
                                ex.Message + "\n\n" + ex.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                    map.RedrawMap();
                    explorer.Update(currentCatalog);
                    waypoints.Refill();
                    recorder.Update(currentCatalog);
                }
            }
        }

        public void OpenTasks() {
            OpenFile(FileTypeId.Task);
        }

        public void SaveTasks() {
            SaveFileDialog fd = new SaveFileDialog();
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");

            fd.CheckPathExists = true;
            fd.OverwritePrompt = true;
            fd.ValidateNames = true;
            fd.Filter = "All known Tasks|*.cup|SeeYou (*.cup)|*.cup";
            fd.InitialDirectory = (string)currUser.GetValue("DefaultWaypointPath", "");
            if (fd.ShowDialog() == DialogResult.OK) {
                FileInfo info = new FileInfo(fd.FileName);
                using (StreamWriter outStream = new StreamWriter(fd.FileName)) {
                    switch (info.Extension.ToLower()) {
                    case ".cup":
                        SeeYouFileHandler h = new SeeYouFileHandler();
                        switch (MessageBox.Show("Save with current catalogue.", "SeeYou cup file", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1)) {
                        case DialogResult.Yes:
                            h.Save(outStream, currentCatalog, AppContents.tasks);
                            break;
                        case DialogResult.No:
                            h.Save(outStream, AppContents.tasks);
                            break;
                        }
                        break;
                    default:
                        MessageBox.Show("Not a valid task filetype '" + info.Extension.ToLower() + "'", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        break;
                    }
                }
            }
        }

        public void Switch(WaypointCatalog c) {
            currentCatalog = c;
            waypoints.SwitchToCatalog(c);
            map.Switch(c);
            tasks.Switch(c);
        }

        public void Update(WaypointCatalog c) {
            explorer.Update(c);
            if (c == currentCatalog) {
                map.Update(c);
                waypoints.Update(c);
                tasks.Update(c);
            }
            recorder.Update(c);
        }

        public void Switch(Flight f) {
            currentFlight = f;
            currentTask = null;
            map.Switch(currentFlight);
            diagramControl.Diagram.Switch(currentFlight);
            tasks.Switch(currentTask);
        }

        public void Switch(Task t) {
            currentTask = t;
            currentFlight = null;
            map.Switch(t);
            diagramControl.Diagram.Switch(currentFlight);
            tasks.Switch(currentTask);
        }

        public void Update(Task t) {
            explorer.Update(t);
            recorder.Update(t);
            tasks.Update(t);
            map.RedrawMap();
        }

       public void CopyWaypoint(WayPoint wp, WaypointCatalog to) {
            to.Add(wp);
            explorer.Update(to);
            if (to == currentCatalog) {
                waypoints.Add(wp);
                map.RedrawMap();
            }
            recorder.Update(to);
        }

        public void MoveWaypoint(WayPoint wp, WaypointCatalog from, WaypointCatalog to) {
            to.Add(wp);
            explorer.Update(to);
            
            from.Remove(wp);
            explorer.Update(from);
            
            if (to == currentCatalog) {
                waypoints.Add(wp);
            }
            else if (from == currentCatalog) {
                waypoints.Remove(wp);
            }

            map.RedrawMap();
            recorder.Update(from);
            recorder.Update(to);
            tasks.Update(from);
            tasks.Update(to);
        }

        public void UpdateAllTasks(WayPoint oldWp, WayPoint newWp) {
            int i;
            bool update;
            SectorDefinition sector;

            foreach (Task t in AppContents.tasks) {
                update = false;
                for (i = 0; i < t.Count; i++) {
                    if (t[i] == oldWp) {
                        sector = t.GetSector(i);
                        t[i] = newWp;
                        t.SetSector(i, sector);
                        update = true;
                    }
                }
                if (update) {
                    Update(t);
                }
            }
        }

        public void AddPilot() {
            PilotDialog pd = new PilotDialog();
            if (pd.ShowDialog(this) == DialogResult.OK) {
                Pilot p = new Pilot();
                p.LastName = pd.lastName.Text;
                p.FirstName = pd.firstName.Text;
                p.BirthDay = pd.birthDay.Value;
                p.Street = pd.street.Text;
                p.Address = pd.address.Text;
                p.Phone = pd.phone.Text;
                p.Email = pd.email.Text;

                AppContents.pilots.Add(p);
                pilots.Add(p);
                recorder.Add(p);
            }
        }

        public void EditPilot(Pilot p) {
            PilotDialog pd = new PilotDialog();

            pd.lastName.Text = p.LastName;
            pd.firstName.Text = p.FirstName;
            pd.birthDay.Value = p.BirthDay;
            pd.street.Text = p.Street;
            pd.address.Text = p.Address;
            pd.phone.Text = p.Phone;
            pd.email.Text = p.Email;

            if (pd.ShowDialog(this) == DialogResult.OK) {
                p.LastName = pd.lastName.Text;
                p.FirstName = pd.firstName.Text;
                p.BirthDay = pd.birthDay.Value;
                p.Street = pd.street.Text;
                p.Address = pd.address.Text;
                p.Phone = pd.phone.Text;
                p.Email = pd.email.Text;

                pilots.Update(p);
                recorder.Update(p);
            }        
        }

        public void Delete(Pilot p) {
            AppContents.pilots.Remove(p);
            pilots.Remove(p);
            recorder.Remove(p);
        }

        public void AddPilots(object o) {
            bool found;
            foreach (Pilot p in (ArrayList)o) {
                found = false;
                foreach (Pilot p2 in AppContents.pilots) {
                    if (p2.ToString().ToUpper() == p.ToString().ToUpper()) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    AppContents.pilots.Add(p);
                    pilots.Add(p);
                    recorder.Add(p);
                }
            }
        }

        public void AddWaypointCatalogue(object o) {
            WaypointCatalog c = (WaypointCatalog)o;
            AppContents.waypointCatalogs.Add(c);
            explorer.Add(c);
            recorder.Add(c);
        }

        public void AddTasks(object o) {            
            foreach (Task t in (ArrayList)o) {
                t.Name = string.Format("Task{0}", AppContents.tasks.Count + 1);
                AppContents.tasks.Add(t);
                explorer.Add(t);
                recorder.Add(t);
            }
        }

        public void AddFlights(object o) {
            foreach (string s in (ArrayList)o) {
                Flight f = new Flight(s);
                AppContents.flights.Add(f);
                explorer.Add(f);
                //AppContents.flights.Add(f);
            }
        }

        public void InitMapArea(int topLat, int leftLon, int bottomLat, int rightLon) {
            // used to set up initial map size; call once before initial show
            map.SetArea(topLat, leftLon, bottomLat, rightLon);
        }

        #endregion

        #region Attributes
        public ArrayList Pilots {
            get {
                return AppContents.pilots;
            }
        }

        public WgsPoint MapCenter {
            get {
                return map.Center;
            }
        }

        public Point MapUpperLeft {
            get {
                return map.UpperLeft;
            }
        }

        public Point MapLowerRight {
            get {
                return map.LowerRight;
            }
        }
        #endregion
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]

        static void Main(string []args) {
            try {
                Control.CheckForIllegalCrossThreadCalls = false;

                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);

                ArrayList igcFiles = new ArrayList();
                igcFiles.AddRange(args);
                AppContents cont = new AppContents();
                AppContents.application = new SoaringDotNet();
                AppContents.application.Init(igcFiles);

                RegistryKey currUser = Registry.CurrentUser.OpenSubKey("Software\\SoaringDotNet\\Map");
                // set default to south germany
                AppContents.application.InitMapArea((int)currUser.GetValue("TopLat", -49*360000),
                    (int)currUser.GetValue("LeftLon", 8*360000),
                    (int)currUser.GetValue("BottomLat", -47*360000), 
                    (int)currUser.GetValue("RightLon", 10*360000));

                Application.Run(AppContents.application);

                AppContents.SavePilots();
            }
            catch (Exception e) {
                MessageBox.Show(e.StackTrace, "System Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
    }
}
