// name   : TriangleOptimizationBase.cs
// author : Harald Maier
// date   : 09.01.2006
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization {
    /// <summary>
    /// 
    /// </summary>
    public abstract class TriangleOptimizationBase : SoaringDotNET.Optimization.OptimizationBase {
        public TriangleOptimizationBase(Flight flight) : 
            base(flight) {
            // 
            // TODO: Add constructor logic here
            //
        }

        public override string ToString() {
            // TODO:  Add TriangleOptimizationBase.ToString implementation
            return base.ToString ();
        }

        /* Optimize for lagest triangle */
        protected virtual void OptimizeTriangle(int [] triangleStart, int [] triangleStop, int step, int soaringStart, int soaringStop, ArrayList triangles, bool firstRun) {
            int loopA, loopB, loopC, i, maxAB;
            float [][] lengthMatrix = flight.lengthMatrix;
            float [] lengthVector;
            float length, s1, s2, s3;
            int startOfTask, stopOfTask;
            FAITriangle tmpTriangle;

            startOfTask = soaringStop;
            stopOfTask = soaringStart;

            for (loopA = triangleStart[0]; loopA <= triangleStop[0]; loopA += step) {
                if (firstRun) {
                    triangleStart[1] = loopA + step - 1;
                }
                
                for (loopB = triangleStart[1]; loopB <= triangleStop[1]; loopB += step) {
                    maxAB = Math.Max(loopA, loopB);
                    s1 = lengthMatrix[maxAB][Math.Min(loopA, loopB)];//p1.distanceKM(p2);
                    if (firstRun) {
                        triangleStart[2] = loopB + step - 1;
                    }
                    
                    for (loopC = triangleStart[2]; loopC <= triangleStop[2]; loopC += step) {
                        lengthVector = lengthMatrix[Math.Max(maxAB, loopC)];
                        s2 = lengthVector[loopB];//p2.distanceKM(p3);
                        s3 = lengthVector[loopA];//p3.distanceKM(p1);
                        length = s1 + s2 + s3;
                        if (isValid(loopA, loopC, soaringStart, soaringStop, ref startOfTask, ref stopOfTask)) {
                            for (i = triangles.Count - 1; i >= 0; i--) {
                                tmpTriangle = (FAITriangle)triangles[i];
                                if (length > tmpTriangle.length) {
                                    if (i == triangles.Count - 1) {
                                        // insert least one
                                        tmpTriangle.length = length;
                                        tmpTriangle.p1 = loopA;
                                        tmpTriangle.p2 = loopB;
                                        tmpTriangle.p3 = loopC;
                                        tmpTriangle.idx1 = startOfTask;
                                        tmpTriangle.idx2 = stopOfTask;
                                    }
                                    else {
                                        //swap
                                        triangles[i] = triangles[i + 1];
                                        triangles[i + 1] = tmpTriangle;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
	
        protected virtual bool isValid(int loopA, int loopC, int soaringStart, int soaringStop, ref int startOfTask, ref int stopOfTask) {
            startOfTask = soaringStart;
            stopOfTask = soaringStop;
            return true;
        }

        protected virtual void OptimizeFAITriangle(int [] triangleStart, int [] triangleStop, int step, int soaringStart, int soaringStop, ArrayList triangles, bool firstRun) {
            int loopA, loopB, loopC, i, maxAB;
            float [][] lengthMatrix = flight.lengthMatrix;
            float [] lengthVector;
            float length, s1, s2, s3;
            FAITriangle tmpTriangle;
            int startOfTask, stopOfTask;

            startOfTask = soaringStop;
            stopOfTask = soaringStart;

            for (loopA = triangleStart[0]; loopA <= triangleStop[0]; loopA += step) {
                if (firstRun) {
                    triangleStart[1] = loopA + step - 1;
                }

                for (loopB = triangleStart[1]; loopB <= triangleStop[1]; loopB += step) {
                    if (firstRun) {
                        triangleStart[2] = loopB + step - 1;
                    }

                    maxAB = Math.Max(loopA, loopB);
                    s1 = lengthMatrix[maxAB][Math.Min(loopA, loopB)];//p1.distanceKM(p2);                  
                    for (loopC = triangleStart[2]; loopC <= triangleStop[2]; loopC += step) {
                        lengthVector = lengthMatrix[Math.Max(maxAB, loopC)];
                        s2 = lengthVector[loopB];//p2.distanceKM(p3);
                        s3 = lengthVector[loopA];//p3.distanceKM(p1);
                        length = s1 + s2 + s3;
                        if (Task.isFAI(length, s1, s2, s3) && isValid(loopA, loopC, soaringStart, soaringStop, ref startOfTask, ref stopOfTask)) {
                            for (i = triangles.Count - 1; i >= 0; i--) {
                                tmpTriangle = (FAITriangle)triangles[i];
                                if (length > tmpTriangle.length) {
                                    if (i == triangles.Count - 1) {
                                        // insert least one
                                        tmpTriangle.length = length;
                                        tmpTriangle.p1 = loopA;
                                        tmpTriangle.p2 = loopB;
                                        tmpTriangle.p3 = loopC;
                                        tmpTriangle.idx1 = startOfTask;
                                        tmpTriangle.idx2 = stopOfTask;
                                    }
                                    else {
                                        //swap
                                        triangles[i] = triangles[i + 1];
                                        triangles[i + 1] = tmpTriangle;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        protected int CalcStepSize(int start, int stop) {
            int step = 1;
            int N;
            uint curNumSteps, minNumSteps;
            uint j, k, temp;

            N = stop - start + 1;
            minNumSteps = uint.MaxValue;

            // calc step size of each section
            for (k = 1; k < 100; k++) {
                // ( N / k ) is the number of points used for the
                // first optimization-run. If this number is smaller than 3, we
                // cannot create a triangle.
                        
                if (N / k < 3) {
                    break;
                }
                curNumSteps = 1;
                temp = 1;

                /*
                    * Calculating the step-width for the first run.
                    */
                for (j = 3; j < N / k; j++) {
                    temp += j;
                    curNumSteps += temp;
                }
                temp = 1;

                /*
                    * Calculating the number of steps for the second run.
                    */
                for (j = 3; j < (k - 1) * 6; j++) {
                    temp += j;
                    curNumSteps += temp + j;
                }

                if (curNumSteps < minNumSteps) {
                    minNumSteps = curNumSteps;
                    step = (int)k;
                }
            }
            return step;
        }
    }
}
