// name   : VolksloggerFileHandler.cs
// author : Harald Maier
// date   : 17.10.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.IO;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;

namespace SoaringDotNET.FileFormats
{
	/// <summary>
	/// 
	/// </summary>

	public class VolksloggerFileHandler : SoaringDotNET.FileFormats.FileHandlerBase
	{
        
        public VolksloggerFileHandler()
		{
			// 
			// TODO: Add constructor logic here
			//
		}
        public override void Load(StreamReader f, WaypointCatalog catalogue) {
            // TODO:  Add SeeYouFileHandler.Load implementation
            string line;
            string [] tokens;
            WayPoint wp;
            int lat, lon, tmp;
            bool isNeg;

            while ((line = f.ReadLine()) != null) {
                try {
                    line.Trim();
                    if (line[0] == '*') {
                        continue;
                    }
                    else {
                        tokens = line.Split(',');
                        if (tokens.Length == 5) {
                            tmp = int.Parse(tokens[2]);
                            if (isNeg = tmp < 0) {
                                tmp = Math.Abs(tmp);
                            }
                            lat = (tmp / 100000) * 360000;
                            lat += (tmp % 100000) * 6;
                            if (!isNeg) {
                                lat = -lat;
                            }

                            tmp = int.Parse(tokens[3]);
                            if (isNeg = tmp < 0) {
                                tmp = Math.Abs(tmp);
                            }
                            lon = (tmp / 100000) * 360000;
                            lon += (tmp % 100000) * 6;
                            if (isNeg) {
                                lon = -lon;
                            }

                            wp = new WayPoint(lat, lon, tokens[1].Trim());
                            if (tokens[4].Length == 2) {
                                tmp = int.Parse(tokens[4].Substring(1));
                                if ((tmp & (int)SoaringDotNET.Recorders.Volkslogger.VolksloggerFlags.Airport) > 0) {
                                    wp.type = WayPointTypeId.Airport;
                                }
                                wp.landable = ((tmp & (int)SoaringDotNET.Recorders.Volkslogger.VolksloggerFlags.Landable) > 0);
                                if (wp.landable) {
                                    if ((tmp & (int)SoaringDotNET.Recorders.Volkslogger.VolksloggerFlags.HardSurface) > 0) {
                                        wp.surface = SurfaceTypeId.Hard;
                                    }
                                    else {
                                        wp.surface = SurfaceTypeId.Grass;
                                    }
                                }
                            }
                            catalogue.Add(wp);
                        }
                    }
                }
                catch (Exception e) {
                    if (MessageBox.Show("An exception occured while reading file (Volkslogger)\n\nThe fault line is:\n\n" +
                        line + "\n\n" + e.StackTrace + "\n\n" + e.Message, "Error", MessageBoxButtons.OKCancel, MessageBoxIcon.Error) == DialogResult.Cancel) {
                        break;
                    }
                }
            }
        }
    
        public override void Load(StreamReader f, WaypointCatalog catalogue, ArrayList tasks) {
            // TODO:  Add CAIAndWinPilotFileHandler.Load implementation
            this.Load(f, catalogue);
        }
        public override void Save(StreamWriter f, WaypointCatalog catalogue) {
            // TODO:  Add SeeYouFileHandler.Save implementation
            int i = 1;
            long tLat, tLon, tmp;
            string line;
            bool isNeg;

            foreach (WayPoint wp in catalogue) {
                isNeg = wp.Latitude < 0;
                tmp = Math.Abs(wp.Latitude);
                tLat = tmp / 360000 * 100000;
                tLat += (tmp % 360000) / 6;
                if (!isNeg) {
                    tLat = -tLat;
                }

                isNeg = wp.Longitude < 0;
                tmp = Math.Abs(wp.Longitude);
                tLon = tmp / 360000 * 100000;
                tLon += (tmp % 360000) / 6;
                if (isNeg) {
                    tLon = -tLon;
                }

                tmp = 0;
                if (wp.landable) {
                    tmp |= (int)SoaringDotNET.Recorders.Volkslogger.VolksloggerFlags.Landable;
                    if (wp.surface == SurfaceTypeId.Hard) {
                        tmp |= (int)SoaringDotNET.Recorders.Volkslogger.VolksloggerFlags.HardSurface;
                    }
                }

                if (wp.type == WayPointTypeId.Airport) {
                    tmp |= (int)SoaringDotNET.Recorders.Volkslogger.VolksloggerFlags.Airport;
                }
                line = string.Format("{0:000},{1:},{2:0000000},{3:00000000},X{4}", i++, wp.shortName.PadRight(6), tLat, tLon, tmp);
                f.WriteLine(line);
            }
        }    
        public override void Save(StreamWriter f, WaypointCatalog catalogue, ArrayList tasks) {
            // TODO:  Add CAIAndWinPilotFileHandler.Save implementation
            this.Save(f, catalogue);
        }
    }
}
