// name   : WayPointFilter.cs
// author : Harald Maier
// date   : 24.11.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;

namespace SoaringDotNET.Data
{
    public enum ReferenceType {Unkonwn = -1, Position, HomePoint, CenterMap, WayPoint};
	/// <summary>
	/// 
	/// </summary>
	public class WayPointFilter
	{
        public WgsArea area;
        public WayPoint center;
        public double radius;
        public Hashtable waypointTypes;
        public ReferenceType reference;
        public Hashtable countries;
        public bool useMapCoord;

		public WayPointFilter()
		{
			// 
			// TODO: Add constructor logic here
			//
            area = new WgsArea();
            center = new WayPoint();
            radius = 0;
            reference = ReferenceType.Unkonwn;
            useMapCoord = false;

            countries = new Hashtable();
            waypointTypes = new Hashtable();
		}

        public WayPointFilter(WayPointFilter f)
            : this() {
            area.LeftLon = f.area.LeftLon;
            area.TopLat = f.area.TopLat;
            area.BottomLat = f.area.BottomLat;
            area.RightLon = f.area.RightLon;

            center = f.center;
            radius = f.radius;
            reference = f.reference;
            useMapCoord = f.useMapCoord;
            waypointTypes = (Hashtable)f.waypointTypes.Clone();
            countries =  (Hashtable)f.countries.Clone();
        }

        public bool IsVisible(WayPoint p) {
            bool useKey, useCoutry;
            bool yes = true;
            useKey = waypointTypes.Count > 0;
            useCoutry = countries.Count > 0;

            if (useKey) {
                yes = waypointTypes.ContainsKey(p.type);
            }

            if (useCoutry && yes) {
                yes = countries.ContainsKey(p.country);
            }

            if (yes) {
                if (radius > 0.0) {
                    yes = (center.distanceKM(p) <= radius);
                }
                else if (!area.IsEmpty) {
                    yes = area.PointInArea(p);
                }
            }
            return yes;
        }

        public void Clear() {
            area.Clear();
            center = new WayPoint();
            waypointTypes.Clear();
            countries.Clear();
            reference = ReferenceType.Unkonwn;
            radius = 0;
            useMapCoord = false;
        }

        public bool IsSet {
            get {
                return (!area.IsEmpty || radius > 0.0 || waypointTypes.Count > 0 || countries.Count > 0);
            }
        }
	}
}
