// name   : Waypoints.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;
using SoaringDotNET.Dialogs;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for Waypoint.
	/// </summary>
    public class Waypoints : System.Windows.Forms.UserControl {
        private System.Windows.Forms.ListView listWaypoints;
        private System.Windows.Forms.ColumnHeader colLat;
        private System.Windows.Forms.ColumnHeader colLong;
        private System.Windows.Forms.ColumnHeader colElev;
        private System.Windows.Forms.ColumnHeader colFreq;
        private System.Windows.Forms.ColumnHeader colIcao;
        private System.Windows.Forms.ColumnHeader colDescription;
        private System.Windows.Forms.ColumnHeader colLandable;
        private System.Windows.Forms.ColumnHeader colRunway;
        private System.Windows.Forms.ColumnHeader colLength;
        private System.Windows.Forms.ColumnHeader colSurface;
        private System.Windows.Forms.ColumnHeader colComment;
        private System.Windows.Forms.ColumnHeader colCountry;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.ImageList smallImageList;
        private System.Windows.Forms.ColumnHeader colLongName;
        private System.Windows.Forms.ColumnHeader colShortName;
        private System.Windows.Forms.Panel panelFilter;
        private System.Windows.Forms.Button buttonFilter;
        private System.Windows.Forms.ImageList imageListFilter;
        private System.Windows.Forms.ImageList largeImageList;
        private System.Windows.Forms.TextBox textBoxVisibleItems;
        private ContextMenuStrip popupMenu;
        private ToolStripMenuItem newWaypointToolStripMenuItem;
        private ToolStripMenuItem editWaypointToolStripMenuItem;
        private ToolStripMenuItem deleteWaypointToolStripMenuItem;
        private ToolStripMenuItem copyToToolStripMenuItem;
        private ToolStripMenuItem toolStripMenuItem2;
        private ToolStripMenuItem moveToToolStripMenuItem;
        private ToolStripMenuItem toolStripMenuItem3;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripMenuItem centerMapToolStripMenuItem;
        private ToolStripMenuItem setTohomepointToolStripMenuItem;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripMenuItem largeViewToolStripMenuItem;
        private ToolStripMenuItem smallViewToolStripMenuItem;
        private ToolStripMenuItem listViewToolStripMenuItem;
        private ToolStripMenuItem detailViewToolStripMenuItem;

        private WaypointCatalog currentCatalog;

        public Waypoints() {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
            currentCatalog = null;
            detailViewToolStripMenuItem.Checked = true;

            listWaypoints.ListViewItemSorter = new ListViewItemSorter();
        }

        #region Protected Functions
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #endregion

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Waypoints));
            this.listWaypoints = new System.Windows.Forms.ListView();
            this.colLongName = new System.Windows.Forms.ColumnHeader();
            this.colShortName = new System.Windows.Forms.ColumnHeader();
            this.colLat = new System.Windows.Forms.ColumnHeader();
            this.colLong = new System.Windows.Forms.ColumnHeader();
            this.colElev = new System.Windows.Forms.ColumnHeader();
            this.colDescription = new System.Windows.Forms.ColumnHeader();
            this.colIcao = new System.Windows.Forms.ColumnHeader();
            this.colFreq = new System.Windows.Forms.ColumnHeader();
            this.colLandable = new System.Windows.Forms.ColumnHeader();
            this.colRunway = new System.Windows.Forms.ColumnHeader();
            this.colLength = new System.Windows.Forms.ColumnHeader();
            this.colSurface = new System.Windows.Forms.ColumnHeader();
            this.colComment = new System.Windows.Forms.ColumnHeader();
            this.colCountry = new System.Windows.Forms.ColumnHeader();
            this.largeImageList = new System.Windows.Forms.ImageList(this.components);
            this.smallImageList = new System.Windows.Forms.ImageList(this.components);
            this.panelFilter = new System.Windows.Forms.Panel();
            this.textBoxVisibleItems = new System.Windows.Forms.TextBox();
            this.buttonFilter = new System.Windows.Forms.Button();
            this.imageListFilter = new System.Windows.Forms.ImageList(this.components);
            this.popupMenu = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.newWaypointToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.editWaypointToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.deleteWaypointToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.copyToToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem2 = new System.Windows.Forms.ToolStripMenuItem();
            this.moveToToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem3 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.centerMapToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.setTohomepointToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.largeViewToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.smallViewToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.listViewToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.detailViewToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.panelFilter.SuspendLayout();
            this.popupMenu.SuspendLayout();
            this.SuspendLayout();
            // 
            // listWaypoints
            // 
            this.listWaypoints.AllowColumnReorder = true;
            this.listWaypoints.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colLongName,
            this.colShortName,
            this.colLat,
            this.colLong,
            this.colElev,
            this.colDescription,
            this.colIcao,
            this.colFreq,
            this.colLandable,
            this.colRunway,
            this.colLength,
            this.colSurface,
            this.colComment,
            this.colCountry});
            this.listWaypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listWaypoints.FullRowSelect = true;
            this.listWaypoints.GridLines = true;
            this.listWaypoints.HideSelection = false;
            this.listWaypoints.LargeImageList = this.largeImageList;
            this.listWaypoints.Location = new System.Drawing.Point(0, 0);
            this.listWaypoints.Name = "listWaypoints";
            this.listWaypoints.Size = new System.Drawing.Size(592, 416);
            this.listWaypoints.SmallImageList = this.smallImageList;
            this.listWaypoints.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listWaypoints.TabIndex = 0;
            this.listWaypoints.UseCompatibleStateImageBehavior = false;
            this.listWaypoints.View = System.Windows.Forms.View.Details;
            this.listWaypoints.DoubleClick += new System.EventHandler(this.OnEditWaypoint);
            this.listWaypoints.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // colLongName
            // 
            this.colLongName.Text = "Long name";
            this.colLongName.Width = 140;
            // 
            // colShortName
            // 
            this.colShortName.Text = "Short name";
            this.colShortName.Width = 80;
            // 
            // colLat
            // 
            this.colLat.Text = "Latitude";
            this.colLat.Width = 80;
            // 
            // colLong
            // 
            this.colLong.Text = "Longitude";
            this.colLong.Width = 80;
            // 
            // colElev
            // 
            this.colElev.Text = "Elevation";
            // 
            // colDescription
            // 
            this.colDescription.Text = "Description";
            this.colDescription.Width = 120;
            // 
            // colIcao
            // 
            this.colIcao.Text = "ICAO";
            // 
            // colFreq
            // 
            this.colFreq.Text = "Frequency";
            this.colFreq.Width = 70;
            // 
            // colLandable
            // 
            this.colLandable.Text = "Landable";
            // 
            // colRunway
            // 
            this.colRunway.Text = "Runway";
            // 
            // colLength
            // 
            this.colLength.Text = "Length";
            // 
            // colSurface
            // 
            this.colSurface.Text = "Surface";
            // 
            // colComment
            // 
            this.colComment.Text = "Comment";
            // 
            // colCountry
            // 
            this.colCountry.Text = "Country";
            // 
            // largeImageList
            // 
            this.largeImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("largeImageList.ImageStream")));
            this.largeImageList.TransparentColor = System.Drawing.Color.Transparent;
            this.largeImageList.Images.SetKeyName(0, "AirportLarge.png");
            this.largeImageList.Images.SetKeyName(1, "GliersideLarge.png");
            this.largeImageList.Images.SetKeyName(2, "OutlandingLarge.png");
            this.largeImageList.Images.SetKeyName(3, "LandmarkLarge.png");
            // 
            // smallImageList
            // 
            this.smallImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("smallImageList.ImageStream")));
            this.smallImageList.TransparentColor = System.Drawing.Color.Transparent;
            this.smallImageList.Images.SetKeyName(0, "Airport.png");
            this.smallImageList.Images.SetKeyName(1, "Glidersite.png");
            this.smallImageList.Images.SetKeyName(2, "Outlanding.png");
            this.smallImageList.Images.SetKeyName(3, "Landmark.png");
            // 
            // panelFilter
            // 
            this.panelFilter.Controls.Add(this.textBoxVisibleItems);
            this.panelFilter.Controls.Add(this.buttonFilter);
            this.panelFilter.Dock = System.Windows.Forms.DockStyle.Right;
            this.panelFilter.Location = new System.Drawing.Point(592, 0);
            this.panelFilter.Name = "panelFilter";
            this.panelFilter.Size = new System.Drawing.Size(136, 416);
            this.panelFilter.TabIndex = 1;
            // 
            // textBoxVisibleItems
            // 
            this.textBoxVisibleItems.BackColor = System.Drawing.SystemColors.Control;
            this.textBoxVisibleItems.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.textBoxVisibleItems.Cursor = System.Windows.Forms.Cursors.Arrow;
            this.textBoxVisibleItems.Location = new System.Drawing.Point(16, 40);
            this.textBoxVisibleItems.Multiline = true;
            this.textBoxVisibleItems.Name = "textBoxVisibleItems";
            this.textBoxVisibleItems.ReadOnly = true;
            this.textBoxVisibleItems.Size = new System.Drawing.Size(112, 32);
            this.textBoxVisibleItems.TabIndex = 1;
            this.textBoxVisibleItems.Text = "0 items\r\n0 visible";
            // 
            // buttonFilter
            // 
            this.buttonFilter.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonFilter.ImageIndex = 0;
            this.buttonFilter.ImageList = this.imageListFilter;
            this.buttonFilter.Location = new System.Drawing.Point(16, 8);
            this.buttonFilter.Name = "buttonFilter";
            this.buttonFilter.Size = new System.Drawing.Size(75, 23);
            this.buttonFilter.TabIndex = 0;
            this.buttonFilter.Text = "Filter";
            this.buttonFilter.Click += new System.EventHandler(this.OnFilter);
            // 
            // imageListFilter
            // 
            this.imageListFilter.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListFilter.ImageStream")));
            this.imageListFilter.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListFilter.Images.SetKeyName(0, "");
            this.imageListFilter.Images.SetKeyName(1, "");
            // 
            // popupMenu
            // 
            this.popupMenu.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.newWaypointToolStripMenuItem,
            this.editWaypointToolStripMenuItem,
            this.deleteWaypointToolStripMenuItem,
            this.copyToToolStripMenuItem,
            this.moveToToolStripMenuItem,
            this.toolStripSeparator1,
            this.centerMapToolStripMenuItem,
            this.setTohomepointToolStripMenuItem,
            this.toolStripSeparator2,
            this.largeViewToolStripMenuItem,
            this.smallViewToolStripMenuItem,
            this.listViewToolStripMenuItem,
            this.detailViewToolStripMenuItem});
            this.popupMenu.Name = "popupMenu";
            this.popupMenu.Size = new System.Drawing.Size(168, 258);
            this.popupMenu.Opening += new System.ComponentModel.CancelEventHandler(this.OnMenuPopup);
            // 
            // newWaypointToolStripMenuItem
            // 
            this.newWaypointToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.NewWaypoint;
            this.newWaypointToolStripMenuItem.Name = "newWaypointToolStripMenuItem";
            this.newWaypointToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.newWaypointToolStripMenuItem.Text = "&New waypoint";
            this.newWaypointToolStripMenuItem.Click += new System.EventHandler(this.OnNewWaypoint);
            // 
            // editWaypointToolStripMenuItem
            // 
            this.editWaypointToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Edit;
            this.editWaypointToolStripMenuItem.Name = "editWaypointToolStripMenuItem";
            this.editWaypointToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.editWaypointToolStripMenuItem.Text = "&Edit waypoint";
            this.editWaypointToolStripMenuItem.Click += new System.EventHandler(this.OnEditWaypoint);
            // 
            // deleteWaypointToolStripMenuItem
            // 
            this.deleteWaypointToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Delete;
            this.deleteWaypointToolStripMenuItem.Name = "deleteWaypointToolStripMenuItem";
            this.deleteWaypointToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.deleteWaypointToolStripMenuItem.Text = "&Delete waypoint";
            this.deleteWaypointToolStripMenuItem.Click += new System.EventHandler(this.OnDeleteWaypoint);
            // 
            // copyToToolStripMenuItem
            // 
            this.copyToToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItem2});
            this.copyToToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Copy;
            this.copyToToolStripMenuItem.Name = "copyToToolStripMenuItem";
            this.copyToToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.copyToToolStripMenuItem.Text = "&Copy to ...";
            this.copyToToolStripMenuItem.DropDownOpening += new System.EventHandler(this.OnPopupCopyTo);
            // 
            // toolStripMenuItem2
            // 
            this.toolStripMenuItem2.Name = "toolStripMenuItem2";
            this.toolStripMenuItem2.Size = new System.Drawing.Size(88, 22);
            this.toolStripMenuItem2.Text = " ";
            // 
            // moveToToolStripMenuItem
            // 
            this.moveToToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItem3});
            this.moveToToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Move;
            this.moveToToolStripMenuItem.Name = "moveToToolStripMenuItem";
            this.moveToToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.moveToToolStripMenuItem.Text = "&Move to ...";
            this.moveToToolStripMenuItem.DropDownOpening += new System.EventHandler(this.OnPopupMoveTo);
            // 
            // toolStripMenuItem3
            // 
            this.toolStripMenuItem3.Name = "toolStripMenuItem3";
            this.toolStripMenuItem3.Size = new System.Drawing.Size(88, 22);
            this.toolStripMenuItem3.Text = " ";
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(164, 6);
            // 
            // centerMapToolStripMenuItem
            // 
            this.centerMapToolStripMenuItem.Name = "centerMapToolStripMenuItem";
            this.centerMapToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.centerMapToolStripMenuItem.Text = "Cen&ter map";
            this.centerMapToolStripMenuItem.Click += new System.EventHandler(this.OnCenterMap);
            // 
            // setTohomepointToolStripMenuItem
            // 
            this.setTohomepointToolStripMenuItem.Image = global::SoaringDotNET.Properties.Resources.Home;
            this.setTohomepointToolStripMenuItem.Name = "setTohomepointToolStripMenuItem";
            this.setTohomepointToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.setTohomepointToolStripMenuItem.Text = "Set to &homepoint";
            this.setTohomepointToolStripMenuItem.Click += new System.EventHandler(this.OnSetHomePoint);
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size(164, 6);
            // 
            // largeViewToolStripMenuItem
            // 
            this.largeViewToolStripMenuItem.Name = "largeViewToolStripMenuItem";
            this.largeViewToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.largeViewToolStripMenuItem.Text = "&Large view";
            this.largeViewToolStripMenuItem.Click += new System.EventHandler(this.OnLargeView);
            // 
            // smallViewToolStripMenuItem
            // 
            this.smallViewToolStripMenuItem.Name = "smallViewToolStripMenuItem";
            this.smallViewToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.smallViewToolStripMenuItem.Text = "&Small view";
            this.smallViewToolStripMenuItem.Click += new System.EventHandler(this.OnSmallView);
            // 
            // listViewToolStripMenuItem
            // 
            this.listViewToolStripMenuItem.Name = "listViewToolStripMenuItem";
            this.listViewToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.listViewToolStripMenuItem.Text = "L&ist view";
            this.listViewToolStripMenuItem.Click += new System.EventHandler(this.OnListView);
            // 
            // detailViewToolStripMenuItem
            // 
            this.detailViewToolStripMenuItem.Name = "detailViewToolStripMenuItem";
            this.detailViewToolStripMenuItem.Size = new System.Drawing.Size(167, 22);
            this.detailViewToolStripMenuItem.Text = "Det&ail view";
            this.detailViewToolStripMenuItem.Click += new System.EventHandler(this.OnDetailView);
            // 
            // Waypoints
            // 
            this.ContextMenuStrip = this.popupMenu;
            this.Controls.Add(this.listWaypoints);
            this.Controls.Add(this.panelFilter);
            this.Name = "Waypoints";
            this.Size = new System.Drawing.Size(728, 416);
            this.panelFilter.ResumeLayout(false);
            this.panelFilter.PerformLayout();
            this.popupMenu.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        #region Private Functions
        // popup menu handlers
        private void OnMenuPopup(object sender, CancelEventArgs e) {
            newWaypointToolStripMenuItem.Enabled = (currentCatalog != null);
            editWaypointToolStripMenuItem.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
            deleteWaypointToolStripMenuItem.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
            copyToToolStripMenuItem.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
            moveToToolStripMenuItem.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
            centerMapToolStripMenuItem.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
            setTohomepointToolStripMenuItem.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
        }

        private void OnPopupCopyTo(object sender, System.EventArgs e) {
            copyToToolStripMenuItem.DropDownItems.Clear();
            foreach (WaypointCatalog c in AppContents.waypointCatalogs) {
                if (c != currentCatalog) {
                    copyToToolStripMenuItem.DropDownItems.Add(c.ToString(), null, new System.EventHandler(OnSelectCopyToCatalog));
                }
            }
            if (copyToToolStripMenuItem.DropDownItems.Count < 1) {
                copyToToolStripMenuItem.DropDownItems.Add("-");
            }
        }

        private void OnSelectCopyToCatalog(object sender, System.EventArgs e) {
            ToolStripMenuItem m = (ToolStripMenuItem)sender;
            WaypointCatalog c = AppContents.FindCatalog(m.Text);
            foreach (ListViewItem ic in listWaypoints.SelectedItems) {
                AppContents.application.CopyWaypoint((WayPoint)ic.Tag, c);
            }
        }

        private void OnPopupMoveTo(object sender, System.EventArgs e) {
            moveToToolStripMenuItem.DropDownItems.Clear();
            foreach (WaypointCatalog c in AppContents.waypointCatalogs) {
                if (c != currentCatalog) {
                    moveToToolStripMenuItem.DropDownItems.Add(c.ToString(), null, new System.EventHandler(OnSelectMoveToCatalog));
                }
            }

            if (moveToToolStripMenuItem.DropDownItems.Count < 1) {
                moveToToolStripMenuItem.DropDownItems.Add("-");
            }
        }

        private void OnSelectMoveToCatalog(object sender, System.EventArgs e) {
            ToolStripMenuItem m = (ToolStripMenuItem)sender;
            WaypointCatalog c = AppContents.FindCatalog(m.Text);
            foreach (ListViewItem ic in listWaypoints.SelectedItems) {
                AppContents.application.MoveWaypoint((WayPoint)ic.Tag, currentCatalog, c);
            }                
        }

        private void OnNewWaypoint(object sender, System.EventArgs e) {
            AppContents.application.AddWaypoint();
        }

        private void OnEditWaypoint(object sender, System.EventArgs e) {
            if (listWaypoints.SelectedItems.Count > 0) {
                WayPoint wp = (WayPoint)listWaypoints.SelectedItems[0].Tag;
                AppContents.application.EditWaypoint(wp);
            }
        }

        private void OnDeleteWaypoint(object sender, System.EventArgs e) {
            ArrayList l = new ArrayList(listWaypoints.SelectedItems.Count);
            foreach (ListViewItem ic in listWaypoints.SelectedItems) {
                l.Add(ic.Tag);
            }

            AppContents.application.Delete(l);
        }

        private void OnCenterMap(object sender, System.EventArgs e) {
            if (listWaypoints.SelectedItems.Count > 0) {
                WayPoint wp = (WayPoint)listWaypoints.SelectedItems[0].Tag;
                AppContents.application.CenterMapTo(wp);
            }        
        }

        private void OnSetHomePoint(object sender, System.EventArgs e) {
            if (listWaypoints.SelectedItems.Count > 0) {
                WayPoint wp = (WayPoint)listWaypoints.SelectedItems[0].Tag;
                AppContents.application.SetHomePoint(wp);
            }        
        }

        private void OnLargeView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.LargeIcon;
            largeViewToolStripMenuItem.Checked = true;
            listViewToolStripMenuItem.Checked = false;
            detailViewToolStripMenuItem.Checked = false;
            smallViewToolStripMenuItem.Checked = false;
        }

        private void OnSmallView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.SmallIcon;
            largeViewToolStripMenuItem.Checked = false;
            listViewToolStripMenuItem.Checked = false;
            detailViewToolStripMenuItem.Checked = false;
            smallViewToolStripMenuItem.Checked = true;
        }
        
        private void OnListView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.List;
            largeViewToolStripMenuItem.Checked = false;
            listViewToolStripMenuItem.Checked = true;
            detailViewToolStripMenuItem.Checked = false;
            smallViewToolStripMenuItem.Checked = false;
        }
        
        private void OnDetailView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.Details;
            largeViewToolStripMenuItem.Checked = false;
            listViewToolStripMenuItem.Checked = false;
            detailViewToolStripMenuItem.Checked = true;
            smallViewToolStripMenuItem.Checked = false;            
        }

        private void OnFilter(object sender, System.EventArgs e) {
            WaypointFilterDialog fd = new WaypointFilterDialog(currentCatalog);
            if (currentCatalog != null && currentCatalog.Filter.useMapCoord) {
                currentCatalog.Filter.area.TopLeft = AppContents.application.MapUpperLeft;
                currentCatalog.Filter.area.BottomRight = AppContents.application.MapLowerRight;
            }

            if (fd.ShowDialog(this) == DialogResult.OK) {
                WayPointFilter filter = fd.filter;
                if (filter.reference == ReferenceType.CenterMap) {
                    filter.center = new WayPoint(AppContents.application.MapCenter);
                }
                else if (filter.reference == ReferenceType.HomePoint) {
                    filter.center = new WayPoint(AppContents.homePoint);
                }

                currentCatalog.Filter = filter;                
                AppContents.application.Update(currentCatalog);
            }
        }

        private void UpdateFilterInfo() {
            string [] lines = textBoxVisibleItems.Lines;
            lines[0] = string.Format("{0} items", currentCatalog != null ? currentCatalog.Count : 0);
            lines[1] = string.Format("{0} visible", currentCatalog != null ? currentCatalog.VisibleWaypoints.Count : 0);
            textBoxVisibleItems.Lines = lines;
        }

        private void OnColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e) {
            ListViewItemSorter sorter = (ListViewItemSorter)listWaypoints.ListViewItemSorter;
            sorter.Col = e.Column;
            listWaypoints.Sort();
        }

        #endregion

        #region Public Functions
        public void SwitchToCatalog(WaypointCatalog catalog) {
            if (catalog != currentCatalog) {
                currentCatalog = catalog;
                Refill();
            }
        }

        public void Update(WaypointCatalog catalog) {
            if (catalog == currentCatalog) {
                Refill();
            }
        }


        public void Add(WayPoint wp) {
            if (currentCatalog != null) {
                CatalogOperation res = currentCatalog.Add(wp);
                
                switch (res) {
                case CatalogOperation.Add:
                    // check if not filtered
                    if (currentCatalog.Filter.IsVisible(wp)) {
                        ListViewItem l = new ListViewItem(wp.longName);
                        l.Tag = wp;
                        l.ImageIndex = (int)wp.type;
                        l.SubItems.AddRange(new string [] {wp.shortName, wp.ToStringLat(), wp.ToStringLong(), wp.Elevation != -1 ? wp.Elevation.ToString() + "m" : "",
                                                                wp.description, wp.icao, wp.frequency, wp.landable.ToString(), 
                                                                wp.runway, wp.length != -1 ? wp.length.ToString() : "", wp.surface.ToString(), wp.comment, wp.country.ToString()});
                        listWaypoints.Items.Add(l);
                    }
                    break;
                case CatalogOperation.Replace:
                    foreach (ListViewItem i in listWaypoints.Items) {
                        if (i.Text == wp.longName) {
                            i.Remove();
                        }
                    }
                    goto case CatalogOperation.Add;
                }
                UpdateFilterInfo();
            }
            else {
                throw new Exception("no open catalog");
            }
        }

        public void Refill() {
            listWaypoints.Items.Clear();
            listWaypoints.BeginUpdate();
            if (currentCatalog != null) {
                ArrayList items = new ArrayList(currentCatalog.Count);
                foreach (WayPoint wp in currentCatalog.VisibleWaypoints) {
                    ListViewItem l = new ListViewItem(wp.longName);
                    l.Tag = wp;
                    l.ImageIndex = (int)wp.type;
                    l.SubItems.AddRange(new string [] {wp.shortName, wp.ToStringLat(), wp.ToStringLong(), wp.Elevation != -1 ? wp.Elevation.ToString() + " m" : "",
                                                            wp.description, wp.icao, wp.frequency, wp.landable.ToString(), 
                                                            wp.runway, wp.length != -1 ? wp.length.ToString() : "", wp.surface.ToString(), wp.comment, wp.country.ToString()});
                    items.Add(l);
                }

                if (items.Count > 0) {
                    listWaypoints.Items.AddRange((ListViewItem [])items.ToArray(items[0].GetType()));
                }
            }

            listWaypoints.EndUpdate();
            buttonFilter.ImageIndex = currentCatalog != null ? (currentCatalog.Filter.IsSet ? 1 : 0) : 0;
            UpdateFilterInfo();
        }

        public void Update(WayPoint oldWp, WayPoint newWp) {
            ListViewItem.ListViewSubItemCollection coll;
            if (currentCatalog != null) {
                CatalogOperation res = currentCatalog.Update(oldWp, newWp);
                switch (res) {
                case CatalogOperation.Update:
                    foreach (ListViewItem l in listWaypoints.Items) {
                        if (l.Tag == oldWp) {
                            if (currentCatalog.Filter.IsVisible(newWp)) {
                                l.Tag = newWp;
                                l.ImageIndex = (int)newWp.type;
                                l.Text = newWp.longName;
                                coll = l.SubItems;
                                coll[1].Text = newWp.shortName;
                                coll[2].Text = newWp.ToStringLat();
                                coll[3].Text = newWp.ToStringLong();
                                coll[4].Text = newWp.Elevation != -1 ? newWp.Elevation.ToString() + "m" : "";
                                coll[5].Text = newWp.description;
                                coll[6].Text = newWp.icao;
                                coll[7].Text = newWp.frequency;
                                coll[8].Text = newWp.landable.ToString(); 
                                coll[9].Text = newWp.runway;
                                coll[10].Text = newWp.length != -1 ? newWp.length.ToString() + "m" : "";
                                coll[11].Text = newWp.surface.ToString();
                                coll[12].Text = newWp.comment;
                                coll[13].Text = newWp.country.ToString();

                                listWaypoints.Sort();
                            }
                            else {
                                l.Remove();
                            }
                            break;
                        }
                    }
                    break;
                case CatalogOperation.Replace:
                    foreach (ListViewItem i in listWaypoints.Items) {
                        if (i.Text == newWp.longName) {
                            i.Remove();
                        }
                    }
                    goto case CatalogOperation.Update;
                }
                UpdateFilterInfo();
            }
            else {
                throw new Exception("no open catalog");
            }
        }

        public void Remove(WayPoint wp) {
            foreach (ListViewItem l in listWaypoints.Items) {
                if (l.Tag == wp) {
                    l.Remove();
                    UpdateFilterInfo();
                    break;
                }
            }
        }
        #endregion

        #region Attributes
        #endregion
    }
}
