// name   : Airspace.cs
// author : Harald Maier
// date   : 23.01.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;

namespace SoaringDotNET.Data
{
	/// <summary>
	/// 
	/// </summary>
    public enum AirspaceTypes {Unknown =  -1, ControlArea = 6, ControlZone = 7, TerminalControlArea = 11, SpecialUsedAirspace};
    public enum AirspaceClasses {Unknown = -1, A, B, C, D, E, F, Prohibited, Danger, Restricted, Military, Temporary, Warning, Alert, Soaring, Other};

    public class Airspace {
        public string id = "";
        public string name = "";
        public AirspaceTypes airspaceType;
        public AirspaceClasses airspaceClass;
        public string lowerBound = "";
        public string upperBound = "";
        public string remark = "";
        public string country = "";
        public string radioFrequency = "";
        public string commName = "";

        public ArrayList points;

        public Airspace() : this(AirspaceClasses.Unknown){}
        public Airspace(AirspaceClasses cl) {
            airspaceType = AirspaceTypes.Unknown;
            airspaceClass = cl;
            points = new ArrayList();
        }

        public IEnumerator GetEnumerator() {
            return points.GetEnumerator();
        }
	}
}
