// name   : DMSt2004.cs
// author : Harald Maier
// date   : 02.04.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
	/// <summary>
	/// 
	/// </summary>
	public class DMSt2004 : SoaringDotNET.Optimization.OptimizationBase
	{
        private const int LEGS = 4;

        public DMSt2004(Flight flight) : 
            base(flight)
		{
			// 
			// TODO: Add constructor logic here
			//
            weight = new double [] {1.0, 1.0, 1.0, 1.0};
            optimizedTask.OptimizedFor = OptimizeTypes.DMSTFreeFlight;
        }
	
        public override void Optimize() {
            // TODO:  Add DMST2004.Optimize implementation
            int N;
            int leg, i, j;
            double length, length2, points;
            double [][]lengthValues;
            double [] prevLeg;
            double [] currentLeg;
            double [] lVector;
            
            int [][] wayPoints;
            int [] currentWaypoints;
            int [] pointList;
            int start, stop;
            FlightPoint p;
            WayPoint wp;
            WgsPoint tmpWp;
            string t;

            start = flight.Start != -1 ? flight.Start : 0;
            stop = flight.Stop != -1 ? flight.Stop : flight.Count;
            N = flight.Count;

            lengthValues = new double[LEGS + 1][];
            wayPoints = new int[LEGS + 1][];
            pointList = new int[LEGS + 1];

            optimizedTask.Clear();

            for (i = 0; i < LEGS + 1; i++) {
                lengthValues[i] = new double[N];
                wayPoints[i] = new int[N];
            }

            status = OptimizataionStatus.Running;

            for (leg = 1; leg <= LEGS; leg++) {
                currentLeg = lengthValues[leg];
                currentWaypoints = wayPoints[leg];
                prevLeg = lengthValues[leg - 1];
                for (i = start; i < stop; i++) {
                    lVector = flight.lengthMatrix[i];
                    length2 = currentLeg[i];
                    for (j = start; j < i; j++) {
                        length = prevLeg[j] + lVector[j];
                        if (length > length2) {
                            currentLeg[i] = length;
                            currentWaypoints[i] = j;
                            length2 = length;
                        }
                    }
                }
            }

            points = 0.0;
            currentLeg = lengthValues[LEGS];
            for (i = start; i < stop; i++){
                if(currentLeg[i] > points){
                    points = currentLeg[i];
                    pointList[LEGS] = i;
                }
            }

            for (leg = LEGS; leg > 0; leg--){
                pointList[leg - 1] = wayPoints[leg][pointList[leg]];
            }

            p = flight[flight.Takeoff];
            wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Takeoff", WayPointTypeId.Unknown);
            wp.reachPoint = p;
            optimizedTask.Add(wp);

            for (leg = 0; leg <= LEGS; leg++) {
                switch (leg) {
                case 0:
                    t = "Start";
                    break;
                case LEGS:
                    t = "Finish";
                    break;
                default:
                    t = string.Format("TP {0}", leg);
                    break;
                }
                p = flight[pointList[leg]];
                wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, t, WayPointTypeId.Unknown);
                wp.reachPoint = p;
                optimizedTask.Add(wp);
            }

            p = flight[flight.Landing];
            wp = new WayPoint(p.Latitude, p.Longitude, p.pAlt, "Landing", WayPointTypeId.Unknown);
            wp.reachPoint = p;
            optimizedTask.Add(wp);

            // "optimize" start and finish according to DMSt rules
            // point is reached when fix inside 1 km radius
            // so we "extend" out flight by that distance

            // start
            wp = optimizedTask[1];
            tmpWp = wp.PosOfDistAndBearing(optimizedTask[2].bearing(wp), 0.99);
            wp.Latitude = tmpWp.Latitude;
            wp.Longitude = tmpWp.Longitude;

            // finish
            wp = optimizedTask[optimizedTask.Count - 2];
            tmpWp = wp.PosOfDistAndBearing(optimizedTask[optimizedTask.Count - 3].bearing(wp), 0.99);
            wp.Latitude = tmpWp.Latitude;
            wp.Longitude = tmpWp.Longitude;

            status = OptimizataionStatus.Idle;
        }
    
        public override string ToString() {
            // TODO:  Add DMST2004.ToString implementation
            return "DMSt 2004";
        }
    }
}
