// name   : Declaration.cs
// author : Harald Maier
// date   : 02.04.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Optimization
{
	/// <summary>
	/// 
	/// </summary>
	public class Declaration : SoaringDotNET.Optimization.OptimizationBase
	{

		public Declaration(Flight flight) : 
            base(flight)
		{
			// 
			// TODO: Add constructor logic here
			//
            weight = new double [] {1.0, 1.0, 1.0, 1.0};
            optimizedTask.OptimizedFor = OptimizeTypes.OriginalTask;
        }
	
        public override void Optimize() {
            // TODO:  Add Declaration.Optimize implementation
            int start = flight.Start != -1 ? flight.Start : 0;
            int stop = flight.Stop != -1 ? flight.Stop : flight.Count;
            int takeoff = flight.Takeoff != -1 ? flight.Takeoff : 0;
            int landing = flight.Landing != -1 ? flight.Landing : flight.Count;
            int i, wpIdx;
            WayPoint wp, wp1, wp2;
            WgsPoint tmpWp;
            SectorDefinition sector;
            double halfSectorAngle;
            double w1, w2, alpha, dist, alpha2;
            double tmpAlpha;
            bool reached;
            FlightPoint fp, nextFp;
            Point p1, p2, p3, pp1, pp2;
            p1 = new Point(0, 0);
            p2 = new Point(0, 0);
            p3 = new Point(0, 0);
            pp1 = new Point(0, 0);
            pp2 = new Point(0, 0);

            optimizedTask.Clear();
            for (i = 0; i < flight.originalTask.Count; i++) {
                optimizedTask.Add(new WayPoint(flight.originalTask[i]));
            }

            wpIdx = 0;
            if (optimizedTask.Count > 2 && flight.Count > 0) {
                if (optimizedTask.TaskType != TaskTypes.Unknown) {
                    // set takeoff time
                    wp = optimizedTask[0];
                    wp.reachPoint = flight[takeoff];
                    // set landing time
                    wp = optimizedTask[optimizedTask.Count - 1];
                    wp.reachPoint = flight[landing];
                    wpIdx = 1;
                }
                // check all waypoints
                wp = optimizedTask[wpIdx];
                wp1 = wp2 = optimizedTask[2];
                w1 = wp.bearingDeg(wp1);
                w2 = wp.bearingDeg(wp2);
                alpha = WgsPoint.GetSectorAngle(w1, w2);
                sector = optimizedTask.GetSector(wpIdx);
                halfSectorAngle = sector.angle / 2.0;
                if (sector.sectorType == SectorTypes.Line) {
                    // p1 = "left" of wp
                    // p2 = "right" of wp
                    tmpAlpha = alpha - 90.0;
                    if (tmpAlpha < 0) {
                        tmpAlpha += 360.0;
                    }
                    tmpWp = wp.PosOfDistAndBearing(tmpAlpha / 180.0 * Math.PI, sector.radius1 / 1000.0);
                    p1.X = tmpWp.Longitude;
                    p1.Y = tmpWp.Latitude;
                    tmpWp = wp.PosOfDistAndBearing(((alpha + 90.0) % 360) / 180.0 * Math.PI, sector.radius1 / 1000.0);
                    p2.X = tmpWp.Longitude;
                    p2.Y = tmpWp.Latitude;
                }
                else {
                    // p1 = wp origin
                    // p2 = wp radial 1
                    // p3 = wp radial 2
                    p1.X = wp.Longitude;
                    p1.Y = wp.Latitude;

                    tmpAlpha = alpha - halfSectorAngle - 180;
                    if (tmpAlpha < 0) {
                        tmpAlpha += 360.0;
                    }

                    tmpWp = wp.PosOfDistAndBearing(tmpAlpha / 180.0 * Math.PI, sector.radius1 / 1000.0);
                    p2.X = tmpWp.Longitude;
                    p2.Y = tmpWp.Latitude;

                    tmpAlpha = alpha + halfSectorAngle - 180;
                    if (tmpAlpha < 0) {
                        tmpAlpha += 360.0;
                    }
                    tmpWp = wp.PosOfDistAndBearing(tmpAlpha / 180.0 * Math.PI, sector.radius1 / 1000.0);
                    p3.X = tmpWp.Longitude;
                    p3.Y = tmpWp.Latitude;
                }

                reached = false;
                for (i = start; i < stop; i++) {
                    fp = flight[i];
                    dist = wp.distanceM(fp);
                    if (sector.radius2 > 0 && dist < sector.radius2) {
                        reached = true;                        
                    }
                    else if (dist < sector.radius1) {
                        if (sector.sectorType == SectorTypes.Sector) {
                            alpha2 = fp.bearingDeg(wp);
                            if (alpha >= halfSectorAngle && alpha <= 360.0 - halfSectorAngle) {
                                if (Math.Abs(alpha2 - alpha) < halfSectorAngle) {
                                    reached = true;
                                }
                            }
                            else if (alpha < halfSectorAngle) {
                                if (alpha2 < alpha + halfSectorAngle || alpha2 > (alpha - halfSectorAngle + 360.0)) {
                                    reached = true;
                                }
                            }
                            else if (alpha > 360.0 - halfSectorAngle) {
                                if (alpha2 > alpha - halfSectorAngle || alpha2 < ((alpha + halfSectorAngle) % 360.0)) {
                                    reached = true;
                                }
                            }
                            if (!reached) {
                                // no point inside sector, check if line to next fp
                                // is crossing at least one sector radial
                                if (i < stop - 1) {
                                    nextFp = flight[i + 1];
                                    pp1.X = fp.Longitude;
                                    pp1.Y = fp.Latitude;
                                    pp2.X = nextFp.Longitude;
                                    pp2.Y = nextFp.Latitude;
                                    reached = LinesCrossing(p1, p2, pp1, pp2) || LinesCrossing(p1, p3, pp1, pp2);
                                }
                            }
                        }
                        else {
                            // line
                            if (i < stop - 1) {
                                nextFp = flight[i + 1];
                                pp1.X = fp.Longitude;
                                pp1.Y = fp.Latitude;
                                pp2.X = nextFp.Longitude;
                                pp2.Y = nextFp.Latitude;
                                reached = LinesCrossing(p1, p2, pp1, pp2);
                            }
                        }
                    }

                    if (reached) {
                        wp.reachPoint = fp;
                        wpIdx++;
                        if (wpIdx > optimizedTask.Count - (optimizedTask.TaskType != TaskTypes.Unknown ? 2 : 1)) {
                            break;
                        }
                        else {
                            wp1 = wp;
                            wp = optimizedTask[wpIdx];
                            if (wpIdx == optimizedTask.Count - 2) {
                                wp2 = wp1;
                            }
                            else {
                                wp2 = optimizedTask[wpIdx + 1];
                            }
                            w1 = wp.bearingDeg(wp1);
                            w2 = wp.bearingDeg(wp2);
                            alpha = WgsPoint.GetSectorAngle(w1, w2);
                            sector = optimizedTask.GetSector(wpIdx);
                            halfSectorAngle = sector.angle / 2.0;
                            reached = false;
                            if (sector.sectorType == SectorTypes.Line) {
                                tmpAlpha = alpha - 90.0;
                                if (tmpAlpha < 0) {
                                    tmpAlpha += 360.0;
                                }
                                tmpWp = wp.PosOfDistAndBearing(tmpAlpha / 180.0 * Math.PI, sector.radius1 / 1000.0);
                                p1.X = tmpWp.Longitude;
                                p1.Y = tmpWp.Latitude;
                                tmpWp = wp.PosOfDistAndBearing(((alpha + 90.0) % 360.0) / 180.0 * Math.PI, sector.radius1 / 1000.0);
                                p2.X = tmpWp.Longitude;
                                p2.Y = tmpWp.Latitude;
                            }
                            else {
                                // p1 = wp origin
                                // p2 = wp radial 1
                                // p3 = wp radial 2
                                p1.X = wp.Longitude;
                                p1.Y = wp.Latitude;

                                tmpAlpha = alpha - halfSectorAngle - 180;
                                if (tmpAlpha < 0) {
                                    tmpAlpha += 360.0;
                                }

                                tmpWp = wp.PosOfDistAndBearing(tmpAlpha / 180.0 * Math.PI, sector.radius1 / 1000.0);
                                p2.X = tmpWp.Longitude;
                                p2.Y = tmpWp.Latitude;

                                tmpAlpha = alpha + halfSectorAngle - 180;
                                if (tmpAlpha < 0) {
                                    tmpAlpha += 360.0;
                                }
                                tmpWp = wp.PosOfDistAndBearing(tmpAlpha / 180.0 * Math.PI, sector.radius1 / 1000.0);
                                p3.X = tmpWp.Longitude;
                                p3.Y = tmpWp.Latitude;
                            }
                        }
                    }
                }
            }
        }

        public override string ToString() {
            // TODO:  Add DMST2004.ToString implementation
            return "Declared Task";
        }

        private bool LinesCrossing(Point p1, Point p2, Point pp1, Point pp2) {
            long i, j, k, l;
            i = SideOfLine(p1, p2, pp1);
            j = SideOfLine(p1, p2, pp2);
            k = SideOfLine(pp1, pp2, p1);
            l = SideOfLine(pp1, pp2, p2);
            return (i * j <= 0) && (k * l <= 0);
        }

        // return >0 if left of p1->p2
        // return <0 of right of p1->p2
        // return 0 if on p1->p2
        private long SideOfLine(Point p1, Point p2, Point px) {
            long x1, x2, y1, y2;
            x1 = (long)p2.X - (long)p1.X;
            y1 = (long)p2.Y - (long)p1.Y;
            x2 = (long)px.X - (long)p1.X;
            y2 = (long)px.Y - (long)p1.Y;
            return (x1 * y2) - (y1 * x2);
        }
    }
}
