// name   : OLCDialog.cs
// author : Harald Maier
// date   : 14.05.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Diagnostics;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Collections;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;
using SoaringDotNET.Optimization;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// 
	/// </summary>
	public class OLCDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button buttonSelectPilot2;
        private System.Windows.Forms.Button buttonSelectPilot1;
        private System.Windows.Forms.TextBox textBoxCompId;
        private System.Windows.Forms.Label label13;
        private System.Windows.Forms.TextBox textBoxGliderId;
        private System.Windows.Forms.ComboBox comboBoxCompClass;
        private System.Windows.Forms.Label label12;
        private System.Windows.Forms.Label label11;
        private System.Windows.Forms.ComboBox comboBoxGlider;
        private System.Windows.Forms.Label label10;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.ColumnHeader columnTurnpoint;
        private System.Windows.Forms.ColumnHeader columnTime;
        private System.Windows.Forms.ColumnHeader columnLat;
        private System.Windows.Forms.ColumnHeader columnLon;
        private System.Windows.Forms.ColumnHeader columnDist;
        private System.Windows.Forms.ColumnHeader columnTaskDist;
        private System.Windows.Forms.ColumnHeader columnPoints;
        private System.Windows.Forms.Button buttonSend;
        private System.Windows.Forms.Button buttonSave;
        private System.Windows.Forms.Button buttonFinish;
        private System.Windows.Forms.ListView listViewTask;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.DateTimePicker dateTimePickerPilot1;
        private System.Windows.Forms.CheckBox checkPureGlider;
        private System.Windows.Forms.DateTimePicker dateTimePickerPilot2;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.TextBox textCoPilotPreName;
        private System.Windows.Forms.TextBox textPilotPreName;
        private System.Windows.Forms.TextBox textCoPilotSurName;
        private System.Windows.Forms.TextBox textPilotSurName;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.ComboBox comboBoxCompetitionCountry;

        private Flight flight;

        private void InitializeComponent() {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(OLCDialog));
            this.buttonSelectPilot2 = new System.Windows.Forms.Button();
            this.buttonSelectPilot1 = new System.Windows.Forms.Button();
            this.textBoxCompId = new System.Windows.Forms.TextBox();
            this.label13 = new System.Windows.Forms.Label();
            this.textBoxGliderId = new System.Windows.Forms.TextBox();
            this.comboBoxCompClass = new System.Windows.Forms.ComboBox();
            this.label12 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.comboBoxGlider = new System.Windows.Forms.ComboBox();
            this.label10 = new System.Windows.Forms.Label();
            this.label9 = new System.Windows.Forms.Label();
            this.textCoPilotPreName = new System.Windows.Forms.TextBox();
            this.textPilotPreName = new System.Windows.Forms.TextBox();
            this.label8 = new System.Windows.Forms.Label();
            this.listViewTask = new System.Windows.Forms.ListView();
            this.columnTurnpoint = new System.Windows.Forms.ColumnHeader();
            this.columnTime = new System.Windows.Forms.ColumnHeader();
            this.columnLat = new System.Windows.Forms.ColumnHeader();
            this.columnLon = new System.Windows.Forms.ColumnHeader();
            this.columnDist = new System.Windows.Forms.ColumnHeader();
            this.columnTaskDist = new System.Windows.Forms.ColumnHeader();
            this.columnPoints = new System.Windows.Forms.ColumnHeader();
            this.buttonSend = new System.Windows.Forms.Button();
            this.buttonSave = new System.Windows.Forms.Button();
            this.buttonFinish = new System.Windows.Forms.Button();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.dateTimePickerPilot1 = new System.Windows.Forms.DateTimePicker();
            this.dateTimePickerPilot2 = new System.Windows.Forms.DateTimePicker();
            this.checkPureGlider = new System.Windows.Forms.CheckBox();
            this.textCoPilotSurName = new System.Windows.Forms.TextBox();
            this.textPilotSurName = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.comboBoxCompetitionCountry = new System.Windows.Forms.ComboBox();
            this.SuspendLayout();
            // 
            // buttonSelectPilot2
            // 
            this.buttonSelectPilot2.Image = ((System.Drawing.Image)(resources.GetObject("buttonSelectPilot2.Image")));
            this.buttonSelectPilot2.Location = new System.Drawing.Point(328, 256);
            this.buttonSelectPilot2.Name = "buttonSelectPilot2";
            this.buttonSelectPilot2.Size = new System.Drawing.Size(22, 22);
            this.buttonSelectPilot2.TabIndex = 35;
            this.buttonSelectPilot2.Click += new System.EventHandler(this.OnSelectPilot2);
            // 
            // buttonSelectPilot1
            // 
            this.buttonSelectPilot1.Image = ((System.Drawing.Image)(resources.GetObject("buttonSelectPilot1.Image")));
            this.buttonSelectPilot1.Location = new System.Drawing.Point(328, 224);
            this.buttonSelectPilot1.Name = "buttonSelectPilot1";
            this.buttonSelectPilot1.Size = new System.Drawing.Size(22, 22);
            this.buttonSelectPilot1.TabIndex = 34;
            this.buttonSelectPilot1.Click += new System.EventHandler(this.OnSelectPilot1);
            // 
            // textBoxCompId
            // 
            this.textBoxCompId.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxCompId.Location = new System.Drawing.Point(420, 320);
            this.textBoxCompId.Name = "textBoxCompId";
            this.textBoxCompId.Size = new System.Drawing.Size(32, 20);
            this.textBoxCompId.TabIndex = 33;
            this.textBoxCompId.Text = "";
            // 
            // label13
            // 
            this.label13.AutoSize = true;
            this.label13.Location = new System.Drawing.Point(358, 320);
            this.label13.Name = "label13";
            this.label13.Size = new System.Drawing.Size(52, 16);
            this.label13.TabIndex = 32;
            this.label13.Text = "Comp. ID";
            // 
            // textBoxGliderId
            // 
            this.textBoxGliderId.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxGliderId.Location = new System.Drawing.Point(420, 288);
            this.textBoxGliderId.Name = "textBoxGliderId";
            this.textBoxGliderId.Size = new System.Drawing.Size(90, 20);
            this.textBoxGliderId.TabIndex = 31;
            this.textBoxGliderId.Text = "";
            // 
            // comboBoxCompClass
            // 
            this.comboBoxCompClass.Location = new System.Drawing.Point(112, 320);
            this.comboBoxCompClass.Name = "comboBoxCompClass";
            this.comboBoxCompClass.Size = new System.Drawing.Size(152, 21);
            this.comboBoxCompClass.Sorted = true;
            this.comboBoxCompClass.TabIndex = 30;
            // 
            // label12
            // 
            this.label12.AutoSize = true;
            this.label12.Location = new System.Drawing.Point(38, 320);
            this.label12.Name = "label12";
            this.label12.Size = new System.Drawing.Size(69, 16);
            this.label12.TabIndex = 29;
            this.label12.Text = "Comp. Class";
            // 
            // label11
            // 
            this.label11.AutoSize = true;
            this.label11.Location = new System.Drawing.Point(361, 288);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(49, 16);
            this.label11.TabIndex = 28;
            this.label11.Text = "Glider ID";
            // 
            // comboBoxGlider
            // 
            this.comboBoxGlider.Location = new System.Drawing.Point(112, 288);
            this.comboBoxGlider.Name = "comboBoxGlider";
            this.comboBoxGlider.Size = new System.Drawing.Size(152, 21);
            this.comboBoxGlider.Sorted = true;
            this.comboBoxGlider.TabIndex = 27;
            // 
            // label10
            // 
            this.label10.AutoSize = true;
            this.label10.Location = new System.Drawing.Point(72, 288);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(35, 16);
            this.label10.TabIndex = 26;
            this.label10.Text = "Glider";
            // 
            // label9
            // 
            this.label9.AutoSize = true;
            this.label9.Location = new System.Drawing.Point(64, 256);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(43, 16);
            this.label9.TabIndex = 25;
            this.label9.Text = "Co-pilot";
            // 
            // textCoPilotPreName
            // 
            this.textCoPilotPreName.Location = new System.Drawing.Point(112, 256);
            this.textCoPilotPreName.Name = "textCoPilotPreName";
            this.textCoPilotPreName.Size = new System.Drawing.Size(104, 20);
            this.textCoPilotPreName.TabIndex = 24;
            this.textCoPilotPreName.Text = "";
            // 
            // textPilotPreName
            // 
            this.textPilotPreName.Location = new System.Drawing.Point(112, 224);
            this.textPilotPreName.Name = "textPilotPreName";
            this.textPilotPreName.Size = new System.Drawing.Size(104, 20);
            this.textPilotPreName.TabIndex = 23;
            this.textPilotPreName.Text = "";
            // 
            // label8
            // 
            this.label8.AutoSize = true;
            this.label8.Location = new System.Drawing.Point(80, 224);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(26, 16);
            this.label8.TabIndex = 22;
            this.label8.Text = "Pilot";
            // 
            // listViewTask
            // 
            this.listViewTask.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                           this.columnTurnpoint,
                                                                                           this.columnTime,
                                                                                           this.columnLat,
                                                                                           this.columnLon,
                                                                                           this.columnDist,
                                                                                           this.columnTaskDist,
                                                                                           this.columnPoints});
            this.listViewTask.Location = new System.Drawing.Point(40, 16);
            this.listViewTask.Name = "listViewTask";
            this.listViewTask.Size = new System.Drawing.Size(496, 168);
            this.listViewTask.TabIndex = 36;
            this.listViewTask.View = System.Windows.Forms.View.Details;
            // 
            // columnTurnpoint
            // 
            this.columnTurnpoint.Text = "Turnpoint";
            this.columnTurnpoint.Width = 80;
            // 
            // columnTime
            // 
            this.columnTime.Text = "Time";
            // 
            // columnLat
            // 
            this.columnLat.Text = "Latitude";
            this.columnLat.Width = 80;
            // 
            // columnLon
            // 
            this.columnLon.Text = "Longitude";
            this.columnLon.Width = 80;
            // 
            // columnDist
            // 
            this.columnDist.Text = "Distance";
            this.columnDist.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.columnDist.Width = 66;
            // 
            // columnTaskDist
            // 
            this.columnTaskDist.Text = "Task dist.";
            this.columnTaskDist.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.columnTaskDist.Width = 66;
            // 
            // columnPoints
            // 
            this.columnPoints.Text = "Points";
            this.columnPoints.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // buttonSend
            // 
            this.buttonSend.Location = new System.Drawing.Point(145, 416);
            this.buttonSend.Name = "buttonSend";
            this.buttonSend.Size = new System.Drawing.Size(80, 23);
            this.buttonSend.TabIndex = 37;
            this.buttonSend.Text = "Send to OLC";
            this.buttonSend.Click += new System.EventHandler(this.OnSend);
            // 
            // buttonSave
            // 
            this.buttonSave.Location = new System.Drawing.Point(249, 416);
            this.buttonSave.Name = "buttonSave";
            this.buttonSave.Size = new System.Drawing.Size(80, 23);
            this.buttonSave.TabIndex = 38;
            this.buttonSave.Text = "Save";
            // 
            // buttonFinish
            // 
            this.buttonFinish.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonFinish.Location = new System.Drawing.Point(353, 416);
            this.buttonFinish.Name = "buttonFinish";
            this.buttonFinish.Size = new System.Drawing.Size(80, 23);
            this.buttonFinish.TabIndex = 39;
            this.buttonFinish.Text = "Finish";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(364, 224);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(46, 16);
            this.label1.TabIndex = 40;
            this.label1.Text = "Birthday";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(364, 256);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(46, 16);
            this.label2.TabIndex = 41;
            this.label2.Text = "Birthday";
            // 
            // dateTimePickerPilot1
            // 
            this.dateTimePickerPilot1.Format = System.Windows.Forms.DateTimePickerFormat.Short;
            this.dateTimePickerPilot1.Location = new System.Drawing.Point(420, 224);
            this.dateTimePickerPilot1.Name = "dateTimePickerPilot1";
            this.dateTimePickerPilot1.Size = new System.Drawing.Size(90, 20);
            this.dateTimePickerPilot1.TabIndex = 42;
            // 
            // dateTimePickerPilot2
            // 
            this.dateTimePickerPilot2.Format = System.Windows.Forms.DateTimePickerFormat.Short;
            this.dateTimePickerPilot2.Location = new System.Drawing.Point(420, 256);
            this.dateTimePickerPilot2.Name = "dateTimePickerPilot2";
            this.dateTimePickerPilot2.Size = new System.Drawing.Size(90, 20);
            this.dateTimePickerPilot2.TabIndex = 43;
            // 
            // checkPureGlider
            // 
            this.checkPureGlider.Location = new System.Drawing.Point(112, 352);
            this.checkPureGlider.Name = "checkPureGlider";
            this.checkPureGlider.TabIndex = 44;
            this.checkPureGlider.Text = "pure glider";
            // 
            // textCoPilotSurName
            // 
            this.textCoPilotSurName.Location = new System.Drawing.Point(224, 256);
            this.textCoPilotSurName.Name = "textCoPilotSurName";
            this.textCoPilotSurName.Size = new System.Drawing.Size(96, 20);
            this.textCoPilotSurName.TabIndex = 46;
            this.textCoPilotSurName.Text = "";
            // 
            // textPilotSurName
            // 
            this.textPilotSurName.Location = new System.Drawing.Point(224, 224);
            this.textPilotSurName.Name = "textPilotSurName";
            this.textPilotSurName.Size = new System.Drawing.Size(96, 20);
            this.textPilotSurName.TabIndex = 45;
            this.textPilotSurName.Text = "";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(112, 200);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(50, 16);
            this.label3.TabIndex = 47;
            this.label3.Text = "Prename";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(224, 200);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(50, 16);
            this.label4.TabIndex = 48;
            this.label4.Text = "Surname";
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(42, 384);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(65, 16);
            this.label5.TabIndex = 49;
            this.label5.Text = "Competition";
            // 
            // comboBoxCompetitionCountry
            // 
            this.comboBoxCompetitionCountry.Location = new System.Drawing.Point(112, 384);
            this.comboBoxCompetitionCountry.Name = "comboBoxCompetitionCountry";
            this.comboBoxCompetitionCountry.Size = new System.Drawing.Size(152, 21);
            this.comboBoxCompetitionCountry.Sorted = true;
            this.comboBoxCompetitionCountry.TabIndex = 50;
            // 
            // OLCDialog
            // 
            this.AcceptButton = this.buttonFinish;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(578, 448);
            this.Controls.Add(this.comboBoxCompetitionCountry);
            this.Controls.Add(this.label5);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.textCoPilotSurName);
            this.Controls.Add(this.textPilotSurName);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.textBoxCompId);
            this.Controls.Add(this.label13);
            this.Controls.Add(this.textBoxGliderId);
            this.Controls.Add(this.label12);
            this.Controls.Add(this.label11);
            this.Controls.Add(this.label10);
            this.Controls.Add(this.label9);
            this.Controls.Add(this.textCoPilotPreName);
            this.Controls.Add(this.textPilotPreName);
            this.Controls.Add(this.label8);
            this.Controls.Add(this.checkPureGlider);
            this.Controls.Add(this.dateTimePickerPilot2);
            this.Controls.Add(this.dateTimePickerPilot1);
            this.Controls.Add(this.buttonFinish);
            this.Controls.Add(this.buttonSave);
            this.Controls.Add(this.buttonSend);
            this.Controls.Add(this.listViewTask);
            this.Controls.Add(this.buttonSelectPilot2);
            this.Controls.Add(this.buttonSelectPilot1);
            this.Controls.Add(this.comboBoxCompClass);
            this.Controls.Add(this.comboBoxGlider);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "OLCDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Send to OLC";
            this.ResumeLayout(false);

        }
    
		public OLCDialog(Flight f)
		{
			// 
			// TODO: Add constructor logic here
			//
            InitializeComponent();

            foreach (DictionaryEntry entry in AppContents.gliderIndexes) {
                comboBoxGlider.Items.Add(entry.Value);
            }

            comboBoxCompetitionCountry.Items.AddRange(AppContents.compCountries.ToArray());

            comboBoxCompClass.Items.AddRange(AppContents.compClasses);

            this.flight = f;
            Task t = f.currentTask;
            int i;
            WayPoint wp;
            ListViewItem item;
            double sumPoints = 0, length, points = 0;
            string lStringAll, lStringTask, pString = "";
            OptimizationBase optimizer = null;

            if (t != null) {
                // find optimizer
                foreach (OptimizationBase opt in flight.optimizedTasks) {
                    if (opt.OptimizedTask == t) {
                        optimizer = opt;
                        break;
                    }
                }

                for (i = 0; i < t.Count; i++) {
                    wp = t[i];

                    item = new ListViewItem(wp.longName);
                    item.ImageIndex = 0;
                    // ignore takeoff
                    length = (i > 0 ? wp.distanceKM(t[i - 1]) : 0);
                    lStringAll = (i > 0 ? string.Format(AppContents.ni, "{0:F1} km", length) : "");
                    if (i < t.Count - 1) {
                        lStringTask = lStringAll;
                    }
                    else {
                        lStringTask = "";
                    }
                    if (t.TaskType != TaskTypes.TriangleStartOnLeg) {
                        // no points from takoff -> start
                        // no points from finish -> landing
                        if (i > 1 && i < t.Count - 1 && optimizer != null) {
                            points = length * 100.0 / flight.GliderIndex * optimizer.GetLegWeight(i - 2);
                            pString = string.Format(AppContents.ni, "{0:F1}", points);
                        }
                        else {
                            points = 0.0;
                            pString = "";
                        }
                    }
                    else {
                        // no points from takoff -> start, start -> TP 1
                        // no points from TP 3 -> finish, finish -> landing
                        if (i > 1 && i < t.Count - 2 && optimizer != null) {
                            if (i == 2) {
                                // first TP, get length to last TP
                                length = wp.distanceKM(t[4]);
                                lStringTask = string.Format(AppContents.ni, "{0:F1} km", length);
                            }
                            points = length * 100.0 / flight.GliderIndex * optimizer.GetLegWeight(i - 2);
                            pString = string.Format(AppContents.ni, "{0:F1}", points);
                        }
                        else {
                            points = 0.0;
                            pString = "";
                            lStringTask = "";
                        }
                    }

                    item.SubItems.AddRange(new string [] {wp.ToStringTime(), wp.ToStringLat(), wp.ToStringLong(), lStringAll, lStringTask, pString});
                    listViewTask.Items.Add(item);
                    sumPoints += points;
                }

                item = new ListViewItem("Total");
                item.ImageIndex = 0;
                item.SubItems.AddRange(new string [] {"", "", "", string.Format(AppContents.ni, "{0:F1} km", t.TotalDistanceKM), string.Format(AppContents.ni, "{0:F2} km", t.TaskDistanceKM), string.Format(AppContents.ni, "{0:F1}", sumPoints)});
                listViewTask.Items.Add(item);

                Regex split = new Regex("[ \t]+");
                string []tokens = split.Split(f.Pilot);
                textPilotPreName.Text = tokens.Length > 0 ? tokens[0] : "";
                textPilotSurName.Text = tokens.Length > 1 ? tokens[1] : "";
                textCoPilotPreName.Text = tokens.Length > 2 ? tokens[2] : "";
                textCoPilotSurName.Text = tokens.Length > 3 ? tokens[3] : "";
                textBoxCompId.Text = f.CompetitionId;
                textBoxGliderId.Text = f.GliderId;

                string s = f.Glider.ToUpper().Replace(" ", "");
                if (AppContents.gliderIndexes.ContainsKey(s)) {
                    comboBoxGlider.SelectedItem = AppContents.gliderIndexes[s];
                }

                if ((i = comboBoxCompClass.FindString(f.CompetitionClass)) != -1) {
                    comboBoxCompClass.SelectedIndex = i;
                }
            }
		}

        private void OnSelectPilot1(object sender, System.EventArgs e) {
            SelectPilotDialog d = new SelectPilotDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                textPilotPreName.Text = d.selectedPilot.FirstName;
                textPilotSurName.Text = d.selectedPilot.LastName;
                dateTimePickerPilot1.Value = d.selectedPilot.BirthDay;
            }
        }

        private void OnSelectPilot2(object sender, System.EventArgs e) {
            SelectPilotDialog d = new SelectPilotDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                textCoPilotPreName.Text = d.selectedPilot.FirstName;
                textCoPilotSurName.Text = d.selectedPilot.LastName;
                dateTimePickerPilot2.Value = d.selectedPilot.BirthDay;
            }
        }

        private void OnSend(object sender, System.EventArgs e) {
            if (comboBoxCompetitionCountry.SelectedItem != null) {
                string olc = BuildOlcString();
                Process p = new Process();
                p.StartInfo.FileName = "IEXPLORE.EXE";
                p.StartInfo.Arguments = olc;
                p.Start();
            }
            else {
                MessageBox.Show(this, "Please select a competition first", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }
        }

        private string BuildOlcString() {
            string txt;
            string tmp;
            int i;
            long latDeg, lonDeg;
            double latMin, lonMin;
            WayPoint wp;
            Task olcTask = null;
            Task dmstTask = null;
            Task task = flight.currentTask;
            FlightPoint fp;

            foreach (OptimizationBase opt in flight.optimizedTasks) {
                Task t = opt.OptimizedTask;
                if (t.OptimizedFor == OptimizeTypes.OLC) {
                    olcTask = t;
                }
                if (t == task && (t.OptimizedFor == OptimizeTypes.DMST || t.OptimizedFor == OptimizeTypes.DMSTFreeFlight)) {
                    dmstTask = t;
                }
            }

            txt = ((CompetitionCountry)comboBoxCompetitionCountry.SelectedItem).URL + "?";

            // competitor
            txt += string.Format("OLCvnolc={0}&na={1}&geb={2}&", textPilotPreName.Text, textPilotSurName.Text, dateTimePickerPilot1.Value.ToString("dd.MM.yy"));
            // co pilot
            if (textCoPilotPreName.Text != "") {
                txt += string.Format("bvn={0}&bna={1}&bgeb={2}&", textCoPilotPreName.Text, textCoPilotSurName.Text, dateTimePickerPilot2.Value.ToString("dd.MM.yy"));
            }
            // igcfile and comp. class
            txt += string.Format("igcfn={0}&Klasse={1}&", flight.IGCName, comboBoxCompClass.SelectedItem == null ? 0 : ((CompetitionClass)comboBoxCompClass.SelectedItem).olcId);

            // glider type, call sign, pure glider
            txt += string.Format("igty={0}&gid={1}&flugzeug={2}&", comboBoxGlider.SelectedItem != null ? ((Glider)comboBoxGlider.SelectedItem).Abbreviation : "",
                textBoxGliderId.Text, checkPureGlider.Checked == true ? 1 : 2);

            // takeoff
            tmp = string.Format("{0}", JulianDate(flight.Date));
            wp = olcTask[0];
            fp = wp.reachPoint;
            txt += string.Format("ft={0}&t0={1:00}:{2:00}:{3:00}&", tmp, fp.fixTime / 3600, (fp.fixTime % 3600) / 60, fp.fixTime % 60);

            // start
            wp = olcTask[1];
            fp = wp.reachPoint;
            txt += string.Format("t0={0:00}:{1:00}:{2:00}&", fp.fixTime / 3600, (fp.fixTime % 3600) / 60, fp.fixTime % 60);
            txt += string.Format("s0={0:00}:{1:00}:{2:00}&", fp.fixTime / 3600, (fp.fixTime % 3600) / 60, fp.fixTime % 60);
            // finish
            wp = olcTask[olcTask.Count - 2];
            fp = wp.reachPoint;
            txt += string.Format("s6={0:00}:{1:00}:{2:00}&", fp.fixTime / 3600, (fp.fixTime % 3600) / 60, fp.fixTime % 60);

            // fill OLC fields
            for (i = 1; i < olcTask.Count - 1; i++) {
                wp = olcTask[i];
                fp = wp.reachPoint;
                latDeg = Math.Abs(wp.Latitude) / 360000;
                latMin = (Math.Abs(wp.Latitude) % 360000) / 6000.0;
                lonDeg = Math.Abs(wp.Longitude) / 360000;
                lonMin = (Math.Abs(wp.Longitude) % 360000) / 6000.0;

                txt += string.Format("w{0}bh={1}&w{0}bg={2:00}&w{0}bm={3:00}&w{0}bmd={4:000}&w{0}lh={5}&w{0}lg={6:000}&w{0}lm={7:00}&w{0}lmd={8:000}&", 
                    i - 1,
                    wp.Latitude < 0 ? "N" : "S",
                    latDeg,
                    Math.Floor(latMin),
                    (int)Math.Round((latMin - Math.Floor(latMin)) * 1000.0, 0),
                    wp.Longitude < 0 ? "W" : "E",
                    lonDeg,
                    Math.Floor(lonMin),
                    (int)Math.Round((lonMin - Math.Floor(lonMin)) * 1000.0, 0));
            }

            if (dmstTask != null) {
                // fill in DMST fields
                wp = dmstTask[1];
                fp = wp.reachPoint;
                txt += string.Format("des0={0:00}:{1:00}:{2:00}&", fp.fixTime / 3600, (fp.fixTime % 3600) / 60, fp.fixTime % 60);
                // finish
                wp = dmstTask[dmstTask.Count - 2];
                fp = wp.reachPoint;
                txt += string.Format("des4={0:00}:{1:00}:{2:00}&", fp.fixTime / 3600, (fp.fixTime % 3600) / 60, fp.fixTime % 60);

                for (i = 1; i < dmstTask.Count - 1; i++) {
                    wp = dmstTask[i];
                    fp = wp.reachPoint;
                    latDeg = Math.Abs(wp.Latitude) / 360000;
                    latMin = (Math.Abs(wp.Latitude) % 360000) / 6000.0;
                    lonDeg = Math.Abs(wp.Longitude) / 360000;
                    lonMin = (Math.Abs(wp.Longitude) % 360000) / 6000.0;

                    txt += string.Format("dew{0}debh={1}&dew{0}bg={2:00}&dew{0}bm={3:00}&dew{0}bmd={4:000}&dew{0}lh={5}&dew{0}lg={6:000}&dew{0}lm={7:00}&dew{0}lmd={8:000}&", 
                        i - 1,
                        wp.Latitude < 0 ? "N" : "S",
                        latDeg,
                        Math.Floor(latMin),
                        (int)Math.Round((latMin - Math.Floor(latMin)) * 1000.0, 0),
                        wp.Longitude < 0 ? "W" : "E",
                        lonDeg,
                        Math.Floor(lonMin),
                        (int)Math.Round((lonMin - Math.Floor(lonMin)) * 1000.0, 0));
                }
            }
            return txt;
        }

        private int JulianDate(string date) {
            DateTime d = DateTime.ParseExact(date, new string [] {"dd.MM.yy", "dd.MM.yyyy"}, null, System.Globalization.DateTimeStyles.NoCurrentDateDefault);
            DateTime d2 = new DateTime(1601, 1, 1);
            TimeSpan t = d - d2;
            return t.Days;
        }
	}
}
