// name   : OptimizationBase.cs
// author : Harald Maier
// date   : 02.04.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;

using SoaringDotNET.GUI;

namespace SoaringDotNET.Optimization
{
    public enum OptimizeTypes {Unknown, OLC, DMST, DMSTFreeFlight, OriginalTask};
    public enum OptimizataionStatus {Idle, Running};

    public class FAITriangle {
        public double length;
        public int p1, p2, p3;
        public int idx1, idx2;
    }

	/// <summary>
	/// 
	/// </summary>
	public abstract class OptimizationBase
	{
        protected OptimizataionStatus status = OptimizataionStatus.Idle;
        protected Flight flight;
        protected Task optimizedTask;
        protected double [] weight;

		public OptimizationBase(Flight flight)
		{
			// 
			// TODO: Add constructor logic here
			//
            this.flight = flight;
            optimizedTask = new Task();
		}

        public double GetLegWeight(int leg) {
            return leg < weight.Length ? weight[leg] : 1.0;
        }

        public abstract void Optimize();

        #region Attributes
        public OptimizataionStatus Status {
            get {
                return status;
            }
        }

        public Task OptimizedTask {
            get {
                return optimizedTask;
            }
        }

        #endregion	
    
        public override string ToString() {
            // TODO:  Add OptimizationBase.ToString implementation
            return base.ToString ();
        }
    }
}
