// name   : SectorDefinition.cs
// author : Harald Maier
// date   : 26.09.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;

namespace SoaringDotNET.Data
{
	/// <summary>
	/// 
	/// </summary>
	public enum SectorTypes {Sector, Line, Area};

	public class SectorDefinition
	{
        public SectorTypes sectorType;
        public TurnpointTypes turnpointType;
        public int radius1;
        public int radius2;
        public int directionFrom;
        public int directionTo;
        public int angle;

        public SectorDefinition() : this(TurnpointTypes.Turnpoint){}
        public SectorDefinition(TurnpointTypes turnpointType) {
			// 
			// TODO: Add constructor logic here
			//
            this.turnpointType = turnpointType;
            Reset();
		}
        public SectorDefinition(SectorDefinition source) {
            sectorType = source.sectorType;
            turnpointType = source.turnpointType;
            radius1 = source.radius1;
            radius2 = source.radius2;
            directionFrom = source.directionFrom;
            directionTo = source.directionTo;
            angle = source.angle;
        }

        public void Reset() {
            sectorType = SectorTypes.Sector;
            radius1 = 3000;
            radius2 = 0;
            directionFrom = 360; // automatic calculation
            directionTo = 360; // automatic calculation
            angle = 90;
        }
	
        public override string ToString() {
            // TODO:  Add SectorDefinition.ToString implementation
            return turnpointType == TurnpointTypes.Start ? "Start" : turnpointType == TurnpointTypes.Turnpoint ? "Turnpoint" : "Finish";
        }
    }
}
