// name   : SelectPilotDialog.cs
// author : Harald Maier
// date   : 14.05.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;

using SoaringDotNET.Data;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// 
	/// </summary>
	public class SelectPilotDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.ListBox listBoxPilots;

        public Pilot selectedPilot;

        public SelectPilotDialog() {
            // 
            // TODO: Add constructor logic here
            //
            InitializeComponent();
            foreach (Pilot p in AppContents.pilots) {
                listBoxPilots.Items.Add(p);
            }
        }

        private void InitializeComponent() {
            this.buttonOK = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.listBoxPilots = new System.Windows.Forms.ListBox();
            this.SuspendLayout();
            // 
            // buttonOK
            // 
            this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOK.Location = new System.Drawing.Point(61, 232);
            this.buttonOK.Name = "buttonOK";
            this.buttonOK.TabIndex = 0;
            this.buttonOK.Text = "OK";
            this.buttonOK.Click += new System.EventHandler(this.OnOK);
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(157, 232);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.TabIndex = 1;
            this.buttonCancel.Text = "Cancel";
            // 
            // listBoxPilots
            // 
            this.listBoxPilots.Location = new System.Drawing.Point(24, 16);
            this.listBoxPilots.Name = "listBoxPilots";
            this.listBoxPilots.ScrollAlwaysVisible = true;
            this.listBoxPilots.Size = new System.Drawing.Size(240, 199);
            this.listBoxPilots.Sorted = true;
            this.listBoxPilots.TabIndex = 2;
            this.listBoxPilots.DoubleClick += new System.EventHandler(this.OnOK);
            // 
            // SelectPilotDialog
            // 
            this.AcceptButton = this.buttonOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.buttonCancel;
            this.ClientSize = new System.Drawing.Size(292, 266);
            this.Controls.Add(this.listBoxPilots);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOK);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "SelectPilotDialog";
            this.ShowInTaskbar = false;
            this.Text = "Select Pilot";
            this.ResumeLayout(false);

        }

        private void OnOK(object sender, System.EventArgs e) {
            selectedPilot = (Pilot)listBoxPilots.SelectedItem;
            if (selectedPilot == null) {
                this.DialogResult = System.Windows.Forms.DialogResult.None;
            }
            else {
                this.DialogResult = System.Windows.Forms.DialogResult.OK;
            }
        }    
	}
}
