// name   : SoaringDotNet.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Xml;
using Microsoft.Win32;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;
using SoaringDotNET.Dialogs;
using SoaringDotNET.FileFormats;
using SoaringDotNET.Optimization;

namespace SoaringDotNET
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>

    public delegate void AddGUIObjectDelegate(object o);

    public class SoaringDotNet : System.Windows.Forms.Form {
        public SoaringDotNET.Data.AppContents appContents;
        public WaypointCatalog currentCatalog;
        public Flight currentFlight;
        public Task currentTask;
        public AddGUIObjectDelegate AddWaypointCatalogueDelegate;
        public AddGUIObjectDelegate AddTasksDelegate;
        public AddGUIObjectDelegate AddFlightDelegate;
        public AddGUIObjectDelegate AddPilotsDelegate;

        private System.Windows.Forms.MainMenu mainMenu;
        private System.Windows.Forms.MenuItem menuFile;
        private System.Windows.Forms.MenuItem menuFileExit;
        private System.Windows.Forms.MenuItem menuView;

        private System.Windows.Forms.StatusBar statusBar;
        private System.Windows.Forms.MenuItem menuItem1;
        private System.Windows.Forms.MenuItem menuNewWaypoint;
        private System.Windows.Forms.MenuItem menuNewTask;
        private System.Windows.Forms.MenuItem menuViewMap;
        private System.Windows.Forms.MenuItem menuViewExplorer;
        private System.Windows.Forms.ToolBar toolBar;
        private System.Windows.Forms.ToolBarButton toolBarButtonZoomIn;
        private System.Windows.Forms.ToolBarButton toolBarButtonZoomOut;
        private System.Windows.Forms.ToolBarButton toolBarButton1;
        private System.Windows.Forms.StatusBarPanel statusBarPanelLat;
        private System.Windows.Forms.StatusBarPanel statusBarPanelLong;
        private System.Windows.Forms.MenuItem menuFileOpen;
        private System.Windows.Forms.ToolBarButton toolBarButtonOpenFile;
        private System.Windows.Forms.ToolBarButton toolBarButton2;
        private System.Windows.Forms.TabControl tabControlDetails;
        private SoaringDotNET.Controls.Map map;
        private System.Windows.Forms.ImageList detailTabsImageList;
        private System.Windows.Forms.MenuItem menuViewWaypoint;
        private System.Windows.Forms.MenuItem menuViewTasks;
        private System.Windows.Forms.MenuItem menuViewPilots;
        private System.Windows.Forms.ToolBarButton toolBarButtonPrint;
        private System.Windows.Forms.ToolBarButton toolBarButton3;
        private System.Windows.Forms.ToolBarButton toolBarButtonSetup;
        private System.Windows.Forms.ImageList toolBarImageList16x16;
        private System.Windows.Forms.ToolBarButton toolBarButtonOlc;
        private System.Windows.Forms.ToolBarButton toolBarButtonSaveFile;
        private System.Windows.Forms.MenuItem menuItem2;
        private System.Windows.Forms.MenuItem menuItem3;
        private System.Windows.Forms.ToolBarButton toolBarButtonCenterHome;
        private System.Windows.Forms.ToolBarButton toolBarButtonCenterFlight;
        private System.Windows.Forms.ToolBarButton toolBarButtonCenterTask;
        private System.Windows.Forms.TabPage wayPointsPage;
        private System.Windows.Forms.TabPage tasksPage;
        private System.Windows.Forms.TabPage pilotsPage;
        private SoaringDotNET.Controls.Waypoints waypoints;
        private SoaringDotNET.Controls.Tasks tasks;
        private SoaringDotNET.Controls.Pilots pilots;
        private System.Windows.Forms.Splitter splitter1;
        private SoaringDotNET.Controls.Explorer explorer;
        private System.Windows.Forms.Splitter splitter2;
        private System.Windows.Forms.TabControl tabControlGraphics;
        private System.Windows.Forms.ImageList graphicsTabsImageList;
        private System.Windows.Forms.TabPage mapPage;
        private System.Windows.Forms.TabPage diagramPage;
        private System.Windows.Forms.StatusBarPanel statusBarPanelElevation;
        private System.Windows.Forms.StatusBarPanel statusBarPanelVario;
        private System.Windows.Forms.StatusBarPanel statusBarPanelSpeed;
        private System.Windows.Forms.StatusBarPanel statusBarPanelTime;
        private System.Windows.Forms.TabPage recorderPage;
        private System.Windows.Forms.MenuItem menuTools;
        private System.Windows.Forms.MenuItem menuToolsGenAirspaceDB;
        private SoaringDotNET.Controls.DiagramControl diagramControl;
        private System.Windows.Forms.ToolBarButton toolBarButtonOptimize;
        private System.Windows.Forms.ToolBarButton toolBarButton4;
        private SoaringDotNET.Controls.Recorder recorder;
        private System.Windows.Forms.MenuItem menuItem4;
        private System.Windows.Forms.MenuItem menuFileImportSUA;
        private System.Windows.Forms.MenuItem menuToolEditAirspace;
        private System.Windows.Forms.TabPage statisticPage;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.MenuItem menuToolsGenTerrainDB;
        private System.ComponentModel.IContainer components;
        public SoaringDotNet(AppContents appContents, ArrayList igcFiles) {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
            currentCatalog = null;
            currentFlight = null;
            currentTask = null;

            this.appContents = appContents;

            map.App = this;
            explorer.App = this;
            waypoints.App = this;
            tasks.App = this;
            pilots.App = this;
            diagramControl.Diagram.App = this;
            recorder.App = this;

            ReadConfig();

            this.menuViewMap.Checked = true;
            this.menuViewWaypoint.Checked = true;
            this.menuViewExplorer.Checked = true;
            this.menuViewTasks.Checked = true;
            this.menuViewPilots.Checked = true;

            pilots.ShowPilots();
            foreach(Pilot p in AppContents.pilots) {
                recorder.Add(p);
            }
            
            map.CenterTo(appContents.homePoint);

            AddWaypointCatalogueDelegate = new AddGUIObjectDelegate(AddWaypointCatalogue);
            AddTasksDelegate = new AddGUIObjectDelegate(AddTasks);
            AddFlightDelegate = new AddGUIObjectDelegate(AddFlights);
            AddPilotsDelegate = new AddGUIObjectDelegate(AddPilots);

            foreach (string igcFile in igcFiles) {
                OpenFlight(igcFile);
            }
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(SoaringDotNet));
            this.mainMenu = new System.Windows.Forms.MainMenu();
            this.menuFile = new System.Windows.Forms.MenuItem();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.menuNewWaypoint = new System.Windows.Forms.MenuItem();
            this.menuNewTask = new System.Windows.Forms.MenuItem();
            this.menuFileOpen = new System.Windows.Forms.MenuItem();
            this.menuItem4 = new System.Windows.Forms.MenuItem();
            this.menuFileImportSUA = new System.Windows.Forms.MenuItem();
            this.menuFileExit = new System.Windows.Forms.MenuItem();
            this.menuView = new System.Windows.Forms.MenuItem();
            this.menuViewMap = new System.Windows.Forms.MenuItem();
            this.menuViewExplorer = new System.Windows.Forms.MenuItem();
            this.menuViewWaypoint = new System.Windows.Forms.MenuItem();
            this.menuViewTasks = new System.Windows.Forms.MenuItem();
            this.menuViewPilots = new System.Windows.Forms.MenuItem();
            this.menuTools = new System.Windows.Forms.MenuItem();
            this.menuToolsGenAirspaceDB = new System.Windows.Forms.MenuItem();
            this.menuToolEditAirspace = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.menuItem3 = new System.Windows.Forms.MenuItem();
            this.statusBar = new System.Windows.Forms.StatusBar();
            this.statusBarPanelLat = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelLong = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelTime = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelElevation = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelVario = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelSpeed = new System.Windows.Forms.StatusBarPanel();
            this.toolBar = new System.Windows.Forms.ToolBar();
            this.toolBarButtonOpenFile = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonSaveFile = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton1 = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonZoomIn = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonZoomOut = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton2 = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonCenterHome = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonCenterTask = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonCenterFlight = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton3 = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonPrint = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonSetup = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton4 = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonOptimize = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonOlc = new System.Windows.Forms.ToolBarButton();
            this.toolBarImageList16x16 = new System.Windows.Forms.ImageList(this.components);
            this.detailTabsImageList = new System.Windows.Forms.ImageList(this.components);
            this.graphicsTabsImageList = new System.Windows.Forms.ImageList(this.components);
            this.tabControlGraphics = new System.Windows.Forms.TabControl();
            this.mapPage = new System.Windows.Forms.TabPage();
            this.map = new SoaringDotNET.Controls.Map();
            this.diagramPage = new System.Windows.Forms.TabPage();
            this.diagramControl = new SoaringDotNET.Controls.DiagramControl();
            this.statisticPage = new System.Windows.Forms.TabPage();
            this.label1 = new System.Windows.Forms.Label();
            this.recorderPage = new System.Windows.Forms.TabPage();
            this.recorder = new SoaringDotNET.Controls.Recorder();
            this.tabControlDetails = new System.Windows.Forms.TabControl();
            this.wayPointsPage = new System.Windows.Forms.TabPage();
            this.waypoints = new SoaringDotNET.Controls.Waypoints();
            this.tasksPage = new System.Windows.Forms.TabPage();
            this.tasks = new SoaringDotNET.Controls.Tasks();
            this.pilotsPage = new System.Windows.Forms.TabPage();
            this.pilots = new SoaringDotNET.Controls.Pilots();
            this.explorer = new SoaringDotNET.Controls.Explorer();
            this.splitter1 = new System.Windows.Forms.Splitter();
            this.splitter2 = new System.Windows.Forms.Splitter();
            this.menuToolsGenTerrainDB = new System.Windows.Forms.MenuItem();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLat)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLong)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelElevation)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelVario)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelSpeed)).BeginInit();
            this.tabControlGraphics.SuspendLayout();
            this.mapPage.SuspendLayout();
            this.diagramPage.SuspendLayout();
            this.statisticPage.SuspendLayout();
            this.recorderPage.SuspendLayout();
            this.tabControlDetails.SuspendLayout();
            this.wayPointsPage.SuspendLayout();
            this.tasksPage.SuspendLayout();
            this.pilotsPage.SuspendLayout();
            this.SuspendLayout();
            // 
            // mainMenu
            // 
            this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                     this.menuFile,
                                                                                     this.menuView,
                                                                                     this.menuTools,
                                                                                     this.menuItem2});
            // 
            // menuFile
            // 
            this.menuFile.Index = 0;
            this.menuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                     this.menuItem1,
                                                                                     this.menuFileOpen,
                                                                                     this.menuItem4,
                                                                                     this.menuFileImportSUA,
                                                                                     this.menuFileExit});
            this.menuFile.Text = "&File";
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 0;
            this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                      this.menuNewWaypoint,
                                                                                      this.menuNewTask});
            this.menuItem1.Shortcut = System.Windows.Forms.Shortcut.CtrlN;
            this.menuItem1.Text = "&New";
            // 
            // menuNewWaypoint
            // 
            this.menuNewWaypoint.Index = 0;
            this.menuNewWaypoint.Text = "&Waypoint";
            this.menuNewWaypoint.Click += new System.EventHandler(this.OnNewWaypoint);
            // 
            // menuNewTask
            // 
            this.menuNewTask.Index = 1;
            this.menuNewTask.Text = "&Task";
            this.menuNewTask.Click += new System.EventHandler(this.OnNewTask);
            // 
            // menuFileOpen
            // 
            this.menuFileOpen.Index = 1;
            this.menuFileOpen.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
            this.menuFileOpen.Text = "&Open";
            this.menuFileOpen.Click += new System.EventHandler(this.OnFileOpen);
            // 
            // menuItem4
            // 
            this.menuItem4.Index = 2;
            this.menuItem4.Text = "-";
            // 
            // menuFileImportSUA
            // 
            this.menuFileImportSUA.Index = 3;
            this.menuFileImportSUA.Text = "&Import SUA (Tim Newport)";
            this.menuFileImportSUA.Click += new System.EventHandler(this.OnImportSUA);
            // 
            // menuFileExit
            // 
            this.menuFileExit.Index = 4;
            this.menuFileExit.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
            this.menuFileExit.Text = "E&xit";
            this.menuFileExit.Click += new System.EventHandler(this.OnFileExit);
            // 
            // menuView
            // 
            this.menuView.Index = 1;
            this.menuView.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                     this.menuViewMap,
                                                                                     this.menuViewExplorer,
                                                                                     this.menuViewWaypoint,
                                                                                     this.menuViewTasks,
                                                                                     this.menuViewPilots});
            this.menuView.Text = "&View";
            // 
            // menuViewMap
            // 
            this.menuViewMap.Index = 0;
            this.menuViewMap.Shortcut = System.Windows.Forms.Shortcut.CtrlM;
            this.menuViewMap.Text = "&Map";
            this.menuViewMap.Click += new System.EventHandler(this.OnViewMap);
            // 
            // menuViewExplorer
            // 
            this.menuViewExplorer.Index = 1;
            this.menuViewExplorer.Shortcut = System.Windows.Forms.Shortcut.CtrlE;
            this.menuViewExplorer.Text = "&Explorer";
            this.menuViewExplorer.Click += new System.EventHandler(this.OnViewExplorer);
            // 
            // menuViewWaypoint
            // 
            this.menuViewWaypoint.Index = 2;
            this.menuViewWaypoint.Shortcut = System.Windows.Forms.Shortcut.CtrlW;
            this.menuViewWaypoint.Text = "&Waypoints";
            this.menuViewWaypoint.Click += new System.EventHandler(this.OnViewWaypoint);
            // 
            // menuViewTasks
            // 
            this.menuViewTasks.Index = 3;
            this.menuViewTasks.Shortcut = System.Windows.Forms.Shortcut.CtrlT;
            this.menuViewTasks.Text = "&Tasks";
            this.menuViewTasks.Click += new System.EventHandler(this.OnViewTask);
            // 
            // menuViewPilots
            // 
            this.menuViewPilots.Index = 4;
            this.menuViewPilots.Shortcut = System.Windows.Forms.Shortcut.CtrlP;
            this.menuViewPilots.Text = "&Pilots";
            this.menuViewPilots.Click += new System.EventHandler(this.OnViewPilot);
            // 
            // menuTools
            // 
            this.menuTools.Index = 2;
            this.menuTools.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                      this.menuToolsGenAirspaceDB,
                                                                                      this.menuToolsGenTerrainDB,
                                                                                      this.menuToolEditAirspace});
            this.menuTools.Text = "&Tools";
            // 
            // menuToolsGenAirspaceDB
            // 
            this.menuToolsGenAirspaceDB.Index = 0;
            this.menuToolsGenAirspaceDB.Text = "&Generate airspace database";
            this.menuToolsGenAirspaceDB.Click += new System.EventHandler(this.OnGenerateAirspaceDB);
            // 
            // menuToolEditAirspace
            // 
            this.menuToolEditAirspace.Index = 2;
            this.menuToolEditAirspace.Text = "&Airspace Editor";
            this.menuToolEditAirspace.Click += new System.EventHandler(this.OnAirspaceEditor);
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 3;
            this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                      this.menuItem3});
            this.menuItem2.Text = "&Help";
            // 
            // menuItem3
            // 
            this.menuItem3.Index = 0;
            this.menuItem3.Text = "&About SoaringDotNet";
            this.menuItem3.Click += new System.EventHandler(this.OnAbout);
            // 
            // statusBar
            // 
            this.statusBar.Location = new System.Drawing.Point(0, 699);
            this.statusBar.Name = "statusBar";
            this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
                                                                                         this.statusBarPanelLat,
                                                                                         this.statusBarPanelLong,
                                                                                         this.statusBarPanelTime,
                                                                                         this.statusBarPanelElevation,
                                                                                         this.statusBarPanelVario,
                                                                                         this.statusBarPanelSpeed});
            this.statusBar.ShowPanels = true;
            this.statusBar.Size = new System.Drawing.Size(944, 22);
            this.statusBar.TabIndex = 1;
            this.statusBar.Text = "statusBar1";
            // 
            // statusBarPanelLat
            // 
            this.statusBarPanelLat.Text = "0000\'00\"N";
            this.statusBarPanelLat.Width = 70;
            // 
            // statusBarPanelLong
            // 
            this.statusBarPanelLong.Text = "00000\'00\"E";
            this.statusBarPanelLong.Width = 75;
            // 
            // statusBarPanelTime
            // 
            this.statusBarPanelTime.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelTime.Text = "12:00 UTC";
            this.statusBarPanelTime.Width = 70;
            // 
            // statusBarPanelElevation
            // 
            this.statusBarPanelElevation.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelElevation.Text = "0 m";
            this.statusBarPanelElevation.Width = 70;
            // 
            // statusBarPanelVario
            // 
            this.statusBarPanelVario.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelVario.Text = "0 m/s";
            this.statusBarPanelVario.Width = 70;
            // 
            // statusBarPanelSpeed
            // 
            this.statusBarPanelSpeed.Alignment = System.Windows.Forms.HorizontalAlignment.Right;
            this.statusBarPanelSpeed.Text = "0 km/h";
            this.statusBarPanelSpeed.Width = 70;
            // 
            // toolBar
            // 
            this.toolBar.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
            this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
                                                                                       this.toolBarButtonOpenFile,
                                                                                       this.toolBarButtonSaveFile,
                                                                                       this.toolBarButton1,
                                                                                       this.toolBarButtonZoomIn,
                                                                                       this.toolBarButtonZoomOut,
                                                                                       this.toolBarButton2,
                                                                                       this.toolBarButtonCenterHome,
                                                                                       this.toolBarButtonCenterTask,
                                                                                       this.toolBarButtonCenterFlight,
                                                                                       this.toolBarButton3,
                                                                                       this.toolBarButtonPrint,
                                                                                       this.toolBarButtonSetup,
                                                                                       this.toolBarButton4,
                                                                                       this.toolBarButtonOptimize,
                                                                                       this.toolBarButtonOlc});
            this.toolBar.ButtonSize = new System.Drawing.Size(16, 16);
            this.toolBar.DropDownArrows = true;
            this.toolBar.ImageList = this.toolBarImageList16x16;
            this.toolBar.Location = new System.Drawing.Point(0, 0);
            this.toolBar.Name = "toolBar";
            this.toolBar.ShowToolTips = true;
            this.toolBar.Size = new System.Drawing.Size(944, 28);
            this.toolBar.TabIndex = 7;
            this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.OnToolbarClick);
            // 
            // toolBarButtonOpenFile
            // 
            this.toolBarButtonOpenFile.ImageIndex = 0;
            this.toolBarButtonOpenFile.ToolTipText = "Open File";
            // 
            // toolBarButtonSaveFile
            // 
            this.toolBarButtonSaveFile.ImageIndex = 1;
            this.toolBarButtonSaveFile.ToolTipText = "Save File";
            // 
            // toolBarButton1
            // 
            this.toolBarButton1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // toolBarButtonZoomIn
            // 
            this.toolBarButtonZoomIn.ImageIndex = 2;
            this.toolBarButtonZoomIn.ToolTipText = "Zoom in";
            // 
            // toolBarButtonZoomOut
            // 
            this.toolBarButtonZoomOut.ImageIndex = 3;
            this.toolBarButtonZoomOut.ToolTipText = "Zoom out";
            // 
            // toolBarButton2
            // 
            this.toolBarButton2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // toolBarButtonCenterHome
            // 
            this.toolBarButtonCenterHome.ImageIndex = 4;
            this.toolBarButtonCenterHome.ToolTipText = "Center to homepoint";
            // 
            // toolBarButtonCenterTask
            // 
            this.toolBarButtonCenterTask.ImageIndex = 5;
            this.toolBarButtonCenterTask.ToolTipText = "Center to task";
            // 
            // toolBarButtonCenterFlight
            // 
            this.toolBarButtonCenterFlight.ImageIndex = 6;
            this.toolBarButtonCenterFlight.ToolTipText = "Center to flight";
            // 
            // toolBarButton3
            // 
            this.toolBarButton3.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // toolBarButtonPrint
            // 
            this.toolBarButtonPrint.ImageIndex = 7;
            this.toolBarButtonPrint.ToolTipText = "Print";
            // 
            // toolBarButtonSetup
            // 
            this.toolBarButtonSetup.ImageIndex = 8;
            this.toolBarButtonSetup.ToolTipText = "Configure SoaringDotNet";
            // 
            // toolBarButton4
            // 
            this.toolBarButton4.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // toolBarButtonOptimize
            // 
            this.toolBarButtonOptimize.ImageIndex = 9;
            this.toolBarButtonOptimize.ToolTipText = "Optimize Flight";
            // 
            // toolBarButtonOlc
            // 
            this.toolBarButtonOlc.ImageIndex = 10;
            this.toolBarButtonOlc.ToolTipText = "Send to OLC";
            // 
            // toolBarImageList16x16
            // 
            this.toolBarImageList16x16.ImageSize = new System.Drawing.Size(16, 16);
            this.toolBarImageList16x16.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("toolBarImageList16x16.ImageStream")));
            this.toolBarImageList16x16.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // detailTabsImageList
            // 
            this.detailTabsImageList.ImageSize = new System.Drawing.Size(16, 16);
            this.detailTabsImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("detailTabsImageList.ImageStream")));
            this.detailTabsImageList.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // graphicsTabsImageList
            // 
            this.graphicsTabsImageList.ImageSize = new System.Drawing.Size(16, 16);
            this.graphicsTabsImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("graphicsTabsImageList.ImageStream")));
            this.graphicsTabsImageList.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // tabControlGraphics
            // 
            this.tabControlGraphics.Controls.Add(this.mapPage);
            this.tabControlGraphics.Controls.Add(this.diagramPage);
            this.tabControlGraphics.Controls.Add(this.statisticPage);
            this.tabControlGraphics.Controls.Add(this.recorderPage);
            this.tabControlGraphics.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tabControlGraphics.ImageList = this.graphicsTabsImageList;
            this.tabControlGraphics.Location = new System.Drawing.Point(203, 28);
            this.tabControlGraphics.Name = "tabControlGraphics";
            this.tabControlGraphics.SelectedIndex = 0;
            this.tabControlGraphics.Size = new System.Drawing.Size(741, 453);
            this.tabControlGraphics.TabIndex = 12;
            // 
            // mapPage
            // 
            this.mapPage.Controls.Add(this.map);
            this.mapPage.ImageIndex = 0;
            this.mapPage.Location = new System.Drawing.Point(4, 23);
            this.mapPage.Name = "mapPage";
            this.mapPage.Size = new System.Drawing.Size(733, 426);
            this.mapPage.TabIndex = 0;
            this.mapPage.Text = "Map";
            this.mapPage.Leave += new System.EventHandler(this.OnLeaveMapPage);
            // 
            // map
            // 
            this.map.App = null;
            this.map.BackColor = System.Drawing.Color.AliceBlue;
            this.map.Cursor = System.Windows.Forms.Cursors.Cross;
            this.map.Dock = System.Windows.Forms.DockStyle.Fill;
            this.map.Location = new System.Drawing.Point(0, 0);
            this.map.Name = "map";
            this.map.Size = new System.Drawing.Size(733, 426);
            this.map.TabIndex = 0;
            // 
            // diagramPage
            // 
            this.diagramPage.AutoScroll = true;
            this.diagramPage.Controls.Add(this.diagramControl);
            this.diagramPage.ImageIndex = 1;
            this.diagramPage.Location = new System.Drawing.Point(4, 23);
            this.diagramPage.Name = "diagramPage";
            this.diagramPage.Size = new System.Drawing.Size(733, 432);
            this.diagramPage.TabIndex = 1;
            this.diagramPage.Text = "Diagram";
            // 
            // diagramControl
            // 
            this.diagramControl.AutoScroll = true;
            this.diagramControl.Dock = System.Windows.Forms.DockStyle.Fill;
            this.diagramControl.Location = new System.Drawing.Point(0, 0);
            this.diagramControl.Name = "diagramControl";
            this.diagramControl.Size = new System.Drawing.Size(733, 432);
            this.diagramControl.TabIndex = 0;
            // 
            // statisticPage
            // 
            this.statisticPage.Controls.Add(this.label1);
            this.statisticPage.ImageIndex = 3;
            this.statisticPage.Location = new System.Drawing.Point(4, 23);
            this.statisticPage.Name = "statisticPage";
            this.statisticPage.Size = new System.Drawing.Size(733, 432);
            this.statisticPage.TabIndex = 3;
            this.statisticPage.Text = "Statistic";
            // 
            // label1
            // 
            this.label1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 48F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Italic))), System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.label1.ForeColor = System.Drawing.Color.IndianRed;
            this.label1.Location = new System.Drawing.Point(0, 0);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(733, 432);
            this.label1.TabIndex = 0;
            this.label1.Text = "comming soon";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // recorderPage
            // 
            this.recorderPage.Controls.Add(this.recorder);
            this.recorderPage.ImageIndex = 2;
            this.recorderPage.Location = new System.Drawing.Point(4, 23);
            this.recorderPage.Name = "recorderPage";
            this.recorderPage.Size = new System.Drawing.Size(733, 432);
            this.recorderPage.TabIndex = 2;
            this.recorderPage.Text = "Recorder";
            // 
            // recorder
            // 
            this.recorder.App = null;
            this.recorder.Cursor = System.Windows.Forms.Cursors.Default;
            this.recorder.Dock = System.Windows.Forms.DockStyle.Fill;
            this.recorder.DockPadding.All = 5;
            this.recorder.Location = new System.Drawing.Point(0, 0);
            this.recorder.Name = "recorder";
            this.recorder.Size = new System.Drawing.Size(733, 432);
            this.recorder.TabIndex = 0;
            // 
            // tabControlDetails
            // 
            this.tabControlDetails.Controls.Add(this.wayPointsPage);
            this.tabControlDetails.Controls.Add(this.tasksPage);
            this.tabControlDetails.Controls.Add(this.pilotsPage);
            this.tabControlDetails.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.tabControlDetails.ImageList = this.detailTabsImageList;
            this.tabControlDetails.Location = new System.Drawing.Point(0, 484);
            this.tabControlDetails.Name = "tabControlDetails";
            this.tabControlDetails.SelectedIndex = 0;
            this.tabControlDetails.Size = new System.Drawing.Size(944, 215);
            this.tabControlDetails.TabIndex = 8;
            // 
            // wayPointsPage
            // 
            this.wayPointsPage.Controls.Add(this.waypoints);
            this.wayPointsPage.ImageIndex = 0;
            this.wayPointsPage.Location = new System.Drawing.Point(4, 23);
            this.wayPointsPage.Name = "wayPointsPage";
            this.wayPointsPage.Size = new System.Drawing.Size(936, 188);
            this.wayPointsPage.TabIndex = 0;
            this.wayPointsPage.Text = "Waypoints";
            // 
            // waypoints
            // 
            this.waypoints.App = null;
            this.waypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.waypoints.Location = new System.Drawing.Point(0, 0);
            this.waypoints.Name = "waypoints";
            this.waypoints.Size = new System.Drawing.Size(936, 188);
            this.waypoints.TabIndex = 0;
            // 
            // tasksPage
            // 
            this.tasksPage.Controls.Add(this.tasks);
            this.tasksPage.ImageIndex = 1;
            this.tasksPage.Location = new System.Drawing.Point(4, 23);
            this.tasksPage.Name = "tasksPage";
            this.tasksPage.Size = new System.Drawing.Size(936, 188);
            this.tasksPage.TabIndex = 1;
            this.tasksPage.Text = "Task definition";
            // 
            // tasks
            // 
            this.tasks.App = null;
            this.tasks.AutoScroll = true;
            this.tasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tasks.Location = new System.Drawing.Point(0, 0);
            this.tasks.Name = "tasks";
            this.tasks.Size = new System.Drawing.Size(936, 188);
            this.tasks.TabIndex = 0;
            // 
            // pilotsPage
            // 
            this.pilotsPage.Controls.Add(this.pilots);
            this.pilotsPage.ImageIndex = 2;
            this.pilotsPage.Location = new System.Drawing.Point(4, 23);
            this.pilotsPage.Name = "pilotsPage";
            this.pilotsPage.Size = new System.Drawing.Size(936, 188);
            this.pilotsPage.TabIndex = 2;
            this.pilotsPage.Text = "Pilots";
            // 
            // pilots
            // 
            this.pilots.App = null;
            this.pilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pilots.Location = new System.Drawing.Point(0, 0);
            this.pilots.Name = "pilots";
            this.pilots.Size = new System.Drawing.Size(936, 188);
            this.pilots.TabIndex = 0;
            // 
            // explorer
            // 
            this.explorer.App = null;
            this.explorer.Dock = System.Windows.Forms.DockStyle.Left;
            this.explorer.Location = new System.Drawing.Point(0, 28);
            this.explorer.Name = "explorer";
            this.explorer.Size = new System.Drawing.Size(200, 453);
            this.explorer.TabIndex = 10;
            // 
            // splitter1
            // 
            this.splitter1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.splitter1.Location = new System.Drawing.Point(0, 481);
            this.splitter1.Name = "splitter1";
            this.splitter1.Size = new System.Drawing.Size(944, 3);
            this.splitter1.TabIndex = 9;
            this.splitter1.TabStop = false;
            // 
            // splitter2
            // 
            this.splitter2.Location = new System.Drawing.Point(200, 28);
            this.splitter2.Name = "splitter2";
            this.splitter2.Size = new System.Drawing.Size(3, 453);
            this.splitter2.TabIndex = 11;
            this.splitter2.TabStop = false;
            // 
            // menuToolsGenTerrainDB
            // 
            this.menuToolsGenTerrainDB.Index = 1;
            this.menuToolsGenTerrainDB.Text = "Generate &terrain DB for SoaringPilot";
            this.menuToolsGenTerrainDB.Click += new System.EventHandler(this.OnGenerateTerrainDB);
            // 
            // SoaringDotNet
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(944, 721);
            this.Controls.Add(this.tabControlGraphics);
            this.Controls.Add(this.splitter2);
            this.Controls.Add(this.explorer);
            this.Controls.Add(this.splitter1);
            this.Controls.Add(this.tabControlDetails);
            this.Controls.Add(this.statusBar);
            this.Controls.Add(this.toolBar);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Menu = this.mainMenu;
            this.Name = "SoaringDotNet";
            this.Text = "SoaringDotNET";
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLat)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelLong)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelElevation)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelVario)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelSpeed)).EndInit();
            this.tabControlGraphics.ResumeLayout(false);
            this.mapPage.ResumeLayout(false);
            this.diagramPage.ResumeLayout(false);
            this.statisticPage.ResumeLayout(false);
            this.recorderPage.ResumeLayout(false);
            this.tabControlDetails.ResumeLayout(false);
            this.wayPointsPage.ResumeLayout(false);
            this.tasksPage.ResumeLayout(false);
            this.pilotsPage.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        #region Protected Functions
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        protected override void OnClosing(CancelEventArgs e) {
            // TODO:  Add SoaringDotNet.OnClosing implementation
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            string defaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");

            foreach (WaypointCatalog c in AppContents.waypointCatalogs) {
                if (c.Dirty) {
                    switch (MessageBox.Show(this, string.Format("{0} is modified!\n\nSave changes?", c.Name), "Warning", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation)) {
                    case DialogResult.Yes:
                        c.Save(AppContents.tasks, defaultWaypointPath);
                        break;
                    case DialogResult.Cancel:
                        e.Cancel = true;
                        break;
                    }
                }
                if (e.Cancel) {
                    break;
                }
            }
            SaveConfig();
            base.OnClosing (e);
        }

        #endregion

        #region Private Functions
        private void OnImportSUA(object sender, System.EventArgs e) {
            OpenFileDialog fd = new OpenFileDialog();
            fd.Filter = "SUA files (Tim Newport-Peace)(*.sua)|*.sua|All files (*.*)|*.*";
            fd.Multiselect = true;
            RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");
            string destPath = (string)currentUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace");

            ArrayList suas = new ArrayList();
            if (fd.ShowDialog(this) == DialogResult.OK) {
                foreach (string file in fd.FileNames) {
                    try {
                        SUAFileHandlerTimNewport fileHandler = new SUAFileHandlerTimNewport();
                        using (StreamReader inStream = new StreamReader(file)) {
                             suas.AddRange(fileHandler.ReadFile(inStream));
                        }
                        DafifCountry c = new DafifCountry();
                        c.code = "XX";
                        c.name = "Unknown";
                        SoaringDotNET.Database.AirspaceGenerator.AppendDatabase(c, suas, DateTime.Now, destPath);
                    }
                    catch (Exception ex) {
                        MessageBox.Show("Error occured while reading file\n\n" + file + "\n\n" +
                            ex.Message + "\n\n" + ex.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }
                appContents.ReloadAirspace();
                map.RedrawMap();
            }
        }

        private void OnAirspaceEditor(object sender, System.EventArgs e) {
            AirspaceDialog d = new AirspaceDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                appContents.ReloadAirspace();
                map.RedrawMap();
            }
        }

        private void OnFileExit(object sender, System.EventArgs e) {
            this.Close();
        }

        private void OnNewWaypoint(object sender, System.EventArgs e) {
            AddWaypoint();
        }

        private void OnNewTask(object sender, System.EventArgs e) {
            NewTask();
        }

        private void OnViewWaypoint(object sender, System.EventArgs e) {
            bool isChecked = !this.menuViewWaypoint.Checked;
            if (isChecked) {
                if (!tabControlDetails.Visible) {
                    tabControlDetails.Show();
                }
                waypoints.Show();
                tabControlDetails.TabPages.Add(wayPointsPage);
                tabControlDetails.SelectedTab = wayPointsPage;
            }
            else {
                waypoints.Hide();
                tabControlDetails.TabPages.Remove(wayPointsPage);
                if (tabControlDetails.TabCount < 1) {
                    tabControlDetails.Hide();
                }
            }
            this.menuViewWaypoint.Checked = isChecked;
        }

        private void OnViewMap(object sender, System.EventArgs e) {
            bool isChecked = !this.menuViewMap.Checked;
            if (isChecked) {
                map.Show();
            }
            else {
                map.Hide();
            }
            this.menuViewMap.Checked = isChecked;        
        }

        private void OnViewExplorer(object sender, System.EventArgs e) {
            bool isChecked = !this.menuViewExplorer.Checked;
            if (isChecked) {
                explorer.Show();
            }
            else {
                explorer.Hide();
            }
            this.menuViewExplorer.Checked = isChecked;        
        }

        private void OnViewTask(object sender, System.EventArgs e) {
            bool isChecked = !this.menuViewTasks.Checked;
            if (isChecked) {
                if (!tabControlDetails.Visible) {
                    tabControlDetails.Show();
                }
                tasks.Show();
                tabControlDetails.TabPages.Add(tasksPage);
                tabControlDetails.SelectedTab = tasksPage;
            }
            else {
                tasks.Hide();
                tabControlDetails.TabPages.Remove(tasksPage);
                if (tabControlDetails.TabCount < 1) {
                    tabControlDetails.Hide();
                }
            }
            this.menuViewTasks.Checked = isChecked;                
        }

        private void OnViewPilot(object sender, System.EventArgs e) {
            bool isChecked = !this.menuViewPilots.Checked;
            if (isChecked) {
                if (!tabControlDetails.Visible) {
                    tabControlDetails.Show();
                }
                pilots.Show();
                tabControlDetails.TabPages.Add(pilotsPage);
                tabControlDetails.SelectedTab = pilotsPage;
            }
            else {
                pilots.Hide();
                tabControlDetails.TabPages.Remove(pilotsPage);
                if (tabControlDetails.TabCount < 1) {
                    tabControlDetails.Hide();
                }
            }
            this.menuViewPilots.Checked = isChecked;
        }

        private void OnGenerateAirspaceDB(object sender, System.EventArgs e) {
            GenAirspaceDBDialog d = new GenAirspaceDBDialog();
            d.ShowDialog(this);
            appContents.ReloadAirspace();
            map.RedrawMap();
        }

        private void OnToolbarClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e) {
            if (e.Button == toolBarButtonZoomOut) {
                if (map.Visible) {
                    map.OnZoomOut();
                }
                else if (diagramControl.Visible) {
                    diagramControl.Diagram.OnZoomOut();
                }
            }
            else if (e.Button == toolBarButtonZoomIn) {
                if (map.Visible) {
                    map.OnZoomIn();
                }
                else if (diagramControl.Visible) {
                    diagramControl.Diagram.OnZoomIn();
                }
            }
            else if (e.Button == toolBarButtonCenterHome) {
                if (map.Visible) {
                    map.OnCenterHome();
                }
            }
            else if (e.Button == toolBarButtonCenterTask) {
                if (map.Visible) {
                    map.OnCenterTask();
                }
            }
            else if (e.Button == toolBarButtonCenterFlight) {
                if (map.Visible) {
                    map.OnCenterFlight();
                }
            }
            else if (e.Button == toolBarButtonOpenFile) {
                OpenFile(FileTypeId.All);
            }
            else if (e.Button == toolBarButtonSaveFile) {
            }
            else if (e.Button == toolBarButtonPrint) {
                if (currentCatalog != null) {
                    currentCatalog.Print();
                }
            }
            else if (e.Button == toolBarButtonSetup) {
                OnSetup();
            }
            else if (e.Button == toolBarButtonOlc) {
                OnSendOLC();
            }
            else if (e.Button == toolBarButtonOptimize) {
                OptimizeFlight();
            }
        }

        private void OpenFile(FileTypeId preselection) {
            OpenFileDialog fd = new OpenFileDialog();
            fd.Filter = "All known types|*.igc;*.cup;*.dbt;*.dat|IGC files (*.igc)|*.igc|All known Catalogs|*.dbt;*.cup;*.dat|All known tasks|*.cup|All files (*.*)|*.*";
            fd.Multiselect = true;
            RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            switch (preselection) {
            case FileTypeId.All:
                fd.FilterIndex = 1;
                break;
            case FileTypeId.Flight:
                fd.FilterIndex = 2;
                fd.InitialDirectory = (string)currentUser.GetValue("DefaultFlightPath", "");
                break;
            case FileTypeId.Waypoint:
                fd.FilterIndex = 3;
                fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");
                break;
            case FileTypeId.Task:
                fd.FilterIndex = 4;
                fd.InitialDirectory = (string)currentUser.GetValue("DefaultWaypointPath", "");
                break;
            default:
                fd.FilterIndex = 5;
                break;
            }
            if (fd.ShowDialog(this) == DialogResult.OK) {
                foreach (string file in fd.FileNames) {
                    try {
                        FileInfo fi = new FileInfo(file);
                        switch (fi.Extension.ToLower()) {
                        case ".igc":
                            OpenFlight(file);
                            break;
                        case ".dat":
                        case ".dbt":
                        case ".cup":
                            OpenCatalog(file);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.Show("Error occured while reading file\n\n" + file + "\n\n" +
                            ex.Message + "\n\n" + ex.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }
                map.RedrawMap();
                diagramControl.Diagram.RedrawDiagram(diagramControl.Diagram.CreateGraphics());
            }
        }

        private void OnFileOpen(object sender, System.EventArgs e) {
            OpenFile(FileTypeId.All);
        }

        private void SaveConfig() {
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Window");
            currUser.SetValue("State", WindowState == FormWindowState.Maximized ? (int)FormWindowState.Maximized : (int)FormWindowState.Normal);
            if (WindowState == FormWindowState.Normal) {
                currUser.SetValue("Width", this.Width);
                currUser.SetValue("Height", this.Height);
            }

            currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Home");
            currUser.SetValue("Name", appContents.homePoint.longName);
            currUser.SetValue("Latitude", appContents.homePoint.Latitude);
            currUser.SetValue("Longitude", appContents.homePoint.Longitude);

            if (currentCatalog != null && currentCatalog.FileName != null) {
                currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet");
                currUser.SetValue("Waypoint Catalogue", currentCatalog.FileName);
            }
        }

        private void ReadConfig() {
            int lat, lon;
            string name = "";
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Window");
            WindowState = (FormWindowState)currUser.GetValue("State", FormWindowState.Normal);
            if (WindowState == FormWindowState.Normal) {
                this.Width = (int)currUser.GetValue("Width", 500);
                this.Height = (int)currUser.GetValue("Height", 500);
            }

            currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Home");

            name = (string)currUser.GetValue("Name", "LAUPHEIM");
            lat = (int)currUser.GetValue("Latitude", -((48 * 360000) + (13 * 6000) + (13 * 100)));
            lon = (int)currUser.GetValue("Longitude", (9 * 360000) + (54 * 6000) + (37 * 100));
            appContents.homePoint = new WayPoint(lat, lon, name);

            currUser = Registry.CurrentUser.OpenSubKey("Software\\SoaringDotNet");
            name = (string)currUser.GetValue("Waypoint Catalogue", "");
            if (name != "") {
                OpenCatalog(name);
            }
        }

        private void OnAbout(object sender, System.EventArgs e) {
            About d = new About();
            d.ShowDialog(this);
        }

        private void OnSendOLC() {
            if (currentFlight != null) {
                OLCDialog d = new OLCDialog(currentFlight);
                d.ShowDialog(this);
            }
            else {
                MessageBox.Show("No flight selected.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private void OnSetup() {
            SetupDialog sd = new SetupDialog();
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            sd.DefaultFlightPath = (string)currUser.GetValue("DefaultFlightPath", "");;
            sd.DefaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");
            sd.SUAPath = (string)currUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace");

            foreach (MapColor c in AppContents.allColors) {
                sd.AddColor(c);
            }

            sd.AddSector((SectorDefinition)AppContents.defaultSectors[TurnpointTypes.Start]);
            sd.AddSector((SectorDefinition)AppContents.defaultSectors[TurnpointTypes.Turnpoint]);
            sd.AddSector((SectorDefinition)AppContents.defaultSectors[TurnpointTypes.Finish]);

            if (sd.ShowDialog(this) == DialogResult.OK) {
                currUser.SetValue("DefaultFlightPath", sd.DefaultFlightPath);
                currUser.SetValue("DefaultWaypointPath", sd.DefaultWaypointPath);
                if ((string)currUser.GetValue("AirspacePath", Application.StartupPath + @"\airspace") != sd.SUAPath) {
                    currUser.SetValue("AirspacePath", sd.SUAPath);
                }
                currUser.Close();
                appContents.SaveColors();
                appContents.SaveSectors();
                appContents.ReloadAirspace();
                if (currentTask != null) {
                    currentTask.SetSectorTypes();
                }
                else if (currentFlight != null) {
                    currentFlight.currentTask.SetSectorTypes();
                }
                map.RedrawMap();
            }
        }

        private void UpdatePanel(int lat, int lon, int time, int elevation, double speed, double vario) {
            this.statusBarPanelLat.Text = lat != -1 ? WgsPoint.ToString(lat, true) : "";
            this.statusBarPanelLong.Text = lon != -1 ? WgsPoint.ToString(lon, false) : "";
            this.statusBarPanelElevation.Text = elevation != -1 ? string.Format("{0} m", elevation) : "";
            this.statusBarPanelSpeed.Text = speed != -1 ? string.Format(AppContents.ni, "{0:F0} km/h", speed) : "";
            this.statusBarPanelTime.Text = time != -1 ? SoaringDotNET.Data.Time.ToTimeString(time) : "";
            this.statusBarPanelVario.Text = vario != -1 ? string.Format(AppContents.ni, "{0:F1} m/s", vario) : "";
        }

        private void OpenCatalog(string fName) {
            if (File.Exists(fName)) {
                WaypointCatalog k = new WaypointCatalog();
                ArrayList tasks = new ArrayList();
                k.Load(fName, tasks);
                AppContents.waypointCatalogs.Add(k);
                explorer.Add(k);
                recorder.Add(k);
                AppContents.tasks.AddRange(tasks);
                foreach(Task t in tasks) {
                    explorer.Add(t);
                    recorder.Add(t);
                }
            }
        }

        private void OpenFlight(string fName) {
            if (File.Exists(fName)) {
                Flight f = new Flight(fName);
                AppContents.flights.Add(f);
                explorer.Add(f);
            }
        }

        private void OnLeaveMapPage(object sender, System.EventArgs e) {
            map.HideToolTip();
        }

        private void OnGenerateTerrainDB(object sender, System.EventArgs e) {
            GenTerrainDb4SoaringPilotDialog d = new GenTerrainDb4SoaringPilotDialog();
            d.ShowDialog(this);
        }

        #endregion

        #region Public Functions
        public void UpdatePosInfo() {
            UpdatePanel(-1, -1, -1, -1, -1, -1);
        }

        public void UpdatePosInfo(int lat, int lon) {
            UpdatePanel(lat, lon, -1, -1, -1, -1);
        }

        public void UpdatePosInfo(int lat, int lon, int time, int elevation, double speed, double vario) {
            UpdatePanel(lat, lon, time, elevation, speed, vario);
        }

        public void OpenFlight() {
            OpenFile(FileTypeId.Flight);
        }

        public void OptimizeFlight() {
            if (currentFlight != null) {
                OptimizationDialog d = new OptimizationDialog(currentFlight);
                d.Diagram.App = this;
                if (d.ShowDialog(this) == DialogResult.OK && d.OptimizedTask != null) {
                    currentFlight.currentTask = d.OptimizedTask;
                    currentFlight.CalcFlightArea();
                    map.RedrawMap();
                    diagramPage.Refresh();
                    explorer.Update(currentFlight);
                }
            }
        }

        public void Close(Flight f) {
            AppContents.flights.Remove(f);
        }

        public void Close(Task t) {
            AppContents.tasks.Remove(t);
            recorder.Remove(t);
        }

        public void Close(WaypointCatalog c) {
            AppContents.waypointCatalogs.Remove(c);
            recorder.Remove(c);
        }

        public void NewCatalog() {
            WaypointCatalog c = appContents.NewCatalog();
            explorer.Add(c);
            recorder.Add(c);
        }

        public void NewTask() {
            Task t = new Task(string.Format("Task{0}", AppContents.tasks.Count + 1));
            AppContents.tasks.Add(t);
            explorer.Add(t);
            recorder.Add(t);
            tasks.Switch(t);
        }

        public void AddWaypoint(int lat, int lon) {
            WaypointDialog d = new WaypointDialog(this);

            d.latEdit.Value = lat;
            d.lonEdit.Value = lon;

            if (d.ShowDialog() == DialogResult.OK) {
                WayPoint wp = new WayPoint(d.latEdit.Value, d.lonEdit.Value, d.name.Text);
                wp.Elevation = d.elevationEdit.Text != "" ? int.Parse(d.elevationEdit.Text) : -1;
                if (d.typeCombo.SelectedItem != null) {
                    wp.type = (WayPointTypeId)((IdType)d.typeCombo.SelectedItem).id;
                }
                wp.description = d.descriptionEdit.Text;
                wp.icao = d.icaoEdit.Text;
                wp.landable = d.landabeCheck.Checked;
                wp.runway = d.runwayEdit.Text;
                wp.frequency = d.frequencyEdit.Text;
                if (d.lenghtEdit.Text != "") {
                    wp.length = int.Parse(d.lenghtEdit.Text);
                }
                if (d.surfaceCombo.SelectedItem != null) {
                    wp.surface = (SurfaceTypeId)((IdType)d.surfaceCombo.SelectedItem).id;
                }
                wp.comment = d.commentEdit.Text;

                if (d.countryCombo.SelectedItem != null) {
                    wp.country = (CountryTypeId)((IdType)d.countryCombo.SelectedItem).id;
                }

                waypoints.Add(wp);
                map.RedrawMap();
                explorer.Update(currentCatalog);
                tasks.Add(wp);
                recorder.Update(currentCatalog);
            }
        }

        public void AddWaypoint() {
            WaypointDialog d = new WaypointDialog(this);
            if (d.ShowDialog() == DialogResult.OK) {
                WayPoint wp = new WayPoint(d.latEdit.Value, d.lonEdit.Value, d.name.Text);
                wp.Elevation = d.elevationEdit.Text != "" ? int.Parse(d.elevationEdit.Text) : -1;
                if (d.typeCombo.SelectedItem != null) {
                    wp.type = (WayPointTypeId)((IdType)d.typeCombo.SelectedItem).id;
                }
                wp.description = d.descriptionEdit.Text;
                wp.icao = d.icaoEdit.Text;
                wp.landable = d.landabeCheck.Checked;
                wp.runway = d.runwayEdit.Text;
                wp.frequency = d.frequencyEdit.Text;
                if (d.lenghtEdit.Text != "") {
                    wp.length = int.Parse(d.lenghtEdit.Text);
                }
                if (d.surfaceCombo.SelectedItem != null) {
                    wp.surface = (SurfaceTypeId)((IdType)d.surfaceCombo.SelectedItem).id;
                }
                wp.comment = d.commentEdit.Text;

                if (d.countryCombo.SelectedItem != null) {
                    wp.country = (CountryTypeId)((IdType)d.countryCombo.SelectedItem).id;
                }

                waypoints.Add(wp);
                map.RedrawMap();
                explorer.Update(currentCatalog);
                recorder.Update(currentCatalog);
            }
        }

        public void EditWaypoint(WayPoint old) {
            WaypointDialog d = new WaypointDialog(this);
            d.name.Text = old.longName;
            d.shortName.Text = old.shortName;
            d.latEdit.Value = old.Latitude;
            d.lonEdit.Value = old.Longitude;
            if (old.Elevation != -1) {
                d.elevationEdit.Text = old.Elevation.ToString();
            }
            d.typeCombo.SelectedItem = appContents.waypointTypes.getIdType((int)old.type);
            d.descriptionEdit.Text = old.description;
            d.icaoEdit.Text = old.icao;
            d.landabeCheck.Checked = old.landable;
            d.runwayEdit.Text = old.runway;
            d.frequencyEdit.Text = old.frequency;
            if (old.length != -1) {
                d.lenghtEdit.Text = old.length.ToString();
            }
            d.surfaceCombo.SelectedItem = appContents.surfaceTypes.getIdType((int)old.surface);
            old.comment = d.commentEdit.Text;
            d.countryCombo.SelectedItem = appContents.countryTypes.getIdType((int)old.country);

            if (d.ShowDialog() == DialogResult.OK) {
                WayPoint wp = new WayPoint(d.latEdit.Value, d.lonEdit.Value, d.name.Text);
                wp.Elevation = d.elevationEdit.Text != "" ? int.Parse(d.elevationEdit.Text) : -1;
                if (d.typeCombo.SelectedItem != null) {
                    wp.type = (WayPointTypeId)((IdType)d.typeCombo.SelectedItem).id;
                }
                wp.description = d.descriptionEdit.Text;
                wp.icao = d.icaoEdit.Text;
                wp.landable = d.landabeCheck.Checked;
                wp.runway = d.runwayEdit.Text;
                wp.frequency = d.frequencyEdit.Text;
                if (d.lenghtEdit.Text != "") {
                    wp.length = int.Parse(d.lenghtEdit.Text);
                }
                if (d.surfaceCombo.SelectedItem != null) {
                    wp.surface = (SurfaceTypeId)((IdType)d.surfaceCombo.SelectedItem).id;
                }
                wp.comment = d.commentEdit.Text;

                if (d.countryCombo.SelectedItem != null) {
                    wp.country = (CountryTypeId)((IdType)d.countryCombo.SelectedItem).id;
                }

                waypoints.Update(old, wp);
                map.RedrawMap();
                explorer.Update(currentCatalog);
                // make sure all tasks show correct names
                UpdateAllTasks(old, wp);
                tasks.Switch(currentCatalog);
                recorder.Update(currentCatalog);
            }
        }

        public void Delete(WayPoint wp) {
            currentCatalog.Remove(wp);
            waypoints.Remove(wp);
            map.RedrawMap();
            explorer.Update(currentCatalog);
            tasks.Remove(wp);
            recorder.Update(currentCatalog);
        }

        public void CenterMapTo(WayPoint wp) {
            map.CenterTo(wp);
        }

        public void SetHomePoint(WayPoint wp) {
            appContents.homePoint = wp;
        }

        public void OpenCatalog() {
            OpenFile(FileTypeId.Waypoint);
        }

        public void MergeCatalog() {
            if (currentCatalog != null) {
                OpenFileDialog fd = new OpenFileDialog();
                fd.Filter = "All known Catalogs|*.dbt;*.cup;*.dat|All files (*.*)|*.*";
                fd.Multiselect = true;
                fd.FilterIndex = 1;

                if (fd.ShowDialog(this) == DialogResult.OK) {
                    foreach (string file in fd.FileNames) {
                        try {
                            FileInfo fi = new FileInfo(file);
                            switch (fi.Extension.ToLower()) {
                            case ".dat":
                            case ".dbt":
                            case ".cup":
                                currentCatalog.Merge(file);
                                break;
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.Show("Error occured while reading file\n\n" + file + "\n\n" +
                                ex.Message + "\n\n" + ex.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                    map.RedrawMap();
                    explorer.Update(currentCatalog);
                    waypoints.Refill();
                    recorder.Update(currentCatalog);
                }
            }
        }

        public void OpenTasks() {
            OpenFile(FileTypeId.Task);
        }

        public void SaveTasks() {
            SaveFileDialog fd = new SaveFileDialog();
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");

            fd.CheckPathExists = true;
            fd.OverwritePrompt = true;
            fd.ValidateNames = true;
            fd.Filter = "All known Tasks|*.cup|SeeYou (*.cup)|*.cup";
            fd.InitialDirectory = (string)currUser.GetValue("DefaultWaypointPath", "");
            if (fd.ShowDialog() == DialogResult.OK) {
                FileInfo info = new FileInfo(fd.FileName);
                using (StreamWriter outStream = new StreamWriter(fd.FileName)) {
                    switch (info.Extension.ToLower()) {
                    case ".cup":
                        SeeYouFileHandler h = new SeeYouFileHandler();
                        switch (MessageBox.Show("Save with current catalogue.", "SeeYou cup file", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1)) {
                        case DialogResult.Yes:
                            h.Save(outStream, currentCatalog, AppContents.tasks);
                            break;
                        case DialogResult.No:
                            h.Save(outStream, AppContents.tasks);
                            break;
                        }
                        break;
                    default:
                        MessageBox.Show("Not a valid task filetype '" + info.Extension.ToLower() + "'", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        break;
                    }
                }
            }
        }

        public void Switch(WaypointCatalog c) {
            currentCatalog = c;
            waypoints.SwitchToCatalog(c);
            map.Switch(c);
            tasks.Switch(c);
        }

        public void Update(WaypointCatalog c) {
            explorer.Update(c);
            if (c == currentCatalog) {
                map.Update(c);
                waypoints.Update(c);
                tasks.Update(c);
                recorder.Update(c);
            }
        }

        public void Switch(Flight f) {
            currentFlight = f;
            currentTask = null;
            map.Switch(currentFlight);
            diagramControl.Diagram.Switch(currentFlight);
            tasks.Switch(currentTask);
        }

        public void Switch(Task t) {
            currentTask = t;
            currentFlight = null;
            map.Switch(t);
            diagramControl.Diagram.Switch(currentFlight);
            tasks.Switch(currentTask);
        }

        public void Update(Task t) {
            explorer.Update(t);
            recorder.Update(t);
            tasks.Update(t);
            map.RedrawMap();
        }

       public void CopyWaypoint(WayPoint wp, WaypointCatalog to) {
            to.Add(wp);
            explorer.Update(to);
            if (to == currentCatalog) {
                waypoints.Add(wp);
                map.RedrawMap();
            }
            recorder.Update(to);
        }

        public void MoveWaypoint(WayPoint wp, WaypointCatalog from, WaypointCatalog to) {
            to.Add(wp);
            explorer.Update(to);
            
            from.Remove(wp);
            explorer.Update(from);
            
            if (to == currentCatalog) {
                waypoints.Add(wp);
            }
            else if (from == currentCatalog) {
                waypoints.Remove(wp);
            }

            map.RedrawMap();
            recorder.Update(from);
            recorder.Update(to);
            tasks.Update(from);
            tasks.Update(to);
        }

        public void UpdateAllTasks(WayPoint oldWp, WayPoint newWp) {
            int i;
            bool update;
            SectorDefinition sector;

            foreach (Task t in AppContents.tasks) {
                update = false;
                for (i = 0; i < t.Count; i++) {
                    if (t[i] == oldWp) {
                        sector = t.GetSector(i);
                        t[i] = newWp;
                        t.SetSector(i, sector);
                        update = true;
                    }
                }
                if (update) {
                    Update(t);
                }
            }
        }

        public void AddPilot() {
            PilotDialog pd = new PilotDialog();
            if (pd.ShowDialog(this) == DialogResult.OK) {
                Pilot p = new Pilot();
                p.LastName = pd.lastName.Text;
                p.FirstName = pd.firstName.Text;
                p.BirthDay = pd.birthDay.Value;
                p.Street = pd.street.Text;
                p.Address = pd.address.Text;
                p.Phone = pd.phone.Text;
                p.Email = pd.email.Text;

                AppContents.pilots.Add(p);
                pilots.Add(p);
                recorder.Add(p);
            }
        }

        public void EditPilot(Pilot p) {
            PilotDialog pd = new PilotDialog();

            pd.lastName.Text = p.LastName;
            pd.firstName.Text = p.FirstName;
            pd.birthDay.Value = p.BirthDay;
            pd.street.Text = p.Street;
            pd.address.Text = p.Address;
            pd.phone.Text = p.Phone;
            pd.email.Text = p.Email;

            if (pd.ShowDialog(this) == DialogResult.OK) {
                p.LastName = pd.lastName.Text;
                p.FirstName = pd.firstName.Text;
                p.BirthDay = pd.birthDay.Value;
                p.Street = pd.street.Text;
                p.Address = pd.address.Text;
                p.Phone = pd.phone.Text;
                p.Email = pd.email.Text;

                pilots.Update(p);
                recorder.Update(p);
            }        
        }

        public void Delete(Pilot p) {
            AppContents.pilots.Remove(p);
            pilots.Remove(p);
            recorder.Remove(p);
        }

        public void AddPilots(object o) {
            bool found;
            foreach (Pilot p in (ArrayList)o) {
                found = false;
                foreach (Pilot p2 in AppContents.pilots) {
                    if (p2.ToString().ToUpper() == p.ToString().ToUpper()) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    AppContents.pilots.Add(p);
                    pilots.Add(p);
                    recorder.Add(p);
                }
            }
        }

        public void AddWaypointCatalogue(object o) {
            WaypointCatalog c = (WaypointCatalog)o;
            AppContents.waypointCatalogs.Add(c);
            explorer.Add(c);
            recorder.Add(c);
        }

        public void AddTasks(object o) {            
            foreach (Task t in (ArrayList)o) {
                t.Name = string.Format("Task{0}", AppContents.tasks.Count + 1);
                AppContents.tasks.Add(t);
                explorer.Add(t);
                recorder.Add(t);
            }
        }

        public void AddFlights(object o) {
            foreach (string s in (ArrayList)o) {
                Flight f = new Flight(s);
                AppContents.flights.Add(f);
                explorer.Add(f);
                //AppContents.flights.Add(f);
            }
        }
        #endregion

        #region Attributes
        public ArrayList Pilots {
            get {
                return AppContents.pilots;
            }
        }

        public TranslationList WayPointTypes {
            get {
                return appContents.waypointTypes;
            }
        }

        public TranslationList SurfaceTypes {
            get {
                return appContents.surfaceTypes;
            }
        }

        public TranslationList CountryTypes {
            get {
                return appContents.countryTypes;
            }
        }

        public WgsPoint MapCenter {
            get {
                return map.Center;
            }
        }

        #endregion
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]

        static void Main(string []args) {
            AppContents cont = new SoaringDotNET.Data.AppContents();
            ArrayList igcFiles = new ArrayList();
            igcFiles.AddRange(args);
            SoaringDotNet app = new SoaringDotNet(cont, igcFiles);
            Application.Run(app);

            cont.SavePilots();
        }
    }
}
