// name   : Tasks.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for Tasks.
	/// </summary>
	public class Tasks : System.Windows.Forms.UserControl
	{
        /// <summary> 
		/// Required designer variable.
		/// </summary>
        private SoaringDotNet app;
        private System.Windows.Forms.ListView listViewTask;
        private System.Windows.Forms.ColumnHeader columnType;
        private System.Windows.Forms.ColumnHeader columnName;
        private System.Windows.Forms.ColumnHeader columnDirection;
        private System.Windows.Forms.Label labelTaskType;
        private System.Windows.Forms.Panel panelTask;
        private System.Windows.Forms.Panel panelMoveWaypoint;
        private System.Windows.Forms.Panel panelMoveWaypointOrder;
        private System.Windows.Forms.Button buttonUp;
        private System.Windows.Forms.Button buttonDown;
        private System.Windows.Forms.Button buttonAdd;
        private System.Windows.Forms.Button buttonRemove;
        private System.ComponentModel.Container components = null;
        private System.Windows.Forms.Button buttonReplace;
        private System.Windows.Forms.Panel panelWaypoints;
        private System.Windows.Forms.ColumnHeader columnTaskDist;
        private System.Windows.Forms.ColumnHeader columnTaskPercent;
        private System.Windows.Forms.ColumnHeader columnLegDist;
        private System.Windows.Forms.ColumnHeader columnLegPercent;
        private System.Windows.Forms.Panel panelSector;
        private SoaringDotNET.Controls.Sector sector;
        private System.Windows.Forms.Panel panelSectorData;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.ComboBox comboBoxSectorType;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.TextBox textBoxSector;
        private System.Windows.Forms.TextBox textBoxCylinder;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.Button buttonReset;
        private int selectedIndex;
        private System.Windows.Forms.ListView listViewWaypoints;
        private System.Windows.Forms.ColumnHeader columnHeader1;
        private Task currentTask;
        private WaypointCatalog currentCatalogue;
        private System.Windows.Forms.Label labelRadialFrom;
        private System.Windows.Forms.Label labelRadialTo;
        private System.Windows.Forms.NumericUpDown numericUpDownRadialFrom;
        private System.Windows.Forms.NumericUpDown numericUpDownRadialTo;
        private System.Windows.Forms.Splitter splitter1;
        private System.Windows.Forms.Panel panelRight;
        private bool redraw = true;

        public Tasks()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call
            comboBoxSectorType.Items.Add(SectorTypes.Sector);
            comboBoxSectorType.Items.Add(SectorTypes.Line);
            comboBoxSectorType.Items.Add(SectorTypes.Area);
            selectedIndex = -1;
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
        private void InitializeComponent() {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Tasks));
            this.listViewTask = new System.Windows.Forms.ListView();
            this.columnType = new System.Windows.Forms.ColumnHeader();
            this.columnName = new System.Windows.Forms.ColumnHeader();
            this.columnDirection = new System.Windows.Forms.ColumnHeader();
            this.columnLegDist = new System.Windows.Forms.ColumnHeader();
            this.columnLegPercent = new System.Windows.Forms.ColumnHeader();
            this.columnTaskDist = new System.Windows.Forms.ColumnHeader();
            this.columnTaskPercent = new System.Windows.Forms.ColumnHeader();
            this.labelTaskType = new System.Windows.Forms.Label();
            this.panelTask = new System.Windows.Forms.Panel();
            this.panelMoveWaypointOrder = new System.Windows.Forms.Panel();
            this.buttonDown = new System.Windows.Forms.Button();
            this.buttonUp = new System.Windows.Forms.Button();
            this.panelMoveWaypoint = new System.Windows.Forms.Panel();
            this.buttonRemove = new System.Windows.Forms.Button();
            this.buttonReplace = new System.Windows.Forms.Button();
            this.buttonAdd = new System.Windows.Forms.Button();
            this.panelWaypoints = new System.Windows.Forms.Panel();
            this.listViewWaypoints = new System.Windows.Forms.ListView();
            this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
            this.panelSector = new System.Windows.Forms.Panel();
            this.panelSectorData = new System.Windows.Forms.Panel();
            this.numericUpDownRadialTo = new System.Windows.Forms.NumericUpDown();
            this.numericUpDownRadialFrom = new System.Windows.Forms.NumericUpDown();
            this.labelRadialTo = new System.Windows.Forms.Label();
            this.labelRadialFrom = new System.Windows.Forms.Label();
            this.buttonReset = new System.Windows.Forms.Button();
            this.label5 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.textBoxCylinder = new System.Windows.Forms.TextBox();
            this.textBoxSector = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.comboBoxSectorType = new System.Windows.Forms.ComboBox();
            this.label1 = new System.Windows.Forms.Label();
            this.sector = new SoaringDotNET.Controls.Sector();
            this.splitter1 = new System.Windows.Forms.Splitter();
            this.panelRight = new System.Windows.Forms.Panel();
            this.panelTask.SuspendLayout();
            this.panelMoveWaypointOrder.SuspendLayout();
            this.panelMoveWaypoint.SuspendLayout();
            this.panelWaypoints.SuspendLayout();
            this.panelSector.SuspendLayout();
            this.panelSectorData.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadialTo)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadialFrom)).BeginInit();
            this.panelRight.SuspendLayout();
            this.SuspendLayout();
            // 
            // listViewTask
            // 
            this.listViewTask.AllowColumnReorder = true;
            this.listViewTask.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                           this.columnType,
                                                                                           this.columnName,
                                                                                           this.columnDirection,
                                                                                           this.columnLegDist,
                                                                                           this.columnLegPercent,
                                                                                           this.columnTaskDist,
                                                                                           this.columnTaskPercent});
            this.listViewTask.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewTask.FullRowSelect = true;
            this.listViewTask.GridLines = true;
            this.listViewTask.HideSelection = false;
            this.listViewTask.Location = new System.Drawing.Point(0, 23);
            this.listViewTask.MultiSelect = false;
            this.listViewTask.Name = "listViewTask";
            this.listViewTask.Size = new System.Drawing.Size(515, 241);
            this.listViewTask.TabIndex = 0;
            this.listViewTask.View = System.Windows.Forms.View.Details;
            this.listViewTask.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDown);
            this.listViewTask.DoubleClick += new System.EventHandler(this.OnRemove);
            this.listViewTask.SelectedIndexChanged += new System.EventHandler(this.OnSelectedWaypointChanged);
            // 
            // columnType
            // 
            this.columnType.Text = "Type";
            this.columnType.Width = 80;
            // 
            // columnName
            // 
            this.columnName.Text = "Name";
            this.columnName.Width = 120;
            // 
            // columnDirection
            // 
            this.columnDirection.Text = "TC";
            this.columnDirection.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.columnDirection.Width = 40;
            // 
            // columnLegDist
            // 
            this.columnLegDist.Text = "Leg dist.";
            this.columnLegDist.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // columnLegPercent
            // 
            this.columnLegPercent.Text = "Percent";
            this.columnLegPercent.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // columnTaskDist
            // 
            this.columnTaskDist.Text = "Task dist.";
            this.columnTaskDist.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // columnTaskPercent
            // 
            this.columnTaskPercent.Text = "Percent";
            this.columnTaskPercent.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // labelTaskType
            // 
            this.labelTaskType.Dock = System.Windows.Forms.DockStyle.Top;
            this.labelTaskType.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.labelTaskType.ForeColor = System.Drawing.Color.Firebrick;
            this.labelTaskType.Location = new System.Drawing.Point(0, 0);
            this.labelTaskType.Name = "labelTaskType";
            this.labelTaskType.Size = new System.Drawing.Size(515, 23);
            this.labelTaskType.TabIndex = 1;
            this.labelTaskType.Text = "task type";
            this.labelTaskType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // panelTask
            // 
            this.panelTask.AutoScroll = true;
            this.panelTask.Controls.Add(this.listViewTask);
            this.panelTask.Controls.Add(this.panelMoveWaypointOrder);
            this.panelTask.Controls.Add(this.labelTaskType);
            this.panelTask.Dock = System.Windows.Forms.DockStyle.Left;
            this.panelTask.DockPadding.Right = 5;
            this.panelTask.Location = new System.Drawing.Point(0, 0);
            this.panelTask.Name = "panelTask";
            this.panelTask.Size = new System.Drawing.Size(520, 304);
            this.panelTask.TabIndex = 2;
            // 
            // panelMoveWaypointOrder
            // 
            this.panelMoveWaypointOrder.Controls.Add(this.buttonDown);
            this.panelMoveWaypointOrder.Controls.Add(this.buttonUp);
            this.panelMoveWaypointOrder.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panelMoveWaypointOrder.Location = new System.Drawing.Point(0, 264);
            this.panelMoveWaypointOrder.Name = "panelMoveWaypointOrder";
            this.panelMoveWaypointOrder.Size = new System.Drawing.Size(515, 40);
            this.panelMoveWaypointOrder.TabIndex = 2;
            // 
            // buttonDown
            // 
            this.buttonDown.Image = ((System.Drawing.Image)(resources.GetObject("buttonDown.Image")));
            this.buttonDown.Location = new System.Drawing.Point(184, 4);
            this.buttonDown.Name = "buttonDown";
            this.buttonDown.Size = new System.Drawing.Size(32, 32);
            this.buttonDown.TabIndex = 1;
            this.buttonDown.Click += new System.EventHandler(this.OnMoveDown);
            // 
            // buttonUp
            // 
            this.buttonUp.Image = ((System.Drawing.Image)(resources.GetObject("buttonUp.Image")));
            this.buttonUp.Location = new System.Drawing.Point(144, 4);
            this.buttonUp.Name = "buttonUp";
            this.buttonUp.Size = new System.Drawing.Size(32, 32);
            this.buttonUp.TabIndex = 0;
            this.buttonUp.Click += new System.EventHandler(this.OnMoveUp);
            // 
            // panelMoveWaypoint
            // 
            this.panelMoveWaypoint.Controls.Add(this.buttonRemove);
            this.panelMoveWaypoint.Controls.Add(this.buttonReplace);
            this.panelMoveWaypoint.Controls.Add(this.buttonAdd);
            this.panelMoveWaypoint.Dock = System.Windows.Forms.DockStyle.Left;
            this.panelMoveWaypoint.Location = new System.Drawing.Point(0, 0);
            this.panelMoveWaypoint.Name = "panelMoveWaypoint";
            this.panelMoveWaypoint.Size = new System.Drawing.Size(48, 304);
            this.panelMoveWaypoint.TabIndex = 1;
            // 
            // buttonRemove
            // 
            this.buttonRemove.Image = ((System.Drawing.Image)(resources.GetObject("buttonRemove.Image")));
            this.buttonRemove.Location = new System.Drawing.Point(8, 104);
            this.buttonRemove.Name = "buttonRemove";
            this.buttonRemove.Size = new System.Drawing.Size(32, 32);
            this.buttonRemove.TabIndex = 4;
            this.buttonRemove.Click += new System.EventHandler(this.OnRemove);
            // 
            // buttonReplace
            // 
            this.buttonReplace.Image = ((System.Drawing.Image)(resources.GetObject("buttonReplace.Image")));
            this.buttonReplace.Location = new System.Drawing.Point(8, 64);
            this.buttonReplace.Name = "buttonReplace";
            this.buttonReplace.Size = new System.Drawing.Size(32, 32);
            this.buttonReplace.TabIndex = 3;
            this.buttonReplace.Click += new System.EventHandler(this.OnReplace);
            // 
            // buttonAdd
            // 
            this.buttonAdd.Image = ((System.Drawing.Image)(resources.GetObject("buttonAdd.Image")));
            this.buttonAdd.Location = new System.Drawing.Point(8, 24);
            this.buttonAdd.Name = "buttonAdd";
            this.buttonAdd.Size = new System.Drawing.Size(32, 32);
            this.buttonAdd.TabIndex = 2;
            this.buttonAdd.Click += new System.EventHandler(this.OnAdd);
            // 
            // panelWaypoints
            // 
            this.panelWaypoints.Controls.Add(this.listViewWaypoints);
            this.panelWaypoints.Controls.Add(this.panelMoveWaypoint);
            this.panelWaypoints.Dock = System.Windows.Forms.DockStyle.Left;
            this.panelWaypoints.Location = new System.Drawing.Point(0, 0);
            this.panelWaypoints.Name = "panelWaypoints";
            this.panelWaypoints.Size = new System.Drawing.Size(180, 304);
            this.panelWaypoints.TabIndex = 4;
            // 
            // listViewWaypoints
            // 
            this.listViewWaypoints.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                                this.columnHeader1});
            this.listViewWaypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewWaypoints.FullRowSelect = true;
            this.listViewWaypoints.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            this.listViewWaypoints.HideSelection = false;
            this.listViewWaypoints.Location = new System.Drawing.Point(48, 0);
            this.listViewWaypoints.MultiSelect = false;
            this.listViewWaypoints.Name = "listViewWaypoints";
            this.listViewWaypoints.Size = new System.Drawing.Size(132, 304);
            this.listViewWaypoints.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listViewWaypoints.TabIndex = 2;
            this.listViewWaypoints.View = System.Windows.Forms.View.Details;
            this.listViewWaypoints.DoubleClick += new System.EventHandler(this.OnAdd);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Width = 120;
            // 
            // panelSector
            // 
            this.panelSector.Controls.Add(this.panelSectorData);
            this.panelSector.Controls.Add(this.sector);
            this.panelSector.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelSector.DockPadding.Left = 10;
            this.panelSector.Location = new System.Drawing.Point(180, 0);
            this.panelSector.Name = "panelSector";
            this.panelSector.Size = new System.Drawing.Size(463, 304);
            this.panelSector.TabIndex = 5;
            // 
            // panelSectorData
            // 
            this.panelSectorData.Controls.Add(this.numericUpDownRadialTo);
            this.panelSectorData.Controls.Add(this.numericUpDownRadialFrom);
            this.panelSectorData.Controls.Add(this.labelRadialTo);
            this.panelSectorData.Controls.Add(this.labelRadialFrom);
            this.panelSectorData.Controls.Add(this.buttonReset);
            this.panelSectorData.Controls.Add(this.label5);
            this.panelSectorData.Controls.Add(this.label4);
            this.panelSectorData.Controls.Add(this.textBoxCylinder);
            this.panelSectorData.Controls.Add(this.textBoxSector);
            this.panelSectorData.Controls.Add(this.label3);
            this.panelSectorData.Controls.Add(this.label2);
            this.panelSectorData.Controls.Add(this.comboBoxSectorType);
            this.panelSectorData.Controls.Add(this.label1);
            this.panelSectorData.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelSectorData.Location = new System.Drawing.Point(160, 0);
            this.panelSectorData.Name = "panelSectorData";
            this.panelSectorData.Size = new System.Drawing.Size(303, 304);
            this.panelSectorData.TabIndex = 1;
            // 
            // numericUpDownRadialTo
            // 
            this.numericUpDownRadialTo.Location = new System.Drawing.Point(112, 136);
            this.numericUpDownRadialTo.Maximum = new System.Decimal(new int[] {
                                                                                  360,
                                                                                  0,
                                                                                  0,
                                                                                  0});
            this.numericUpDownRadialTo.Name = "numericUpDownRadialTo";
            this.numericUpDownRadialTo.Size = new System.Drawing.Size(56, 20);
            this.numericUpDownRadialTo.TabIndex = 15;
            this.numericUpDownRadialTo.Value = new System.Decimal(new int[] {
                                                                                360,
                                                                                0,
                                                                                0,
                                                                                0});
            this.numericUpDownRadialTo.ValueChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            this.numericUpDownRadialTo.Leave += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // numericUpDownRadialFrom
            // 
            this.numericUpDownRadialFrom.Location = new System.Drawing.Point(16, 136);
            this.numericUpDownRadialFrom.Maximum = new System.Decimal(new int[] {
                                                                                    360,
                                                                                    0,
                                                                                    0,
                                                                                    0});
            this.numericUpDownRadialFrom.Name = "numericUpDownRadialFrom";
            this.numericUpDownRadialFrom.Size = new System.Drawing.Size(56, 20);
            this.numericUpDownRadialFrom.TabIndex = 14;
            this.numericUpDownRadialFrom.Value = new System.Decimal(new int[] {
                                                                                  360,
                                                                                  0,
                                                                                  0,
                                                                                  0});
            this.numericUpDownRadialFrom.ValueChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            this.numericUpDownRadialFrom.Leave += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // labelRadialTo
            // 
            this.labelRadialTo.AutoSize = true;
            this.labelRadialTo.Location = new System.Drawing.Point(112, 120);
            this.labelRadialTo.Name = "labelRadialTo";
            this.labelRadialTo.Size = new System.Drawing.Size(49, 16);
            this.labelRadialTo.TabIndex = 13;
            this.labelRadialTo.Text = "Radial to";
            // 
            // labelRadialFrom
            // 
            this.labelRadialFrom.AutoSize = true;
            this.labelRadialFrom.Location = new System.Drawing.Point(16, 120);
            this.labelRadialFrom.Name = "labelRadialFrom";
            this.labelRadialFrom.Size = new System.Drawing.Size(62, 16);
            this.labelRadialFrom.TabIndex = 12;
            this.labelRadialFrom.Text = "Radial from";
            // 
            // buttonReset
            // 
            this.buttonReset.Location = new System.Drawing.Point(112, 16);
            this.buttonReset.Name = "buttonReset";
            this.buttonReset.Size = new System.Drawing.Size(56, 23);
            this.buttonReset.TabIndex = 11;
            this.buttonReset.Text = "Reset";
            this.buttonReset.Click += new System.EventHandler(this.OnClickReset);
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(80, 96);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(14, 16);
            this.label5.TabIndex = 10;
            this.label5.Text = "m";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(80, 56);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(14, 16);
            this.label4.TabIndex = 9;
            this.label4.Text = "m";
            // 
            // textBoxCylinder
            // 
            this.textBoxCylinder.Location = new System.Drawing.Point(16, 96);
            this.textBoxCylinder.Name = "textBoxCylinder";
            this.textBoxCylinder.Size = new System.Drawing.Size(64, 20);
            this.textBoxCylinder.TabIndex = 8;
            this.textBoxCylinder.Text = "";
            this.textBoxCylinder.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.textBoxCylinder.TextChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // textBoxSector
            // 
            this.textBoxSector.Location = new System.Drawing.Point(16, 56);
            this.textBoxSector.Name = "textBoxSector";
            this.textBoxSector.Size = new System.Drawing.Size(64, 20);
            this.textBoxSector.TabIndex = 7;
            this.textBoxSector.Text = "";
            this.textBoxSector.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.textBoxSector.TextChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(16, 80);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(135, 16);
            this.label3.TabIndex = 5;
            this.label3.Text = "Radius cylinder/min range";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(16, 40);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(151, 16);
            this.label2.TabIndex = 2;
            this.label2.Text = "Radius sector/line/max range";
            // 
            // comboBoxSectorType
            // 
            this.comboBoxSectorType.Location = new System.Drawing.Point(16, 16);
            this.comboBoxSectorType.Name = "comboBoxSectorType";
            this.comboBoxSectorType.Size = new System.Drawing.Size(88, 21);
            this.comboBoxSectorType.TabIndex = 1;
            this.comboBoxSectorType.SelectedIndexChanged += new System.EventHandler(this.OnSectorDefinitionChanged);
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(16, 0);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(61, 16);
            this.label1.TabIndex = 0;
            this.label1.Text = "Sector type";
            // 
            // sector
            // 
            this.sector.BackColor = System.Drawing.SystemColors.Window;
            this.sector.Dock = System.Windows.Forms.DockStyle.Left;
            this.sector.Location = new System.Drawing.Point(10, 0);
            this.sector.Name = "sector";
            this.sector.Size = new System.Drawing.Size(150, 304);
            this.sector.TabIndex = 0;
            // 
            // splitter1
            // 
            this.splitter1.BackColor = System.Drawing.SystemColors.Control;
            this.splitter1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.splitter1.Location = new System.Drawing.Point(520, 0);
            this.splitter1.Name = "splitter1";
            this.splitter1.Size = new System.Drawing.Size(5, 304);
            this.splitter1.TabIndex = 6;
            this.splitter1.TabStop = false;
            // 
            // panelRight
            // 
            this.panelRight.Controls.Add(this.panelSector);
            this.panelRight.Controls.Add(this.panelWaypoints);
            this.panelRight.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelRight.Location = new System.Drawing.Point(525, 0);
            this.panelRight.Name = "panelRight";
            this.panelRight.Size = new System.Drawing.Size(643, 304);
            this.panelRight.TabIndex = 7;
            // 
            // Tasks
            // 
            this.AutoScroll = true;
            this.Controls.Add(this.panelRight);
            this.Controls.Add(this.splitter1);
            this.Controls.Add(this.panelTask);
            this.Name = "Tasks";
            this.Size = new System.Drawing.Size(1168, 304);
            this.panelTask.ResumeLayout(false);
            this.panelMoveWaypointOrder.ResumeLayout(false);
            this.panelMoveWaypoint.ResumeLayout(false);
            this.panelWaypoints.ResumeLayout(false);
            this.panelSector.ResumeLayout(false);
            this.panelSectorData.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadialTo)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadialFrom)).EndInit();
            this.panelRight.ResumeLayout(false);
            this.ResumeLayout(false);

        }

        #endregion

        #region Public Functions
        public void Switch(Task t) {
            if (currentTask != t) {
                currentTask = t;
                Update();
                sector.Switch(t);
                sector.Switch(selectedIndex);
            }
        }

        public void Switch(WaypointCatalog c) {
            currentCatalogue = c;

            listViewWaypoints.Items.Clear();
            listViewWaypoints.BeginUpdate();
            if (c != null) {
                ArrayList items = new ArrayList(c.Count);
                foreach (WayPoint wp in currentCatalogue.VisibleWaypoints) {
                    ListViewItem l = new ListViewItem(wp.longName);
                    l.Tag = wp;
                    items.Add(l);
                }
                if (items.Count > 0) {
                    listViewWaypoints.Items.AddRange((ListViewItem [])items.ToArray(items[0].GetType()));
                }

            }
            listViewWaypoints.EndUpdate();
        }

        public void Update(WaypointCatalog c) {
            if (c == currentCatalogue) {
                Switch(c);
            }
        }

        private void OnKeyDown(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                OnRemove(null, null);
            }
        }

        public void Update(Task t) {
            if (currentTask == t) {
                Update();
            }
        }

        public void Add(WayPoint wp) {
            ListViewItem lv = new ListViewItem(wp.ToString());
            lv.Tag = wp;
            listViewWaypoints.Items.Add(lv);
        }

        public void Remove(WayPoint wp) {
            foreach (ListViewItem lv in listViewWaypoints.Items) {
                if (lv.Tag == wp) {
                    lv.Remove();
                    break;
                }
            }
        }

        #endregion

        #region Protected Functions
        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }
        #endregion

        #region Private Functions
        private void OnClickReset(object sender, System.EventArgs e) {
            int idx;
            if (currentTask != null && listViewTask.SelectedIndices.Count > 0 && 
                (idx = listViewTask.SelectedIndices[0]) > 0 && idx < currentTask.Count - 1) {
                currentTask.GetSector(idx).Reset();
                OnSelectedWaypointChanged(null, null);
            }
        }

        private void OnSectorDefinitionChanged(object sender, System.EventArgs e) {
            SectorDefinition sector;
            int idx;
            if (currentTask != null && listViewTask.SelectedIndices.Count > 0 && 
                (idx = listViewTask.SelectedIndices[0]) > 0 && idx < currentTask.Count - 1) {
                sector = currentTask.GetSector(idx);
                if (sender == comboBoxSectorType && comboBoxSectorType.SelectedIndex != -1) {
                    sector.sectorType = (SectorTypes)comboBoxSectorType.SelectedItem;
                }
                else if (sender == textBoxSector && textBoxSector.Text != "") {
                    try {
                        sector.radius1 = int.Parse(textBoxSector.Text);
                    }
                    catch {
                        sector.radius1 = 0;
                    }
                }
                else if (sender == textBoxCylinder && textBoxCylinder.Text != "") {
                    try { 
                        sector.radius2 = int.Parse(textBoxCylinder.Text);
                    }
                    catch {
                        sector.radius2 = 0;
                    }
                }
                else if (sender == numericUpDownRadialFrom) {
                    sector.directionFrom = decimal.ToInt32(numericUpDownRadialFrom.Value);
                }
                else if (sender == numericUpDownRadialTo) {
                    sector.directionTo = decimal.ToInt32(numericUpDownRadialTo.Value);
                }

                if (redraw) {
                    app.Update(currentTask);
                }
            }
        }

        private void OnSelectedWaypointChanged(object sender, System.EventArgs e) {
            SectorDefinition sec;
            redraw = false;
            if (currentTask != null && listViewTask.SelectedIndices.Count > 0 && 
                (selectedIndex = listViewTask.SelectedIndices[0]) > 0 && selectedIndex < currentTask.Count - 1) {
                sec = currentTask.GetSector(selectedIndex);
                comboBoxSectorType.Enabled = true;
                textBoxSector.Enabled = true;
                textBoxSector.Text = sec.radius1.ToString();
                textBoxCylinder.Text = sec.radius2.ToString();
                comboBoxSectorType.SelectedItem = sec.sectorType;
                numericUpDownRadialFrom.Value = sec.directionFrom;
                numericUpDownRadialTo.Value = sec.directionTo;
                sector.Switch(selectedIndex);
                switch (sec.sectorType) {
                case SectorTypes.Line:
                    textBoxCylinder.Enabled = false;
                    textBoxCylinder.Text = "0";
                    sec.radius2 = 0;
                    numericUpDownRadialFrom.Value = 360;
                    numericUpDownRadialFrom.Enabled = false;
                    numericUpDownRadialTo.Value = 360;
                    numericUpDownRadialTo.Enabled = false;
                    break;
                case SectorTypes.Sector:
                    textBoxCylinder.Enabled = true;
                    numericUpDownRadialFrom.Value = 360;
                    numericUpDownRadialFrom.Enabled = false;
                    numericUpDownRadialTo.Value = 360;
                    numericUpDownRadialTo.Enabled = false;
                    break;
                case SectorTypes.Area:
                    textBoxCylinder.Enabled = true;
                    numericUpDownRadialFrom.Enabled = true;
                    numericUpDownRadialTo.Enabled = true;
                    break;
                }
            }
            else {
                comboBoxSectorType.SelectedIndex = -1;
                textBoxCylinder.Text = "";
                textBoxSector.Text = "";
                comboBoxSectorType.Enabled = false;
                textBoxCylinder.Enabled = false;
                textBoxSector.Enabled = false;
                numericUpDownRadialFrom.Enabled = false;
                numericUpDownRadialTo.Enabled = false;
                sector.Switch(-1);
            }
            redraw = true;
        }

        private void OnMoveUp(object sender, System.EventArgs e) {
            if (currentTask != null && listViewTask.SelectedIndices.Count > 0) {
                selectedIndex = listViewTask.SelectedIndices[0];
                if (selectedIndex > 0) {
                    currentTask.Swap(selectedIndex - 1, selectedIndex);
                    listViewTask.Items[selectedIndex - 1].Selected = true;
                    app.Update(currentTask);
                }
            }
        }

        private void OnMoveDown(object sender, System.EventArgs e) {
            if (currentTask != null && listViewTask.SelectedIndices.Count > 0) {
                selectedIndex = listViewTask.SelectedIndices[0];
                if (selectedIndex < currentTask.Count - 1) {
                    currentTask.Swap(selectedIndex, selectedIndex + 1);
                    listViewTask.Items[selectedIndex + 1].Selected = true;
                    app.Update(currentTask);
                }
            }
        }

        private void OnAdd(object sender, System.EventArgs e) {
            if (currentTask != null && listViewWaypoints.SelectedIndices.Count > 0) {
                if (selectedIndex != -1 && selectedIndex < currentTask.Count) {
                    selectedIndex++;
                    currentTask.Insert(selectedIndex, (WayPoint)listViewWaypoints.SelectedItems[0].Tag);
                }
                else {
                    currentTask.Add((WayPoint)listViewWaypoints.SelectedItems[0].Tag);
                    selectedIndex = 0;
                }
                app.Update(currentTask);
            }
        }

        private void OnReplace(object sender, System.EventArgs e) {
            if (currentTask != null && selectedIndex != -1 && listViewWaypoints.SelectedIndices.Count > 0) {
                currentTask[selectedIndex] = (WayPoint)listViewWaypoints.SelectedItems[0].Tag;
                app.Update(currentTask);
            }
        }

        private void OnRemove(object sender, System.EventArgs e) {
            if (currentTask != null && selectedIndex != -1) {
                currentTask.Delete(selectedIndex);
                app.Update(currentTask);
                selectedIndex = Math.Max(selectedIndex - 1, 0);
                if (listViewTask.Items.Count > 0) {
                    listViewTask.Items[selectedIndex].Selected = true;
                    listViewTask.Items[selectedIndex].Focused = true;
                    listViewTask.Focus();
                }
            }
        }

        private new void Update() {
            int i;
            WayPoint wp;
            string txt;
            ListViewItem item;
            double totalDist, taskDist, legDist;

            if (currentTask != null) {
                labelTaskType.Text = currentTask.TaskTypeString;
                taskDist = currentTask.TaskDistanceKM;
                totalDist = currentTask.TotalDistanceKM;

                if (listViewTask.Items.Count > currentTask.Count) {
                    for (i = listViewTask.Items.Count - 1; i >= currentTask.Count; i--) {
                        listViewTask.Items.RemoveAt(i);
                    }
                }
                else if (listViewTask.Items.Count < currentTask.Count) {
                    for (i = listViewTask.Items.Count; i < currentTask.Count; i++) {
                        listViewTask.Items.Add(new ListViewItem(new string []{"", "", "", "", "", "", "", ""}));
                    }
                }

                for (i = 0; i < currentTask.Count; i++) {
                    if (i == 0) {
                        txt = "Takeoff";
                    }
                    else if (i == 1) {
                        txt = "Start";
                    }
                    else if (i == currentTask.Count - 2) {
                        txt = "Finish";
                    }
                    else if (i == currentTask.Count - 1) {
                        txt = "Landing";
                    }
                    else {
                        txt = "Turnpoint";                        
                    }

                    wp = currentTask[i];
                    legDist = i > 0 ? wp.distanceKM(currentTask[i - 1]) : 0.0;
                    item = listViewTask.Items[i];
                    item.SubItems[0].Text = txt;
                    item.SubItems[1].Text = wp.longName;
                    item.SubItems[2].Text = i > 0 ? string.Format(AppContents.ni, "{0:0} ", currentTask[i - 1].bearingDeg(wp)) : "";
                    item.SubItems[3].Text = i > 0 ? string.Format(AppContents.ni, "{0:F1} km", legDist) : "";
                    item.SubItems[4].Text = i > 0 ? string.Format(AppContents.ni, "{0:F1} %", legDist / totalDist * 100.0) : "";

                    if (currentTask.TaskType == TaskTypes.TriangleStartOnLeg) {
                        if (i > 1 && i < 5) {
                            if (i == 2) {
                                // start point of triangle get dist to last point of triangle
                                legDist = wp.distanceKM(currentTask[4]);
                            }
                            txt = string.Format(AppContents.ni, "{0:F1} %", legDist / taskDist * 100.0);
                        }
                        else {
                            txt = "";
                        }
                    }
                    else if (i > 1 && i < currentTask.Count - 1) {
                        txt = string.Format(AppContents.ni, "{0:F1} %", legDist / taskDist * 100.0);
                    }
                    else {
                        txt = "";
                    }
                    item.SubItems[5].Text = (i > 1 && 
                        ((currentTask.TaskType != TaskTypes.TriangleStartOnLeg && i < currentTask.Count - 1) ||
                        (currentTask.TaskType == TaskTypes.TriangleStartOnLeg && i < currentTask.Count - 2))) ? string.Format(AppContents.ni, "{0:F1} km", legDist) : "";
                    item.SubItems[6].Text = txt;
                }
                buttonUp.Enabled = currentTask.Count > 1;
                buttonDown.Enabled = currentTask.Count > 1;
                buttonRemove.Enabled = true;
                buttonReplace.Enabled = true;
                comboBoxSectorType.Enabled = true;
                textBoxCylinder.Enabled = currentTask.Count > 0 && currentTask.GetSector(0).sectorType == SectorTypes.Sector;
                textBoxSector.Enabled = true;
                if (currentTask.Count > 0) {
                    listViewTask.Items[Math.Max(Math.Min(selectedIndex, currentTask.Count - 1), 0)].Selected = true;
                }
            }
            else  {
                listViewTask.Items.Clear();
                buttonUp.Enabled = false;
                buttonDown.Enabled = false;
                buttonRemove.Enabled = false;
                buttonReplace.Enabled = false;
                comboBoxSectorType.Enabled = false;
                textBoxCylinder.Enabled = false;
                textBoxSector.Enabled = false;
                selectedIndex = -1;
            }
            OnSelectedWaypointChanged(null, null);
        }
        #endregion

        #region Attributes
        public SoaringDotNet App {
            get {
                return app;
            }
            set {
                app = value;
            }
        }
        #endregion
    }
}
