// name   : WaypointFilterDialog.cs
// author : Harald Maier
// date   : 12.18.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for WaypointFilterDialog.
	/// </summary>
	public class WaypointFilterDialog : System.Windows.Forms.Form
	{
        public WayPointFilter filter;

        private System.Windows.Forms.CheckBox checkBoxAll;
        private System.Windows.Forms.GroupBox groupBoxTypes;
        private System.Windows.Forms.CheckBox checkBoxAirport;
        private System.Windows.Forms.CheckBox checkBoxGlidersites;
        private System.Windows.Forms.CheckBox checkBoxLandmarks;
        private System.Windows.Forms.CheckBox checkBoxOutlanding;
        private System.Windows.Forms.CheckBox checkBoxUnknown;
        private System.Windows.Forms.Button buttonOk;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.GroupBox groupBoxArea;
        private System.Windows.Forms.Label label1;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatFrom;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonFrom;
        private System.Windows.Forms.Label label2;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatTo;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonTo;
        private System.Windows.Forms.GroupBox groupBoxRadius;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLat;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLon;
        private System.Windows.Forms.RadioButton radioButtonHome;
        private System.Windows.Forms.RadioButton radioButtonCenter;
        private System.Windows.Forms.ComboBox comboBoxWaypoints;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.RadioButton radioButtonWayoint;
        private System.Windows.Forms.RadioButton radioButtonPos;
        private System.Windows.Forms.ComboBox comboBoxRadius;
        private System.Windows.Forms.Button buttonReset;
        private System.Windows.Forms.CheckedListBox checkedListBoxCountry;
        private System.Windows.Forms.Label label4;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		
		private System.ComponentModel.Container components = null;

        public WaypointFilterDialog(WaypointCatalog catalogue) {
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            Hashtable loadedCountries = new Hashtable();

            if (catalogue == null) {
                filter = new WayPointFilter();
            }
            else {
                filter = new WayPointFilter(catalogue.Filter);
                comboBoxWaypoints.Items.AddRange(catalogue.ToArray());
                foreach (WayPoint w in catalogue) {
                    loadedCountries[w.country] = null;
                }
            }
            InitGUI();
            foreach (DictionaryEntry entry in loadedCountries) {
                checkedListBoxCountry.Items.Add(entry.Key, filter.countries.ContainsKey(entry.Key));
            }
        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WaypointFilterDialog));
            this.checkBoxAll = new System.Windows.Forms.CheckBox();
            this.groupBoxTypes = new System.Windows.Forms.GroupBox();
            this.checkBoxUnknown = new System.Windows.Forms.CheckBox();
            this.checkBoxOutlanding = new System.Windows.Forms.CheckBox();
            this.checkBoxLandmarks = new System.Windows.Forms.CheckBox();
            this.checkBoxGlidersites = new System.Windows.Forms.CheckBox();
            this.checkBoxAirport = new System.Windows.Forms.CheckBox();
            this.buttonOk = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.groupBoxArea = new System.Windows.Forms.GroupBox();
            this.coordEditControlLonTo = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatTo = new SoaringDotNET.Controls.CoordEditControl();
            this.label2 = new System.Windows.Forms.Label();
            this.coordEditControlLonFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.label1 = new System.Windows.Forms.Label();
            this.groupBoxRadius = new System.Windows.Forms.GroupBox();
            this.comboBoxRadius = new System.Windows.Forms.ComboBox();
            this.label3 = new System.Windows.Forms.Label();
            this.comboBoxWaypoints = new System.Windows.Forms.ComboBox();
            this.radioButtonWayoint = new System.Windows.Forms.RadioButton();
            this.radioButtonCenter = new System.Windows.Forms.RadioButton();
            this.radioButtonHome = new System.Windows.Forms.RadioButton();
            this.radioButtonPos = new System.Windows.Forms.RadioButton();
            this.coordEditControlLat = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLon = new SoaringDotNET.Controls.CoordEditControl();
            this.buttonReset = new System.Windows.Forms.Button();
            this.checkedListBoxCountry = new System.Windows.Forms.CheckedListBox();
            this.label4 = new System.Windows.Forms.Label();
            this.groupBoxTypes.SuspendLayout();
            this.groupBoxArea.SuspendLayout();
            this.groupBoxRadius.SuspendLayout();
            this.SuspendLayout();
            // 
            // checkBoxAll
            // 
            this.checkBoxAll.Location = new System.Drawing.Point(16, 24);
            this.checkBoxAll.Name = "checkBoxAll";
            this.checkBoxAll.TabIndex = 0;
            this.checkBoxAll.Text = "&Use all";
            this.checkBoxAll.Click += new System.EventHandler(this.OnClickTypes);
            // 
            // groupBoxTypes
            // 
            this.groupBoxTypes.Controls.Add(this.checkBoxUnknown);
            this.groupBoxTypes.Controls.Add(this.checkBoxOutlanding);
            this.groupBoxTypes.Controls.Add(this.checkBoxLandmarks);
            this.groupBoxTypes.Controls.Add(this.checkBoxGlidersites);
            this.groupBoxTypes.Controls.Add(this.checkBoxAirport);
            this.groupBoxTypes.Controls.Add(this.checkBoxAll);
            this.groupBoxTypes.Location = new System.Drawing.Point(16, 16);
            this.groupBoxTypes.Name = "groupBoxTypes";
            this.groupBoxTypes.Size = new System.Drawing.Size(176, 176);
            this.groupBoxTypes.TabIndex = 1;
            this.groupBoxTypes.TabStop = false;
            this.groupBoxTypes.Text = "Waypoint type";
            // 
            // checkBoxUnknown
            // 
            this.checkBoxUnknown.Location = new System.Drawing.Point(16, 144);
            this.checkBoxUnknown.Name = "checkBoxUnknown";
            this.checkBoxUnknown.TabIndex = 5;
            this.checkBoxUnknown.Text = "All &others";
            this.checkBoxUnknown.Click += new System.EventHandler(this.OnClickTypes);
            // 
            // checkBoxOutlanding
            // 
            this.checkBoxOutlanding.Location = new System.Drawing.Point(16, 120);
            this.checkBoxOutlanding.Name = "checkBoxOutlanding";
            this.checkBoxOutlanding.Size = new System.Drawing.Size(120, 24);
            this.checkBoxOutlanding.TabIndex = 4;
            this.checkBoxOutlanding.Text = "&Outlanding fields";
            this.checkBoxOutlanding.Click += new System.EventHandler(this.OnClickTypes);
            // 
            // checkBoxLandmarks
            // 
            this.checkBoxLandmarks.Location = new System.Drawing.Point(16, 96);
            this.checkBoxLandmarks.Name = "checkBoxLandmarks";
            this.checkBoxLandmarks.TabIndex = 3;
            this.checkBoxLandmarks.Text = "&Landmarks";
            this.checkBoxLandmarks.Click += new System.EventHandler(this.OnClickTypes);
            // 
            // checkBoxGlidersites
            // 
            this.checkBoxGlidersites.Location = new System.Drawing.Point(16, 72);
            this.checkBoxGlidersites.Name = "checkBoxGlidersites";
            this.checkBoxGlidersites.TabIndex = 2;
            this.checkBoxGlidersites.Text = "&Glidersites";
            this.checkBoxGlidersites.Click += new System.EventHandler(this.OnClickTypes);
            // 
            // checkBoxAirport
            // 
            this.checkBoxAirport.Location = new System.Drawing.Point(16, 48);
            this.checkBoxAirport.Name = "checkBoxAirport";
            this.checkBoxAirport.TabIndex = 1;
            this.checkBoxAirport.Text = "&Airports";
            this.checkBoxAirport.Click += new System.EventHandler(this.OnClickTypes);
            // 
            // buttonOk
            // 
            this.buttonOk.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOk.Location = new System.Drawing.Point(156, 360);
            this.buttonOk.Name = "buttonOk";
            this.buttonOk.TabIndex = 12;
            this.buttonOk.Text = "OK";
            this.buttonOk.Click += new System.EventHandler(this.OnOK);
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(260, 360);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.TabIndex = 13;
            this.buttonCancel.Text = "Cancel";
            // 
            // groupBoxArea
            // 
            this.groupBoxArea.Controls.Add(this.coordEditControlLonTo);
            this.groupBoxArea.Controls.Add(this.coordEditControlLatTo);
            this.groupBoxArea.Controls.Add(this.label2);
            this.groupBoxArea.Controls.Add(this.coordEditControlLonFrom);
            this.groupBoxArea.Controls.Add(this.coordEditControlLatFrom);
            this.groupBoxArea.Controls.Add(this.label1);
            this.groupBoxArea.Location = new System.Drawing.Point(208, 16);
            this.groupBoxArea.Name = "groupBoxArea";
            this.groupBoxArea.Size = new System.Drawing.Size(272, 88);
            this.groupBoxArea.TabIndex = 4;
            this.groupBoxArea.TabStop = false;
            this.groupBoxArea.Text = "Area";
            // 
            // coordEditControlLonTo
            // 
            this.coordEditControlLonTo.IsLatitude = false;
            this.coordEditControlLonTo.Location = new System.Drawing.Point(144, 56);
            this.coordEditControlLonTo.Name = "coordEditControlLonTo";
            this.coordEditControlLonTo.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLonTo.TabIndex = 5;
            this.coordEditControlLonTo.Value = 0;
            // 
            // coordEditControlLatTo
            // 
            this.coordEditControlLatTo.IsLatitude = true;
            this.coordEditControlLatTo.Location = new System.Drawing.Point(48, 56);
            this.coordEditControlLatTo.Name = "coordEditControlLatTo";
            this.coordEditControlLatTo.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLatTo.TabIndex = 4;
            this.coordEditControlLatTo.Value = 0;
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(32, 56);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(14, 16);
            this.label2.TabIndex = 3;
            this.label2.Text = "to";
            // 
            // coordEditControlLonFrom
            // 
            this.coordEditControlLonFrom.IsLatitude = false;
            this.coordEditControlLonFrom.Location = new System.Drawing.Point(144, 24);
            this.coordEditControlLonFrom.Name = "coordEditControlLonFrom";
            this.coordEditControlLonFrom.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLonFrom.TabIndex = 2;
            this.coordEditControlLonFrom.Value = 0;
            // 
            // coordEditControlLatFrom
            // 
            this.coordEditControlLatFrom.IsLatitude = true;
            this.coordEditControlLatFrom.Location = new System.Drawing.Point(48, 24);
            this.coordEditControlLatFrom.Name = "coordEditControlLatFrom";
            this.coordEditControlLatFrom.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLatFrom.TabIndex = 1;
            this.coordEditControlLatFrom.Value = 0;
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(16, 24);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(27, 16);
            this.label1.TabIndex = 0;
            this.label1.Text = "from";
            // 
            // groupBoxRadius
            // 
            this.groupBoxRadius.Controls.Add(this.comboBoxRadius);
            this.groupBoxRadius.Controls.Add(this.label3);
            this.groupBoxRadius.Controls.Add(this.comboBoxWaypoints);
            this.groupBoxRadius.Controls.Add(this.radioButtonWayoint);
            this.groupBoxRadius.Controls.Add(this.radioButtonCenter);
            this.groupBoxRadius.Controls.Add(this.radioButtonHome);
            this.groupBoxRadius.Controls.Add(this.radioButtonPos);
            this.groupBoxRadius.Controls.Add(this.coordEditControlLat);
            this.groupBoxRadius.Controls.Add(this.coordEditControlLon);
            this.groupBoxRadius.Location = new System.Drawing.Point(208, 120);
            this.groupBoxRadius.Name = "groupBoxRadius";
            this.groupBoxRadius.Size = new System.Drawing.Size(272, 168);
            this.groupBoxRadius.TabIndex = 5;
            this.groupBoxRadius.TabStop = false;
            this.groupBoxRadius.Text = "Radius";
            // 
            // comboBoxRadius
            // 
            this.comboBoxRadius.Items.AddRange(new object[] {
                                                                "0",
                                                                "50",
                                                                "100",
                                                                "300",
                                                                "500"});
            this.comboBoxRadius.Location = new System.Drawing.Point(96, 134);
            this.comboBoxRadius.Name = "comboBoxRadius";
            this.comboBoxRadius.Size = new System.Drawing.Size(72, 21);
            this.comboBoxRadius.TabIndex = 6;
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(16, 136);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(65, 16);
            this.label3.TabIndex = 5;
            this.label3.Text = "Radius (km)";
            // 
            // comboBoxWaypoints
            // 
            this.comboBoxWaypoints.Location = new System.Drawing.Point(96, 98);
            this.comboBoxWaypoints.Name = "comboBoxWaypoints";
            this.comboBoxWaypoints.Size = new System.Drawing.Size(168, 21);
            this.comboBoxWaypoints.TabIndex = 4;
            // 
            // radioButtonWayoint
            // 
            this.radioButtonWayoint.Location = new System.Drawing.Point(16, 96);
            this.radioButtonWayoint.Name = "radioButtonWayoint";
            this.radioButtonWayoint.Size = new System.Drawing.Size(72, 24);
            this.radioButtonWayoint.TabIndex = 3;
            this.radioButtonWayoint.Text = "Waypoint";
            this.radioButtonWayoint.CheckedChanged += new System.EventHandler(this.OnCheckWaypointChanged);
            // 
            // radioButtonCenter
            // 
            this.radioButtonCenter.Location = new System.Drawing.Point(16, 72);
            this.radioButtonCenter.Name = "radioButtonCenter";
            this.radioButtonCenter.Size = new System.Drawing.Size(88, 24);
            this.radioButtonCenter.TabIndex = 2;
            this.radioButtonCenter.Text = "Center map";
            // 
            // radioButtonHome
            // 
            this.radioButtonHome.Location = new System.Drawing.Point(16, 48);
            this.radioButtonHome.Name = "radioButtonHome";
            this.radioButtonHome.Size = new System.Drawing.Size(56, 24);
            this.radioButtonHome.TabIndex = 1;
            this.radioButtonHome.Text = "Home";
            // 
            // radioButtonPos
            // 
            this.radioButtonPos.Location = new System.Drawing.Point(16, 24);
            this.radioButtonPos.Name = "radioButtonPos";
            this.radioButtonPos.Size = new System.Drawing.Size(72, 24);
            this.radioButtonPos.TabIndex = 0;
            this.radioButtonPos.Text = "Position";
            this.radioButtonPos.CheckedChanged += new System.EventHandler(this.OnCheckPosChanged);
            // 
            // coordEditControlLat
            // 
            this.coordEditControlLat.IsLatitude = true;
            this.coordEditControlLat.Location = new System.Drawing.Point(96, 24);
            this.coordEditControlLat.Name = "coordEditControlLat";
            this.coordEditControlLat.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLat.TabIndex = 7;
            this.coordEditControlLat.Value = 0;
            // 
            // coordEditControlLon
            // 
            this.coordEditControlLon.IsLatitude = false;
            this.coordEditControlLon.Location = new System.Drawing.Point(192, 24);
            this.coordEditControlLon.Name = "coordEditControlLon";
            this.coordEditControlLon.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLon.TabIndex = 8;
            this.coordEditControlLon.Value = 0;
            // 
            // buttonReset
            // 
            this.buttonReset.Location = new System.Drawing.Point(400, 360);
            this.buttonReset.Name = "buttonReset";
            this.buttonReset.TabIndex = 14;
            this.buttonReset.Text = "Reset";
            this.buttonReset.Click += new System.EventHandler(this.OnReset);
            // 
            // checkedListBoxCountry
            // 
            this.checkedListBoxCountry.CheckOnClick = true;
            this.checkedListBoxCountry.ForeColor = System.Drawing.SystemColors.WindowText;
            this.checkedListBoxCountry.Location = new System.Drawing.Point(16, 216);
            this.checkedListBoxCountry.Name = "checkedListBoxCountry";
            this.checkedListBoxCountry.ScrollAlwaysVisible = true;
            this.checkedListBoxCountry.Size = new System.Drawing.Size(176, 124);
            this.checkedListBoxCountry.Sorted = true;
            this.checkedListBoxCountry.TabIndex = 15;
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(16, 200);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(44, 16);
            this.label4.TabIndex = 16;
            this.label4.Text = "Country";
            // 
            // WaypointFilterDialog
            // 
            this.AcceptButton = this.buttonOk;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.buttonCancel;
            this.ClientSize = new System.Drawing.Size(490, 392);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.checkedListBoxCountry);
            this.Controls.Add(this.buttonReset);
            this.Controls.Add(this.groupBoxRadius);
            this.Controls.Add(this.groupBoxArea);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOk);
            this.Controls.Add(this.groupBoxTypes);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "WaypointFilterDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Waypoint Filter";
            this.groupBoxTypes.ResumeLayout(false);
            this.groupBoxArea.ResumeLayout(false);
            this.groupBoxRadius.ResumeLayout(false);
            this.ResumeLayout(false);

        }
		#endregion

        private void OnClickTypes(object sender, System.EventArgs e) {
            if (sender == checkBoxAll) {
                if (checkBoxAll.Checked) {
                    checkBoxAirport.Checked = 
                        checkBoxGlidersites.Checked = 
                        checkBoxLandmarks.Checked = 
                        checkBoxOutlanding.Checked =
                        checkBoxUnknown.Checked = false;
                }
            }
            else {
                checkBoxAll.Checked = false;
            }
        }

        private void OnCheckPosChanged(object sender, System.EventArgs e) {
            coordEditControlLat.Enabled = radioButtonPos.Checked;
            coordEditControlLon.Enabled = radioButtonPos.Checked;
        }

        private void OnCheckWaypointChanged(object sender, System.EventArgs e) {
            comboBoxWaypoints.Enabled = radioButtonWayoint.Checked;
        }

        private void OnReset(object sender, System.EventArgs e) {
            filter.Clear();
            InitGUI();
        }

        
        private void InitGUI() {

            if (filter.waypointTypes.Count > 0) {
                checkBoxAll.Checked = false;
                checkBoxAirport.Checked = filter.waypointTypes.ContainsKey(WayPointTypeId.Airport);
                checkBoxGlidersites.Checked = filter.waypointTypes.ContainsKey(WayPointTypeId.Glidersite);
                checkBoxLandmarks.Checked = filter.waypointTypes.ContainsKey(WayPointTypeId.Landmark);
                checkBoxOutlanding.Checked = filter.waypointTypes.ContainsKey(WayPointTypeId.Outlanding);
                checkBoxUnknown.Checked = filter.waypointTypes.ContainsKey(WayPointTypeId.Unknown);
                OnClickTypes(null, null);
            }
            else {
                checkBoxAll.Checked = true;
                OnClickTypes(checkBoxAll, null);
            }

            if (!filter.area.IsEmpty) {
                radioButtonCenter.Checked = false;
                radioButtonHome.Checked = false;
                radioButtonPos.Checked = false;
                radioButtonWayoint.Checked = false;
                coordEditControlLat.Value = 0;
                coordEditControlLon.Value = 0;
                comboBoxRadius.SelectedIndex = 0;
                comboBoxWaypoints.SelectedIndex = -1;

                coordEditControlLatFrom.Value = filter.area.TopLat;
                coordEditControlLonFrom.Value = filter.area.LeftLon;
                coordEditControlLatTo.Value = filter.area.BottomLat;
                coordEditControlLonTo.Value = filter.area.RightLon;
            }
            else {
                coordEditControlLatFrom.Value = 0;
                coordEditControlLonFrom.Value = 0;
                coordEditControlLatTo.Value = 0;
                coordEditControlLonTo.Value = 0;
            }
            if (filter.radius > 0) {
                comboBoxRadius.Text = filter.radius.ToString();
                switch (filter.reference) {
                case ReferenceType.CenterMap:
                    radioButtonCenter.Checked = true;
                    comboBoxWaypoints.SelectedIndex = -1;
                    break;
                case ReferenceType.HomePoint:
                    radioButtonHome.Checked = true;
                    comboBoxWaypoints.SelectedIndex = -1;
                    break;
                case ReferenceType.Position:
                    radioButtonPos.Checked = true;
                    coordEditControlLat.Value = filter.center.Latitude;
                    coordEditControlLon.Value = filter.center.Longitude;
                    comboBoxWaypoints.SelectedIndex = -1;
                    break;
                case ReferenceType.WayPoint:
                    radioButtonWayoint.Checked = true;
                    comboBoxWaypoints.SelectedItem = filter.center;
                    break;
                case ReferenceType.Unkonwn:
                    coordEditControlLon.Value = 0;
                    coordEditControlLat.Value = 0;
                    comboBoxRadius.SelectedIndex = 0;
                    comboBoxWaypoints.SelectedIndex = -1;
                    OnCheckPosChanged(null, null);
                    OnCheckWaypointChanged(null, null);
                    break;
                }
            }
            else {
                comboBoxRadius.SelectedIndex = 0;
                comboBoxWaypoints.SelectedIndex = -1;
                coordEditControlLat.Value = 0;
                coordEditControlLon.Value = 0;

                radioButtonCenter.Checked = false;
                radioButtonHome.Checked = false;
                radioButtonPos.Checked = false;
                radioButtonWayoint.Checked = false;

                OnCheckPosChanged(null, null);
                OnCheckWaypointChanged(null, null);
            }

            for (int i = 0; i < checkedListBoxCountry.Items.Count; i++) {
                checkedListBoxCountry.SetItemChecked(i, false);
            }
        }

        private void OnOK(object sender, System.EventArgs e) {
            this.DialogResult = DialogResult.OK;
            filter.waypointTypes.Clear();
            filter.countries.Clear();

            if (checkBoxAll.Checked) {
                filter.waypointTypes.Clear();
            }
            else {
                if (checkBoxAirport.Checked) {
                    filter.waypointTypes.Add(WayPointTypeId.Airport, null);
                }
                if (checkBoxGlidersites.Checked) {
                    filter.waypointTypes.Add(WayPointTypeId.Glidersite, null);
                }
                if (checkBoxLandmarks.Checked) {
                    filter.waypointTypes.Add(WayPointTypeId.Landmark, null);
                }
                if (checkBoxOutlanding.Checked) {
                    filter.waypointTypes.Add(WayPointTypeId.Outlanding, null);
                }
                if (checkBoxUnknown.Checked) {
                    filter.waypointTypes.Add(WayPointTypeId.Unknown, null);
                }
            }

            if (double.Parse(comboBoxRadius.Text) > 0.0) {
                filter.radius = double.Parse(comboBoxRadius.Text);
                if (radioButtonWayoint.Checked) {
                    if (comboBoxWaypoints.SelectedItem == null) {
                        MessageBox.Show("Please select a waypoint!", "Sorry", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        this.DialogResult = DialogResult.None;
                    }
                    else {
                        filter.center = (WayPoint) comboBoxWaypoints.SelectedItem;
                        filter.reference = ReferenceType.WayPoint;
                    }
                }
                else if (radioButtonPos.Checked) {
                    if (coordEditControlLat.Value == 0 && coordEditControlLon.Value == 0) {
                        MessageBox.Show("Please enter coordinates of reference point!", "Sorry", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        this.DialogResult = DialogResult.None;
                    }
                    else {
                        filter.center.Latitude = coordEditControlLat.Value;
                        filter.center.Longitude = coordEditControlLon.Value;
                        filter.reference = ReferenceType.Position;
                    }
                }
                else if (radioButtonCenter.Checked) {
                    filter.reference = ReferenceType.CenterMap;
                }
                else if (radioButtonHome.Checked) {
                    filter.reference = ReferenceType.HomePoint;
                }
                else {
                    MessageBox.Show("Please select a reference point!", "Sorry", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    this.DialogResult = DialogResult.None;
                }

                filter.area.Clear();
            }
            else {
                if ((radioButtonCenter.Checked || radioButtonHome.Checked || radioButtonPos.Checked || radioButtonWayoint.Checked) &&
                    double.Parse(comboBoxRadius.Text) == 0.0) {
                    MessageBox.Show("Please select or insert a radius!", "Sorry", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    this.DialogResult = DialogResult.None;
                }
                else {
                    filter.center.Clear();
                    if (coordEditControlLatFrom.Value == 0 && coordEditControlLatTo.Value == 0 &&
                        coordEditControlLonFrom.Value == 0 && coordEditControlLonTo.Value == 0) {
                        filter.area.Clear();
                    }
                    else {
                        filter.area.TopLat = coordEditControlLatFrom.Value;
                        filter.area.BottomLat = coordEditControlLatTo.Value;
                        filter.area.LeftLon = coordEditControlLonFrom.Value;
                        filter.area.RightLon = coordEditControlLonTo.Value;
                    }
                }
            }

            foreach (CountryTypeId c in checkedListBoxCountry.CheckedItems) {
                filter.countries.Add(c, null);
            }
        }
	}
}
