// name   : CoordEditControl.cs
// author : Harald Maier
// date   : 12.10.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using SoaringDotNET.Data;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for UserControl1.
	/// </summary>
	public class CoordEditControl : System.Windows.Forms.UserControl
	{
        private System.Windows.Forms.TextBox coordEdit;
        private string template;
        private bool isLatitude;
        private int coordValue;
        /// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public CoordEditControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			// TODO: Add any initialization after the InitializeComponent call
            coordValue = 0;
            IsLatitude = true;
            Value = 0;
            coordEdit.Select(0, 0);
		}

        #region Attributes
        public bool IsLatitude {
            get {
                return isLatitude;
            }
            set {
                isLatitude = value;
                if (isLatitude) {
                    template = "0000'00\"N";
                }
                else {
                    template = "00000'00\"E";
                }
                Value = coordValue;
            }
        }

        public int Value {
            get {
                return coordValue;
            }
            set {
                coordValue = value;
                coordEdit.Text = WgsPoint.ToString(coordValue, isLatitude);
                coordEdit.Select(0, 0);
            }
        }
        #endregion

        #region Protected Functions
        /// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

        #endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.coordEdit = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            // 
            // coordEdit
            // 
            this.coordEdit.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.coordEdit.Dock = System.Windows.Forms.DockStyle.Fill;
            this.coordEdit.Location = new System.Drawing.Point(0, 0);
            this.coordEdit.Name = "coordEdit";
            this.coordEdit.Size = new System.Drawing.Size(104, 20);
            this.coordEdit.TabIndex = 0;
            this.coordEdit.Text = "";
            this.coordEdit.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.coordEdit_KeyPress);
            // 
            // CoordEditControl
            // 
            this.Controls.Add(this.coordEdit);
            this.Name = "CoordEditControl";
            this.Size = new System.Drawing.Size(104, 24);
            this.ResumeLayout(false);

        }
		#endregion

        #region Control Events
        private void coordEdit_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e) {
            int idx = coordEdit.SelectionStart;
            e.Handled = true;

            if (idx < template.Length) {
                switch (template[idx]) {
                case '0':
                    if (e.KeyChar >= '0' && e.KeyChar <= '9') {
                        coordEdit.Text = coordEdit.Text.Substring(0, idx) + e.KeyChar + coordEdit.Text.Substring(idx + 1);
                        idx++;
                        if (template[idx] == '' || template[idx] == '\'' || template[idx] == '"') {
                            idx++;
                        }
                    }
                    break;
                case 'N':
                    if (e.KeyChar == 'N' || e.KeyChar == 'S' || e.KeyChar == 'n' || e.KeyChar == 's') {
                        coordEdit.Text = coordEdit.Text.Substring(0, idx) + e.KeyChar + coordEdit.Text.Substring(idx + 1);
                        idx++;
                    }
                    break;
                case 'E':
                    if (e.KeyChar == 'E' || e.KeyChar == 'W' || e.KeyChar == 'e' || e.KeyChar == 'w') {
                        coordEdit.Text = coordEdit.Text.Substring(0, idx) + e.KeyChar + coordEdit.Text.Substring(idx + 1);
                        idx++;
                    }
                    break;
                default:
                    //base.OnKeyPress (e);
                    break;
                }
                coordEdit.Select(idx, 0);
                coordValue = WgsPoint.FromString(coordEdit.Text, isLatitude);
            }
        }    
        #endregion
    }
}
