// name   : DiagramControl.cs
// author : Harald Maier
// date   : 03.09.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for DiagramControl.
	/// </summary>
    public class DiagramControl : System.Windows.Forms.UserControl {
        private Diagram diagram;
        private System.Windows.Forms.TrackBar trackBarSmooth;
        private System.Windows.Forms.Panel panel1;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Panel panel2;
        private System.Windows.Forms.Label labelSmoothFactor;
        /// <summary> 
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public DiagramControl() {
            // This call is required by the Windows.Forms Form Designer.
            InitializeComponent();

            // TODO: Add any initialization after the InitializeComponent call
        }

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region Component Designer generated code
        /// <summary> 
        /// Required method for Designer support - do not modify 
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.diagram = new SoaringDotNET.Controls.Diagram();
            this.trackBarSmooth = new System.Windows.Forms.TrackBar();
            this.panel1 = new System.Windows.Forms.Panel();
            this.labelSmoothFactor = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.panel2 = new System.Windows.Forms.Panel();
            ((System.ComponentModel.ISupportInitialize)(this.trackBarSmooth)).BeginInit();
            this.panel1.SuspendLayout();
            this.panel2.SuspendLayout();
            this.SuspendLayout();
            // 
            // diagram
            // 
            this.diagram.App = null;
            this.diagram.BackColor = System.Drawing.Color.White;
            this.diagram.Location = new System.Drawing.Point(0, 0);
            this.diagram.Name = "diagram";
            this.diagram.Size = new System.Drawing.Size(300, 200);
            this.diagram.SmoothFactor = 0;
            this.diagram.TabIndex = 0;
            // 
            // trackBarSmooth
            // 
            this.trackBarSmooth.LargeChange = 2;
            this.trackBarSmooth.Location = new System.Drawing.Point(16, 24);
            this.trackBarSmooth.Name = "trackBarSmooth";
            this.trackBarSmooth.Orientation = System.Windows.Forms.Orientation.Vertical;
            this.trackBarSmooth.Size = new System.Drawing.Size(42, 192);
            this.trackBarSmooth.TabIndex = 1;
            this.trackBarSmooth.TickStyle = System.Windows.Forms.TickStyle.Both;
            this.trackBarSmooth.ValueChanged += new System.EventHandler(this.OnSmoothFactorChanged);
            this.trackBarSmooth.Scroll += new System.EventHandler(this.OnScrollSmoothFactor);
            // 
            // panel1
            // 
            this.panel1.Controls.Add(this.labelSmoothFactor);
            this.panel1.Controls.Add(this.label1);
            this.panel1.Controls.Add(this.trackBarSmooth);
            this.panel1.Dock = System.Windows.Forms.DockStyle.Right;
            this.panel1.Location = new System.Drawing.Point(344, 0);
            this.panel1.Name = "panel1";
            this.panel1.Size = new System.Drawing.Size(64, 272);
            this.panel1.TabIndex = 2;
            // 
            // labelSmoothFactor
            // 
            this.labelSmoothFactor.Location = new System.Drawing.Point(18, 216);
            this.labelSmoothFactor.Name = "labelSmoothFactor";
            this.labelSmoothFactor.Size = new System.Drawing.Size(24, 16);
            this.labelSmoothFactor.TabIndex = 3;
            this.labelSmoothFactor.Text = "0";
            this.labelSmoothFactor.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(8, 8);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(58, 16);
            this.label1.TabIndex = 2;
            this.label1.Text = "Smoothing";
            // 
            // panel2
            // 
            this.panel2.AutoScroll = true;
            this.panel2.Controls.Add(this.diagram);
            this.panel2.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panel2.Location = new System.Drawing.Point(0, 0);
            this.panel2.Name = "panel2";
            this.panel2.Size = new System.Drawing.Size(344, 272);
            this.panel2.TabIndex = 3;
            this.panel2.SizeChanged += new System.EventHandler(this.OnSizeChanged);
            // 
            // DiagramControl
            // 
            this.Controls.Add(this.panel2);
            this.Controls.Add(this.panel1);
            this.Name = "DiagramControl";
            this.Size = new System.Drawing.Size(408, 272);
            ((System.ComponentModel.ISupportInitialize)(this.trackBarSmooth)).EndInit();
            this.panel1.ResumeLayout(false);
            this.panel2.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        private void OnSizeChanged(object sender, System.EventArgs e) {
            diagram.Width = panel2.ClientSize.Width;
            diagram.Height = panel2.ClientSize.Height;
        }

        private void OnScrollSmoothFactor(object sender, System.EventArgs e) {
            diagram.SmoothFactor = trackBarSmooth.Value;
        }

        private void OnSmoothFactorChanged(object sender, System.EventArgs e) {
            labelSmoothFactor.Text = trackBarSmooth.Value.ToString();
        }

        public Diagram Diagram {
            get {
                return diagram;
            }
        }
    }
}
