// name   : Explorer.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// 
	/// </summary>
	public class Explorer : System.Windows.Forms.UserControl
	{
        private System.Windows.Forms.ContextMenu contextMenuFlights;
        private System.Windows.Forms.MenuItem menuItemOpenFlight;
        private System.Windows.Forms.MenuItem menuItemCloseFlight;
        private System.Windows.Forms.ContextMenu contextMenuTasks;
        private System.Windows.Forms.MenuItem menuItemNewTask;
        private System.Windows.Forms.MenuItem menuItemEditTask;
        private System.Windows.Forms.MenuItem menuItemDeleteTask;
        private System.Windows.Forms.MenuItem menuItem2;
        private System.Windows.Forms.MenuItem menuItemOpenTasks;
        private System.Windows.Forms.MenuItem menuItemSaveTasks;
        private System.Windows.Forms.ContextMenu contextMenuWaypoints;
        private System.Windows.Forms.MenuItem menuItemOpenCatalogue;
        private System.Windows.Forms.MenuItem menuItemDeleteCatalogue;
        private System.Windows.Forms.MenuItem menuItemSaveCatalogue;
        private System.Windows.Forms.MenuItem menuItemSaveCatalogueAs;
        private System.Windows.Forms.MenuItem menuItemCloseCatalogue;
        private System.Windows.Forms.TreeView objectsView;
        private System.Windows.Forms.TreeNode flightNode;
        private System.Windows.Forms.TreeNode taskNode;
        private System.Windows.Forms.ImageList imageListRootItems;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.TreeNode waypointNode;

        private SoaringDotNet app;
        private System.Windows.Forms.MenuItem menuItemNewCatalogue;
        private System.Windows.Forms.MenuItem menuItem1;
        private System.Windows.Forms.MenuItem menuItem3;
        private System.Windows.Forms.MenuItem menuItemMergeCatalogue;
        private System.Windows.Forms.MenuItem menuItemOptimizeFlight;

        public Explorer() {
            InitializeComponent();
            // 
            // TODO: Add constructor logic here
            //
            flightNode = new TreeNode("Flights", 0, 0);
            taskNode = new TreeNode("Tasks", 1, 1);
            waypointNode = new TreeNode("Waypoint catalogues", 2, 2);
            //userNode = new TreeNode("Pilots", 3, 3);

            objectsView.Nodes.Add(flightNode);
            objectsView.Nodes.Add(taskNode);
            objectsView.Nodes.Add(waypointNode);
            //objectsView.Nodes.Add(userNode);
        }


        #region Private Functions
        private TreeNode Look4ObjectNode(TreeNode n) {
            // look for object node
            while (n.Parent != null && n.Tag == null) {
                n = n.Parent;
            }
            return n;
        }

        private TreeNode Look4ItemNode(Flight f) {
            foreach (TreeNode n in flightNode.Nodes) {
                if (n.Tag == f) {
                    return n;
                }
            }
            return null;
        }

        private TreeNode Look4ItemNode(Task t) {
            foreach (TreeNode n in taskNode.Nodes) {
                if (n.Tag == t) {
                    return n;
                }
            }
            return null;
        }

        private TreeNode Look4ItemNode(WaypointCatalog c) {
            foreach (TreeNode n in waypointNode.Nodes) {
                if (n.Tag == c) {
                    return n;
                }
            }
            return null;
        }

        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Explorer));
            this.objectsView = new System.Windows.Forms.TreeView();
            this.imageListRootItems = new System.Windows.Forms.ImageList(this.components);
            this.contextMenuFlights = new System.Windows.Forms.ContextMenu();
            this.menuItemOpenFlight = new System.Windows.Forms.MenuItem();
            this.menuItemOptimizeFlight = new System.Windows.Forms.MenuItem();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.menuItemCloseFlight = new System.Windows.Forms.MenuItem();
            this.contextMenuTasks = new System.Windows.Forms.ContextMenu();
            this.menuItemNewTask = new System.Windows.Forms.MenuItem();
            this.menuItemEditTask = new System.Windows.Forms.MenuItem();
            this.menuItemDeleteTask = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.menuItemOpenTasks = new System.Windows.Forms.MenuItem();
            this.menuItemSaveTasks = new System.Windows.Forms.MenuItem();
            this.contextMenuWaypoints = new System.Windows.Forms.ContextMenu();
            this.menuItemNewCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemOpenCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemDeleteCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemSaveCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItemSaveCatalogueAs = new System.Windows.Forms.MenuItem();
            this.menuItemCloseCatalogue = new System.Windows.Forms.MenuItem();
            this.menuItem3 = new System.Windows.Forms.MenuItem();
            this.menuItemMergeCatalogue = new System.Windows.Forms.MenuItem();
            this.SuspendLayout();
            // 
            // objectsView
            // 
            this.objectsView.Dock = System.Windows.Forms.DockStyle.Fill;
            this.objectsView.HideSelection = false;
            this.objectsView.ImageList = this.imageListRootItems;
            this.objectsView.Location = new System.Drawing.Point(0, 0);
            this.objectsView.Name = "objectsView";
            this.objectsView.Size = new System.Drawing.Size(200, 288);
            this.objectsView.TabIndex = 0;
            this.objectsView.MouseDown += new System.Windows.Forms.MouseEventHandler(this.objectsView_MouseDown);
            this.objectsView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.objectsView_AfterSelect);
            // 
            // imageListRootItems
            // 
            this.imageListRootItems.ImageSize = new System.Drawing.Size(16, 16);
            this.imageListRootItems.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListRootItems.ImageStream")));
            this.imageListRootItems.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // contextMenuFlights
            // 
            this.contextMenuFlights.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                               this.menuItemOpenFlight,
                                                                                               this.menuItemOptimizeFlight,
                                                                                               this.menuItem1,
                                                                                               this.menuItemCloseFlight});
            this.contextMenuFlights.Popup += new System.EventHandler(this.OnPopupContextMenuFlights);
            // 
            // menuItemOpenFlight
            // 
            this.menuItemOpenFlight.Index = 0;
            this.menuItemOpenFlight.Text = "&Open flight";
            this.menuItemOpenFlight.Click += new System.EventHandler(this.OnOpenFlight);
            // 
            // menuItemOptimizeFlight
            // 
            this.menuItemOptimizeFlight.Index = 1;
            this.menuItemOptimizeFlight.Text = "O&ptimize flight";
            this.menuItemOptimizeFlight.Click += new System.EventHandler(this.OnOptimizeFlight);
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 2;
            this.menuItem1.Text = "-";
            // 
            // menuItemCloseFlight
            // 
            this.menuItemCloseFlight.Index = 3;
            this.menuItemCloseFlight.Text = "&Close flight";
            this.menuItemCloseFlight.Click += new System.EventHandler(this.OnCloseFlight);
            // 
            // contextMenuTasks
            // 
            this.contextMenuTasks.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                             this.menuItemNewTask,
                                                                                             this.menuItemEditTask,
                                                                                             this.menuItemDeleteTask,
                                                                                             this.menuItem2,
                                                                                             this.menuItemOpenTasks,
                                                                                             this.menuItemSaveTasks});
            this.contextMenuTasks.Popup += new System.EventHandler(this.OnPopupContextMenuTasks);
            // 
            // menuItemNewTask
            // 
            this.menuItemNewTask.Index = 0;
            this.menuItemNewTask.Text = "&New task";
            this.menuItemNewTask.Click += new System.EventHandler(this.OnNewTask);
            // 
            // menuItemEditTask
            // 
            this.menuItemEditTask.Index = 1;
            this.menuItemEditTask.Text = "&Edit task";
            this.menuItemEditTask.Click += new System.EventHandler(this.OnEditTask);
            // 
            // menuItemDeleteTask
            // 
            this.menuItemDeleteTask.Index = 2;
            this.menuItemDeleteTask.Text = "&Delete task";
            this.menuItemDeleteTask.Click += new System.EventHandler(this.OnDeleteTask);
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 3;
            this.menuItem2.Text = "-";
            // 
            // menuItemOpenTasks
            // 
            this.menuItemOpenTasks.Index = 4;
            this.menuItemOpenTasks.Text = "&Open tasks";
            this.menuItemOpenTasks.Click += new System.EventHandler(this.OnOpenTasks);
            // 
            // menuItemSaveTasks
            // 
            this.menuItemSaveTasks.Index = 5;
            this.menuItemSaveTasks.Text = "&Save tasks";
            this.menuItemSaveTasks.Click += new System.EventHandler(this.OnSaveTasks);
            // 
            // contextMenuWaypoints
            // 
            this.contextMenuWaypoints.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                                 this.menuItemNewCatalogue,
                                                                                                 this.menuItemOpenCatalogue,
                                                                                                 this.menuItemDeleteCatalogue,
                                                                                                 this.menuItemMergeCatalogue,
                                                                                                 this.menuItem3,
                                                                                                 this.menuItemSaveCatalogue,
                                                                                                 this.menuItemSaveCatalogueAs,
                                                                                                 this.menuItemCloseCatalogue});
            this.contextMenuWaypoints.Popup += new System.EventHandler(this.OnPopupContextMenuWaypoints);
            // 
            // menuItemNewCatalogue
            // 
            this.menuItemNewCatalogue.Index = 0;
            this.menuItemNewCatalogue.Text = "&New catalogue";
            this.menuItemNewCatalogue.Click += new System.EventHandler(this.OnNewCatalog);
            // 
            // menuItemOpenCatalogue
            // 
            this.menuItemOpenCatalogue.Index = 1;
            this.menuItemOpenCatalogue.Text = "&Open catalogue";
            this.menuItemOpenCatalogue.Click += new System.EventHandler(this.OnOpenCatalog);
            // 
            // menuItemDeleteCatalogue
            // 
            this.menuItemDeleteCatalogue.Index = 2;
            this.menuItemDeleteCatalogue.Text = "&Delete catalogue";
            this.menuItemDeleteCatalogue.Click += new System.EventHandler(this.OnDeleteCatalog);
            // 
            // menuItemSaveCatalogue
            // 
            this.menuItemSaveCatalogue.Index = 5;
            this.menuItemSaveCatalogue.Text = "&Save catalogue";
            this.menuItemSaveCatalogue.Click += new System.EventHandler(this.OnSaveCatalog);
            // 
            // menuItemSaveCatalogueAs
            // 
            this.menuItemSaveCatalogueAs.Index = 6;
            this.menuItemSaveCatalogueAs.Text = "Save catalogue &as";
            this.menuItemSaveCatalogueAs.Click += new System.EventHandler(this.OnSaveCatalogAs);
            // 
            // menuItemCloseCatalogue
            // 
            this.menuItemCloseCatalogue.Index = 7;
            this.menuItemCloseCatalogue.Text = "&Close catalogue";
            this.menuItemCloseCatalogue.Click += new System.EventHandler(this.OnCloseCatalog);
            // 
            // menuItem3
            // 
            this.menuItem3.Index = 4;
            this.menuItem3.Text = "-";
            // 
            // menuItemMergeCatalogue
            // 
            this.menuItemMergeCatalogue.Index = 3;
            this.menuItemMergeCatalogue.Text = "&Merge catalogue";
            this.menuItemMergeCatalogue.Click += new System.EventHandler(this.OnMergeCatalogue);
            // 
            // Explorer
            // 
            this.Controls.Add(this.objectsView);
            this.Name = "Explorer";
            this.Size = new System.Drawing.Size(200, 288);
            this.ResumeLayout(false);

        }
        #endregion

        #region Public Functions
        public void Add(Flight node) {
            TreeNode n = new TreeNode(node.Name, 0, 0);
            n.Tag = node;
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));
            n.Nodes.Add(new TreeNode("", 3, 3));

            TreeNode t = new TreeNode("Task", 1, 1);
            n.Nodes.Add(t);
            t.Nodes.Add(new TreeNode("", 1, 1));
            t.Nodes.Add(new TreeNode("", 1, 1));
            t.Nodes.Add(new TreeNode("", 1, 1));
            t.Nodes.Add(new TreeNode("Waypoints", 2, 2));

            flightNode.Nodes.Add(n);
            Update(node);
            objectsView.SelectedNode = n;
        }

        public void Add(Task node) {
            TreeNode n = new TreeNode(node.Name, 1, 1);
            n.Tag = node;
            n.Nodes.Add(new TreeNode("", 1, 1));
            n.Nodes.Add(new TreeNode("", 1, 1));
            n.Nodes.Add(new TreeNode("", 1, 1));
            n.Nodes.Add(new TreeNode("Waypoints", 2, 2));

            taskNode.Nodes.Add(n);
            Update(node);
            objectsView.SelectedNode = n;
        }

        public void Add(WaypointCatalog node) {
            TreeNode n = new TreeNode(node.Name, 2, 2);
            n.Tag = node;
            n.Nodes.Add(new TreeNode("", 2, 2));
            n.Nodes.Add(new TreeNode("", 2, 2));
            n.Nodes.Add(new TreeNode("", 2, 2));

            waypointNode.Nodes.Add(n);
            Update(node);
            objectsView.SelectedNode = n;
        }

        public void Update(Flight f) {
            int i;
            WayPoint wp;
            string txt;
            TreeNode n = Look4ItemNode(f);
            if (n != null) {
                n.Nodes[0].Text = "Pilot: " + f.Pilot;
                n.Nodes[1].Text = "Date: " + f.Date;
                n.Nodes[2].Text = "Glider: " + f.Glider + " " + f.GliderId + (f.CompetitionId != null ? " (" + f.CompetitionId + ")" : "");
                n.Nodes[3].Text = "Takeoff: " + f[f.Takeoff].ToStringTime();
                n.Nodes[4].Text = "Landing: " + f[f.Landing].ToStringTime();
                n.Nodes[5].Text = "Duration: " + Time.ToTimeString(f.Duration);
                n.Nodes[6].Text = "Task duration: " + Time.ToTimeString(f.TaskDuration);

                TreeNode t = n.Nodes[7];
                t.Nodes[0].Text = "Type: " + f.currentTask.TaskTypeString;
                if (!f.currentTask.IsArea) {
                    t.Nodes[1].Text = string.Format(AppContents.ni, "Task length: {0:F1} km", f.currentTask.TaskDistanceKM);
                    t.Nodes[2].Text = string.Format(AppContents.ni, "Total length: {0:F1} km", f.currentTask.TotalDistanceKM);
                }
                else {
                    t.Nodes[1].Text = string.Format(AppContents.ni, "Task length: FIXME");
                    t.Nodes[2].Text = string.Format(AppContents.ni, "Total length: FIXME");
                }

                t = t.Nodes[3];

                if (t.Nodes.Count > f.currentTask.Count) {
                    for (i = t.Nodes.Count - 1; i >= f.currentTask.Count; i--) {
                        t.Nodes.RemoveAt(i);
                    }
                }
                else if (t.Nodes.Count < f.currentTask.Count) {
                    for (i = t.Nodes.Count; i < f.currentTask.Count; i++) {
                        t.Nodes.Add(new TreeNode("", 2, 2));
                    }
                }

                for(i = 0; i < f.currentTask.Count; i++) {
                    wp = (WayPoint)f.currentTask[i];
                    if (i > 0) {
                        txt = string.Format(AppContents.ni, "{0} {1:F1} km", wp.longName, wp.distanceKM(f.currentTask[i - 1]));
                    }
                    else {
                        txt = wp.longName;
                    }
                    t.Nodes[i].Text = txt;
                }
                n.EnsureVisible();
                n.Expand();
            }
        }

        public void Update(Task t) {
            int i;
            string txt;
            WayPoint wp;

            TreeNode n = Look4ItemNode(t);
            if (n != null) {
                n.Text = t.Name;
                n.Nodes[0].Text = "Type: " + t.TaskTypeString;
                if (!t.IsArea) {
                    n.Nodes[1].Text = string.Format(AppContents.ni, "Task length: {0:F1} km", t.TaskDistanceKM);
                    n.Nodes[2].Text = string.Format(AppContents.ni, "Total length: {0:F1} km", t.TotalDistanceKM);
                }
                else {
                    n.Nodes[1].Text = string.Format(AppContents.ni, "Task length: FIXME");
                    n.Nodes[2].Text = string.Format(AppContents.ni, "Total length: FIXME");
                }

                TreeNode tt = n.Nodes[3];
                if (tt.Nodes.Count > t.Count) {
                    for (i = tt.Nodes.Count - 1; i >= t.Count; i--) {
                        tt.Nodes.RemoveAt(i);
                    }
                }
                else if (tt.Nodes.Count < t.Count) {
                    for (i = tt.Nodes.Count; i < t.Count; i++) {
                        tt.Nodes.Add(new TreeNode("", 2, 2));
                    }
                }

                for(i = 0; i < t.Count; i++) {
                    wp = (WayPoint)t[i];
                    if (i > 0) {
                        txt = string.Format(AppContents.ni, "{0} {1:F1} km", wp.longName, wp.distanceKM(t[i -1]));
                    }
                    else {
                        txt = wp.longName;
                    }
                    tt.Nodes[i].Text = txt;
                }

                n.EnsureVisible();
                n.Expand();
                tt.Expand();
            }
        }

        public void Update(WaypointCatalog c) {
            TreeNode n = Look4ItemNode(c);
            if (n != null) {
                n.Nodes[0].Text = c.Count.ToString() + " Items";
                n.Nodes[1].Text = "Last update: " + c.LastModification;
                n.Nodes[2].Text = "Status: " + ((c.Dirty == true) ? "need save" : "clean");

                n.EnsureVisible();
                n.Expand();
            }
        }

        public void Save() {
            TreeNode n = objectsView.SelectedNode;
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                if (n.Parent == waypointNode) {
                    OnSaveCatalog(null, null);
                }
                else if (n.Parent == taskNode) {
                    OnSaveTasks(null, null);
                }
            }
        }

        #endregion

        #region Control Events
        private void objectsView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e) {
            TreeNode n = e.Node;
            while (n.Parent != null) {
                n = n.Parent;
            }
            if (n == flightNode) {
                objectsView.ContextMenu = contextMenuFlights;
            }
            else if (n == taskNode) {
                objectsView.ContextMenu = contextMenuTasks;
            }
            else if (n == waypointNode) {
                objectsView.ContextMenu = contextMenuWaypoints;
            }
            else {
                objectsView.ContextMenu = null;
            }

            n = Look4ObjectNode(e.Node);
            if (n.Tag != null) {
                if (n.Parent == waypointNode) {
                    app.Switch((WaypointCatalog) n.Tag);
                }
                else if (n.Parent == taskNode) {
                    app.Switch((Task)n.Tag);
                }
                else if (n.Parent == flightNode) {
                    app.Switch((Flight)n.Tag);
                }
            }

        }

        private void objectsView_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e) {
            if (e.Button == MouseButtons.Right) {
                objectsView.SelectedNode = objectsView.GetNodeAt(e.X, e.Y);
            }
        }
        #endregion

        #region Flight Handlers
        private void OnOpenFlight(object sender, System.EventArgs e) {
            app.OpenFlight();
        }

        private void OnOptimizeFlight(object sender, System.EventArgs e) {
            app.OptimizeFlight();
        }

        private void OnCloseFlight(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;

            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                app.Close((Flight)n.Tag);

                if (n.NextNode != null) {
                    objectsView.SelectedNode = n.NextNode;
                }
                else if (n.PrevNode != null) {
                    objectsView.SelectedNode = n.PrevNode;
                }
                else {
                    app.Switch((Flight) null);
                }

                n.Remove();
            }
        }
        #endregion

        #region Waypoint Handlers
        private void OnNewCatalog(object sender, System.EventArgs e) {
            app.NewCatalog();
        }

        private void OnOpenCatalog(object sender, System.EventArgs e) {
            app.OpenCatalog();        
        }

        private void OnCloseCatalog(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;

            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                app.Close((WaypointCatalog)n.Tag);

                if (n.NextNode != null) {
                    objectsView.SelectedNode = n.NextNode;
                }
                else if (n.PrevNode != null) {
                    objectsView.SelectedNode = n.PrevNode;
                }
                else {
                    app.Switch((WaypointCatalog) null);
                }

                n.Remove();
            }
        }

        private void OnDeleteCatalog(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                WaypointCatalog c = (WaypointCatalog)n.Tag;
                if (MessageBox.Show(app, "Remove catalogue " + c.Name + " from disk?", app.Name, MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation,
                    MessageBoxDefaultButton.Button2) == DialogResult.OK) {
                    OnCloseCatalog(sender, e);
                    c.Destroy();
                }
            }
        }

        private void OnMergeCatalogue(object sender, System.EventArgs e) {
            app.MergeCatalog();
        }

        private void OnSaveCatalog(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
                string defaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");

                WaypointCatalog c = (WaypointCatalog)n.Tag;
                c.Save(AppContents.tasks, defaultWaypointPath);
                Update(c);
            }
        }

        private void OnSaveCatalogAs(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
                string defaultWaypointPath = (string)currUser.GetValue("DefaultWaypointPath", "");

                WaypointCatalog c = (WaypointCatalog)n.Tag;
                c.SaveAs(AppContents.tasks, defaultWaypointPath);
                n.Text = c.Name;
                Update(c);
            }
        }

        #endregion

        #region Task Handlers
        private void OnDeleteTask(object sender, System.EventArgs e) {
            TreeNode n = objectsView.SelectedNode;
  
            n = Look4ObjectNode(n);
            if (n.Tag != null) {
                app.Close((Task)n.Tag);
                if (n.NextNode != null) {
                    objectsView.SelectedNode = n.NextNode;
                }
                else if (n.PrevNode != null) {
                    objectsView.SelectedNode = n.PrevNode;
                }
                else {
                    app.Switch((Task) null);
                }

                n.Remove();
            }
        }

        private void OnNewTask(object sender, System.EventArgs e) {
            app.NewTask();
        }

        private void OnEditTask(object sender, System.EventArgs e) {
            MessageBox.Show("Edit dialog not yet implemented!", "SoaringDotNet", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
        }

        private void OnOpenTasks(object sender, System.EventArgs e) {
            app.OpenTasks();
        }

        private void OnSaveTasks(object sender, System.EventArgs e) {
            app.SaveTasks();
        }
        #endregion

        #region PopupMenu Handlers
        private void OnPopupContextMenuWaypoints(object sender, System.EventArgs e) {
            this.menuItemDeleteCatalogue.Enabled = app.currentCatalog != null;
            this.menuItemMergeCatalogue.Enabled = app.currentCatalog != null;
            this.menuItemSaveCatalogue.Enabled = (app.currentCatalog != null && app.currentCatalog.Dirty);
            this.menuItemSaveCatalogueAs.Enabled = app.currentCatalog != null;
            this.menuItemCloseCatalogue.Enabled = app.currentCatalog != null;
        }

        private void OnPopupContextMenuFlights(object sender, System.EventArgs e) {
            this.menuItemCloseFlight.Enabled = app.currentFlight != null;
            this.menuItemOptimizeFlight.Enabled = app.currentFlight != null;
        }

        private void OnPopupContextMenuTasks(object sender, System.EventArgs e) {
            this.menuItemEditTask.Enabled = app.currentTask != null;
            this.menuItemDeleteTask.Enabled = app.currentTask != null;
            this.menuItemSaveTasks.Enabled = app.currentTask != null;
        }
        #endregion

        #region Attributes
        public SoaringDotNet App {
            get {
                return app;
            }
            set {
                app = value;
            }
        }
        #endregion

	}
}
