using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;

using SoaringDotNET.Database;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for GenTerrainDb4SoaringPilotDialog.
	/// </summary>
	public class GenTerrainDb4SoaringPilotDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.TextBox textBoxTopLat;
        private System.Windows.Forms.TextBox textBoxLeftLon;
        private System.Windows.Forms.TextBox textBoxRightLon;
        private System.Windows.Forms.TextBox textBoxBottomLat;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Button buttonRootDirectory;
        private System.Windows.Forms.TextBox textBoxRootDir;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Button buttonCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public GenTerrainDb4SoaringPilotDialog()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//

            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
            textBoxRootDir.Text = (string)currUser.GetValue("DEMRoot", "");
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.textBoxTopLat = new System.Windows.Forms.TextBox();
            this.textBoxLeftLon = new System.Windows.Forms.TextBox();
            this.textBoxRightLon = new System.Windows.Forms.TextBox();
            this.textBoxBottomLat = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.textBoxRootDir = new System.Windows.Forms.TextBox();
            this.buttonRootDirectory = new System.Windows.Forms.Button();
            this.label5 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.buttonOK = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // textBoxTopLat
            // 
            this.textBoxTopLat.Location = new System.Drawing.Point(160, 136);
            this.textBoxTopLat.Name = "textBoxTopLat";
            this.textBoxTopLat.Size = new System.Drawing.Size(48, 20);
            this.textBoxTopLat.TabIndex = 0;
            this.textBoxTopLat.Text = "";
            // 
            // textBoxLeftLon
            // 
            this.textBoxLeftLon.Location = new System.Drawing.Point(104, 160);
            this.textBoxLeftLon.Name = "textBoxLeftLon";
            this.textBoxLeftLon.Size = new System.Drawing.Size(48, 20);
            this.textBoxLeftLon.TabIndex = 1;
            this.textBoxLeftLon.Text = "";
            // 
            // textBoxRightLon
            // 
            this.textBoxRightLon.Location = new System.Drawing.Point(216, 160);
            this.textBoxRightLon.Name = "textBoxRightLon";
            this.textBoxRightLon.Size = new System.Drawing.Size(48, 20);
            this.textBoxRightLon.TabIndex = 2;
            this.textBoxRightLon.Text = "";
            // 
            // textBoxBottomLat
            // 
            this.textBoxBottomLat.Location = new System.Drawing.Point(160, 184);
            this.textBoxBottomLat.Name = "textBoxBottomLat";
            this.textBoxBottomLat.Size = new System.Drawing.Size(48, 20);
            this.textBoxBottomLat.TabIndex = 3;
            this.textBoxBottomLat.Text = "";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(168, 120);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(39, 16);
            this.label1.TabIndex = 4;
            this.label1.Text = "Top lat";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(64, 162);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(41, 16);
            this.label2.TabIndex = 5;
            this.label2.Text = "Left lon";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(264, 162);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(49, 16);
            this.label3.TabIndex = 6;
            this.label3.Text = "Right lon";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(160, 208);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(55, 16);
            this.label4.TabIndex = 7;
            this.label4.Text = "Bottom lat";
            // 
            // textBoxRootDir
            // 
            this.textBoxRootDir.Location = new System.Drawing.Point(16, 32);
            this.textBoxRootDir.Name = "textBoxRootDir";
            this.textBoxRootDir.ReadOnly = true;
            this.textBoxRootDir.Size = new System.Drawing.Size(320, 20);
            this.textBoxRootDir.TabIndex = 8;
            this.textBoxRootDir.Text = "";
            // 
            // buttonRootDirectory
            // 
            this.buttonRootDirectory.Location = new System.Drawing.Point(336, 32);
            this.buttonRootDirectory.Name = "buttonRootDirectory";
            this.buttonRootDirectory.Size = new System.Drawing.Size(24, 20);
            this.buttonRootDirectory.TabIndex = 9;
            this.buttonRootDirectory.Text = "...";
            this.buttonRootDirectory.Click += new System.EventHandler(this.OnButtonRootDirectory);
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(16, 16);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(98, 16);
            this.label5.TabIndex = 10;
            this.label5.Text = "DEM root directory";
            // 
            // label6
            // 
            this.label6.Location = new System.Drawing.Point(56, 64);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(240, 48);
            this.label6.TabIndex = 11;
            this.label6.Text = "Please enter top-left and bottom-right coordinate of terrain region. Numbers are " +
                "in nn.nnn format. Use negativ numbers for southern and western hemisphere";
            this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // buttonOK
            // 
            this.buttonOK.Location = new System.Drawing.Point(104, 232);
            this.buttonOK.Name = "buttonOK";
            this.buttonOK.TabIndex = 12;
            this.buttonOK.Text = "OK";
            this.buttonOK.Click += new System.EventHandler(this.OnOK);
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(200, 232);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.TabIndex = 13;
            this.buttonCancel.Text = "Cancel";
            // 
            // GenTerrainDb4SoaringPilotDialog
            // 
            this.AcceptButton = this.buttonOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.buttonCancel;
            this.ClientSize = new System.Drawing.Size(378, 272);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOK);
            this.Controls.Add(this.label6);
            this.Controls.Add(this.label5);
            this.Controls.Add(this.buttonRootDirectory);
            this.Controls.Add(this.textBoxRootDir);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.textBoxBottomLat);
            this.Controls.Add(this.textBoxRightLon);
            this.Controls.Add(this.textBoxLeftLon);
            this.Controls.Add(this.textBoxTopLat);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "GenTerrainDb4SoaringPilotDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Generate Terrain DB";
            this.ResumeLayout(false);

        }
		#endregion

        private void OnButtonRootDirectory(object sender, System.EventArgs e) {
            FolderBrowserDialog fd = new FolderBrowserDialog();
            fd.ShowNewFolderButton = false;
            fd.Description = "Select path of DEM root directory";
            if (fd.ShowDialog(this) == DialogResult.OK) {
                textBoxRootDir.Text = fd.SelectedPath;

                RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");
                currUser.SetValue("DEMRoot", textBoxRootDir.Text);
            }
        }

        private void OnOK(object sender, System.EventArgs e) {
            DialogResult = DialogResult.OK;
            SaveFileDialog fd = new SaveFileDialog();
            fd.CheckPathExists = true;
            fd.OverwritePrompt = false;
            fd.ValidateNames = true;
            fd.FileName = "SoaringPilot_terrain_db.pdb";
            fd.Filter = "PDB files (*.pdb)|*.pdb|All files (*.*)|*.*";
            fd.FilterIndex = 0;

            double topLat, leftLon, bottomLat, rightLon;
            try {
                topLat = double.Parse(textBoxTopLat.Text, SoaringDotNET.Data.AppContents.ni);
                leftLon = double.Parse(textBoxLeftLon.Text, SoaringDotNET.Data.AppContents.ni);
                bottomLat = double.Parse(textBoxBottomLat.Text, SoaringDotNET.Data.AppContents.ni);
                rightLon = double.Parse(textBoxRightLon.Text, SoaringDotNET.Data.AppContents.ni);
                if (bottomLat >= topLat) {
                    throw new Exception("Latitude out-of-bounds\nBottom lat greater than or equal to top lat");
                }
                if (rightLon <= leftLon) {
                    throw new Exception("Longitude out-of-bounds\nLeft lon less than or equal to right lon");
                }


                if (fd.ShowDialog() == DialogResult.OK) {
                    SoaringPilotTerrainGenerator tg = new SoaringPilotTerrainGenerator();
                    tg.DEMFilePath = textBoxRootDir.Text;
                    tg.BuildSPTerrainDB(fd.FileName, topLat, leftLon, bottomLat, rightLon);
                    MessageBox.Show(this, "Terrain DB written to " + fd.FileName, "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
            }
            catch (FormatException fe) {
                MessageBox.Show(this, fe.Message + "\n\nUse a decimal format like nn.nnn", "Format Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                DialogResult = DialogResult.None;
            }
            catch (Exception ex) {
                MessageBox.Show(this, ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                DialogResult = DialogResult.None;
            }
        }
	}
}
