using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.Data;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// Summary description for ImportSUAOptionsDialog.
	/// </summary>
	public class ImportSUAOptionsDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.CheckBox checkBoxLorenzMeier;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.ComboBox comboBoxDefaultAirspace;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ImportSUAOptionsDialog()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            comboBoxDefaultAirspace.Items.Add(new IdType(AirspaceClasses.A, "Class A"));
            comboBoxDefaultAirspace.Items.Add(new IdType(AirspaceClasses.B, "Class B"));
            comboBoxDefaultAirspace.Items.Add(new IdType(AirspaceClasses.C, "Class C"));
            comboBoxDefaultAirspace.Items.Add(new IdType(AirspaceClasses.D, "Class D"));
            comboBoxDefaultAirspace.Items.Add(new IdType(AirspaceClasses.E, "Class E"));
            comboBoxDefaultAirspace.Items.Add(new IdType(AirspaceClasses.F, "Class F"));
        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.buttonOK = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.checkBoxLorenzMeier = new System.Windows.Forms.CheckBox();
            this.label1 = new System.Windows.Forms.Label();
            this.comboBoxDefaultAirspace = new System.Windows.Forms.ComboBox();
            this.SuspendLayout();
            // 
            // buttonOK
            // 
            this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOK.Location = new System.Drawing.Point(64, 128);
            this.buttonOK.Name = "buttonOK";
            this.buttonOK.TabIndex = 0;
            this.buttonOK.Text = "OK";
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(160, 128);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.TabIndex = 1;
            this.buttonCancel.Text = "Cancel";
            // 
            // checkBoxLorenzMeier
            // 
            this.checkBoxLorenzMeier.Location = new System.Drawing.Point(24, 16);
            this.checkBoxLorenzMeier.Name = "checkBoxLorenzMeier";
            this.checkBoxLorenzMeier.Size = new System.Drawing.Size(248, 32);
            this.checkBoxLorenzMeier.TabIndex = 2;
            this.checkBoxLorenzMeier.Text = "Determine airspace type from title generated by Michael-Lorenz Meiers collection";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(24, 56);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(157, 16);
            this.label1.TabIndex = 3;
            this.label1.Text = "Default airspace for CTA/CTR:";
            // 
            // comboBoxDefaultAirspace
            // 
            this.comboBoxDefaultAirspace.Location = new System.Drawing.Point(24, 72);
            this.comboBoxDefaultAirspace.Name = "comboBoxDefaultAirspace";
            this.comboBoxDefaultAirspace.Size = new System.Drawing.Size(152, 21);
            this.comboBoxDefaultAirspace.TabIndex = 4;
            // 
            // ImportSUAOptionsDialog
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(298, 160);
            this.Controls.Add(this.comboBoxDefaultAirspace);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.checkBoxLorenzMeier);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOK);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.Name = "ImportSUAOptionsDialog";
            this.ShowInTaskbar = false;
            this.Text = "Import SUA options";
            this.ResumeLayout(false);

        }
		#endregion

        public bool UseMichaelMeier {
            get {
                return checkBoxLorenzMeier.Checked;
            }
        }

        public AirspaceClasses DefaultAirspace {
            get {
                AirspaceClasses space = AirspaceClasses.Unknown;
                IdType type = (IdType) comboBoxDefaultAirspace.SelectedItem;
                if (type != null) {
                    space = (AirspaceClasses) type.id;
                }
                return space;
            }
        }
	}
}
