// name   : MapColor.cs
// author : Harald Maier
// date   : 18.12.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   
using System;
using System.Drawing;
using Microsoft.Win32;

namespace SoaringDotNET.GUI
{
	/// <summary>
	/// 
	/// </summary>
    public class MapColor {
        private string name;
        private Color defaultColor;
        private Color drawColor;
		
        public MapColor(string name) :
            this(name, Color.Black, Color.Black) {}
        public MapColor(string name, Color defaultColor) :
            this(name, defaultColor, Color.Black) {}
        public MapColor(string name, Color defaultColor, Color drawColor) {
            this.name = name;
            this.defaultColor = defaultColor;
            this.drawColor = drawColor;
        }

        public void Reset() {
            drawColor = defaultColor;
        }

        public void Load() {
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Map\\Colors");
            try {
                drawColor = Color.FromArgb((int)currUser.GetValue(Name));
            }
            catch {
                Reset();
            }
        }

        public void Save() {
            RegistryKey currUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Map\\Colors");
            if (DrawColor != DefaultColor) {
                currUser.SetValue(Name, DrawColor.ToArgb());
            }
            else {
                currUser.DeleteValue(Name, false);
            }
            currUser.Close();
        }

        public override string ToString() {
            // TODO:  Add MapColor.ToString implementation
            return Name;
        }

        public string Name {
            get {
                return name;
            }
            set {
                name = value != null ? value : "";
            }
        }

        public Color DefaultColor {
            get {
                return defaultColor;
            }
        }

        public Color DrawColor {
            get {
                return drawColor;
            }
            set {
                drawColor = value;
            }
        }	
    }
}
