// name   : MapElement.cs
// author : Harald Maier
// date   : 17.10.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.Drawing;

using SoaringDotNET.Data;

namespace SoaringDotNET.GUI
{
    public enum MapElementTypes {Unknown, Flight, Task, WaypointCatalog, Airspace, TurnPoint};
	/// <summary>
	/// 
	/// </summary>
	public abstract class MapElement
	{
        protected MapElementTypes elementType;
        protected Pen pen = Pens.Black;
        protected Brush brush = Brushes.Transparent;
        protected Hashtable mapPos;

		public MapElement(MapElementTypes type)
		{
			// 
			// TODO: Add constructor logic here
			//
            elementType = type;
            mapPos = new Hashtable();
		}

        #region Public Functions
        public virtual void Draw(Graphics g, WgsArea view, int width, int height){}
        public virtual void Draw(Graphics g, Pen pen, Brush brush, WgsArea view, int width, int height){
            Pen oldPen = this.pen;
            Brush oldBrush = this.brush;
            this.pen = pen;
            this.brush = brush;
            this.Draw(g, view, width, height);
            this.pen = oldPen;
            this.brush = oldBrush;
        }

        public int FindElementNearPos(Point pos, int range) {
            return FindElementNearPos(pos.X, pos.Y, range);
        }

        public int FindElementNearPos(int x, int y, int range) {
            Point p;
            foreach (DictionaryEntry entry in mapPos) {
                p = (Point) entry.Value;
                if (Math.Abs(p.X - x) <= range && Math.Abs(p.Y - y) <= range) {
                    return (int)entry.Key;
                }
            }
            return -1;
        }
        #endregion

        #region Attributes
        public MapElementTypes Type {
            get {
                return elementType;
            }
        }
        #endregion
    }
}
