using System;
using System.IO;
using System.Collections;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;

namespace SoaringDotNET.FileFormats
{
	/// <summary>
	/// 
	/// </summary>
	public class SUAFileHandlerTimNewport
	{
		public SUAFileHandlerTimNewport()
		{
			// 
			// TODO: Add constructor logic here
			//
		}

        public void WriteFile(ArrayList suas, StreamWriter file) {
            foreach (string line in WriteFile(suas)) {
                file.WriteLine(line);
            }
        }

        public ArrayList WriteFile(ArrayList suas) {
            ArrayList file = new ArrayList(suas.Count * 6);
            bool firstSeg;
            string tmp, airspaceClass;
            Airspace space = null;
            foreach (AirspaceElement sua in suas) {
                space = sua.airspace;
                file.Add("INCLUDE=YES");
                airspaceClass = "";
                if (sua.AirspaceType == AirspaceTypes.SpecialUsedAirspace) {
                    tmp = string.Format("{0}:{1}",  space.id, space.name);
                }
                else {
                    tmp = space.name.Length > 0 ? space.name : space.id;
                }
                file.Add(string.Format("TITLE={0}", tmp));

                switch (space.airspaceType) {
                case AirspaceTypes.TerminalControlArea:
                    tmp = "TMA";
                    airspaceClass = sua.AirspaceClass.ToString();
                    break;
                case AirspaceTypes.ControlZone:
                    tmp = "CTA/CTR";
                    airspaceClass = sua.AirspaceClass.ToString();
/*                    if (sua.AirspaceClass == AirspaceClasses.C ||
                        sua.AirspaceClass == AirspaceClasses.D) {
                    }
                    else {
                        tmp = sua.AirspaceClassString;
                    }*/
                    break;
                default:
                    if (space.airspaceClass == AirspaceClasses.Temporary) {
                        tmp = "Training";
                    }
                    else if (space.airspaceClass == AirspaceClasses.Soaring) {
                        tmp = "SFS";
                    }
                    else {
                        tmp = sua.AirspaceClassString;
                    }
                    break;
                }
                file.Add(string.Format("TYPE={0}", tmp));
                file.Add(string.Format("CLASS={0}", airspaceClass));
                file.Add(string.Format("RADIO={0}", space.radioFrequency));
                file.Add(string.Format("ACTIVE={0}", space.remark));

                file.Add(string.Format("BASE={0}", space.lowerBound));
                file.Add(string.Format("TOPS={0}", space.upperBound));
                firstSeg = true;
                foreach (AirspaceSegment seg in sua) {
                    switch (seg.type) {
                    case AirspaceSegmentTypes.Line:
                        if (firstSeg) {
                            file.Add(string.Format("POINT={0} {1}", WgsPoint.ToCompactString(seg.latFrom, true), WgsPoint.ToCompactString(seg.lonFrom, false)));
                            firstSeg = false;
                        }
                        file.Add(string.Format("POINT={0} {1}", WgsPoint.ToCompactString(seg.latTo, true), WgsPoint.ToCompactString(seg.lonTo, false)));
                        break;
                    case AirspaceSegmentTypes.Circle:
                        file.Add(string.Format("CIRCLE RADIUS={0} CENTRE={1} {2}", seg.radius, WgsPoint.ToCompactString(seg.latCenter, true), WgsPoint.ToCompactString(seg.lonCenter, false)));
                        break;
                    case AirspaceSegmentTypes.ArcClock:
                    case AirspaceSegmentTypes.ArcCounterClock:
                        if (firstSeg) {
                            file.Add(string.Format("POINT={0} {1}", WgsPoint.ToCompactString(seg.latFrom, true), WgsPoint.ToCompactString(seg.lonFrom, false)));
                        }
                        file.Add(string.Format("{0}CLOCKWISE RADIUS={1} CENTRE={2} {3} TO={4} {5}", seg.type == AirspaceSegmentTypes.ArcCounterClock ? "ANTI-" : "",
                            seg.radius, WgsPoint.ToCompactString(seg.latCenter, true), WgsPoint.ToCompactString(seg.lonCenter, false), 
                            WgsPoint.ToCompactString(seg.latTo, true), WgsPoint.ToCompactString(seg.lonTo, false)));
                        firstSeg = true;
                        break;
                    }
                }
                file.Add("#");
            }
            file.Add("END");

            return file;
        }


        public ArrayList ReadFile(StreamReader file) {
            return ReadFile(file, false, AirspaceClasses.C);
        }

        public ArrayList ReadFile(StreamReader file, bool useMichaelMeier) {
            return ReadFile(file, useMichaelMeier, AirspaceClasses.C);
        }

        public ArrayList ReadFile(StreamReader file, AirspaceClasses defaultClass) {
            return ReadFile(file, false, defaultClass);
        }

        public ArrayList ReadFile(StreamReader file, bool useMichaelMeier, AirspaceClasses defaultClass) {
            ArrayList lines = new ArrayList();
            string line;
            while ((line = file.ReadLine()) != null) {
                lines.Add(line.Trim().ToUpper());
            }
            return ReadFile(lines, useMichaelMeier, defaultClass);
        }

        private ArrayList ReadFile(ArrayList file, bool useMichaelMeier, AirspaceClasses defaultClass) {
            ArrayList suas = new ArrayList();
            bool include = true;
            char [] splitt = {'\t', ' '};
            Match m = null;
            GroupCollection coll;
            string t;
            string []tt;
            string airspaceActive = "", airspaceRadio = "";
            AirspaceClasses airspaceClass = AirspaceClasses.Unknown;
            AirspaceTypes airspaceType = AirspaceTypes.Unknown;
            int lat, lon;

            Regex tokens = new Regex("(?:(?<first>INCLUDE)[ \t]*=[ \t]*(?<second>YES|NO))|" +
                "(?:(?<first>TITLE)[ \t]*=[ \t]*(?<second>.+))|" +
                "(?:(?<first>BASE)[ \t]*=[ \t]*(?<second>.+))|" +
                "(?:(?<first>POINT)[ \t]*=[ \t]*(?<second>[N|S][0-9]{6}[ \t]*[E|W][0-9]{7}))|" +
                "(?:(?<first>CIRCLE)[ \t]+RADIUS[ \t]*=[ \t]*(?<radius>[0-9]+\\.?[0-9]*)[ \t]+CENTRE[ \t]*=[ \t]*(?<centre>[N|S][0-9]{6}[ \t]*[E|W][0-9]{7}))|" +
                "(?:(?<first>CLOCKWISE|ANTI-CLOCKWISE)[ \t]+RADIUS[ \t]*=[ \t]*(?<radius>[0-9]+\\.?[0-9]*)[ \t]+CENTRE[ \t]*=[ \t]*(?<centre>[N|S][0-9]{6}[ \t]*[E|W][0-9]{7})[ \t]+TO[ \t]*=[ \t]*(?<to>[N|S][0-9]{6}[ \t]*[E|W][0-9]{7}))|" +
                "(?:(?<first>TOPS)[ \t]*=[ \t]*(?<second>.+))|" +
                "(?:(?<first>CLASS)[ \t]*=[ \t]*(?<second>.*))|" +
                "(?:(?<first>RADIO)[ \t]*=[ \t]*(?<second>.*))|" +
                "(?:(?<first>ACTIVE)[ \t]*=[ \t]*(?<second>.*))|" +
                "(?:(?<first>TYPE)[ \t]*=[ \t]*(?<second>.+))");
            Airspace space = null;
            AirspaceSegment segment = null;

            try {
                foreach (string line in file) {
                    m = tokens.Match(line);
                    if (m.Success) {
                        coll = m.Groups;
                        t = coll["first"].Value;
                        if (t == "INCLUDE") {
                            include = (coll["second"].Value == "YES");
                        }
                        else if (include) {
                            switch (t) {
                            case "TITLE":
                                if (space != null && space.airspaceType != AirspaceTypes.Unknown && space.name != "") {
                                    if (space.airspaceClass == AirspaceClasses.Unknown ||
                                        space.airspaceClass == AirspaceClasses.Other) {
                                        if (useMichaelMeier) {
                                            switch (space.name[0]) {
                                            case 'C':
                                                space.airspaceClass = AirspaceClasses.C;
                                                break;
                                            case 'D':
                                                space.airspaceClass = AirspaceClasses.D;
                                                break;
                                            case 'F':
                                                if (space.name[1] == 'X') {
                                                    space.airspaceClass = AirspaceClasses.F;
                                                }
                                                break;
                                            case 'H':
                                                if (space.name[1] == 'X') {
                                                    space.airspaceClass = AirspaceClasses.D;
                                                }
                                                break;
                                            case 'S':
                                                if (space.name[1] == 'X') {
                                                    space.airspaceClass = AirspaceClasses.Soaring;
                                                }
                                                break;
                                            default:
                                                if (space.name.Substring(0, 3) == "TMZ") {
                                                    space.airspaceClass = AirspaceClasses.TMZ;
                                                }
                                                break;
                                            }
                                        }
                                    }

                                    // append prev airspace, start new one
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = airspaceClass != AirspaceClasses.Unknown ? airspaceClass : defaultClass;
                                    }

                                    if (space.airspaceType == AirspaceTypes.Unknown) {
                                        space.airspaceType = airspaceType;
                                    }

                                    space.remark = airspaceActive;
                                    space.radioFrequency = airspaceRadio;
                                    suas.Add(space);
                                    space = null;
                                }

                                if (space == null) {
                                    space = new Airspace();
                                    segment = null;
                                }
                                space.name = coll["second"].Value;
                                break;
                            case "TYPE":
                                if (space != null && space.airspaceType != AirspaceTypes.Unknown && space.name != "") {
                                    if (space.airspaceClass == AirspaceClasses.Unknown ||
                                        space.airspaceClass == AirspaceClasses.Other) {
                                        if (useMichaelMeier) {
                                            switch (space.name[0]) {
                                            case 'C':
                                                space.airspaceClass = AirspaceClasses.C;
                                                break;
                                            case 'D':
                                                space.airspaceClass = AirspaceClasses.D;
                                                break;
                                            case 'F':
                                                if (space.name[1] == 'X') {
                                                    space.airspaceClass = AirspaceClasses.F;
                                                }
                                                break;
                                            case 'H':
                                                if (space.name[1] == 'X') {
                                                    space.airspaceClass = AirspaceClasses.D;
                                                }
                                                break;
                                            case 'S':
                                                if (space.name[1] == 'X') {
                                                    space.airspaceClass = AirspaceClasses.Soaring;
                                                }
                                                break;
                                            default:
                                                if (space.name.Substring(0, 3) == "TMZ") {
                                                    space.airspaceClass = AirspaceClasses.TMZ;
                                                }
                                                break;
                                            }
                                        }
                                    }

                                    // append prev airspace, start new one
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = airspaceClass != AirspaceClasses.Unknown ? airspaceClass : defaultClass;
                                    }

                                    if (space.airspaceType == AirspaceTypes.Unknown) {
                                        space.airspaceType = airspaceType;
                                    }

                                    space.remark = airspaceActive;
                                    space.radioFrequency = airspaceRadio;

                                    suas.Add(space);
                                    space = null;
                                }

                                if (space == null) {
                                    space = new Airspace();
                                    segment = null;
                                }

                                t = coll["second"].Value.Replace(" ", "").ToUpper();
                                switch (t) {
                                case "CTLZ":
                                    space.airspaceType = AirspaceTypes.ControlZone;
                                    break;
                                case "CTA":
                                case "CTR":
                                case "CTA/CTR":
                                case "C":
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "TCA":
                                case "TMA":
                                case "MTCA":
                                    space.airspaceType = AirspaceTypes.TerminalControlArea;
                                    break;
                                case "AIRWAYS":
                                case "A":
                                    space.airspaceClass = AirspaceClasses.Unknown;
                                    space.airspaceType = AirspaceTypes.Unknown;
                                    break;
                                case "RESTRICTED":
                                case "R":
                                    space.airspaceClass = AirspaceClasses.Restricted;
                                    space.airspaceType = AirspaceTypes.SpecialUsedAirspace;
                                    break;
                                case "PROHIBITED":
                                case "P":
                                    space.airspaceClass = AirspaceClasses.Prohibited;
                                    space.airspaceType = AirspaceTypes.SpecialUsedAirspace;
                                    break;
                                case "DANGER":
                                case "D":
                                    space.airspaceClass = AirspaceClasses.Danger;
                                    space.airspaceType = AirspaceTypes.SpecialUsedAirspace;
                                    break;
                                case "OTHER":
                                case "O":
                                    space.airspaceClass = AirspaceClasses.Other;
                                    space.airspaceType = AirspaceTypes.SpecialUsedAirspace;
                                    break;
                                case "TRAININGZONE":
                                case "Z":
                                    space.airspaceClass = AirspaceClasses.Temporary;
                                    space.airspaceType = AirspaceTypes.SpecialUsedAirspace;
                                    break;
                                case "MATZ":
                                case "MOA":
                                case "M":
                                    space.airspaceClass = AirspaceClasses.Military;
                                    space.airspaceType = AirspaceTypes.SpecialUsedAirspace;
                                    break;
                                case "TRAFFICINFO":
                                case "I":
                                    space.airspaceClass = AirspaceClasses.Unknown;
                                    space.airspaceType = AirspaceTypes.Unknown;
                                    break;
                                case "CLASSA":
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = AirspaceClasses.A;
                                    }
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "CLASSB":
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = AirspaceClasses.B;
                                    }
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "CLASSC":
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = AirspaceClasses.C;
                                    }
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "CLASSD":
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = AirspaceClasses.D;
                                    }
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "CLASSE":
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = AirspaceClasses.E;
                                    }
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "CLASSF":
                                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                                        space.airspaceClass = AirspaceClasses.F;
                                    }
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "SOARING":
                                    space.airspaceClass = AirspaceClasses.Soaring;
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                case "TMZ":
                                    space.airspaceClass = AirspaceClasses.TMZ;
                                    space.airspaceType = AirspaceTypes.ControlArea;
                                    break;
                                default:
                                    space.airspaceClass = AirspaceClasses.Unknown;
                                    space.airspaceType = AirspaceTypes.Unknown;
                                    break;
                                }
                                break;
                            case "CLASS":
                                // class keyword allway overwrite type
                                t = coll["second"].Value.ToUpper();
                                if (space == null) {
                                    space = new Airspace();
                                    segment = null;
                                }
                                switch (t) {
                                case "A":
                                    airspaceClass = AirspaceClasses.A;
                                    break;
                                case "B":
                                    airspaceClass = AirspaceClasses.B;
                                    break;
                                case "C":
                                    airspaceClass = AirspaceClasses.C;
                                    break;
                                case "D":
                                    airspaceClass = AirspaceClasses.D;
                                    break;
                                case "E":
                                    airspaceClass = AirspaceClasses.E;
                                    break;
                                case "F":
                                    airspaceClass = AirspaceClasses.F;
                                    break;
                                default:
                                    airspaceClass = AirspaceClasses.Unknown;
                                    break;
                                }

                                if (airspaceClass != AirspaceClasses.Unknown) {
                                    space.airspaceClass = airspaceClass;
                                }

                                break;
                            case "POINT":
                                tt = coll["second"].Value.Split(splitt);
                                lat = WgsPoint.FromCompactString(tt[0], true);
                                lon = WgsPoint.FromCompactString(tt[1], false);
                                if (segment == null) {
                                    segment = new AirspaceSegment();
                                    // from
                                    segment.latFrom = lat;
                                    segment.lonFrom = lon;
                                }
                                else {
                                    segment.type = AirspaceSegmentTypes.Line;
                                    // to
                                    segment.latTo = lat;
                                    segment.lonTo = lon;

                                    space.points.Add(segment);
                                    segment = new AirspaceSegment();
                                    segment.type = AirspaceSegmentTypes.Unknown;
                                    // from = to
                                    segment.latFrom = lat;
                                    segment.lonFrom = lon;
                                }
                                break;
                            case "CLOCKWISE":
                            case "ANTI-CLOCKWISE":
                                if (segment == null) {
                                    throw new Exception("No prev. POINT definition for clockwise or anti-clockwise arc");
                                }
                                if (t == "CLOCKWISE") {
                                    segment.type = AirspaceSegmentTypes.ArcClock;
                                }
                                else {
                                    segment.type = AirspaceSegmentTypes.ArcCounterClock;
                                }
                                // center, radius, to
                                tt = coll["centre"].Value.Split(splitt);
                                segment.latCenter = WgsPoint.FromCompactString(tt[0], true);
                                segment.lonCenter = WgsPoint.FromCompactString(tt[1], false);
                                segment.radius = float.Parse(coll["radius"].Value, AppContents.ni);
                                tt = coll["to"].Value.Split(splitt);
                                lat = WgsPoint.FromCompactString(tt[0], true);
                                lon = WgsPoint.FromCompactString(tt[1], false);
                                segment.latTo = lat;
                                segment.lonTo = lon;

                                space.points.Add(segment);
                                segment = new AirspaceSegment();
                                segment.type = AirspaceSegmentTypes.Unknown;
                                // from = to
                                segment.latFrom = lat;
                                segment.lonFrom = lon;
                                break;
                            case "CIRCLE":
                                if (space.points.Count > 0) {
                                    throw new Exception("Found other segments with circle entry");
                                }
                                else {
                                    segment = new AirspaceSegment();
                                    segment.type = AirspaceSegmentTypes.Circle;
                                }
                                // center, radius
                                tt = coll["centre"].Value.Split(splitt);
                                segment.latCenter = WgsPoint.FromCompactString(tt[0], true);
                                segment.lonCenter = WgsPoint.FromCompactString(tt[1], false);
                                segment.radius = float.Parse(coll["radius"].Value, AppContents.ni);
                                space.points.Add(segment);
                                segment = new AirspaceSegment();
                                break;
                            case "TOPS":
                                space.upperBound = coll["second"].Value;
                                break;
                            case "BASE":
                                space.lowerBound = coll["second"].Value;
                                break;
                            case "RADIO":
                                airspaceRadio = coll["second"].Value;
                                if (airspaceRadio == null) {
                                    airspaceRadio = "";
                                }
                                break;
                            case "ACTIVE":
                                airspaceActive = coll["second"].Value;
                                if (airspaceActive == null) {
                                    airspaceActive = "";
                                }
                                break;
                            }
                        }
                    }
                }

                if (space != null && space.name != "") {
                    if (space.airspaceClass == AirspaceClasses.Unknown) {
                        space.airspaceClass = airspaceClass != AirspaceClasses.Unknown ? airspaceClass : defaultClass;
                    }

                    if (space.airspaceType == AirspaceTypes.Unknown) {
                        space.airspaceType = airspaceType;
                    }

                    space.remark = airspaceActive;
                    space.radioFrequency = airspaceRadio;

                    suas.Add(space);
                }
            }
            catch (Exception e) {
                MessageBox.Show("An exception occured while reading file (Tim Newport Peace)\n\nThe fault line is:\n\n" +
                    m.ToString() + "\n\n" + e.StackTrace + "\n\n" + e.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                suas.Clear();
            }

            return suas;
        }
    }
}
