// name   : Sector.cs
// author : Harald Maier
// date   : 26.09.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// 
	/// </summary>
	public class Sector : System.Windows.Forms.UserControl
	{
        private Task currentTask;
        private int wpIndex;

        public Sector() {
            // 
            // TODO: Add constructor logic here
            //
            currentTask = null;
            wpIndex = -1;
            InitializeComponent();
        }

        private void InitializeComponent() {
            // 
            // Sector
            // 
            this.BackColor = System.Drawing.SystemColors.Window;
            this.Name = "Sector";

        }
	
        protected override void OnPaint(System.Windows.Forms.PaintEventArgs e) {
            // TODO:  Add Sector.OnPaint implementation
            base.OnPaint (e);
            Graphics g = e.Graphics;
            double x, y, x2, y2, x3, y3;
            double r, radius;
            WayPoint wp1, wp2;
            double alpha;
            double w1, w2;
            double maxSize, size;
            int sweepAngle;
            int d;
            SectorDefinition sector;

            wp1 = wp2 = null;

            if (currentTask != null && wpIndex > 0 && wpIndex < currentTask.Count - 1) {
                WayPoint wp = currentTask[wpIndex];
                sector = currentTask.GetSector(wpIndex);
                d = Math.Min(Width - 1, Height - 1);
                x = Width / 2;
                y = Height / 2;
                r = (double)d / 2.0;
                maxSize = Math.Max(sector.radius1, sector.radius2);

                if (wpIndex == 1) {
                    wp1 = currentTask[wpIndex + 1];
                }
                else if (wpIndex == currentTask.Count - 2) {
                    wp1 = currentTask[wpIndex - 1];
                }
                else {
                    wp1 = currentTask[wpIndex - 1];
                    wp2 = currentTask[wpIndex + 1];
                }
                if (wp1 != null) {
                    x2 = Math.Cos(Math.PI * (wp.bearingDeg(wp1) + 90.0) / 180.0) * r;
                    y2 = Math.Sin(Math.PI * (wp.bearingDeg(wp1) + 90.0) / 180.0) * r;
                    g.DrawLine(Pens.Blue, (float)x, (float)y, (float)(x - x2), (float)(y - y2));
                }

                if (wp2 != null) {
                    x2 = (float)Math.Cos(Math.PI * (wp.bearingDeg(wp2) + 90.0) / 180.0) * r;
                    y2 = (float)Math.Sin(Math.PI * (wp.bearingDeg(wp2) + 90.0) / 180.0) * r;
                    g.DrawLine(Pens.Blue, (float)x, (float)y, (float)(x - x2), (float)(y - y2));
                }
                else {
                    wp2 = wp1;
                }

                // draw sector
                if (sector.directionFrom == 360) {
                    w1 = wp.bearingDeg(wp1);
                    w2 = wp.bearingDeg(wp2);
                    alpha = WgsPoint.GetSectorAngle(w1, w2);
                }
                else {
                    alpha = sector.directionFrom;
                }

                switch (sector.sectorType) {
                case SectorTypes.Sector:
                    alpha = (alpha + (sector.angle / 2.0)) % 360.0;
                    if (sector.radius1 > 0) {
                        size = d * sector.radius1 / maxSize;
                        g.DrawPie(Pens.Green, (float)(Width - size) / 2, (float)(Height - size) / 2, (float)size, (float)size, (float)alpha + 90, -90);
                    }
                    if (sector.radius2 > 0) {
                        size = d * sector.radius2 / maxSize;
                        g.DrawEllipse(Pens.Green, (float)(Width - size) / 2, (float)(Height - size) / 2, (float)size, (float)size);
                    }
                    break;
                case SectorTypes.Line:
                    alpha += 180.0;
                    x2 = Math.Cos(Math.PI * alpha / 180.0) * (r * sector.radius1 / maxSize);
                    y2 = Math.Sin(Math.PI * alpha / 180.0) * (r * sector.radius1 / maxSize);
                    g.DrawLine(Pens.Green, (float)(x + x2), (float)(y + y2), (float)(x - x2), (float)(y - y2));
                    break;
                case SectorTypes.Area:
                    if (sector.directionFrom == sector.directionTo) {
                        // draw circle for both radius
                        if (sector.radius1 > 0) {
                            radius = r * sector.radius1 / maxSize;
                            g.DrawEllipse(Pens.Green, (float)(x - radius), (float)(y - radius), (float)(2 * radius), (float)(2 * radius));
                        }
                        if (sector.radius2 > 0) {
                            radius = r * sector.radius2 / maxSize;
                            g.DrawEllipse(Pens.Green, (float)(x - radius), (float)(y - radius), (float)(2 * radius), (float)(2 * radius));
                        }
                    }
                    else {
                        // calculate center and offset for upper left corner of arc rectangle
                        if (sector.directionFrom < sector.directionTo) {
                            sweepAngle = sector.directionTo - sector.directionFrom;
                        }
                        else {
                            sweepAngle = 360 - sector.directionFrom + sector.directionTo;
                        }
                        radius = r * sector.radius1 / maxSize;
                        if (radius > 0.0) {
                            g.DrawArc(Pens.Green, (float)(x - radius), (float)(y - radius), (float)(2 * radius), (float)(2 * radius), sector.directionFrom - 90, sweepAngle);
                        }

                        radius = r * sector.radius2 / maxSize;
                        if (radius > 0.0) {
                            g.DrawArc(Pens.Green, (float)(x - radius), (float)(y - radius), (float)(2 * radius), (float)(2 * radius), sector.directionFrom - 90, sweepAngle);
                        }

                        // draw segments
                        x2 = Math.Cos(Math.PI * (sector.directionFrom + 90) / 180.0) * (r * sector.radius1 / maxSize);
                        y2 = Math.Sin(Math.PI * (sector.directionFrom + 90) / 180.0) * (r * sector.radius1 / maxSize);
                        x3 = Math.Cos(Math.PI * (sector.directionFrom + 90) / 180.0) * (r * sector.radius2 / maxSize);
                        y3 = Math.Sin(Math.PI * (sector.directionFrom + 90) / 180.0) * (r * sector.radius2 / maxSize);
                        g.DrawLine(Pens.Green, (float)(x - x3), (float)(y - y3), (float)(x - x2), (float)(y - y2));
                        x2 = Math.Cos(Math.PI * (sector.directionTo + 90) / 180.0) * (r * sector.radius1 / maxSize);
                        y2 = Math.Sin(Math.PI * (sector.directionTo + 90) / 180.0) * (r * sector.radius1 / maxSize);
                        x3 = Math.Cos(Math.PI * (sector.directionTo + 90) / 180.0) * (r * sector.radius2 / maxSize);
                        y3 = Math.Sin(Math.PI * (sector.directionTo + 90) / 180.0) * (r * sector.radius2 / maxSize);
                        g.DrawLine(Pens.Green, (float)(x - x3), (float)(y - y3), (float)(x - x2), (float)(y - y2));
                    }
                    break;
                }
            }
        }

        public void Switch(int wpIdx) {
            wpIndex = wpIdx;
            Invalidate();
        }

        public void Switch(Task t) {
            currentTask = t;
            wpIndex = -1;
            Invalidate();
        }
    }
}
