// name   : SerialConnectionRecorder.cs
// author : Harald Maier
// date   : 25.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Windows.Forms;

using SerialPorts;

namespace SoaringDotNET.Recorders
{

    /// <summary>
	/// 
	/// </summary>
	public abstract class SerialConnectionRecorder : SoaringDotNET.Recorders.RecorderBase
	{
        protected SerialPort comPort;
        protected int preferedLineSpeed;
        protected object [] supportedLineSpeeds;

        public SerialConnectionRecorder()
		{
			// 
			// TODO: Add constructor logic here
			//
            SerialPorts.WithEvents ev = new WithEvents();
            comPort = new SerialPort(ev);
            comPort.Cnfg.FlowCtrl = Handshake.CtsRts;
            connectionType = RecorderConnectionType.Serial;
            preferedLineSpeed = 9600;
            supportedLineSpeeds = new object[0];
        }

        public override void Close() {
            // TODO:  Add SoaringPilot.Close implementation
            if (comPort.IsOpen) {
                comPort.Flush();
                comPort.Close();
            }
            base.Close();
        }

        public override bool Open(string port, LineSpeed speed) {
            bool ok;
            comPort.Cnfg.BaudRate = speed;
            comPort.Cnfg.PortName = port;
            
            if (!(ok = comPort.Open(int.Parse(port.Substring(port.Length - 2, 1))))) {
                MessageBox.Show(comPort.Fault, "IO Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            return ok;
        }
    
        public int PreferedSpeed {
            get {
                return preferedLineSpeed;
            }
        }

        public object[] SupportedLineSpeeds {
            get {
                return supportedLineSpeeds;
            }
        }
	}
}
