using System;
using System.IO;
using System.Collections;

using SoaringDotNET.Data;

namespace SoaringDotNET.FileFormats
{
	/// <summary>
	/// 
	/// </summary>

	public class VolksloggerHandler : FileHandlerBase
	{
        private enum VolksloggerFlags {Landable = 1, HardSurface = 2, Airport = 4, CheckPoint = 8};
        public VolksloggerHandler()
		{
			// 
			// TODO: Add constructor logic here
			//
		}
        public override void Load(StreamReader f, ArrayList waypoints) {
            // TODO:  Add SeeYouFileHandler.Load implementation
            string line;
            string [] tokens;
            WayPoint wp;
            int lat, lon, tmp;
            bool isNeg;

            while ((line = f.ReadLine()) != null) {
                line.Trim();
                if (line[0] == '*') {
                    continue;
                }
                else {
                    tokens = line.Split(',');
                    if (tokens.Length == 5) {
                        tmp = int.Parse(tokens[2]);
                        if (isNeg = tmp < 0) {
                            tmp = Math.Abs(tmp);
                        }
                        lat = (tmp / 100000) * 36000;
                        lat += (int)Math.Round((tmp % 100000) * 0.6, 0);
                        if (!isNeg) {
                            lat = -lat;
                        }

                        tmp = int.Parse(tokens[3]);
                        if (isNeg = tmp < 0) {
                            tmp = Math.Abs(tmp);
                        }
                        lon = (tmp / 100000) * 36000;
                        lon += (int)Math.Round((tmp % 100000) * 0.6, 0);
                        if (isNeg) {
                            lon = -lon;
                        }

                        wp = new WayPoint(lat, lon, tokens[1].Trim());
                        if (tokens[4].Length == 2) {
                            tmp = int.Parse(tokens[4].Substring(1));
                            if ((tmp & (int)VolksloggerFlags.Airport) > 0) {
                                wp.type = WayPointTypeId.Airport;
                            }
                            wp.landable = ((tmp & (int)VolksloggerFlags.Landable) > 0);
                            if (wp.landable) {
                                if ((tmp & (int)VolksloggerFlags.HardSurface) > 0) {
                                    wp.surface = SurfaceTypeId.Hard;
                                }
                                else {
                                    wp.surface = SurfaceTypeId.Grass;
                                }
                            }
                        }
                        waypoints.Add(wp);
                    }
                }
            }
        }
    
        public override void Save(StreamWriter f, ArrayList waypoints) {
            // TODO:  Add SeeYouFileHandler.Save implementation
            int i = 1, tLat, tLon, tmp;
            string line;
            bool isNeg;

            foreach (WayPoint wp in waypoints) {
                isNeg = wp.Latitude < 0;
                tmp = Math.Abs(wp.Latitude);
                tLat = tmp / 36000 * 100000;
                tLat += (tmp % 36000) * 10 / 6;
                if (!isNeg) {
                    tLat = -tLat;
                }

                tmp = Math.Abs(wp.Longitude);
                tLon = tmp / 36000 * 100000;
                tLon += (tmp % 36000) * 10 / 6;
                if (!isNeg) {
                    tLon = -tLon;
                }

                tmp = 0;
                if (wp.landable) {
                    tmp |= (int)VolksloggerFlags.Landable;
                    if (wp.surface == SurfaceTypeId.Hard) {
                        tmp |= (int)VolksloggerFlags.HardSurface;
                    }
                }

                if (wp.type == WayPointTypeId.Airport) {
                    tmp |= (int)VolksloggerFlags.Airport;
                }
                line = string.Format("{0:000},{1:},{2:0000000},{3:00000000},X{4}", i++, wp.shortName.PadRight(6), tLat, tLon, tmp);
                f.WriteLine(line);
            }
        }    
	}
}
