// name   : WayPoint.cs
// author : Harald Maier
// date   : 13.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using SoaringDotNET;

namespace SoaringDotNET.Data
{
	/// <summary>
	/// class WayPoint
	/// represent navigational pos on WGS sphere. May be of different type (airport, glider site ...)
	/// </summary>
	public class WayPoint : SoaringDotNET.Data.WgsPoint
	{
        public string longName = "";
        public string shortName = "";
        public string description = "";
        public WayPointTypeId type = WayPointTypeId.Unknown;
        public string icao = "";
        public bool landable = false;
        public string runway = "";
        public string frequency = "";
        public int length = -1;
        public SurfaceTypeId surface = SurfaceTypeId.Unknown;
        public string comment = "";
        public CountryTypeId country = CountryTypeId.Unknown;
        public FlightPoint reachPoint;

        public WayPoint() :
            this(0, 0, -1, "", WayPointTypeId.Unknown, "", "", false, "", "", -1, SurfaceTypeId.Unknown, "", CountryTypeId.Unknown, null, "") {}
        public WayPoint(int latitude, int longitude, int elevation, string name, WayPointTypeId type) :
            this(latitude, longitude, elevation, name, type, "", "", false, "", "", -1, SurfaceTypeId.Unknown, "", CountryTypeId.Unknown, null, "") {}
        public WayPoint(int latitude, int longitude, string name) :
            this(latitude, longitude, -1, name, WayPointTypeId.Unknown, "", "", false, "", "", -1, SurfaceTypeId.Unknown, "", CountryTypeId.Unknown, null, "") {}
        public WayPoint(WayPoint wp) : 
            this(wp.Latitude, wp.Longitude, wp.Elevation, wp.longName, wp.type, wp.description, wp.icao, wp.landable,
            wp.runway, wp.frequency, wp.length, wp.surface, wp.comment, wp.country, wp.reachPoint, wp.shortName) {}
        public WayPoint(WgsPoint wp) : 
            this(wp.Latitude, wp.Longitude, wp.Elevation, "", WayPointTypeId.Unknown, "", "", false, "", "", -1, SurfaceTypeId.Unknown, "", CountryTypeId.Unknown, null, "") {}
        public WayPoint(int latitude, int longitude, int elevation, string name, WayPointTypeId type, string description, string icao, bool landable, 
            string runway, string frequency, int length, SurfaceTypeId surface, string comment, CountryTypeId country, FlightPoint reachPoint, string shortName) : 
            base(latitude, longitude, elevation) {
            this.longName = name;
            this.description = description;
            this.type = type;
            this.icao = icao;
            this.landable = landable;
            this.runway = runway;
            this.frequency = frequency;
            this.length = length;
            this.surface = surface;
            this.comment = comment;
            this.country = country;
            this.reachPoint = (reachPoint == null ? new FlightPoint() : reachPoint);
            this.shortName = shortName;
        }

        public string ToStringTime() {
            return SoaringDotNET.Data.Time.ToTimeString(reachPoint.fixTime);
        }
    
        public override string ToString() {
            // TODO:  Add WayPoint.ToString implementation
            return this.longName;
        }
    }
}
