// name   : Waypoints.cs
// author : Harald Maier
// date   : 03.08.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.GUI;
using SoaringDotNET.Data;
using SoaringDotNET.Dialogs;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for Waypoint.
	/// </summary>
    public class Waypoints : System.Windows.Forms.UserControl {
        private SoaringDotNet app;
        private System.Windows.Forms.ListView listWaypoints;
        private System.Windows.Forms.ContextMenu popupMenu;
        private System.Windows.Forms.MenuItem popupMenuLarge;
        private System.Windows.Forms.MenuItem popupMenuSmall;
        private System.Windows.Forms.MenuItem popupMenuList;
        private System.Windows.Forms.MenuItem popupMenuReport;
        private System.Windows.Forms.ColumnHeader colLat;
        private System.Windows.Forms.ColumnHeader colLong;
        private System.Windows.Forms.ColumnHeader colElev;
        private System.Windows.Forms.ColumnHeader colFreq;
        private System.Windows.Forms.ColumnHeader colIcao;
        private System.Windows.Forms.MenuItem menuItem1;
        private System.Windows.Forms.MenuItem menuNewWaypoint;
        private System.Windows.Forms.MenuItem menuEditWaypoint;
        private System.Windows.Forms.MenuItem menuDeleteWaypoint;
        private System.Windows.Forms.ColumnHeader colDescription;
        private System.Windows.Forms.ColumnHeader colLandable;
        private System.Windows.Forms.ColumnHeader colRunway;
        private System.Windows.Forms.ColumnHeader colLength;
        private System.Windows.Forms.ColumnHeader colSurface;
        private System.Windows.Forms.ColumnHeader colComment;
        private System.Windows.Forms.ColumnHeader colCountry;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.ImageList smallImageList;
        private System.Windows.Forms.ColumnHeader colLongName;
        private System.Windows.Forms.ColumnHeader colShortName;
        private System.Windows.Forms.MenuItem popupMenuCopyTo;
        private System.Windows.Forms.MenuItem menuItem4;
        private System.Windows.Forms.MenuItem popupMenuMoveTo;
        private System.Windows.Forms.MenuItem menuItem2;
        private System.Windows.Forms.MenuItem menuItem3;
        private System.Windows.Forms.MenuItem menuItemCenterMap;
        private System.Windows.Forms.MenuItem menuItemSetToHomepoint;
        private System.Windows.Forms.Panel panelFilter;
        private System.Windows.Forms.Button buttonFilter;
        private System.Windows.Forms.ImageList imageListFilter;
        private System.Windows.Forms.ImageList largeImageList;
        private System.Windows.Forms.TextBox textBoxVisibleItems;

        private WaypointCatalog currentCatalog;

        public Waypoints() {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
            currentCatalog = null;
            popupMenuReport.Checked = true;
        }

        #region Protected Functions
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #endregion

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Waypoints));
            this.listWaypoints = new System.Windows.Forms.ListView();
            this.colLongName = new System.Windows.Forms.ColumnHeader();
            this.colShortName = new System.Windows.Forms.ColumnHeader();
            this.colLat = new System.Windows.Forms.ColumnHeader();
            this.colLong = new System.Windows.Forms.ColumnHeader();
            this.colElev = new System.Windows.Forms.ColumnHeader();
            this.colDescription = new System.Windows.Forms.ColumnHeader();
            this.colIcao = new System.Windows.Forms.ColumnHeader();
            this.colFreq = new System.Windows.Forms.ColumnHeader();
            this.colLandable = new System.Windows.Forms.ColumnHeader();
            this.colRunway = new System.Windows.Forms.ColumnHeader();
            this.colLength = new System.Windows.Forms.ColumnHeader();
            this.colSurface = new System.Windows.Forms.ColumnHeader();
            this.colComment = new System.Windows.Forms.ColumnHeader();
            this.colCountry = new System.Windows.Forms.ColumnHeader();
            this.largeImageList = new System.Windows.Forms.ImageList(this.components);
            this.smallImageList = new System.Windows.Forms.ImageList(this.components);
            this.popupMenu = new System.Windows.Forms.ContextMenu();
            this.menuNewWaypoint = new System.Windows.Forms.MenuItem();
            this.menuEditWaypoint = new System.Windows.Forms.MenuItem();
            this.menuDeleteWaypoint = new System.Windows.Forms.MenuItem();
            this.popupMenuCopyTo = new System.Windows.Forms.MenuItem();
            this.menuItem4 = new System.Windows.Forms.MenuItem();
            this.popupMenuMoveTo = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.menuItem3 = new System.Windows.Forms.MenuItem();
            this.menuItemCenterMap = new System.Windows.Forms.MenuItem();
            this.menuItemSetToHomepoint = new System.Windows.Forms.MenuItem();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.popupMenuLarge = new System.Windows.Forms.MenuItem();
            this.popupMenuSmall = new System.Windows.Forms.MenuItem();
            this.popupMenuList = new System.Windows.Forms.MenuItem();
            this.popupMenuReport = new System.Windows.Forms.MenuItem();
            this.panelFilter = new System.Windows.Forms.Panel();
            this.textBoxVisibleItems = new System.Windows.Forms.TextBox();
            this.buttonFilter = new System.Windows.Forms.Button();
            this.imageListFilter = new System.Windows.Forms.ImageList(this.components);
            this.panelFilter.SuspendLayout();
            this.SuspendLayout();
            // 
            // listWaypoints
            // 
            this.listWaypoints.AllowColumnReorder = true;
            this.listWaypoints.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                            this.colLongName,
                                                                                            this.colShortName,
                                                                                            this.colLat,
                                                                                            this.colLong,
                                                                                            this.colElev,
                                                                                            this.colDescription,
                                                                                            this.colIcao,
                                                                                            this.colFreq,
                                                                                            this.colLandable,
                                                                                            this.colRunway,
                                                                                            this.colLength,
                                                                                            this.colSurface,
                                                                                            this.colComment,
                                                                                            this.colCountry});
            this.listWaypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listWaypoints.FullRowSelect = true;
            this.listWaypoints.GridLines = true;
            this.listWaypoints.HideSelection = false;
            this.listWaypoints.LargeImageList = this.largeImageList;
            this.listWaypoints.Location = new System.Drawing.Point(0, 0);
            this.listWaypoints.Name = "listWaypoints";
            this.listWaypoints.Size = new System.Drawing.Size(592, 416);
            this.listWaypoints.SmallImageList = this.smallImageList;
            this.listWaypoints.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listWaypoints.TabIndex = 0;
            this.listWaypoints.View = System.Windows.Forms.View.Details;
            this.listWaypoints.DoubleClick += new System.EventHandler(this.OnEditWaypoint);
            // 
            // colLongName
            // 
            this.colLongName.Text = "Long name";
            this.colLongName.Width = 140;
            // 
            // colShortName
            // 
            this.colShortName.Text = "Short name";
            this.colShortName.Width = 80;
            // 
            // colLat
            // 
            this.colLat.Text = "Latitude";
            this.colLat.Width = 80;
            // 
            // colLong
            // 
            this.colLong.Text = "Longitude";
            this.colLong.Width = 80;
            // 
            // colElev
            // 
            this.colElev.Text = "Elevation";
            // 
            // colDescription
            // 
            this.colDescription.Text = "Description";
            this.colDescription.Width = 120;
            // 
            // colIcao
            // 
            this.colIcao.Text = "ICAO";
            // 
            // colFreq
            // 
            this.colFreq.Text = "Frequency";
            this.colFreq.Width = 70;
            // 
            // colLandable
            // 
            this.colLandable.Text = "Landable";
            // 
            // colRunway
            // 
            this.colRunway.Text = "Runway";
            // 
            // colLength
            // 
            this.colLength.Text = "Length";
            // 
            // colSurface
            // 
            this.colSurface.Text = "Surface";
            // 
            // colComment
            // 
            this.colComment.Text = "Comment";
            // 
            // colCountry
            // 
            this.colCountry.Text = "Country";
            // 
            // largeImageList
            // 
            this.largeImageList.ImageSize = new System.Drawing.Size(32, 32);
            this.largeImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("largeImageList.ImageStream")));
            this.largeImageList.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // smallImageList
            // 
            this.smallImageList.ImageSize = new System.Drawing.Size(16, 16);
            this.smallImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("smallImageList.ImageStream")));
            this.smallImageList.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // popupMenu
            // 
            this.popupMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                      this.menuNewWaypoint,
                                                                                      this.menuEditWaypoint,
                                                                                      this.menuDeleteWaypoint,
                                                                                      this.popupMenuCopyTo,
                                                                                      this.popupMenuMoveTo,
                                                                                      this.menuItem3,
                                                                                      this.menuItemCenterMap,
                                                                                      this.menuItemSetToHomepoint,
                                                                                      this.menuItem1,
                                                                                      this.popupMenuLarge,
                                                                                      this.popupMenuSmall,
                                                                                      this.popupMenuList,
                                                                                      this.popupMenuReport});
            this.popupMenu.Popup += new System.EventHandler(this.OnMenuPopup);
            // 
            // menuNewWaypoint
            // 
            this.menuNewWaypoint.Index = 0;
            this.menuNewWaypoint.Text = "&New Waypoint";
            this.menuNewWaypoint.Click += new System.EventHandler(this.OnNewWaypoint);
            // 
            // menuEditWaypoint
            // 
            this.menuEditWaypoint.Index = 1;
            this.menuEditWaypoint.Text = "&Edit Waypoint";
            this.menuEditWaypoint.Click += new System.EventHandler(this.OnEditWaypoint);
            // 
            // menuDeleteWaypoint
            // 
            this.menuDeleteWaypoint.Index = 2;
            this.menuDeleteWaypoint.Text = "&Delete Waypoint";
            this.menuDeleteWaypoint.Click += new System.EventHandler(this.OnDeleteWaypoint);
            // 
            // popupMenuCopyTo
            // 
            this.popupMenuCopyTo.Index = 3;
            this.popupMenuCopyTo.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                            this.menuItem4});
            this.popupMenuCopyTo.Text = "&Copy to...";
            this.popupMenuCopyTo.Popup += new System.EventHandler(this.OnPopupCopyTo);
            // 
            // menuItem4
            // 
            this.menuItem4.Index = 0;
            this.menuItem4.Text = "";
            // 
            // popupMenuMoveTo
            // 
            this.popupMenuMoveTo.Index = 4;
            this.popupMenuMoveTo.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                            this.menuItem2});
            this.popupMenuMoveTo.Text = "&Move to...";
            this.popupMenuMoveTo.Popup += new System.EventHandler(this.OnPopupMoveTo);
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 0;
            this.menuItem2.Text = "";
            // 
            // menuItem3
            // 
            this.menuItem3.Index = 5;
            this.menuItem3.Text = "-";
            // 
            // menuItemCenterMap
            // 
            this.menuItemCenterMap.Index = 6;
            this.menuItemCenterMap.Text = "Cen&ter map";
            this.menuItemCenterMap.Click += new System.EventHandler(this.OnCenterMap);
            // 
            // menuItemSetToHomepoint
            // 
            this.menuItemSetToHomepoint.Index = 7;
            this.menuItemSetToHomepoint.Text = "Set to homepoint";
            this.menuItemSetToHomepoint.Click += new System.EventHandler(this.OnSetHomePoint);
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 8;
            this.menuItem1.Text = "-";
            // 
            // popupMenuLarge
            // 
            this.popupMenuLarge.Index = 9;
            this.popupMenuLarge.RadioCheck = true;
            this.popupMenuLarge.Text = "&Large View";
            this.popupMenuLarge.Click += new System.EventHandler(this.OnLargeView);
            // 
            // popupMenuSmall
            // 
            this.popupMenuSmall.Index = 10;
            this.popupMenuSmall.RadioCheck = true;
            this.popupMenuSmall.Text = "&Small View";
            this.popupMenuSmall.Click += new System.EventHandler(this.OnSmallView);
            // 
            // popupMenuList
            // 
            this.popupMenuList.Index = 11;
            this.popupMenuList.RadioCheck = true;
            this.popupMenuList.Text = "L&ist View";
            this.popupMenuList.Click += new System.EventHandler(this.OnListView);
            // 
            // popupMenuReport
            // 
            this.popupMenuReport.Index = 12;
            this.popupMenuReport.RadioCheck = true;
            this.popupMenuReport.Text = "De&tail View";
            this.popupMenuReport.Click += new System.EventHandler(this.OnDetailView);
            // 
            // panelFilter
            // 
            this.panelFilter.Controls.Add(this.textBoxVisibleItems);
            this.panelFilter.Controls.Add(this.buttonFilter);
            this.panelFilter.Dock = System.Windows.Forms.DockStyle.Right;
            this.panelFilter.Location = new System.Drawing.Point(592, 0);
            this.panelFilter.Name = "panelFilter";
            this.panelFilter.Size = new System.Drawing.Size(136, 416);
            this.panelFilter.TabIndex = 1;
            // 
            // textBoxVisibleItems
            // 
            this.textBoxVisibleItems.BackColor = System.Drawing.SystemColors.Control;
            this.textBoxVisibleItems.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.textBoxVisibleItems.Cursor = System.Windows.Forms.Cursors.Arrow;
            this.textBoxVisibleItems.Location = new System.Drawing.Point(16, 40);
            this.textBoxVisibleItems.Multiline = true;
            this.textBoxVisibleItems.Name = "textBoxVisibleItems";
            this.textBoxVisibleItems.ReadOnly = true;
            this.textBoxVisibleItems.Size = new System.Drawing.Size(112, 32);
            this.textBoxVisibleItems.TabIndex = 1;
            this.textBoxVisibleItems.Text = "0 items\r\n0 visible";
            // 
            // buttonFilter
            // 
            this.buttonFilter.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonFilter.ImageIndex = 0;
            this.buttonFilter.ImageList = this.imageListFilter;
            this.buttonFilter.Location = new System.Drawing.Point(16, 8);
            this.buttonFilter.Name = "buttonFilter";
            this.buttonFilter.TabIndex = 0;
            this.buttonFilter.Text = "Filter";
            this.buttonFilter.Click += new System.EventHandler(this.OnFilter);
            // 
            // imageListFilter
            // 
            this.imageListFilter.ImageSize = new System.Drawing.Size(16, 16);
            this.imageListFilter.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListFilter.ImageStream")));
            this.imageListFilter.TransparentColor = System.Drawing.Color.White;
            // 
            // Waypoints
            // 
            this.ContextMenu = this.popupMenu;
            this.Controls.Add(this.listWaypoints);
            this.Controls.Add(this.panelFilter);
            this.Name = "Waypoints";
            this.Size = new System.Drawing.Size(728, 416);
            this.panelFilter.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        #region Private Functions
        // popup menu handlers
        private void OnMenuPopup(object sender, System.EventArgs e) {
            menuNewWaypoint.Enabled = (currentCatalog != null);
            menuEditWaypoint.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
            menuDeleteWaypoint.Enabled = (currentCatalog != null && currentCatalog.Count > 0);
        }

        private void OnPopupCopyTo(object sender, System.EventArgs e) {
            popupMenuCopyTo.MenuItems.Clear();
            foreach (WaypointCatalog c in AppContents.waypointCatalogs) {
                if (c != currentCatalog) {
                    popupMenuCopyTo.MenuItems.Add(c.ToString(), new System.EventHandler(OnSelectCopyToCatalog));
                }
            }
            if (popupMenuCopyTo.MenuItems.Count < 1) {
                popupMenuCopyTo.MenuItems.Add("-");
            }
        }

        private void OnSelectCopyToCatalog(object sender, System.EventArgs e) {
            MenuItem m = (MenuItem)sender;
            WaypointCatalog c = app.appContents.FindCatalog(m.Text);
            foreach (ListViewItem ic in listWaypoints.SelectedItems) {
                app.CopyWaypoint((WayPoint)ic.Tag, c);
            }
        }

        private void OnPopupMoveTo(object sender, System.EventArgs e) {
            popupMenuMoveTo.MenuItems.Clear();
            foreach (WaypointCatalog c in AppContents.waypointCatalogs) {
                if (c != currentCatalog) {
                    popupMenuMoveTo.MenuItems.Add(c.ToString(), new System.EventHandler(OnSelectMoveToCatalog));
                }
            }

            if (popupMenuMoveTo.MenuItems.Count < 1) {
                popupMenuMoveTo.MenuItems.Add("-");
            }
        }

        private void OnSelectMoveToCatalog(object sender, System.EventArgs e) {
            MenuItem m = (MenuItem)sender;
            WaypointCatalog c = app.appContents.FindCatalog(m.Text);
            foreach (ListViewItem ic in listWaypoints.SelectedItems) {
                app.MoveWaypoint((WayPoint)ic.Tag, currentCatalog, c);
            }                
        }

        private void OnNewWaypoint(object sender, System.EventArgs e) {
            app.AddWaypoint();
        }

        private void OnEditWaypoint(object sender, System.EventArgs e) {
            if (listWaypoints.SelectedItems.Count > 0) {
                WayPoint wp = (WayPoint)listWaypoints.SelectedItems[0].Tag;
                app.EditWaypoint(wp);
            }
        }

        private void OnDeleteWaypoint(object sender, System.EventArgs e) {
            ArrayList l = new ArrayList(listWaypoints.SelectedItems.Count);
            foreach (ListViewItem ic in listWaypoints.SelectedItems) {
                l.Add(ic.Tag);
            }

            app.Delete(l);
        }

        private void OnCenterMap(object sender, System.EventArgs e) {
            if (listWaypoints.SelectedItems.Count > 0) {
                WayPoint wp = (WayPoint)listWaypoints.SelectedItems[0].Tag;
                app.CenterMapTo(wp);
            }        
        }

        private void OnSetHomePoint(object sender, System.EventArgs e) {
            if (listWaypoints.SelectedItems.Count > 0) {
                WayPoint wp = (WayPoint)listWaypoints.SelectedItems[0].Tag;
                app.SetHomePoint(wp);
            }        
        }

        private void OnLargeView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.LargeIcon;
            popupMenuLarge.Checked = true;
            popupMenuList.Checked = false;
            popupMenuReport.Checked = false;
            popupMenuSmall.Checked = false;
        }

        private void OnSmallView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.SmallIcon;
            popupMenuLarge.Checked = false;
            popupMenuList.Checked = false;
            popupMenuReport.Checked = false;
            popupMenuSmall.Checked = true;
        }
        
        private void OnListView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.List;
            popupMenuLarge.Checked = false;
            popupMenuList.Checked = true;
            popupMenuReport.Checked = false;
            popupMenuSmall.Checked = false;
        }
        
        private void OnDetailView(object sender, System.EventArgs e) {
            this.listWaypoints.View = System.Windows.Forms.View.Details;
            popupMenuLarge.Checked = false;
            popupMenuList.Checked = false;
            popupMenuReport.Checked = true;
            popupMenuSmall.Checked = false;            
        }

        private void OnFilter(object sender, System.EventArgs e) {
            WaypointFilterDialog fd = new WaypointFilterDialog(currentCatalog);
            if (fd.ShowDialog(this) == DialogResult.OK) {
                WayPointFilter filter = fd.filter;
                if (filter.reference == ReferenceType.CenterMap) {
                    filter.center = new WayPoint(app.MapCenter);
                }
                else if (filter.reference == ReferenceType.HomePoint) {
                    filter.center = new WayPoint(app.appContents.homePoint);
                }

                currentCatalog.Filter = filter;                
                app.Update(currentCatalog);
            }
        }

        private void UpdateFilterInfo() {
            string [] lines = textBoxVisibleItems.Lines;
            lines[0] = string.Format("{0} items", currentCatalog != null ? currentCatalog.Count : 0);
            lines[1] = string.Format("{0} visible", currentCatalog != null ? currentCatalog.VisibleWaypoints.Count : 0);
            textBoxVisibleItems.Lines = lines;
        }

        #endregion

        #region Public Functions
        public void SwitchToCatalog(WaypointCatalog catalog) {
            if (catalog != currentCatalog) {
                currentCatalog = catalog;
                Refill();
            }
        }

        public void Update(WaypointCatalog catalog) {
            if (catalog == currentCatalog) {
                Refill();
            }
        }


        public void Add(WayPoint wp) {
            if (currentCatalog != null) {
                CatalogOperation res = currentCatalog.Add(wp);
                
                switch (res) {
                case CatalogOperation.Add:
                    // check if not filtered
                    if (currentCatalog.Filter.IsVisible(wp)) {
                        ListViewItem l = new ListViewItem(wp.longName);
                        l.Tag = wp;
                        l.ImageIndex = (int)wp.type;
                        l.SubItems.AddRange(new string [] {wp.shortName, wp.ToStringLat(), wp.ToStringLong(), wp.Elevation != -1 ? wp.Elevation.ToString() + "m" : "",
                                                                wp.description, wp.icao, wp.frequency, wp.landable.ToString(), 
                                                                wp.runway, wp.length != -1 ? wp.length.ToString() : "", wp.surface.ToString(), wp.comment, wp.country.ToString()});
                        listWaypoints.Items.Add(l);
                    }
                    break;
                case CatalogOperation.Replace:
                    foreach (ListViewItem i in listWaypoints.Items) {
                        if (i.Text == wp.longName) {
                            i.Remove();
                        }
                    }
                    goto case CatalogOperation.Add;
                }
                UpdateFilterInfo();
            }
            else {
                throw new Exception("no open catalog");
            }
        }

        public void Refill() {
            listWaypoints.Items.Clear();
            listWaypoints.BeginUpdate();
            if (currentCatalog != null) {
                ArrayList items = new ArrayList(currentCatalog.Count);
                foreach (WayPoint wp in currentCatalog.VisibleWaypoints) {
                    ListViewItem l = new ListViewItem(wp.longName);
                    l.Tag = wp;
                    l.ImageIndex = (int)wp.type;
                    l.SubItems.AddRange(new string [] {wp.shortName, wp.ToStringLat(), wp.ToStringLong(), wp.Elevation != -1 ? wp.Elevation.ToString() + " m" : "",
                                                            wp.description, wp.icao, wp.frequency, wp.landable.ToString(), 
                                                            wp.runway, wp.length != -1 ? wp.length.ToString() : "", wp.surface.ToString(), wp.comment, wp.country.ToString()});
                    items.Add(l);
                }

                if (items.Count > 0) {
                    listWaypoints.Items.AddRange((ListViewItem [])items.ToArray(items[0].GetType()));
                }
            }

            listWaypoints.EndUpdate();
            buttonFilter.ImageIndex = currentCatalog != null ? (currentCatalog.Filter.IsSet ? 1 : 0) : 0;
            UpdateFilterInfo();
        }

        public void Update(WayPoint oldWp, WayPoint newWp) {
            ListViewItem.ListViewSubItemCollection coll;
            if (currentCatalog != null) {
                CatalogOperation res = currentCatalog.Update(oldWp, newWp);
                switch (res) {
                case CatalogOperation.Update:
                    foreach (ListViewItem l in listWaypoints.Items) {
                        if (l.Tag == oldWp) {
                            if (currentCatalog.Filter.IsVisible(newWp)) {
                                l.Tag = newWp;
                                l.ImageIndex = (int)newWp.type;
                                l.Text = newWp.longName;
                                coll = l.SubItems;
                                coll[1].Text = newWp.shortName;
                                coll[2].Text = newWp.ToStringLat();
                                coll[3].Text = newWp.ToStringLong();
                                coll[4].Text = newWp.Elevation != -1 ? newWp.Elevation.ToString() + "m" : "";
                                coll[5].Text = newWp.description;
                                coll[6].Text = newWp.icao;
                                coll[7].Text = newWp.frequency;
                                coll[8].Text = newWp.landable.ToString(); 
                                coll[9].Text = newWp.runway;
                                coll[10].Text = newWp.length != -1 ? newWp.length.ToString() + "m" : "";
                                coll[11].Text = newWp.surface.ToString();
                                coll[12].Text = newWp.comment;
                                coll[13].Text = newWp.country.ToString();

                                listWaypoints.Sort();
                            }
                            else {
                                l.Remove();
                            }
                            break;
                        }
                    }
                    break;
                case CatalogOperation.Replace:
                    foreach (ListViewItem i in listWaypoints.Items) {
                        if (i.Text == newWp.longName) {
                            i.Remove();
                        }
                    }
                    goto case CatalogOperation.Update;
                }
                UpdateFilterInfo();
            }
            else {
                throw new Exception("no open catalog");
            }
        }

        public void Remove(WayPoint wp) {
            foreach (ListViewItem l in listWaypoints.Items) {
                if (l.Tag == wp) {
                    l.Remove();
                    UpdateFilterInfo();
                    break;
                }
            }
        }
        #endregion

        #region Attributes
        public SoaringDotNet App {
            get {
                return app;
            }
            set {
                app = value;
            }
        }
        #endregion
    }
}
