using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;

using SoaringDotNET.Data;
using SoaringDotNET.GUI;

namespace SoaringDotNET.Dialogs
{
	/// <summary>
	/// 
	/// </summary>
	public class AirspaceDialog : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.TextBox textBoxName;
        private System.Windows.Forms.TextBox textBoxID;
        private System.Windows.Forms.ComboBox comboBoxCountry;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.ComboBox comboBoxClass;
        private System.Windows.Forms.ComboBox comboBoxType;
        private System.Windows.Forms.Label label7;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.TextBox textBoxBase;
        private System.Windows.Forms.TextBox textBoxTop;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.Label label10;
        private System.Windows.Forms.TextBox textBoxCommName;
        private System.Windows.Forms.TextBox textBoxFrequency;
        private System.Windows.Forms.Label label11;
        private System.Windows.Forms.TextBox textBoxRemark;
        private System.Windows.Forms.ListView listViewSUAItems;
        private System.Windows.Forms.Panel panelPreview;
        private System.Windows.Forms.ColumnHeader columnSUADetailType;
        private System.Windows.Forms.Label label13;
        private System.Windows.Forms.Label label14;
        private System.Windows.Forms.Label label15;
        private System.Windows.Forms.Label label16;
        private System.Windows.Forms.Label label17;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatFrom;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatTo;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatCenter;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonFrom;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonTo;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonCenter;
        private System.Windows.Forms.TextBox textBoxRadius;
        private System.Windows.Forms.ContextMenu contextMenuSUA;
        private System.Windows.Forms.MenuItem menuItemAddSUA;
        private System.Windows.Forms.MenuItem menuItemDeleteSUA;
        private System.Windows.Forms.ContextMenu contextMenuSegments;
        private System.Windows.Forms.MenuItem menuItemAddSegemnts;
        private System.Windows.Forms.MenuItem menuItemDeleteSegment;
        private System.Windows.Forms.ListView listViewSUAs;
        private System.Windows.Forms.ColumnHeader columnSUAName;
        private System.Windows.Forms.ColumnHeader columnSUAId;
        private System.Windows.Forms.ColumnHeader columnSUACountry;
        private System.Windows.Forms.ColumnHeader columnSUAClass;
        private System.Windows.Forms.ColumnHeader columnSUAType;
        private System.Windows.Forms.ColumnHeader columnSUABase;
        private System.Windows.Forms.ColumnHeader columnSUATop;
        private System.Windows.Forms.ColumnHeader columnSUAComm;
        private System.Windows.Forms.ColumnHeader columnSUAFrequency;
        private System.Windows.Forms.ColumnHeader columnSUARemark;
        private System.Windows.Forms.ColumnHeader columnSUADetailLatFrom;
        private System.Windows.Forms.ColumnHeader columnSUADetailLonFrom;
        private System.Windows.Forms.ColumnHeader columnSUADetailLatTo;
        private System.Windows.Forms.ColumnHeader columnSUADetailLonTo;
        private System.Windows.Forms.ColumnHeader columnSUADetailLatCenter;
        private System.Windows.Forms.ColumnHeader columnSUADetailLonCenter;
        private System.Windows.Forms.ColumnHeader columnSUADetailRadius;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.ComboBox comboBoxSegmentType;
        private System.Windows.Forms.Label label12;
        private bool refill = false;
        private AirspaceElement currentAirspace = null;
        private AirspaceSegment currentSegment = null;

		public AirspaceDialog()
		{
			// 
			// TODO: Add constructor logic here
			//
            InitializeComponent();
            foreach (IdType t in AppContents.countryTypes) {
                comboBoxCountry.Items.Add(t);
            }

            foreach (IdType c in AppContents.airspaceClasses) {
                comboBoxClass.Items.Add(c);
            }

            foreach (IdType t in AppContents.airspaceTypes) {
                comboBoxType.Items.Add(t);
            }

            foreach (IdType i in AppContents.segmentTypes) {
                comboBoxSegmentType.Items.Add(i);
            }

            listViewSUAs.ListViewItemSorter = new ListViewItemSorter();

            LoadAirspace();
            OnSelectedAirspaceChanged(null, null);
		}

        private void InitializeComponent() {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(AirspaceDialog));
            this.buttonOK = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.textBoxName = new System.Windows.Forms.TextBox();
            this.textBoxID = new System.Windows.Forms.TextBox();
            this.comboBoxCountry = new System.Windows.Forms.ComboBox();
            this.label5 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.comboBoxClass = new System.Windows.Forms.ComboBox();
            this.comboBoxType = new System.Windows.Forms.ComboBox();
            this.label7 = new System.Windows.Forms.Label();
            this.label8 = new System.Windows.Forms.Label();
            this.textBoxBase = new System.Windows.Forms.TextBox();
            this.textBoxTop = new System.Windows.Forms.TextBox();
            this.label9 = new System.Windows.Forms.Label();
            this.label10 = new System.Windows.Forms.Label();
            this.textBoxCommName = new System.Windows.Forms.TextBox();
            this.textBoxFrequency = new System.Windows.Forms.TextBox();
            this.label11 = new System.Windows.Forms.Label();
            this.textBoxRemark = new System.Windows.Forms.TextBox();
            this.listViewSUAItems = new System.Windows.Forms.ListView();
            this.columnSUADetailType = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailLatFrom = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailLonFrom = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailLatTo = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailLonTo = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailLatCenter = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailLonCenter = new System.Windows.Forms.ColumnHeader();
            this.columnSUADetailRadius = new System.Windows.Forms.ColumnHeader();
            this.contextMenuSegments = new System.Windows.Forms.ContextMenu();
            this.menuItemAddSegemnts = new System.Windows.Forms.MenuItem();
            this.menuItemDeleteSegment = new System.Windows.Forms.MenuItem();
            this.panelPreview = new System.Windows.Forms.Panel();
            this.label13 = new System.Windows.Forms.Label();
            this.label14 = new System.Windows.Forms.Label();
            this.label15 = new System.Windows.Forms.Label();
            this.label16 = new System.Windows.Forms.Label();
            this.label17 = new System.Windows.Forms.Label();
            this.coordEditControlLatFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatTo = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatCenter = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLonFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLonTo = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLonCenter = new SoaringDotNET.Controls.CoordEditControl();
            this.textBoxRadius = new System.Windows.Forms.TextBox();
            this.contextMenuSUA = new System.Windows.Forms.ContextMenu();
            this.menuItemAddSUA = new System.Windows.Forms.MenuItem();
            this.menuItemDeleteSUA = new System.Windows.Forms.MenuItem();
            this.listViewSUAs = new System.Windows.Forms.ListView();
            this.columnSUAName = new System.Windows.Forms.ColumnHeader();
            this.columnSUAId = new System.Windows.Forms.ColumnHeader();
            this.columnSUACountry = new System.Windows.Forms.ColumnHeader();
            this.columnSUAClass = new System.Windows.Forms.ColumnHeader();
            this.columnSUAType = new System.Windows.Forms.ColumnHeader();
            this.columnSUABase = new System.Windows.Forms.ColumnHeader();
            this.columnSUATop = new System.Windows.Forms.ColumnHeader();
            this.columnSUAComm = new System.Windows.Forms.ColumnHeader();
            this.columnSUAFrequency = new System.Windows.Forms.ColumnHeader();
            this.columnSUARemark = new System.Windows.Forms.ColumnHeader();
            this.comboBoxSegmentType = new System.Windows.Forms.ComboBox();
            this.label12 = new System.Windows.Forms.Label();
            this.SuspendLayout();
            // 
            // buttonOK
            // 
            this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOK.Location = new System.Drawing.Point(372, 520);
            this.buttonOK.Name = "buttonOK";
            this.buttonOK.Size = new System.Drawing.Size(75, 24);
            this.buttonOK.TabIndex = 0;
            this.buttonOK.Text = "OK";
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(460, 520);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.Size = new System.Drawing.Size(75, 24);
            this.buttonCancel.TabIndex = 1;
            this.buttonCancel.Text = "Cancel";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(8, 8);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(48, 16);
            this.label1.TabIndex = 8;
            this.label1.Text = "Airspace";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(8, 232);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(34, 16);
            this.label2.TabIndex = 9;
            this.label2.Text = "Name";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(160, 232);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(15, 16);
            this.label3.TabIndex = 10;
            this.label3.Text = "ID";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(224, 232);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(44, 16);
            this.label4.TabIndex = 11;
            this.label4.Text = "Country";
            // 
            // textBoxName
            // 
            this.textBoxName.Location = new System.Drawing.Point(8, 248);
            this.textBoxName.Name = "textBoxName";
            this.textBoxName.Size = new System.Drawing.Size(144, 20);
            this.textBoxName.TabIndex = 12;
            this.textBoxName.Text = "";
            this.textBoxName.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // textBoxID
            // 
            this.textBoxID.Location = new System.Drawing.Point(160, 248);
            this.textBoxID.Name = "textBoxID";
            this.textBoxID.Size = new System.Drawing.Size(56, 20);
            this.textBoxID.TabIndex = 13;
            this.textBoxID.Text = "";
            this.textBoxID.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // comboBoxCountry
            // 
            this.comboBoxCountry.Location = new System.Drawing.Point(224, 248);
            this.comboBoxCountry.Name = "comboBoxCountry";
            this.comboBoxCountry.Size = new System.Drawing.Size(96, 21);
            this.comboBoxCountry.Sorted = true;
            this.comboBoxCountry.TabIndex = 14;
            this.comboBoxCountry.SelectedIndexChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(8, 280);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(33, 16);
            this.label5.TabIndex = 15;
            this.label5.Text = "Class";
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(160, 280);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(29, 16);
            this.label6.TabIndex = 16;
            this.label6.Text = "Type";
            // 
            // comboBoxClass
            // 
            this.comboBoxClass.Location = new System.Drawing.Point(8, 296);
            this.comboBoxClass.Name = "comboBoxClass";
            this.comboBoxClass.Size = new System.Drawing.Size(121, 21);
            this.comboBoxClass.TabIndex = 17;
            this.comboBoxClass.SelectedIndexChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // comboBoxType
            // 
            this.comboBoxType.Location = new System.Drawing.Point(160, 296);
            this.comboBoxType.Name = "comboBoxType";
            this.comboBoxType.Size = new System.Drawing.Size(121, 21);
            this.comboBoxType.TabIndex = 18;
            this.comboBoxType.SelectedIndexChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(8, 328);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(30, 16);
            this.label7.TabIndex = 19;
            this.label7.Text = "Base";
            // 
            // label8
            // 
            this.label8.AutoSize = true;
            this.label8.Location = new System.Drawing.Point(160, 328);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(24, 16);
            this.label8.TabIndex = 20;
            this.label8.Text = "Top";
            // 
            // textBoxBase
            // 
            this.textBoxBase.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxBase.Location = new System.Drawing.Point(8, 344);
            this.textBoxBase.Name = "textBoxBase";
            this.textBoxBase.TabIndex = 21;
            this.textBoxBase.Text = "";
            this.textBoxBase.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // textBoxTop
            // 
            this.textBoxTop.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxTop.Location = new System.Drawing.Point(160, 344);
            this.textBoxTop.Name = "textBoxTop";
            this.textBoxTop.TabIndex = 22;
            this.textBoxTop.Text = "";
            this.textBoxTop.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // label9
            // 
            this.label9.AutoSize = true;
            this.label9.Location = new System.Drawing.Point(8, 376);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(74, 16);
            this.label9.TabIndex = 23;
            this.label9.Text = "Comm. Name";
            // 
            // label10
            // 
            this.label10.AutoSize = true;
            this.label10.Location = new System.Drawing.Point(160, 376);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(58, 16);
            this.label10.TabIndex = 24;
            this.label10.Text = "Frequency";
            // 
            // textBoxCommName
            // 
            this.textBoxCommName.Location = new System.Drawing.Point(8, 392);
            this.textBoxCommName.Name = "textBoxCommName";
            this.textBoxCommName.TabIndex = 25;
            this.textBoxCommName.Text = "";
            this.textBoxCommName.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // textBoxFrequency
            // 
            this.textBoxFrequency.Location = new System.Drawing.Point(160, 392);
            this.textBoxFrequency.Name = "textBoxFrequency";
            this.textBoxFrequency.TabIndex = 26;
            this.textBoxFrequency.Text = "";
            this.textBoxFrequency.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // label11
            // 
            this.label11.AutoSize = true;
            this.label11.Location = new System.Drawing.Point(8, 424);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(44, 16);
            this.label11.TabIndex = 27;
            this.label11.Text = "Remark";
            // 
            // textBoxRemark
            // 
            this.textBoxRemark.Location = new System.Drawing.Point(8, 440);
            this.textBoxRemark.Name = "textBoxRemark";
            this.textBoxRemark.Size = new System.Drawing.Size(312, 20);
            this.textBoxRemark.TabIndex = 28;
            this.textBoxRemark.Text = "";
            this.textBoxRemark.TextChanged += new System.EventHandler(this.OnSUAChanged);
            // 
            // listViewSUAItems
            // 
            this.listViewSUAItems.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                               this.columnSUADetailType,
                                                                                               this.columnSUADetailLatFrom,
                                                                                               this.columnSUADetailLonFrom,
                                                                                               this.columnSUADetailLatTo,
                                                                                               this.columnSUADetailLonTo,
                                                                                               this.columnSUADetailLatCenter,
                                                                                               this.columnSUADetailLonCenter,
                                                                                               this.columnSUADetailRadius});
            this.listViewSUAItems.ContextMenu = this.contextMenuSegments;
            this.listViewSUAItems.FullRowSelect = true;
            this.listViewSUAItems.GridLines = true;
            this.listViewSUAItems.HideSelection = false;
            this.listViewSUAItems.Location = new System.Drawing.Point(328, 248);
            this.listViewSUAItems.Name = "listViewSUAItems";
            this.listViewSUAItems.Size = new System.Drawing.Size(568, 80);
            this.listViewSUAItems.TabIndex = 29;
            this.listViewSUAItems.View = System.Windows.Forms.View.Details;
            this.listViewSUAItems.SelectedIndexChanged += new System.EventHandler(this.OnSelectedSegmentChanged);
            // 
            // columnSUADetailType
            // 
            this.columnSUADetailType.Text = "Type";
            this.columnSUADetailType.Width = 65;
            // 
            // columnSUADetailLatFrom
            // 
            this.columnSUADetailLatFrom.Text = "Lat from";
            this.columnSUADetailLatFrom.Width = 70;
            // 
            // columnSUADetailLonFrom
            // 
            this.columnSUADetailLonFrom.Text = "Lon from";
            this.columnSUADetailLonFrom.Width = 75;
            // 
            // columnSUADetailLatTo
            // 
            this.columnSUADetailLatTo.Text = "Lat to";
            this.columnSUADetailLatTo.Width = 70;
            // 
            // columnSUADetailLonTo
            // 
            this.columnSUADetailLonTo.Text = "Lon to";
            this.columnSUADetailLonTo.Width = 75;
            // 
            // columnSUADetailLatCenter
            // 
            this.columnSUADetailLatCenter.Text = "Lat center";
            this.columnSUADetailLatCenter.Width = 70;
            // 
            // columnSUADetailLonCenter
            // 
            this.columnSUADetailLonCenter.Text = "Lon center";
            this.columnSUADetailLonCenter.Width = 75;
            // 
            // columnSUADetailRadius
            // 
            this.columnSUADetailRadius.Text = "Radius";
            this.columnSUADetailRadius.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.columnSUADetailRadius.Width = 40;
            // 
            // contextMenuSegments
            // 
            this.contextMenuSegments.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                                this.menuItemAddSegemnts,
                                                                                                this.menuItemDeleteSegment});
            // 
            // menuItemAddSegemnts
            // 
            this.menuItemAddSegemnts.Index = 0;
            this.menuItemAddSegemnts.Text = "&Add Segment";
            this.menuItemAddSegemnts.Click += new System.EventHandler(this.OnAddSegment);
            // 
            // menuItemDeleteSegment
            // 
            this.menuItemDeleteSegment.Index = 1;
            this.menuItemDeleteSegment.Text = "&Delete Segment";
            this.menuItemDeleteSegment.Click += new System.EventHandler(this.OnDeleteSegment);
            // 
            // panelPreview
            // 
            this.panelPreview.BackColor = System.Drawing.SystemColors.Window;
            this.panelPreview.Location = new System.Drawing.Point(584, 336);
            this.panelPreview.Name = "panelPreview";
            this.panelPreview.Size = new System.Drawing.Size(312, 210);
            this.panelPreview.TabIndex = 30;
            this.panelPreview.Paint += new System.Windows.Forms.PaintEventHandler(this.OnPaintAirspace);
            // 
            // label13
            // 
            this.label13.AutoSize = true;
            this.label13.Location = new System.Drawing.Point(328, 232);
            this.label13.Name = "label13";
            this.label13.Size = new System.Drawing.Size(55, 16);
            this.label13.TabIndex = 32;
            this.label13.Text = "Segments";
            // 
            // label14
            // 
            this.label14.AutoSize = true;
            this.label14.Location = new System.Drawing.Point(363, 376);
            this.label14.Name = "label14";
            this.label14.Size = new System.Drawing.Size(31, 16);
            this.label14.TabIndex = 33;
            this.label14.Text = "From";
            // 
            // label15
            // 
            this.label15.AutoSize = true;
            this.label15.Location = new System.Drawing.Point(377, 408);
            this.label15.Name = "label15";
            this.label15.Size = new System.Drawing.Size(17, 16);
            this.label15.TabIndex = 34;
            this.label15.Text = "To";
            // 
            // label16
            // 
            this.label16.AutoSize = true;
            this.label16.Location = new System.Drawing.Point(356, 440);
            this.label16.Name = "label16";
            this.label16.Size = new System.Drawing.Size(38, 16);
            this.label16.TabIndex = 35;
            this.label16.Text = "Center";
            // 
            // label17
            // 
            this.label17.AutoSize = true;
            this.label17.Location = new System.Drawing.Point(328, 472);
            this.label17.Name = "label17";
            this.label17.Size = new System.Drawing.Size(66, 16);
            this.label17.TabIndex = 36;
            this.label17.Text = "Radius (nm)";
            // 
            // coordEditControlLatFrom
            // 
            this.coordEditControlLatFrom.IsLatitude = true;
            this.coordEditControlLatFrom.Location = new System.Drawing.Point(400, 376);
            this.coordEditControlLatFrom.Name = "coordEditControlLatFrom";
            this.coordEditControlLatFrom.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLatFrom.TabIndex = 39;
            this.coordEditControlLatFrom.Value = 0;
            this.coordEditControlLatFrom.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSUAElementChanged);
            // 
            // coordEditControlLatTo
            // 
            this.coordEditControlLatTo.IsLatitude = true;
            this.coordEditControlLatTo.Location = new System.Drawing.Point(400, 408);
            this.coordEditControlLatTo.Name = "coordEditControlLatTo";
            this.coordEditControlLatTo.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLatTo.TabIndex = 41;
            this.coordEditControlLatTo.Value = 0;
            this.coordEditControlLatTo.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSUAElementChanged);
            // 
            // coordEditControlLatCenter
            // 
            this.coordEditControlLatCenter.IsLatitude = true;
            this.coordEditControlLatCenter.Location = new System.Drawing.Point(400, 440);
            this.coordEditControlLatCenter.Name = "coordEditControlLatCenter";
            this.coordEditControlLatCenter.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLatCenter.TabIndex = 43;
            this.coordEditControlLatCenter.Value = 0;
            this.coordEditControlLatCenter.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSUAElementChanged);
            // 
            // coordEditControlLonFrom
            // 
            this.coordEditControlLonFrom.IsLatitude = false;
            this.coordEditControlLonFrom.Location = new System.Drawing.Point(496, 376);
            this.coordEditControlLonFrom.Name = "coordEditControlLonFrom";
            this.coordEditControlLonFrom.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLonFrom.TabIndex = 40;
            this.coordEditControlLonFrom.Value = 0;
            this.coordEditControlLonFrom.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSUAElementChanged);
            // 
            // coordEditControlLonTo
            // 
            this.coordEditControlLonTo.IsLatitude = false;
            this.coordEditControlLonTo.Location = new System.Drawing.Point(496, 408);
            this.coordEditControlLonTo.Name = "coordEditControlLonTo";
            this.coordEditControlLonTo.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLonTo.TabIndex = 42;
            this.coordEditControlLonTo.Value = 0;
            this.coordEditControlLonTo.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSUAElementChanged);
            // 
            // coordEditControlLonCenter
            // 
            this.coordEditControlLonCenter.IsLatitude = false;
            this.coordEditControlLonCenter.Location = new System.Drawing.Point(496, 440);
            this.coordEditControlLonCenter.Name = "coordEditControlLonCenter";
            this.coordEditControlLonCenter.Size = new System.Drawing.Size(80, 24);
            this.coordEditControlLonCenter.TabIndex = 44;
            this.coordEditControlLonCenter.Value = 0;
            this.coordEditControlLonCenter.CoordTextChanged += new SoaringDotNET.Controls.CoordTextChangedHandler(this.OnSUAElementChanged);
            // 
            // textBoxRadius
            // 
            this.textBoxRadius.Location = new System.Drawing.Point(400, 472);
            this.textBoxRadius.Name = "textBoxRadius";
            this.textBoxRadius.Size = new System.Drawing.Size(80, 20);
            this.textBoxRadius.TabIndex = 45;
            this.textBoxRadius.Text = "";
            this.textBoxRadius.TextChanged += new System.EventHandler(this.OnSUAElementChanged);
            // 
            // contextMenuSUA
            // 
            this.contextMenuSUA.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                           this.menuItemAddSUA,
                                                                                           this.menuItemDeleteSUA});
            // 
            // menuItemAddSUA
            // 
            this.menuItemAddSUA.Index = 0;
            this.menuItemAddSUA.Text = "&Add SUA";
            this.menuItemAddSUA.Click += new System.EventHandler(this.OnAddSUA);
            // 
            // menuItemDeleteSUA
            // 
            this.menuItemDeleteSUA.Index = 1;
            this.menuItemDeleteSUA.Text = "&Delete SUA";
            this.menuItemDeleteSUA.Click += new System.EventHandler(this.OnDeleteSUA);
            // 
            // listViewSUAs
            // 
            this.listViewSUAs.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                           this.columnSUAName,
                                                                                           this.columnSUAId,
                                                                                           this.columnSUACountry,
                                                                                           this.columnSUAClass,
                                                                                           this.columnSUAType,
                                                                                           this.columnSUABase,
                                                                                           this.columnSUATop,
                                                                                           this.columnSUAComm,
                                                                                           this.columnSUAFrequency,
                                                                                           this.columnSUARemark});
            this.listViewSUAs.ContextMenu = this.contextMenuSUA;
            this.listViewSUAs.FullRowSelect = true;
            this.listViewSUAs.GridLines = true;
            this.listViewSUAs.HideSelection = false;
            this.listViewSUAs.Location = new System.Drawing.Point(8, 24);
            this.listViewSUAs.Name = "listViewSUAs";
            this.listViewSUAs.Size = new System.Drawing.Size(888, 199);
            this.listViewSUAs.TabIndex = 7;
            this.listViewSUAs.View = System.Windows.Forms.View.Details;
            this.listViewSUAs.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnSUASClick);
            this.listViewSUAs.SelectedIndexChanged += new System.EventHandler(this.OnSelectedAirspaceChanged);
            // 
            // columnSUAName
            // 
            this.columnSUAName.Text = "Name";
            this.columnSUAName.Width = 150;
            // 
            // columnSUAId
            // 
            this.columnSUAId.Text = "ID";
            // 
            // columnSUACountry
            // 
            this.columnSUACountry.Text = "Country";
            // 
            // columnSUAClass
            // 
            this.columnSUAClass.Text = "Class";
            // 
            // columnSUAType
            // 
            this.columnSUAType.Text = "Type";
            this.columnSUAType.Width = 80;
            // 
            // columnSUABase
            // 
            this.columnSUABase.Text = "Base";
            this.columnSUABase.Width = 70;
            // 
            // columnSUATop
            // 
            this.columnSUATop.Text = "Top";
            this.columnSUATop.Width = 70;
            // 
            // columnSUAComm
            // 
            this.columnSUAComm.Text = "Comm. Name";
            this.columnSUAComm.Width = 81;
            // 
            // columnSUAFrequency
            // 
            this.columnSUAFrequency.Text = "Frequency";
            this.columnSUAFrequency.Width = 65;
            // 
            // columnSUARemark
            // 
            this.columnSUARemark.Text = "Remark";
            this.columnSUARemark.Width = 170;
            // 
            // comboBoxSegmentType
            // 
            this.comboBoxSegmentType.Location = new System.Drawing.Point(400, 344);
            this.comboBoxSegmentType.Name = "comboBoxSegmentType";
            this.comboBoxSegmentType.Size = new System.Drawing.Size(176, 21);
            this.comboBoxSegmentType.TabIndex = 46;
            this.comboBoxSegmentType.SelectedIndexChanged += new System.EventHandler(this.OnSUAElementChanged);
            // 
            // label12
            // 
            this.label12.AutoSize = true;
            this.label12.Location = new System.Drawing.Point(365, 344);
            this.label12.Name = "label12";
            this.label12.Size = new System.Drawing.Size(29, 16);
            this.label12.TabIndex = 47;
            this.label12.Text = "Type";
            // 
            // AirspaceDialog
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(906, 552);
            this.Controls.Add(this.label12);
            this.Controls.Add(this.textBoxRadius);
            this.Controls.Add(this.label17);
            this.Controls.Add(this.label16);
            this.Controls.Add(this.label15);
            this.Controls.Add(this.label14);
            this.Controls.Add(this.label13);
            this.Controls.Add(this.textBoxRemark);
            this.Controls.Add(this.label11);
            this.Controls.Add(this.textBoxFrequency);
            this.Controls.Add(this.textBoxCommName);
            this.Controls.Add(this.label10);
            this.Controls.Add(this.label9);
            this.Controls.Add(this.textBoxTop);
            this.Controls.Add(this.textBoxBase);
            this.Controls.Add(this.label8);
            this.Controls.Add(this.label7);
            this.Controls.Add(this.label6);
            this.Controls.Add(this.label5);
            this.Controls.Add(this.textBoxID);
            this.Controls.Add(this.textBoxName);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.comboBoxSegmentType);
            this.Controls.Add(this.coordEditControlLonCenter);
            this.Controls.Add(this.coordEditControlLonTo);
            this.Controls.Add(this.coordEditControlLonFrom);
            this.Controls.Add(this.coordEditControlLatCenter);
            this.Controls.Add(this.coordEditControlLatTo);
            this.Controls.Add(this.coordEditControlLatFrom);
            this.Controls.Add(this.panelPreview);
            this.Controls.Add(this.listViewSUAItems);
            this.Controls.Add(this.comboBoxType);
            this.Controls.Add(this.comboBoxClass);
            this.Controls.Add(this.comboBoxCountry);
            this.Controls.Add(this.listViewSUAs);
            this.Controls.Add(this.buttonOK);
            this.Controls.Add(this.buttonCancel);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "AirspaceDialog";
            this.ShowInTaskbar = false;
            this.Text = "Airspace Editor";
            this.ResumeLayout(false);

        }

        private void OnSelectedAirspaceChanged(object sender, System.EventArgs e) {
            if (listViewSUAs.SelectedItems.Count > 0) {
                refill = true;
                currentAirspace = (AirspaceElement)listViewSUAs.SelectedItems[0].Tag;
                textBoxName.Text = currentAirspace.airspace.name;
                textBoxID.Text = currentAirspace.airspace.id;
                comboBoxCountry.SelectedItem = AppContents.countryTypes.getIdType((int)currentAirspace.airspace.country);
                comboBoxClass.SelectedItem = AppContents.airspaceClasses.getIdType((int)currentAirspace.AirspaceClass);
                comboBoxType.SelectedItem = AppContents.airspaceTypes.getIdType((int)currentAirspace.AirspaceType);
                textBoxBase.Text = currentAirspace.airspace.lowerBound;
                textBoxTop.Text = currentAirspace.airspace.upperBound;
                textBoxCommName.Text = currentAirspace.airspace.commName;
                textBoxFrequency.Text = currentAirspace.airspace.radioFrequency;
                textBoxRemark.Text = currentAirspace.airspace.remark;
                refill = false;
            }
            else {
                currentAirspace = null;
            }

            textBoxName.Enabled = textBoxID.Enabled = comboBoxCountry.Enabled = comboBoxClass.Enabled = comboBoxType.Enabled = 
                textBoxBase.Enabled = textBoxTop.Enabled = textBoxCommName.Enabled = textBoxFrequency.Enabled = 
                textBoxRemark.Enabled = currentAirspace != null;

            LoadAirspaceSegments();
            OnSelectedSegmentChanged(null, null);
        }

        private void OnAddSUA(object sender, System.EventArgs e) {
            currentAirspace = AirspaceElement.CreateNewAirspaceElement(new Airspace());
            AppContents.AddAirspace(currentAirspace);
            ListViewItem l = new ListViewItem(new string []{currentAirspace.airspace.name, currentAirspace.airspace.id, (string)AppContents.countryTypesById[currentAirspace.airspace.country],
                                                               currentAirspace.AirspaceClass != AirspaceClasses.Unknown ? currentAirspace.AirspaceClassString : "", 
                                                               currentAirspace.AirspaceType != AirspaceTypes.Unknown ? currentAirspace.AirspaceTypeString : "",
                                                               currentAirspace.airspace.lowerBound, currentAirspace.airspace.upperBound, currentAirspace.airspace.commName,
                                                               currentAirspace.airspace.radioFrequency, currentAirspace.airspace.remark});
            l.Tag = currentAirspace;
            foreach(ListViewItem lv in listViewSUAs.Items) {
                lv.Selected = false;
            }
            listViewSUAs.Items.Add(l);
            l.Selected = true;
            listViewSUAs.EnsureVisible(l.Index);
        }

        private void OnDeleteSUA(object sender, System.EventArgs e) {
            foreach (ListViewItem lv in listViewSUAs.SelectedItems) {
                AppContents.DeleteAirspace((AirspaceElement)lv.Tag);
                lv.Remove();
            }
        }

        private void OnAddSegment(object sender, System.EventArgs e) {
            if (currentAirspace != null) {
                AirspaceSegment seg = new AirspaceSegment();
                seg.type = AirspaceSegmentTypes.Line;
                if (currentAirspace.Count > 0) {
                    AirspaceSegment lastSeg = currentAirspace[currentAirspace.Count - 1];
                    seg.latFrom = seg.latTo = lastSeg.latTo;
                    seg.lonFrom = seg.lonTo = lastSeg.lonTo;
                }

                ListViewItem l = new ListViewItem(new string []{seg.type.ToString(), seg.latFrom != 0 ? WgsPoint.ToString(seg.latFrom, true) : "", seg.lonFrom != 0 ? WgsPoint.ToString(seg.lonFrom, false) : "",
                                                                   seg.latTo != 0 ? WgsPoint.ToString(seg.latTo, true) : "", seg.lonTo != 0 ? WgsPoint.ToString(seg.lonTo, false) : "",
                                                                   seg.latCenter != 0 ? WgsPoint.ToString(seg.latCenter, true) : "", seg.lonCenter != 0 ? WgsPoint.ToString(seg.lonCenter, false) : "",
                                                                   seg.radius != 0.0f ? string.Format("{0:F2}", seg.radius) : ""});
                l.Tag = seg;
                
                foreach(ListViewItem lv in listViewSUAItems.Items) {
                    lv.Selected = false;
                }
                listViewSUAItems.Items.Add(l);
                currentAirspace.airspace.points.Add(seg);
                currentAirspace.CalcArea();
                l.Selected = true;
                listViewSUAItems.EnsureVisible(l.Index);
            }
        }

        private void OnDeleteSegment(object sender, System.EventArgs e) {
            if (currentAirspace != null) {
                foreach (ListViewItem lv in listViewSUAItems.SelectedItems) {
                    currentAirspace.airspace.points.Remove((AirspaceSegment)lv.Tag);
                    lv.Remove();
                }
                currentAirspace.CalcArea();
            }
        }

        private void OnPaintAirspace(object sender, System.Windows.Forms.PaintEventArgs e) {
            if (currentAirspace != null && currentAirspace.Count > 0) {
                Graphics g = e.Graphics;
                g.Clear(panelPreview.BackColor);
                
                WgsArea viewArea = new WgsArea(currentAirspace.Area);
                // calculate correct aspect ratio
                double mapFactor = Math.Cos(WgsPoint.InternalToRad(viewArea.Center.Latitude));
                double screenFactor = (double)panelPreview.Width / (double)panelPreview.Height;

                int reqWidth = (int)(viewArea.Height / mapFactor * screenFactor);
                WgsPoint center = viewArea.Center;

                if (viewArea.Width < reqWidth) {
                    reqWidth /= 2;
                    // screen has sapce for more lon 
                    if (viewArea.LeftLon < viewArea.RightLon) {
                        viewArea.LeftLon = center.Longitude - reqWidth;
                        viewArea.RightLon = center.Longitude + reqWidth;
                    }
                    else {
                        viewArea.LeftLon = viewArea.Center.Longitude + reqWidth;
                        viewArea.RightLon = viewArea.Center.Longitude - reqWidth;
                    }
                }
                else if (viewArea.Width > reqWidth) {
                    // we need more space for lat
                    int reqHeight = (int)((viewArea.Width * mapFactor / screenFactor) / 2);
                    if (viewArea.Center.Latitude - reqHeight > -32400000 && viewArea.Center.Latitude  + reqHeight < 32400000) {
                        viewArea.TopLat = center.Latitude - reqHeight;
                        viewArea.BottomLat = center.Latitude + reqHeight;
                    }
                }

                currentAirspace.Draw(g, viewArea, panelPreview.Width - 1, panelPreview.Height - 1);
            }
        }

        private void OnSelectedSegmentChanged(object sender, System.EventArgs e) {
            if (currentAirspace != null) {
                if (listViewSUAItems.SelectedItems.Count > 0) {
                    currentSegment = (AirspaceSegment) listViewSUAItems.SelectedItems[0].Tag;
                }
                else {
                    currentSegment = null;
                }
            }
            else {
                currentSegment = null;
            }

            listViewSUAItems.Enabled = currentAirspace != null;

            comboBoxSegmentType.Enabled = coordEditControlLatCenter.Enabled = coordEditControlLatFrom.Enabled = coordEditControlLatTo.Enabled = 
                coordEditControlLonCenter.Enabled = coordEditControlLonFrom.Enabled = coordEditControlLonTo.Enabled = textBoxRadius.Enabled = 
                (currentSegment != null);

            LoadAirspaceSegmentDetails();

            panelPreview.Invalidate();
        }

        private void LoadAirspace() {
            refill = true;
            listViewSUAs.Items.Clear();
            listViewSUAs.BeginUpdate();
            foreach (AirspaceElement space in AppContents.airspaces) {
                ListViewItem l = new ListViewItem(new string []{space.airspace.name, space.airspace.id, (string)AppContents.countryTypesById[space.airspace.country],
                                                                   space.AirspaceClass != AirspaceClasses.Unknown ? space.AirspaceClassString : "", 
                                                                   space.AirspaceType != AirspaceTypes.Unknown ? space.AirspaceTypeString : "",
                                                                   space.airspace.lowerBound, space.airspace.upperBound, space.airspace.commName,
                                                                   space.airspace.radioFrequency, space.airspace.remark});
                l.Tag = space;
                listViewSUAs.Items.Add(l);
            }
            listViewSUAs.EndUpdate();
            refill = false;
        }

        private void LoadAirspaceSegments() {
            listViewSUAItems.Items.Clear();
            listViewSUAItems.BeginUpdate();
            refill = true;
            if (currentAirspace != null) {
                foreach (AirspaceSegment seg in currentAirspace.airspace) {
                    ListViewItem l = new ListViewItem(new string []{seg.type.ToString(), seg.latFrom != 0 ? WgsPoint.ToString(seg.latFrom, true) : "", seg.lonFrom != 0 ? WgsPoint.ToString(seg.lonFrom, false) : "",
                                                                       seg.latTo != 0 ? WgsPoint.ToString(seg.latTo, true) : "", seg.lonTo != 0 ? WgsPoint.ToString(seg.lonTo, false) : "",
                                                                       seg.latCenter != 0 ? WgsPoint.ToString(seg.latCenter, true) : "", seg.lonCenter != 0 ? WgsPoint.ToString(seg.lonCenter, false) : "",
                                                                       seg.radius != 0.0f ? string.Format("{0:F2}", seg.radius) : ""});
                    l.Tag = seg;
                    listViewSUAItems.Items.Add(l);
                }
            }
            listViewSUAItems.EndUpdate();
            refill = false;
        }

        private void LoadAirspaceSegmentDetails() {
            refill = true;
            if (currentSegment != null) {
                comboBoxSegmentType.SelectedItem = AppContents.segmentTypes.getIdType((int)currentSegment.type);
                coordEditControlLatCenter.Value = currentSegment.latCenter;
                coordEditControlLatFrom.Value = currentSegment.latFrom;
                coordEditControlLatTo.Value = currentSegment.latTo;
                coordEditControlLonCenter.Value = currentSegment.lonCenter;
                coordEditControlLonFrom.Value = currentSegment.lonFrom;
                coordEditControlLonTo.Value = currentSegment.lonTo;
                textBoxRadius.Text = currentSegment.radius != 0.0f ? string.Format("{0:F2}", currentSegment.radius) : "";
                
                coordEditControlLatCenter.Enabled = currentSegment.type != AirspaceSegmentTypes.Line;
                coordEditControlLonCenter.Enabled = currentSegment.type != AirspaceSegmentTypes.Line;
                textBoxRadius.Enabled = currentSegment.type != AirspaceSegmentTypes.Line;

                coordEditControlLatFrom.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
                coordEditControlLatTo.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
                coordEditControlLonFrom.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
                coordEditControlLonTo.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
            }
            else {
                comboBoxSegmentType.SelectedItem = null;
                coordEditControlLatCenter.Value = 0;
                coordEditControlLatFrom.Value = 0;
                coordEditControlLatTo.Value = 0;
                coordEditControlLonCenter.Value = 0;
                coordEditControlLonFrom.Value = 0;
                coordEditControlLonTo.Value = 0;
                textBoxRadius.Text = "";
            }
            refill = false;
        }

        private void OnSUAChanged(object sender, System.EventArgs e) {
            if (!refill && currentAirspace != null) {
                if (sender == comboBoxCountry || sender == comboBoxClass || sender == comboBoxType) {
                    AppContents.DeleteAirspace(currentAirspace);
                }

                currentAirspace.airspace.name = textBoxName.Text;
                currentAirspace.airspace.id = textBoxID.Text;
                currentAirspace.airspace.country = (CountryTypeId)((IdType)comboBoxCountry.SelectedItem).id;
                currentAirspace.airspace.airspaceClass = (AirspaceClasses)((IdType)comboBoxClass.SelectedItem).id;
                currentAirspace.airspace.airspaceType = (AirspaceTypes)((IdType)comboBoxType.SelectedItem).id;
                currentAirspace.airspace.lowerBound = textBoxBase.Text;
                currentAirspace.airspace.upperBound = textBoxTop.Text;
                currentAirspace.airspace.commName = textBoxCommName.Text;
                currentAirspace.airspace.radioFrequency = textBoxFrequency.Text;
                currentAirspace.airspace.remark = textBoxRemark.Text;

                if (sender == comboBoxCountry || sender == comboBoxClass || sender == comboBoxType) {
                    if (sender == comboBoxClass || sender == comboBoxType) {
                        currentAirspace = AirspaceElement.CreateNewAirspaceElement(currentAirspace.airspace);
                        listViewSUAs.SelectedItems[0].Tag = currentAirspace;
                        panelPreview.Invalidate();
                    }
                    AppContents.AddAirspace(currentAirspace);
                }
                UpdateSUA();
            }
        }

        private void UpdateSUA() {
            if (listViewSUAs.SelectedItems.Count > 0) {
                ListViewItem l = listViewSUAs.SelectedItems[0];
                l.SubItems[0].Text = currentAirspace.airspace.name;
                l.SubItems[1].Text = currentAirspace.airspace.id;
                l.SubItems[2].Text = (string)AppContents.countryTypesById[currentAirspace.airspace.country];
                l.SubItems[3].Text = currentAirspace.AirspaceClass != AirspaceClasses.Unknown ? currentAirspace.AirspaceClassString : "";
                l.SubItems[4].Text = currentAirspace.AirspaceType != AirspaceTypes.Unknown ? currentAirspace.AirspaceTypeString : "";
                l.SubItems[5].Text = currentAirspace.airspace.lowerBound;
                l.SubItems[6].Text = currentAirspace.airspace.upperBound;
                l.SubItems[7].Text = currentAirspace.airspace.commName;
                l.SubItems[8].Text = currentAirspace.airspace.radioFrequency;
                l.SubItems[9].Text = currentAirspace.airspace.remark;
            }
        }

        private void OnColumnSUASClick(object sender, System.Windows.Forms.ColumnClickEventArgs e) {
            ListViewItemSorter sorter = (ListViewItemSorter)listViewSUAs.ListViewItemSorter;
            sorter.Col = e.Column;
            listViewSUAs.Sort();
        }

        private void OnSUAElementChanged(object sender, System.EventArgs e) {
            if (!refill && currentSegment != null) {
                currentSegment.type = (AirspaceSegmentTypes)((IdType)comboBoxSegmentType.SelectedItem).id;
                refill = true;
                switch (currentSegment.type) {
                case AirspaceSegmentTypes.Line:
                    coordEditControlLatCenter.Value = 0;
                    coordEditControlLonCenter.Value = 0;
                    textBoxRadius.Text = "0";
                    break;
                case AirspaceSegmentTypes.Circle:
                    coordEditControlLatFrom.Value = 0;
                    coordEditControlLatTo.Value = 0;
                    coordEditControlLonFrom.Value = 0;
                    coordEditControlLonTo.Value = 0;
                    break;
                }

                coordEditControlLatCenter.Enabled = currentSegment.type != AirspaceSegmentTypes.Line;
                coordEditControlLonCenter.Enabled = currentSegment.type != AirspaceSegmentTypes.Line;
                textBoxRadius.Enabled = currentSegment.type != AirspaceSegmentTypes.Line;

                coordEditControlLatFrom.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
                coordEditControlLatTo.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
                coordEditControlLonFrom.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;
                coordEditControlLonTo.Enabled = currentSegment.type != AirspaceSegmentTypes.Circle;

                refill = false;
                currentSegment.latCenter = coordEditControlLatCenter.Value;
                currentSegment.latFrom = coordEditControlLatFrom.Value;
                currentSegment.latTo = coordEditControlLatTo.Value;
                currentSegment.lonCenter = coordEditControlLonCenter.Value;
                currentSegment.lonFrom = coordEditControlLonFrom.Value;
                currentSegment.lonTo = coordEditControlLonTo.Value;
                try {
                    currentSegment.radius = float.Parse(textBoxRadius.Text, AppContents.ni);
                }
                catch {
                    currentSegment.radius = 0;
                }
                currentAirspace.CalcArea();
                UpdateSUASegment();
                panelPreview.Invalidate();
            }
        }

        private void UpdateSUASegment() {
            if (listViewSUAItems.SelectedItems.Count > 0) {
                ListViewItem l = listViewSUAItems.SelectedItems[0];
                l.SubItems[0].Text = currentSegment.type.ToString();
                l.SubItems[1].Text = currentSegment.latFrom != 0 ? WgsPoint.ToString(currentSegment.latFrom, true) : "";
                l.SubItems[2].Text = currentSegment.lonFrom != 0 ? WgsPoint.ToString(currentSegment.lonFrom, false) : "";
                l.SubItems[3].Text = currentSegment.latTo != 0 ? WgsPoint.ToString(currentSegment.latTo, true) : "";
                l.SubItems[4].Text = currentSegment.lonTo != 0 ? WgsPoint.ToString(currentSegment.lonTo, false) : "";
                l.SubItems[5].Text = currentSegment.latCenter != 0 ? WgsPoint.ToString(currentSegment.latCenter, true) : "";
                l.SubItems[6].Text = currentSegment.lonCenter != 0 ? WgsPoint.ToString(currentSegment.lonCenter, false) : "";
                l.SubItems[7].Text = currentSegment.radius != 0.0f ? string.Format("{0:F2}", currentSegment.radius) : "";
            }
        }
    }
}
