// name   : AirspcaePopupInfo.cs
// author : Harald Maier
// date   : 02.06.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using SoaringDotNET.Controls;

namespace SoaringDotNET.GUI
{
	/// <summary>
	/// Summary description for PopupInfo.
	/// </summary>
	public class AirspcaePopupInfo : System.Windows.Forms.Form
	{
        private ArrayList items;
        private Map parent;
        private System.Windows.Forms.Label labelClose;
        /// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public AirspcaePopupInfo(Map map)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            items = new ArrayList();
            Reset();
            parent = map;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.labelClose = new System.Windows.Forms.Label();
            this.SuspendLayout();
            // 
            // labelClose
            // 
            this.labelClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.labelClose.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.labelClose.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.labelClose.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.labelClose.ForeColor = System.Drawing.SystemColors.GrayText;
            this.labelClose.Location = new System.Drawing.Point(120, 0);
            this.labelClose.Name = "labelClose";
            this.labelClose.Size = new System.Drawing.Size(16, 16);
            this.labelClose.TabIndex = 2;
            this.labelClose.Text = "X";
            this.labelClose.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.labelClose.Click += new System.EventHandler(this.OnCloseToolTip);
            // 
            // AirspcaePopupInfo
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.BackColor = System.Drawing.SystemColors.Info;
            this.ClientSize = new System.Drawing.Size(136, 100);
            this.Controls.Add(this.labelClose);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
            this.Name = "AirspcaePopupInfo";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            this.TopMost = true;
            this.ResumeLayout(false);

        }
		#endregion
	
        protected override void OnPaint(PaintEventArgs e) {
            // TODO:  Add PopupInfo.OnPaint implementation
            Graphics g = e.Graphics;
            SizeF textSize;
            int i, y;
            string s;

            y = 21;
            if (items.Count > 0) {
                for (i = 0; i < items.Count; i++) {
                    s = (string)items[i];
                    g.DrawString(s, Font, Brushes.Black, 5, y);
                    textSize = g.MeasureString(s, Font);
                    y += (int)textSize.Height;
                    if (i < items.Count - 1) {
                        g.DrawLine(Pens.Brown, 0, y + 2, Width - 1, y + 2);
                        y += 5;
                    }
                }
            }
            else {
                s = "No info";
                g.DrawString("No info", Font, Brushes.Black, 5, y);
            }

            s = "Airspace Info";
            textSize = g.MeasureString(s, Font);
            if (Width < textSize.Width + labelClose.Width + 10) {
                Width = (int)textSize.Width + labelClose.Width + 10;
            }
            if (Height < textSize.Height + 25) {
                Height = (int)textSize.Height + 25;
            }

            g.DrawString(s, new Font(Font.Name, 8, FontStyle.Bold), Brushes.Firebrick, 5, 2);
            g.DrawRectangle(Pens.Black, 0, 0, Width - 1, Height - 1);
            labelClose.Left = Width - labelClose.Width - 1;
            labelClose.Top = 1;
            g.DrawLine(Pens.Brown, 1, 16, Width - 2, 16);
        }

        private void Reset() {
            Width = 10;
            Height = 10;
            items.Clear();
        }

        public void Add(string txt) {
            Graphics g = CreateGraphics();
            SizeF textSize;
            textSize = g.MeasureString(txt, Font);
            if (items.Count > 0) {
                Height += 5;
            }
            else {
                Height = 22;
                Width = 10;
            }

            Height += (int)textSize.Height;
            if (textSize.Width > Width) {
                Width = (int)textSize.Width + 10;
            }
            items.Add(txt);
        }

        private void OnCloseToolTip(object sender, System.EventArgs e) {
            Hide();
        }

        public new void Hide() {
            Reset();
            base.Hide();
        }
    }
}
