// name   : RecorderBase.cs
// author : Harald Maier
// date   : 18.02.2004
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.IO;
using System.Collections;

namespace SoaringDotNET.Data
{
	/// <summary>
	/// 
	/// </summary>
	public class IGCFile
	{
        public string A = "";
        public string DTE = "";
        public string FXA = "";
        public string PLT = "";
        public string GTY = "";
        public string GID = "";
        public string RFW = "";
        public string RHW = "";
        public string FTY = "";
        public string DTM = "";
        public string CID = "";
        public string CCL = "";
        public string TZN = "";
        public string GPS = "";
        public string SIT = "";
        public string CONV = "";
        public string I = "";

        public ArrayList CRecord;
        public ArrayList BRecord;
        public ArrayList GRecord;

		public IGCFile()
		{
			// 
			// TODO: Add constructor logic here
			//
            BRecord = new ArrayList();
            CRecord = new ArrayList();
            GRecord = new ArrayList();
		}

        public void Write(string path) {
            StreamWriter w = new StreamWriter(path);

            w.WriteLine(A);
            w.WriteLine(DTE);
            w.WriteLine(FXA);
            w.WriteLine(PLT);
            w.WriteLine(GTY);
            w.WriteLine(GID);
            w.WriteLine(DTM);
            w.WriteLine(RFW);
            if (GPS != "") {
                w.WriteLine(GPS);
            }
            w.WriteLine(RHW);
            w.WriteLine(FTY);
            w.WriteLine(CID);
            w.WriteLine(CCL);
            if (SIT != "") {
                w.WriteLine(SIT);
            }

            if (TZN != "") {
                w.WriteLine("HFTZNTIMEZONE:{0}", TZN);
            }

            if (I != "") {
                w.WriteLine(I);
            }

            if (CONV != "") {
                w.WriteLine(CONV);
            }


            foreach (string s in CRecord) {
                w.WriteLine(s);
            }

            foreach (string s in BRecord) {
                w.WriteLine(s);
            }

            foreach (string s in GRecord) {
                w.WriteLine(s);
            }
            w.Close();
        }
	}
}
