// name   : MapLineElement.cs
// author : Harald Maier
// date   : 17.10.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Drawing;
using System.Collections;

using SoaringDotNET.Data;

namespace SoaringDotNET.GUI
{
	/// <summary>
	/// 
	/// </summary>
	public class MapLineElement : SoaringDotNET.GUI.MapElement
	{
        protected WgsArea area;
        protected ArrayList points;

		public MapLineElement(MapElementTypes type) :
            base(type)
		{
			// 
			// TODO: Add constructor logic here
			//
            area = new WgsArea();
            points = new ArrayList();
        }

        #region Protected Functions
        protected virtual void CalcArea() {
            // TODO:  Add Task.CalcArea implementation
            area.Clear();
            foreach (WgsPoint t in this) {
                if (area.IsEmpty) {
                    area.BottomLat = t.Latitude;
                    area.TopLat = t.Latitude;
                    area.LeftLon = t.Longitude;
                    area.RightLon = t.Longitude;
                }
                else {
                    area.BottomLat = Math.Max(t.Latitude, area.BottomLat);
                    area.TopLat = Math.Min(t.Latitude, area.TopLat);
                    area.LeftLon = Math.Min(t.Longitude, area.LeftLon);
                    area.RightLon = Math.Max(t.Longitude, area.RightLon);
                }
            }
        }

        #endregion

        #region Public Functions
        public IEnumerator GetEnumerator() {
            return points.GetEnumerator();
        }

        public override void Draw(Graphics g, SoaringDotNET.Data.WgsArea view, int width, int height) {
            // TODO:  Add MapLineElement.Draw implementation
            WgsPoint p;
            long lat, lat2;
            long lon, lon2;
            long latRange, lonRange;
            long minLat, minLon;
            int i;
            long diff;

            minLat = view.TopLat;
            latRange = view.Height;
            minLon = view.LeftLon;
            lonRange = view.Width;

            mapPos.Clear();

            if (view.AreaIntersect(Area)) {
                if (points.Count > 0) {
                    p = this[0];
                    lat = (p.Latitude - minLat) * height / latRange;
                    diff = p.Longitude - minLon;
                    if (diff <= -64800000) {
                        diff += 129600000;
                    }
                    lon = diff * width / lonRange;

                    mapPos[0] = new Point((int)lon, (int)lat);

                    for (i = 1; i < points.Count; i++) {
                        p = this[i];
                        lat2 = (p.Latitude - minLat) * height / latRange;
                        diff = p.Longitude - minLon;
                        if (diff <= -64800000) {
                            diff += 129600000;
                        }
                        lon2 = diff * width / lonRange;

                        g.DrawLine(this.pen, lon, lat, lon2, lat2);
                        mapPos[i] = new Point((int)lon2, (int)lat2);

                        lat = lat2;
                        lon = lon2;
                    }
                }
            }
        }
/*
        public override void Draw(Graphics g, Pen pen, WgsArea view, int width, int height) {
            Pen oldPen = this.pen;
            this.pen = pen;
            this.Draw(g, view, width, height);
            this.pen = oldPen;
        }
*/
        #endregion

        #region Attributes
        public WgsPoint this[int pos] {
            get {
                return (WgsPoint)points[pos];
            }
        }

        public WgsArea Area {
            get {
                return area;
            }
        }

        public int Count {
            get {
                return points.Count;
            }
        }
	
        #endregion
    
    }
}
