// name   : Pilots.cs
// author : Harald Maier
// date   : 19.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using SoaringDotNET.Data;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// Summary description for Pilots.
	/// </summary>
	public class Pilots : System.Windows.Forms.UserControl {
	    private SoaringDotNet app;
        private System.Windows.Forms.ListView listPilots;
        private System.Windows.Forms.ColumnHeader columnName;
        private System.Windows.Forms.ColumnHeader columnBirthday;
        private System.Windows.Forms.ColumnHeader columnStreet;
        private System.Windows.Forms.ColumnHeader columnAddress;
        private System.Windows.Forms.ColumnHeader columnPhone;
        private System.Windows.Forms.ColumnHeader columnEMail;
        private System.Windows.Forms.ImageList imageList;
        private System.Windows.Forms.ContextMenu contextMenuPilots;
        private System.Windows.Forms.MenuItem menuItemAddPilot;
        private System.Windows.Forms.MenuItem menuItemEditPilot;
        private System.Windows.Forms.MenuItem menuItemDeletePilot;
        private System.ComponentModel.IContainer components;

		public Pilots()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call
            listPilots.ListViewItemSorter = new ListViewItemSorter();


		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Pilots));
            this.listPilots = new System.Windows.Forms.ListView();
            this.columnName = new System.Windows.Forms.ColumnHeader();
            this.columnBirthday = new System.Windows.Forms.ColumnHeader();
            this.columnStreet = new System.Windows.Forms.ColumnHeader();
            this.columnAddress = new System.Windows.Forms.ColumnHeader();
            this.columnPhone = new System.Windows.Forms.ColumnHeader();
            this.columnEMail = new System.Windows.Forms.ColumnHeader();
            this.contextMenuPilots = new System.Windows.Forms.ContextMenu();
            this.menuItemAddPilot = new System.Windows.Forms.MenuItem();
            this.menuItemEditPilot = new System.Windows.Forms.MenuItem();
            this.menuItemDeletePilot = new System.Windows.Forms.MenuItem();
            this.imageList = new System.Windows.Forms.ImageList(this.components);
            this.SuspendLayout();
            // 
            // listPilots
            // 
            this.listPilots.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                         this.columnName,
                                                                                         this.columnBirthday,
                                                                                         this.columnStreet,
                                                                                         this.columnAddress,
                                                                                         this.columnPhone,
                                                                                         this.columnEMail});
            this.listPilots.ContextMenu = this.contextMenuPilots;
            this.listPilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listPilots.FullRowSelect = true;
            this.listPilots.GridLines = true;
            this.listPilots.HideSelection = false;
            this.listPilots.Location = new System.Drawing.Point(0, 0);
            this.listPilots.Name = "listPilots";
            this.listPilots.Size = new System.Drawing.Size(624, 152);
            this.listPilots.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listPilots.TabIndex = 0;
            this.listPilots.View = System.Windows.Forms.View.Details;
            this.listPilots.DoubleClick += new System.EventHandler(this.OnEditPilot);
            this.listPilots.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnName
            // 
            this.columnName.Text = "Name";
            this.columnName.Width = 200;
            // 
            // columnBirthday
            // 
            this.columnBirthday.Text = "Birthday";
            this.columnBirthday.Width = 80;
            // 
            // columnStreet
            // 
            this.columnStreet.Text = "Street";
            this.columnStreet.Width = 120;
            // 
            // columnAddress
            // 
            this.columnAddress.Text = "Address";
            this.columnAddress.Width = 120;
            // 
            // columnPhone
            // 
            this.columnPhone.Text = "Phone";
            this.columnPhone.Width = 120;
            // 
            // columnEMail
            // 
            this.columnEMail.Text = "e-mail";
            this.columnEMail.Width = 180;
            // 
            // contextMenuPilots
            // 
            this.contextMenuPilots.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                              this.menuItemAddPilot,
                                                                                              this.menuItemEditPilot,
                                                                                              this.menuItemDeletePilot});
            this.contextMenuPilots.Popup += new System.EventHandler(this.OnPopupContextMenu);
            // 
            // menuItemAddPilot
            // 
            this.menuItemAddPilot.Index = 0;
            this.menuItemAddPilot.Text = "&Add Pilot";
            this.menuItemAddPilot.Click += new System.EventHandler(this.OnAddPilot);
            // 
            // menuItemEditPilot
            // 
            this.menuItemEditPilot.Index = 1;
            this.menuItemEditPilot.Text = "&Edit Pilot";
            this.menuItemEditPilot.Click += new System.EventHandler(this.OnEditPilot);
            // 
            // menuItemDeletePilot
            // 
            this.menuItemDeletePilot.Index = 2;
            this.menuItemDeletePilot.Text = "&Delete Pilot";
            this.menuItemDeletePilot.Click += new System.EventHandler(this.OnDeletePilot);
            // 
            // imageList
            // 
            this.imageList.ImageSize = new System.Drawing.Size(16, 16);
            this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
            this.imageList.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // Pilots
            // 
            this.Controls.Add(this.listPilots);
            this.Name = "Pilots";
            this.Size = new System.Drawing.Size(624, 152);
            this.ResumeLayout(false);

        }
		#endregion

        #region Public Functions
        public void ShowPilots() {
            listPilots.Items.Clear();
            listPilots.BeginUpdate();
            foreach (Pilot p in app.Pilots) {
                ListViewItem l = new ListViewItem(p.FirstName + " " + p.LastName);
                l.Tag = p;
                l.SubItems.AddRange(new string [] {p.BirthDayString, p.Street, p.Address, p.Phone, p.Email});
                listPilots.Items.Add(l);

            }
            listPilots.EndUpdate();
        }

        public void Add(Pilot p) {
            ListViewItem l = new ListViewItem(p.FirstName + " " + p.LastName);
            l.Tag = p;
            l.SubItems.AddRange(new string [] {p.BirthDayString, p.Street, p.Address, p.Phone, p.Email});
            listPilots.Items.Add(l);
        }

        public void Update(Pilot p) {
            ListViewItem.ListViewSubItemCollection coll;
            foreach (ListViewItem l in listPilots.Items) {
                if (l.Tag == p) {
                    l.Text = p.FirstName + " " + p.LastName;
                    coll = l.SubItems;
                    coll[1].Text = p.BirthDayString;
                    coll[2].Text = p.Street;
                    coll[3].Text = p.Address;
                    coll[4].Text = p.Phone;
                    coll[5].Text = p.Email;
                    listPilots.Sort();
                    break;
                }
            }
        }

        public void Remove(Pilot p) {
            foreach (ListViewItem l in listPilots.Items) {
                if (l.Tag == p) {
                    app.Pilots.Remove(p);
                    l.Remove();
                    break;
                }
            }
        }

        #endregion

        #region Private Functions
        private void OnAddPilot(object sender, System.EventArgs e) {
            app.AddPilot();
        }

        private void OnEditPilot(object sender, System.EventArgs e) {
            if (listPilots.SelectedItems.Count > 0) {
                Pilot p = (Pilot)listPilots.SelectedItems[0].Tag;
                app.EditPilot(p);
            }
        }

        private void OnDeletePilot(object sender, System.EventArgs e) {
            foreach (ListViewItem ic in listPilots.SelectedItems) {
                app.Delete((Pilot)ic.Tag);
            }
        }
        
        private void OnPopupContextMenu(object sender, System.EventArgs e) {
            menuItemEditPilot.Enabled = app.Pilots.Count > 0;
            menuItemDeletePilot.Enabled = app.Pilots.Count > 0;
        }

        private void OnColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e) {
            ListViewItemSorter sorter = (ListViewItemSorter)listPilots.ListViewItemSorter;
            sorter.Col = e.Column;
            listPilots.Sort();
        }
        #endregion

        #region Attributes
        public SoaringDotNet App {
            get {
                return app;
            }
            set {
                app = value;
            }
        }
        #endregion
	}
}
